/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.util.AFConfManager;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.DNSResolverThread;
import com.adventnet.la.util.HTMLFileReader;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnomalyTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(AnomalyTask.class.getName());
    private DataObject obj = null;
    private HashMap map = new HashMap();
    private HashMap smsmap = new HashMap();
    ProductBundle bundle = ProductBundle.getInstance();
    ResourceBundle rb = this.bundle.getBundle();

    public void executeTask(TaskContext context) {
        Object scheduleId = this.fillAnomalyObject(context);
        if (this.obj == null) {
            return;
        }
        try {
            this.executeQuery();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private Object fillAnomalyObject(TaskContext context) {
        try {
            DataObject tInput = context.getTaskInputDO();
            Row row = tInput.getFirstRow("Task_Input");
            Object scheduleId = row.get("SCHEDULE_ID");
            this.obj = AFConfManager.getScheduledProfile(scheduleId);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() throws Exception {
        long dbResultVal;
        int decidingColumn = 2;
        Row row = this.obj.getRow("AnomalyFilters");
        String query = (String)row.get("QUERY");
        String scheduleName = (String)row.get("FILTER_NAME");
        String unit = (String)row.get("SUM_THRESHOLD_UNIT");
        String reportType = (String)row.get("REPORT_TYPE");
        String subReportType = (String)row.get("SUB_REPORT_TYPE");
        String thresholdString = row.get("SUM_THRESHOLD").toString();
        long threshold = Long.parseLong(thresholdString);
        String subCritType = (String)row.get("SUB_CRITERIA_TYPE");
        String subCritLabel = "";
        boolean isSubCritValNeeded = true;
        boolean moreThan2Col = false;
        if (subCritType == null || "All".equals(subCritType)) {
            isSubCritValNeeded = false;
            decidingColumn = 1;
        } else {
            subCritLabel = "AnySRC".equals(subCritType) || subCritType.indexOf("Transaction(SRC") > -1 ? this.rb.getString("Alert.Arg.Value4") : ("AnyDEST".equals(subCritType) ? this.rb.getString("Alert.Arg.Value5") : this.rb.getString("Alert.Arg.Value11"));
        }
        int factor = this.getAnomThersholdFactor(subReportType, unit);
        ArrayList<String> dbResult = new ArrayList<String>();
        ArrayList<String> subCritValList = new ArrayList<String>();
        ArrayList<String> colNamelist = new ArrayList<String>();
        ArrayList consolidatedList = new ArrayList();
        consolidatedList.add(dbResult);
        consolidatedList.add(subCritValList);
        Connection conn = null;
        Statement stmt = null;
        ResultSet set = null;
        int noOfColumns = -1;
        try {
            int k;
            RelationalAPI relAPI = RelationalAPI.getInstance();
            conn = relAPI.getConnection();
            stmt = conn.createStatement();
            set = stmt.executeQuery(query);
            ResultSetMetaData rsmd = set.getMetaData();
            noOfColumns = rsmd.getColumnCount();
            if (noOfColumns > 2) {
                moreThan2Col = true;
            }
            for (k = decidingColumn; k < noOfColumns; ++k) {
                colNamelist.add(rsmd.getColumnName(k + 1));
                ArrayList extraList = new ArrayList();
                consolidatedList.add(extraList);
            }
            while (set.next()) {
                dbResult.add(set.getString(1));
                if (isSubCritValNeeded) {
                    subCritValList.add(set.getString(2));
                }
                if (!moreThan2Col && isSubCritValNeeded) continue;
                for (k = decidingColumn; k < noOfColumns; ++k) {
                    ((List)consolidatedList.get(k)).add(set.getString(k + 1));
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ee) {}
        }
        LOGGER.log(Level.FINER, " ScheduleName ::" + scheduleName + " ReportType ::" + reportType + " ThresholdString ::" + thresholdString + " ThresholdUnit ::" + unit + " DBResult :::" + dbResult);
        if (dbResult.size() == 0) {
            return;
        }
        String tempResult = (String)dbResult.get(0);
        if ("null".equals(tempResult) || tempResult == null) {
            return;
        }
        DNSResolverThread dt = DNSResolverThread.getInstance();
        StringBuffer buffer = new StringBuffer();
        String dummy_subReportType = null;
        StringBuffer smsbuffer = new StringBuffer();
        String timeString = AFConfManager.getTimeString((String)row.get("TIME_THRESHOLD"), (String)row.get("QUERY_INTERVAL"));
        if (dbResult.size() > 0 && noOfColumns > 1) {
            try {
                dummy_subReportType = this.rb.getString("Anomaly.SubReport." + (String)row.get("SUB_REPORT_TYPE"));
            }
            catch (Exception e) {
                dummy_subReportType = (String)row.get("SUB_REPORT_TYPE");
            }
            buffer.append(dummy_subReportType);
            smsbuffer.append((String)row.get("SUB_REPORT_TYPE"));
            buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg1") + " ");
            smsbuffer.append(" " + this.rb.getString("Anomaly.Alert.Msg1"));
            buffer.append(thresholdString);
            buffer.append(" ");
            smsbuffer.append(" ");
            buffer.append(this.rb.getString("Alert.Value." + unit));
            smsbuffer.append(unit);
            buffer.append(", ");
            buffer.append(timeString);
            buffer.append(", " + this.rb.getString("Anomaly.Alert.Msg2") + ": ");
            smsbuffer.append(this.rb.getString("Sms.Entities"));
            buffer.append("<br> <br> <table align=\"center\" width=\"500\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
            buffer.append("<tr> <td bgcolor=\"#999999\"> <table style=\"font-size:12px;\" width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\">");
            buffer.append("<tr> <td width=\"45%\" align=\"left\" bgcolor=\"#E4E4E4\"> <strong>");
            buffer.append(subCritLabel);
            smsbuffer.append(subCritLabel);
            buffer.append("</strong> </td>");
            if (moreThan2Col || !isSubCritValNeeded) {
                for (int k = decidingColumn; k < noOfColumns; ++k) {
                    buffer.append("<td align=\"left\" bgcolor=\"#E4E4E4\"> <strong>");
                    buffer.append((String)colNamelist.get(k - decidingColumn));
                    buffer.append("</strong></td>");
                }
            }
            buffer.append("<td align=\"left\" bgcolor=\"#E4E4E4\"> <strong>");
            buffer.append((String)row.get("SUB_REPORT_TYPE"));
            smsbuffer.append((String)row.get("SUB_REPORT_TYPE"));
            buffer.append("</strong></td>");
            buffer.append("</tr>");
            for (int i = 0; i < dbResult.size(); ++i) {
                buffer.append("<tr> <td align=\"left\" bgcolor=\"#FFFFFF\">");
                if (isSubCritValNeeded) {
                    buffer.append(subCritValList.get(i) + "");
                    smsbuffer.append(subCritValList.get(i) + "");
                }
                if (!isSubCritValNeeded || noOfColumns > 2) {
                    for (int k = decidingColumn; k < noOfColumns; ++k) {
                        buffer.append("</td> <td align=\"left\" bgcolor=\"#FFFFFF\">");
                        String dnsName = dt.getDNSName((String)((List)consolidatedList.get(k)).get(i), true);
                        buffer.append(dnsName);
                        buffer.append("</td>");
                    }
                }
                buffer.append("<td align=\"left\" bgcolor=\"#FFFFFF\">");
                dbResultVal = Long.parseLong(dbResult.get(i) + "");
                String currentValue = dbResultVal / (long)factor + " " + this.rb.getString("Alert.Value." + unit);
                buffer.append(currentValue);
                smsbuffer.append(currentValue);
                buffer.append("</td>");
                buffer.append("</td> </tr>");
            }
            buffer.append("</table> </td> </tr> </table> <br>");
        } else {
            try {
                dummy_subReportType = this.rb.getString("Anomaly.SubReport." + (String)row.get("SUB_REPORT_TYPE"));
            }
            catch (Exception e) {
                dummy_subReportType = (String)row.get("SUB_REPORT_TYPE");
            }
            buffer.append(dummy_subReportType);
            smsbuffer.append((String)row.get("SUB_REPORT_TYPE"));
            String anomalyMsg = this.rb.getString("Anomaly.Alert.Msg3");
            anomalyMsg = anomalyMsg.replace("${ProductName}", this.bundle.getRebrandingString("ProductName"));
            buffer.append(" " + anomalyMsg);
            smsbuffer.append(" value");
            if (isSubCritValNeeded) {
                buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg4") + " ");
                smsbuffer.append(" of ");
                buffer.append("<b>");
                buffer.append(subCritLabel);
                smsbuffer.append(subCritLabel);
                buffer.append(":");
                smsbuffer.append(":");
                buffer.append(subCritValList.get(0) + "");
                buffer.append("</b>");
            }
            buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg5") + " ");
            smsbuffer.append(" is ");
            dbResultVal = Long.parseLong(dbResult.get(0) + "");
            String currentValue = dbResultVal / (long)factor + " " + this.rb.getString("Alert.Value." + unit);
            buffer.append(currentValue);
            smsbuffer.append(currentValue);
            buffer.append(timeString);
            smsbuffer.append(timeString);
            buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg6") + " ");
            smsbuffer.append(" " + this.rb.getString("Sms.GreaterThan") + " ");
            buffer.append(thresholdString);
            smsbuffer.append(thresholdString);
            buffer.append(" ");
            smsbuffer.append(" ");
            buffer.append(this.rb.getString("Alert.Value." + unit));
            smsbuffer.append(unit);
            buffer.append(".");
        }
        this.map.put("auditMessage", buffer.toString());
        this.smsmap.put("auditMessage", smsbuffer.toString());
        buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg7") + " ");
        smsbuffer.append(" " + this.rb.getString("Sms.LoginFwa") + " ");
        buffer.append(reportType);
        smsbuffer.append(reportType);
        buffer.append(" " + this.rb.getString("Anomaly.Alert.Msg8"));
        smsbuffer.append(" " + this.rb.getString("Anomaly.Alert.Msg8"));
        this.map.put("alertMessage", buffer.toString());
        this.smsmap.put("alertMessage", smsbuffer.toString());
        StringBuffer resources = new StringBuffer();
        StringBuffer criteria = new StringBuffer();
        AFConfManager.fillFromLAExpression(resources, criteria, this.obj);
        this.map.put("devices", resources.toString());
        this.map.put("criteria", criteria.toString());
        consolidatedList = null;
        this.sendNotifications(row, scheduleName);
    }

    private int getAnomThersholdFactor(String subReportType, String unit) {
        int factor = 1;
        if ("Duration".equals(subReportType)) {
            factor = "mins".equals(unit) ? 60 : ("secs".equals(unit) ? 1 : ("days".equals(unit) ? 86400 : 3600));
        } else if (subReportType.indexOf("Traffic") > -1) {
            factor = "GB".equals(unit) ? 0x40000000 : ("KB".equals(unit) ? 1024 : 0x100000);
        }
        return factor;
    }

    private boolean checkForNotiFrequency(Row filterRow, Object scheduleName) {
        int lastOccurCount = AFConfManager.getLastOccurCount(scheduleName);
        int thresholdValue = (Integer)filterRow.get("NOTI_FREQUENCY");
        LOGGER.log(Level.FINER, " currentthreshold ::" + ++lastOccurCount + " givenValue ::" + thresholdValue + " currentTime ::" + new Date());
        if (thresholdValue > 1) {
            String timeThreshold = (String)filterRow.get("TIME_THRESHOLD");
            if ("This Week".equals(timeThreshold)) {
                lastOccurCount = this.handleCalendarTimeNotification(scheduleName, 3, lastOccurCount);
            } else if ("This Month".equals(timeThreshold)) {
                lastOccurCount = this.handleCalendarTimeNotification(scheduleName, 2, lastOccurCount);
            }
        }
        if (lastOccurCount > thresholdValue) {
            AFConfManager.putLastOccurCount(scheduleName, new Integer(1));
            return true;
        }
        AFConfManager.putLastOccurCount(scheduleName, new Integer(lastOccurCount));
        return false;
    }

    private int handleCalendarTimeNotification(Object scheduleName, int calendarField, int lastOccurCount) {
        int calendTimeVal = AFConfManager.getCalendarTimeVal(scheduleName);
        GregorianCalendar calend = new GregorianCalendar();
        int val = calend.get(calendarField);
        if (calendTimeVal == -1) {
            AFConfManager.putCalendarTimeVal(scheduleName, val);
        } else if (calendTimeVal != val) {
            AFConfManager.putCalendarTimeVal(scheduleName, val);
            lastOccurCount = 1;
        }
        return lastOccurCount;
    }

    private void sendNotifications(Row filterRow, Object scheduleName) throws Exception {
        String errorString = null;
        Row afRow = this.obj.getRow("AnomalyFilters");
        Object filterId = afRow.get("AF_ID");
        if (this.checkForNotiFrequency(filterRow, scheduleName) && AFConfManager.doNotify(this.obj)) {
            if (this.obj.containsTable("MailSettings")) {
                errorString = this.sendMail(filterRow);
            }
            if (this.obj.containsTable("ScriptSettings")) {
                errorString = this.executeScript(filterRow);
            }
            if (this.obj.containsTable("SmsSettings")) {
                errorString = this.sendSms(filterRow);
            }
        }
        int status = 0;
        if (errorString == null) {
            status = 1;
            errorString = (String)this.map.get("auditMessage");
        }
        if (!(this.obj.containsTable("MailSettings") || this.obj.containsTable("SmsSettings") || this.obj.containsTable("ScriptSettings"))) {
            status = 3;
        }
        String recordCol = "AF_ID";
        String criticality = (String)filterRow.get("CRITICALITY");
        String anomalyAlertOwner = (String)filterRow.get("OWNER_NAME");
        try {
            DataObject dObject = DataAccess.constructDataObject();
            Row row = new Row("AnomalyAudit");
            row.set("AF_ID", filterId);
            row.set("NOTIFIEDTIME", (Object)new Long(System.currentTimeMillis()));
            row.set("TYPE", (Object)"Firewall");
            String devices = (String)this.map.get("devices");
            if (devices.indexOf(",") > -1) {
                devices = "Multiple Devices";
            }
            row.set("SOURCE", (Object)devices);
            row.set("STATUS", (Object)new Integer(status));
            row.set("CRITICALITY", (Object)criticality);
            row.set("OWNERNAME", (Object)anomalyAlertOwner);
            row.set("ERROR_DETAILS", (Object)errorString);
            row.set("RECORD_COLUMN", (Object)recordCol);
            dObject.addRow(row);
            DataAccess.add((DataObject)dObject);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private String sendMail(Row row) {
        String err = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("MailServerSettings"));
            query.addSelectColumn(new Column("MailServerSettings", "*"));
            DataObject mailObject = DataAccess.get((SelectQuery)query);
            String mailServer = "192.168.4.41";
            String smtpPort = "25";
            String username = null;
            String password = null;
            String from = null;
            String tls = "no";
            String filterName = (String)this.obj.getFirstValue("AnomalyFilters", "FILTER_NAME");
            if (mailObject.containsTable("MailServerSettings")) {
                Row mailRow = mailObject.getRow("MailServerSettings");
                mailServer = (String)mailRow.get("SMTPSERVER");
                Long smtpPortLong = (Long)mailRow.get("SMTPSERVERPORT");
                if (smtpPortLong != null) {
                    smtpPort = smtpPortLong.toString();
                }
                username = (String)mailRow.get("USERNAME");
                password = (String)mailRow.get("PASSWORD");
                from = (String)mailRow.get("SENDER_MAILID");
                tls = (String)mailRow.get("ACTIVE_TLS");
            }
            if (from == null) {
                from = "firewallreport@localdomain.com";
            }
            String to = (String)this.obj.getFirstValue("MailSettings", "TO_ADDRESS");
            String subject = (String)this.obj.getFirstValue("MailSettings", "SUBJECT");
            String comment = (String)this.obj.getFirstValue("MailSettings", "COMMENT");
            if (subject != null && !"".equals(subject)) {
                if (subject.indexOf("$PROFILENAME") != -1) {
                    subject = subject.replaceAll("\\$PROFILENAME", filterName);
                }
                if (subject.indexOf("$CRITERIA") != -1) {
                    String crt = (String)this.map.get("criteria");
                    subject = subject.replaceAll("\\$CRITERIA", crt);
                }
                if (subject.indexOf("$RESOURCE") != -1) {
                    String res = (String)this.map.get("devices");
                    subject = subject.replaceAll("\\$RESOURCE", res);
                }
                if (subject.indexOf("$DESC") != -1) {
                    String des = (String)this.map.get("auditMessage");
                    subject = subject.replaceAll("\\$DESC", des);
                }
                if (subject.indexOf("<br>") != -1) {
                    subject = subject.replaceAll("\\<br>", ",");
                }
            } else {
                subject = "Alert from Anomaly Filter :: " + filterName;
            }
            SmtpMailer mailer = new SmtpMailer(mailServer, from, to, subject, null, username, password, smtpPort, tls);
            LOGGER.log(Level.FINER, " sending mail ::::::" + mailServer + " from ::" + from + " to ::" + to + " subject :::" + subject + " username " + username + " pass " + password);
            String dum_reportType = null;
            String dum_subReport = null;
            this.map.put("profileName", (String)row.get("FILTER_NAME"));
            try {
                dum_reportType = this.rb.getString("Anomaly.Report." + (String)row.get("REPORT_TYPE"));
                dum_subReport = this.rb.getString("Anomaly.SubReport." + (String)row.get("SUB_REPORT_TYPE"));
            }
            catch (Exception e) {
                dum_reportType = (String)row.get("REPORT_TYPE");
                dum_subReport = (String)row.get("SUB_REPORT_TYPE");
            }
            this.map.put("reportType", dum_reportType);
            this.map.put("subReportType", dum_subReport);
            this.map.put("sumThreshold", row.get("SUM_THRESHOLD").toString() + " " + (String)row.get("SUM_THRESHOLD_UNIT"));
            this.map.put("queryInterval", row.get("QUERY_INTERVAL").toString());
            if (comment != null && !"".equals(comment)) {
                this.map.put("display", "display:block");
                this.map.put("comment", comment);
            } else {
                this.map.put("display", "display:none");
            }
            err = mailer.sendMessage(HTMLFileReader.getMailContent((int)HTMLFileReader.ANOMALY_MAIL_INDEX, (Map)this.map));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return err;
    }

    private String sendSms(Row row) {
        String ex = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SmsServerSettings"));
            query.addSelectColumn(new Column("SmsServerSettings", "*"));
            DataObject smsObject = DataAccess.get((SelectQuery)query);
            String smsport = "";
            String message = "";
            String filterName = (String)this.obj.getFirstValue("AnomalyFilters", "FILTER_NAME");
            if (smsObject.containsTable("SmsServerSettings")) {
                Row smsRow = smsObject.getRow("SmsServerSettings");
                smsport = (String)smsRow.get("PORT");
                message = (String)smsRow.get("MESSAGE");
            }
            String to = (String)this.obj.getFirstValue("SmsSettings", "TO_NUMBER");
            LOGGER.log(Level.FINER, " sending sms" + smsport + ",to" + to);
            this.smsmap.put("profileName", (String)row.get("FILTER_NAME"));
            String smsmessage = this.rb.getString("SmsNotify.profilename") + "=" + (String)this.smsmap.get("profileName") + "," + this.rb.getString("SmsNotify.alertmessage") + "=" + (String)this.smsmap.get("alertMessage");
            ex = LaUtil.getInstance().sendSms(smsport, to, smsmessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
        return ex;
    }

    private String executeScript(Row filterRow) {
        try {
            String osname = System.getProperty("os.name", "Windows");
            Row r = this.obj.getFirstRow("ScriptSettings");
            String path = (String)r.get("LOCATION");
            String temp1 = (String)r.get("ARGUMENTS");
            String arg = "";
            if (temp1 != null) {
                temp1 = temp1.replaceAll("\\$", "");
                String[] params = temp1.split(" ");
                String temp = "";
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].equals("CRITERIA")) {
                        temp = (String)this.map.get("criteria");
                    } else if (params[i].equals("PROFILENAME")) {
                        temp = (String)filterRow.get("FILTER_NAME");
                    } else if (params[i].equals("RESOURCE")) {
                        temp = (String)this.map.get("devices");
                    } else if (params[i].equals("DESC")) {
                        temp = (String)this.map.get("alertMessage");
                        temp = temp.substring(0, temp.indexOf("Login into") - 1);
                    }
                    if (temp.indexOf(34) > -1) {
                        temp = temp.replace('\"', ' ');
                        temp = temp.replaceAll(" ", "");
                    }
                    arg = arg + "\"" + temp + "\"";
                    arg = arg.trim();
                }
            }
            String cmd = null;
            if (osname.startsWith("Win")) {
                cmd = "cmd /c " + path + " " + arg;
            } else if (osname.startsWith("Lin")) {
                cmd = "sh " + path + " " + arg;
            }
            if (cmd != null) {
                Runtime rt = Runtime.getRuntime();
                rt.exec(cmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
        return null;
    }

    private DataObject getAnomalyDataObject(Object scheduleId) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(new Table("Schedule"));
        query.addSelectColumn(new Column("Schedule", "*"));
        query.addSelectColumn(new Column("AnomalyFilters", "*"));
        query.addJoin(new Join("Schedule", "AnomalyFilters", new String[]{"SCHEDULE_NAME"}, new String[]{"FILTER_NAME"}, 2));
        Criteria fCrit = new Criteria(new Column("Schedule", "SCHEDULE_ID"), scheduleId, 0);
        query.setCriteria(fCrit);
        DataObject anomalyObj = DataAccess.get((SelectQuery)query);
        return anomalyObj;
    }

    public void stopTask() {
    }
}

