/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.dc.DataConsolidator;
import com.adventnet.fa.server.dc.FirewallAuditHandler;
import com.adventnet.fa.server.imp.DataArchiver;
import com.adventnet.fa.server.imp.ImportLogManager;
import com.adventnet.fa.server.lc.CollectorParserAdopter;
import com.adventnet.fa.server.lc.FwLogCollector;
import com.adventnet.fa.server.lc.LogCollector;
import com.adventnet.fa.server.rules.FWASSHD;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.LaUtil;
import com.adventnet.la.tray.ProductTrayIcon;
import com.adventnet.la.util.dm.LimitFinder;
import com.adventnet.la.util.nf.AuditHandler;
import com.adventnet.la.util.nf.NFConfHandler;
import com.adventnet.la.util.nf.NFManager;
import com.adventnet.la.util.nf.NotificationEngine;
import com.adventnet.la.util.pe.DataArchiverInterface;
import com.adventnet.la.util.pe.ParserEngine;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DServer {
    private static final Logger LOGGER = Logger.getLogger(DServer.class.getName());
    public static final int DB_DUMP_INTERVAL = 199000;
    private ParserEngine parserEngine = null;
    private FwParserEngine fwEngine = null;
    private LogCollector logCollector = null;
    private DataConsolidator consolidator = null;
    private NotificationEngine notificationEngine = null;
    private String parserRuleFile = "FirewallLogParserRules.xml";
    private AuditHandler auditHandler = null;
    private DataArchiverInterface archiver = null;
    private boolean useReceiverFallback = new Boolean(System.getProperty("useReceiverFallback", "true"));

    public DServer(String parserRuleFile) {
        LOGGER.log(Level.FINER, "[DServer] Property Set for useReceiverFallback attribute is {0}", new Boolean(this.useReceiverFallback));
        this.parserRuleFile = parserRuleFile;
        FWASSHD sshdInstance = new FWASSHD();
        FirewallConstants.loadFromDatabase();
        FAServerUtil.populateMemoryDetails();
        String dbType = System.getProperty("DBType", "mysql");
        if ("mysql".equals(dbType)) {
            this.checkToMemoryVal();
        }
        int fwCount = FirewallLicenseManager.getInstance().getDeviceHashSize();
        LimitFinder.resetTableLimits((int)fwCount);
        LaUtil.loadFromDatabase();
        LaCacheManager.setMaxDeviceCount((int)200);
    }

    public DServer() {
    }

    private void checkToMemoryVal() {
        int calcVal = this.getCalculatedToMemory();
        this.updateToMemory(calcVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCalculatedToMemory() {
        int toMemoryVal = 10000;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet rsJap = null;
        try {
            RelationalAPI rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery("show variables like 'max_heap_table_size'");
            while (rs.next()) {
                long val = Long.parseLong((String)rs.getObject(2));
                if (val > 0x2000000L && val <= 0x9600000L) {
                    toMemoryVal = 50000;
                    continue;
                }
                if (val <= 0x9600000L) continue;
                toMemoryVal = 100000;
            }
            rsJap = stmt.executeQuery("show variables like 'character_set_database'");
            while (rsJap.next()) {
                String charSet = (String)rsJap.getObject(2);
                if (!"utf8".equals(charSet)) continue;
                toMemoryVal = toMemoryVal * 3 / 4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return toMemoryVal;
    }

    private void updateToMemory(int val) {
        try {
            UpdateQueryImpl uquery = new UpdateQueryImpl("CruncherState");
            Criteria crt = new Criteria(new Column("CruncherState", "TABLE_NAME"), (Object)"ToMemory", 0);
            uquery.setCriteria(crt);
            uquery.setUpdateColumn("CRUNCHER_POINTER", (Object)new Long(val));
            DataAccess.update((UpdateQuery)uquery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setParserRule(String parserRuleFile) {
        this.parserRuleFile = parserRuleFile;
    }

    public void bootServer() {
        LOGGER.log(Level.FINER, " Booting Dserver !!!! ");
        this.initializeTray();
        this.initializeModules();
        if (!this.useReceiverFallback) {
            this.interlinkModules();
        }
        this.startModules();
        this.test();
    }

    private void initializeTray() {
        String showTray = System.getProperty("com.adventnet.la.showtray");
        if (showTray != null && showTray.equals("true")) {
            System.out.println("TRAYICON:::::initializing ProductTrayIcon Thread");
            Thread trayIconThread = new Thread("TrayIconThread"){

                @Override
                public void run() {
                    try {
                        ProductTrayIcon opcTrayIcon = new ProductTrayIcon("../server/conf/TrayIconInfo.xml");
                        opcTrayIcon.startAndRun();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            trayIconThread.start();
        }
    }

    private void initializeModules() {
        this.logCollector = new FwLogCollector();
        if (!this.useReceiverFallback) {
            this.parserEngine = new ParserEngine(this.parserRuleFile);
            this.archiver = new DataArchiver(this.parserEngine.getContext());
            this.parserEngine.setDataArchiver(this.archiver);
            this.consolidator = new DataConsolidator();
            this.consolidator.scheduleDOUpdate(199000);
        } else {
            this.fwEngine = FwParserEngine.getInstance();
            this.fwEngine.init(this.parserRuleFile);
            this.archiver = new DataArchiver(this.fwEngine.context);
            this.fwEngine.setDataArchiver(this.archiver);
        }
        ImportLogManager.getInstance();
        this.notificationEngine = NotificationEngine.getInstance();
        this.initializeNF(this.notificationEngine);
    }

    private void interlinkModules() {
        CollectorParserAdopter adopter = new CollectorParserAdopter(this.parserEngine);
        this.logCollector.addListener(adopter);
        this.parserEngine.setParameter("DATA_CONSOLIDATOR", (Object)this.consolidator);
        this.parserEngine.setParameter("NOTIFICATION_ENGINE", (Object)this.notificationEngine);
    }

    private void startModules() {
        this.logCollector.start();
    }

    public void shutdown() {
        LOGGER.log(Level.FINER, " Shutting down Dserver");
        this.logCollector.shutdown();
        if (!this.useReceiverFallback) {
            this.parserEngine.shutdown();
            this.consolidator.shutdown();
        }
        ImportLogManager.shutdown();
        this.notificationEngine.deRegisterAuditHandler(1);
        this.notificationEngine.shutdown();
        FirewallConstants.fFlushLogFiles();
        this.archiver.shutdown();
    }

    private void test() {
        LOGGER.log(Level.FINER, " From test");
    }

    private void initializeNF(NotificationEngine ne) {
        DataObject conf = NFManager.getInstance().getNFConfiguration();
        NFConfHandler handler = NFConfHandler.getInstance();
        this.auditHandler = new FirewallAuditHandler();
        ne.registerAuditHandler(1, this.auditHandler);
        handler.populateConfiguration(conf);
    }

    public static void main(String[] args) {
        DServer ds = new DServer("C:\\Orange\\projects\\balaji\\fa\\conf\\FirewallLogParserRules.xml");
        ds.bootServer();
    }
}

