/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.util.CreateSchema;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.Autonumberfix;
import com.adventnet.fa.server.DServer;
import com.adventnet.fa.server.DServiceMBean;
import com.adventnet.fa.server.DWSManager;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallAdder;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallStatusNotifier;
import com.adventnet.fa.server.LiveVPNCount;
import com.adventnet.fa.server.SNMPQueryThread;
import com.adventnet.fa.server.StatusPoll;
import com.adventnet.fa.server.dataCollection.DeviceConfig;
import com.adventnet.fa.server.lc.IPFIXStaticFlowHandler;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.WriterRepository;
import com.adventnet.la.ExportCleanup;
import com.adventnet.la.LaUtil;
import com.adventnet.la.QueryParser;
import com.adventnet.la.SQLGenerator;
import com.adventnet.la.enterprise.AdminServerUtil;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.startup.StartUPUtil;
import com.adventnet.la.packetCapture;
import com.adventnet.la.util.DNSResolverThread;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.ServerUtil;
import com.adventnet.la.util.dm.MySQLErrorResolver;
import com.adventnet.mfw.message.MessageListener;
import com.adventnet.mfw.message.Messenger;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.xml.Do2XmlConverter;
import com.adventnet.persistence.xml.Xml2DoConverter;
import com.me.tools.zcutil.METrack;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DService
implements DServiceMBean {
    private static final Logger LOGGER = Logger.getLogger(DService.class.getName());
    private FirewallAdder fwAdder = null;
    private boolean isServerShutdown = false;
    DServer ds = null;
    private ExportCleanup cleanup;
    private String confFile = null;
    private static List tableNames = Arrays.asList("SystemConfigurations");
    private static Criteria crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"HF_INIT", 0);

    public DService() throws Exception {
        ServerUtil.setModuleType((int)1);
    }

    public void create(DataObject serviceDO) {
    }

    public void start() {
        String avStatus;
        System.setProperty("sortedIndex", "false");
        String dbType = System.getProperty("DBType", "mysql");
        this.confFile = System.getProperty("server.dir") + File.separator + "server" + File.separator + "conf";
        String rulesFilePath = this.confFile + File.separator + "FirewallLogParserRules.xml";
        this.regenerateSQLForMigration(dbType);
        this.createComplianceCheckListXML(dbType);
        boolean isAdminServer = this.checkInstallationType();
        StatusPoll spObject = StatusPoll.getInstance();
        spObject.init();
        if (!isAdminServer) {
            this.prepareFWAForHighFlowRate();
        }
        FirewallStatusNotifier statusNotifier = FirewallStatusNotifier.getInstance();
        statusNotifier.startThread();
        if ("mysql".equals(dbType)) {
            MySQLErrorResolver errorResolver = MySQLErrorResolver.getInstance();
            errorResolver.addObserver((Observer)statusNotifier);
        }
        this.initMETracker();
        if ("mssql".equals(dbType)) {
            this.setSQLAuthenticationType();
        }
        if (isAdminServer) {
            LOGGER.log(Level.INFO, "INFO: Existing installation type is ::: Admin Server. Hence, skipping Syslog & Parser Rules intialization.");
            return;
        }
        this.cleanUpOldFiles();
        this.ds = new DServer(rulesFilePath);
        this.ds.bootServer();
        try {
            this.fwAdder = new FirewallAdder();
            Messenger.subscribe((String)"DataModelTopic", (MessageListener)this.fwAdder, (boolean)true, null);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "WARNING: Unable to Register FirewallAdder with MessageListener");
            exp.printStackTrace();
        }
        if (System.getProperty("disableDropTableFix") == null) {
            this.createTables(dbType);
        }
        if (System.getProperty("disableAutoNumberFix") == null) {
            new Autonumberfix().start();
        }
        LOGGER.log(Level.INFO, "DService: Calling ExportCleanup Thread frm startService()");
        this.cleanup = new ExportCleanup();
        DWSManager dwsm = DWSManager.getInstance();
        dwsm.init();
        LiveVPNCount lvc = LiveVPNCount.getInstance();
        lvc.init();
        DeviceConfig.init();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria crit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)new String[]{"7000PatchTables", "7000PatchTime"}, 8);
            query.setCriteria(crit);
            DataObject dataObj = DataAccess.get((SelectQuery)query);
            if (dataObj.size("SystemConfigurations") == 2) {
                LaUtil.getInstance().setFA7000PatchInfo(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!"mssql".equals(dbType) && "0".equals(avStatus = FirewallConstants.getAVScanner())) {
            this.startScannerSearch();
        }
        FAServerUtil.loadReportFilter();
        LaUtil.shouldCheckForPsuedoQuery = true;
        QueryParser.shouldCheckForPsuedoQuery = true;
        packetCapture.getPacketCapture();
    }

    private void initMETracker() {
        try {
            boolean isMETrackEnabled = true;
            String confDir = System.getProperty("server.dir") + File.separator + "server" + File.separator + "conf";
            METrack me = new METrack(confDir, System.getProperty("server.dir"), "mickeylite", null);
            SelectQueryImpl sql = new SelectQueryImpl(new Table("SystemConfigurations"));
            sql.addSelectColumn(new Column("SystemConfigurations", "*"));
            sql.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"isMETrackerEnabled", 0));
            DataObject dobj = DataAccess.get((SelectQuery)sql);
            if (!dobj.isEmpty()) {
                isMETrackEnabled = "true".equals((String)dobj.getFirstValue("SystemConfigurations", "CONF_VALUE"));
            }
            if (isMETrackEnabled) {
                Thread metrack = new Thread((Runnable)me);
                metrack.start();
            } else {
                METrack.disable();
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, " Exception while initializing ME Tracker ", exp);
        }
    }

    private void setSQLAuthenticationType() {
        try {
            String dbConFile = System.getProperty("server.dir") + File.separator + "conf" + File.separator + "database_params.conf";
            File dbFile = new File(dbConFile);
            if (dbFile.exists()) {
                Properties dbProp = this.getDBProperies(dbFile);
                String connectionUrl = dbProp.getProperty("url");
                if (connectionUrl.indexOf("Domain=") != -1) {
                    System.setProperty("isWinAuthType", "true");
                } else {
                    System.setProperty("isWinAuthType", "false");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getDBProperies(File dbConfFile) {
        Properties dbProp = new Properties();
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(dbConfFile);
            dbProp.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return dbProp;
    }

    private void createTables(String dbType) {
        try {
            LOGGER.log(Level.FINER, "Executing drop table fix");
            CreateSchema cs = new CreateSchema(RelationalAPI.getInstance().getDataSource());
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("server.dir"));
            sb.append(File.separator);
            sb.append("conf");
            sb.append(File.separator);
            sb.append("FirewallAnalyzer");
            sb.append(File.separator);
            sb.append(dbType);
            sb.append(File.separator);
            sb.append("DatabaseSchema.conf");
            File f = new File(sb.toString());
            if (!"mysql".equals(dbType)) {
                cs.createSchemas(true, false, (InputStream)new FileInputStream(f));
            } else {
                cs.createSchemas(true, true, (InputStream)new FileInputStream(f));
            }
            cs.createTables("FirewallAnalyzer");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while executing drop table fix");
            e.printStackTrace();
        }
    }

    private void regenerateSQLForMigration(String dbType) {
        block33: {
            try {
                File checkListXml;
                SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
                query.addSelectColumn(new Column("SystemConfigurations", "*"));
                Criteria crit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"regenerateSQL", 0);
                query.setCriteria(crit1);
                DataObject obj = DataAccess.get((SelectQuery)query);
                if (obj.getTableNames().size() <= 0) {
                    LOGGER.log(Level.INFO, "INFO::::This is a normal warm start. Not the first warm start after Migration.");
                    return;
                }
                Row migRow = new Row("SystemConfigurations");
                migRow.set("CONF_NAME", (Object)"regenerateSQL");
                Row finalRow = obj.getRow("SystemConfigurations", migRow);
                boolean isppm8000 = false;
                if (!"true".equals((String)finalRow.get("CONF_VALUE"))) break block33;
                query = new SelectQueryImpl(new Table("SystemConfigurations"));
                query.addSelectColumn(new Column("SystemConfigurations", "*"));
                crit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"DatabaseMigration", 0);
                query.setCriteria(crit1);
                obj = DataAccess.get((SelectQuery)query);
                String dataMig = "false";
                try {
                    dataMig = !obj.isEmpty() ? (String)obj.getFirstValue("SystemConfigurations", "CONF_VALUE") : "false";
                }
                catch (DataAccessException e) {
                    dataMig = "false";
                }
                if ("false".equals(dataMig)) {
                    isppm8000 = true;
                    SelectQueryImpl sql = new SelectQueryImpl(new Table("ReportBuildingBlockGroup"));
                    sql.addSelectColumn(new Column("ReportBuildingBlockGroup", "*"));
                    DataObject newRBBG = DataAccess.get((SelectQuery)sql);
                    String[] fireRBBG = new String[]{"PCI-DSS Compliance Queries", "SANS Compliance Queries", "ISO Compliance Queries", "NIST Compliance Queries", "NERC-CIP Compliance Queries", "Service CheckList Queries", "Compliance Queries for PDF"};
                    this.addNewRBBGToExistingDevices(newRBBG, "fire", fireRBBG);
                }
                query = new SelectQueryImpl(new Table("SystemConfigurations"));
                query.addSelectColumn(new Column("SystemConfigurations", "*"));
                crit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"ConfigVersionsMigration", 0);
                query.setCriteria(crit1);
                obj = DataAccess.get((SelectQuery)query);
                String changeMgmtDataMig = "false";
                try {
                    changeMgmtDataMig = !obj.isEmpty() ? (String)obj.getFirstValue("SystemConfigurations", "CONF_VALUE") : "false";
                }
                catch (DataAccessException e) {
                    changeMgmtDataMig = "false";
                }
                if ("true".equals(changeMgmtDataMig)) {
                    String separator = File.separator;
                    StringBuffer fileData = new StringBuffer(1000);
                    String backupDir = System.getProperty("server.dir") + separator + "ConfigVersionsBackup";
                    String ConfigVersionsBackupfilename = backupDir + separator + "ConfigVersions.txt";
                    BufferedReader reader = new BufferedReader(new FileReader(ConfigVersionsBackupfilename));
                    char[] buf = new char[1024];
                    int numRead = 0;
                    while ((numRead = reader.read(buf)) != -1) {
                        String readData = String.valueOf(buf, 0, numRead);
                        fileData.append(readData);
                        buf = new char[1024];
                    }
                    reader.close();
                    String fileContent = fileData.toString();
                    StringBuffer buffer = new StringBuffer();
                    StringCharacterIterator iterator = new StringCharacterIterator(fileContent);
                    char character = iterator.current();
                    while (character != '\uffff') {
                        if (character == '\'') {
                            buffer.append("''");
                        } else if (character == '\r') {
                            buffer.append("\\r");
                        } else if (character == '\n') {
                            buffer.append("\\n");
                        } else if (character == '\u0000') {
                            LOGGER.log(Level.FINER, " Ignoring ^@ char");
                        } else {
                            buffer.append(character);
                        }
                        character = iterator.next();
                    }
                    fileContent = buffer.toString();
                    int prevIndex = 0;
                    int lineIndex = fileContent.indexOf("|&&|&&|\\n", prevIndex);
                    while (lineIndex > 0) {
                        String subContent = fileContent.substring(prevIndex, lineIndex);
                        String[] data = subContent.split("\\|\\&\\&\\|");
                        try {
                            Row confRow = new Row("ConfigVersions");
                            confRow.set("VERSION_ID", (Object)new Long(data[0]));
                            confRow.set("VERSION_NO", (Object)new Long(data[1]));
                            confRow.set("RID", (Object)new Long(data[2]));
                            String configData = data[3];
                            StringBuffer temp = new StringBuffer();
                            try {
                                StringCharacterIterator charIterator = new StringCharacterIterator(configData);
                                char myCharacter = charIterator.current();
                                while (myCharacter != '\uffff') {
                                    if (myCharacter != '\u0000') {
                                        temp.append(myCharacter);
                                    }
                                    myCharacter = charIterator.next();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            temp.append("\n");
                            configData = temp.toString();
                            try {
                                configData = configData.replaceAll("\\\\t", "\t");
                                configData = configData.replaceAll("\\\\r", "\r");
                                configData = configData.replaceAll("\\\\n", "\n");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ByteArrayInputStream is = new ByteArrayInputStream(configData.getBytes("UTF-8"));
                            confRow.set("FILE_CONTENTS", (Object)is);
                            confRow.set("CHANGED_BY", (Object)data[4]);
                            confRow.set("ANNOTATION", (Object)data[5]);
                            confRow.set("CONFIG_TYPE", (Object)data[6]);
                            Timestamp timeStamp = Timestamp.valueOf(data[7]);
                            confRow.set("MODIFIED_TIME", (Object)timeStamp);
                            String diffCnts = data[8];
                            diffCnts = diffCnts.replaceAll("\\\\n", "\n");
                            confRow.set("DIFF_CONTENTS", (Object)diffCnts);
                            confRow.set("DIFF_COUNT", (Object)new Integer(data[9]));
                            DataObject confDo = DataAccess.constructDataObject();
                            confDo.addRow(confRow);
                            DataAccess.add((DataObject)confDo);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                        prevIndex = lineIndex + 9;
                        lineIndex = fileContent.indexOf("|&&|&&|\\n", prevIndex);
                    }
                    File configVersionsDir = new File(backupDir);
                    File[] files = configVersionsDir.listFiles();
                    files[0].delete();
                    configVersionsDir.delete();
                }
                try {
                    CreateSchema cs = new CreateSchema(RelationalAPI.getInstance().getDataSource());
                    cs.createTables("LogAnalyzer");
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, " Unable to recreate la tables", exp);
                }
                DepartmentUtil.populateResToDept();
                SelectQueryImpl selectquery = new SelectQueryImpl(new Table("ReportConfig"));
                selectquery.addSelectColumn(new Column("ReportConfig", "*"));
                DataObject dataOb = DataAccess.get((SelectQuery)selectquery);
                Iterator reportIter = dataOb.getRows("ReportConfig");
                while (reportIter.hasNext()) {
                    Row reportRow = (Row)reportIter.next();
                    Long reportId = (Long)reportRow.get("REPORTID");
                    HashMap map = new HashMap();
                    SQLGenerator sqlGen = new SQLGenerator(reportId, map);
                    DataObject dooSql = sqlGen.generate();
                    LOGGER.log(Level.FINER, "DService: SQL regeneration completed for the ReportID:" + reportId);
                }
                new Thread("SpecialTrendExecutor"){

                    @Override
                    public void run() {
                        LOGGER.log(Level.INFO, "DService: Starting SpecialTrendExecutor :::::::::::");
                        PacketUtil.executeTrendTasks();
                        LOGGER.log(Level.INFO, "DService: Ending SpecialTrendExecutor :::::::::::");
                    }
                }.start();
                Criteria migCriteria1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"regenerateSQL", 0);
                DataAccess.delete((Criteria)migCriteria1);
                migCriteria1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"DatabaseMigration", 0);
                DataAccess.delete((Criteria)migCriteria1);
                migCriteria1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"ConfigVersionsMigration", 0);
                DataAccess.delete((Criteria)migCriteria1);
                this.renameSumScripts();
                File ppmFile = new File(System.getProperty("server.dir") + File.separator + "ppmFile.txt");
                if (ppmFile.exists()) {
                    ppmFile.delete();
                }
                if ((checkListXml = new File(System.getProperty("server.dir") + File.separator + "conf" + File.separator + "FirewallAnalyzer" + File.separator + "CheckListQueries_" + dbType + ".xml")).exists()) {
                    checkListXml.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void renameSumScripts() {
        try {
            String sumLocation = System.getProperty("server.dir") + File.separator + "bin" + File.separator;
            String[] sumFiles = new String[]{".bat", ".sh"};
            for (int i = 0; i < sumFiles.length; ++i) {
                File sumFile;
                String fileExtn = sumFiles[i];
                File sumLiteFile = new File(sumLocation + "sum_mlite" + fileExtn);
                if (!sumLiteFile.exists() || !(sumFile = new File(sumLocation + "sum" + fileExtn)).exists()) continue;
                sumFile.delete();
                sumLiteFile.renameTo(sumFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNewRBBGEntries() {
        try {
            String[] rbbArray = new String[]{"Top Proxy Virus"};
            String[] rbbgArray = new String[]{"Proxy Virus Drill Down"};
            int size = rbbArray.length;
            for (int j = 0; j < size; ++j) {
                UpdateQueryImpl upQ = new UpdateQueryImpl("RBBGraphOptions");
                upQ.setCriteria(new Criteria(new Column("RBBGraphOptions", "RBBNAME"), (Object)rbbArray[j], 0));
                upQ.setUpdateColumn("LINKINGRBBGNAME", (Object)rbbgArray[j]);
                DataAccess.update((UpdateQuery)upQ);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while updating LinkingRBBG into RBBGraphOptions (DService)");
            e.printStackTrace();
        }
    }

    private void addRBBGToExistingUserCreatedRptProfs(DataObject newRBBG, String rbbgForUserCreatedRptProf) {
        try {
            List reportIdList = null;
            Criteria crit = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)"Rules", 0);
            DataObject dobj = DataAccess.get((String)"ReportBuildingBlockGroup", (Criteria)crit);
            Long ruleRbbgId = (Long)dobj.getFirstValue("ReportBuildingBlockGroup", "RBBGID");
            reportIdList = this.getRptIdAsoociatedToRulesRpt(ruleRbbgId);
            Criteria crt = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgForUserCreatedRptProf, 0);
            Long newUnUsedRuleRbbgId = (Long)newRBBG.getValue("ReportBuildingBlockGroup", "RBBGID", crt);
            if (newUnUsedRuleRbbgId == null) {
                LOGGER.log(Level.WARNING, " RBBGID obtained for the rbbg " + rbbgForUserCreatedRptProf + "is NULL");
            }
            if (reportIdList != null && reportIdList.size() > 0 && newUnUsedRuleRbbgId != null) {
                this.associateRBBGToUserCreatedRptProfs(newUnUsedRuleRbbgId, reportIdList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVdomRelatedForCisco() {
        ResultSet rs = null;
        Connection con = null;
        Statement stmt = null;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            con = relAPI.getConnection();
            stmt = con.createStatement();
            String vdomQuery = "select IPADDRESS,count(RESOURCEID) from Resources where VENDOR_TYPE='Cisco' group by IPADDRESS";
            rs = stmt.executeQuery(vdomQuery);
            String ipAddress = null;
            String dnsName = null;
            long resCount = 0L;
            while (rs.next()) {
                ipAddress = rs.getString(1);
                resCount = rs.getLong(2);
                dnsName = DNSResolverThread.getInstance().getDNSName(ipAddress, true);
                if (resCount > 1L) {
                    boolean isFirst = true;
                    SelectQueryImpl query = new SelectQueryImpl(new Table("Resources"));
                    query.addSelectColumn(new Column("Resources", "*"));
                    Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ipAddress, 0);
                    query.setCriteria(crit);
                    DataObject doo = DataAccess.get((SelectQuery)query);
                    if (!doo.isEmpty()) {
                        Criteria new_crt = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)"admin", 0);
                        String devName = (String)doo.getValue("Resources", "RESOURCENAME", new_crt);
                        Iterator itr = doo.getRows("Resources");
                        while (itr.hasNext()) {
                            try {
                                Row row = (Row)itr.next();
                                String resName = (String)row.get("RESOURCENAME");
                                if (resName.equals(devName) || devName == null && isFirst) {
                                    row.set("PHYSICALDEVIP", (Object)"");
                                    isFirst = false;
                                } else {
                                    row.set("PHYSICALDEVIP", (Object)ipAddress);
                                }
                                doo.updateRow(row);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    DataAccess.update((DataObject)doo);
                }
                UpdateQueryImpl query = new UpdateQueryImpl("Resources");
                query.setCriteria(new Criteria(new Column("Resources", "IPADDRESS"), (Object)ipAddress, 0));
                query.setUpdateColumn("PHYSICALDEVICENAME", (Object)dnsName);
                DataAccess.update((UpdateQuery)query);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private List getRptIdAsoociatedToRulesRpt(Long ruleRbbgId) {
        ArrayList<Long> reportIdList = new ArrayList<Long>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ReportConfig"));
            Column selCol1 = new Column("ReportConfig", "*");
            Column selCol2 = new Column("ReportConfigToRBBGMapping", "*");
            String[] colName = new String[]{"REPORTID"};
            Join join_1 = new Join("ReportConfig", "ReportConfigToRBBGMapping", colName, colName, 2);
            query.addSelectColumn(selCol1);
            query.addSelectColumn(selCol2);
            query.addJoin(join_1);
            Criteria crt = new Criteria(new Column("ReportConfig", "REPORTID"), (Object)this.getResourceSpecificReportIDList(), 9);
            crt = crt.and(new Criteria(new Column("ReportConfigToRBBGMapping", "RBBGID"), (Object)ruleRbbgId, 0));
            query.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)query);
            if (!doo.isEmpty()) {
                Long rptID = null;
                Iterator itr = doo.getRows("ReportConfig");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    rptID = (Long)row.get("REPORTID");
                    reportIdList.add(rptID);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return reportIdList;
    }

    private Object[] getResourceSpecificReportIDList() {
        ArrayList<Long> resRptIDList = new ArrayList<Long>();
        try {
            SelectQueryImpl resQuery = new SelectQueryImpl(new Table("ResourcesToReportConfig"));
            Column resToRptCnfgCol = new Column("ResourcesToReportConfig", "*");
            Column rptCnfgCol = new Column("ReportConfig", "*");
            String[] col = new String[]{"REPORTID"};
            Join join = new Join("ResourcesToReportConfig", "ReportConfig", col, col, 1);
            resQuery.addSelectColumn(resToRptCnfgCol);
            resQuery.addSelectColumn(rptCnfgCol);
            resQuery.addJoin(join);
            DataObject resRptConfigDO = DataAccess.get((SelectQuery)resQuery);
            Iterator iter = resRptConfigDO.getRows("ResourcesToReportConfig");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Long resRptID = (Long)row.get("REPORTID");
                resRptIDList.add(resRptID);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return resRptIDList.toArray();
    }

    private void associateRBBGToUserCreatedRptProfs(Long newUnUsedRuleRbbgId, List reportIdList) {
        try {
            DataObject addDO = DataAccess.constructDataObject();
            Object[] reportIdArray = reportIdList.toArray();
            Criteria crt = new Criteria(new Column("ReportConfig", "REPORTID"), (Object)reportIdArray, 8);
            DataObject dobj = DataAccess.get((String)"ReportConfig", (Criteria)crt);
            Iterator itr = dobj.getRows("ReportConfig");
            while (itr.hasNext()) {
                Criteria crt2;
                Row row = (Row)itr.next();
                Long repId = (Long)row.get("REPORTID");
                Criteria crt1 = new Criteria(new Column("ReportConfigToRBBGMapping", "REPORTID"), (Object)repId, 0);
                DataObject doo = DataAccess.get((String)"ReportConfigToRBBGMapping", (Criteria)crt1.and(crt2 = new Criteria(new Column("ReportConfigToRBBGMapping", "RBBGID"), (Object)newUnUsedRuleRbbgId, 0)));
                if (!doo.isEmpty()) continue;
                Row newRow = new Row("ReportConfigToRBBGMapping");
                newRow.set("RBBGID", (Object)newUnUsedRuleRbbgId);
                newRow.set("REPORTID", (Object)repId);
                addDO.addRow(newRow);
            }
            if (addDO.getTableNames().size() > 0) {
                DataAccess.add((DataObject)addDO);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void addNewRBBGToExistingDevices(DataObject newRBBG, String devType, String[] leftSideRBBG) {
        try {
            List reportIdList = null;
            int length = leftSideRBBG.length;
            Long[] rbbgIds = new Long[length];
            int j = 0;
            for (int i = 0; i < length; ++i) {
                String rbbgName = leftSideRBBG[i];
                Criteria crt = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgName, 0);
                rbbgIds[j] = (Long)newRBBG.getValue("ReportBuildingBlockGroup", "RBBGID", crt);
                if (rbbgIds[j] == null) {
                    LOGGER.log(Level.WARNING, " RBBGID obtained for the rbbg " + rbbgName + "is NULL");
                }
                ++j;
            }
            Criteria crit = null;
            if ("Squid".equals(devType)) {
                crit = new Criteria(new Column("Resources", "RESOURCETYPE"), (Object)devType, 0);
            }
            if ((reportIdList = this.getReportIdToAddRBBG(crit)) != null && reportIdList.size() > 0) {
                for (int a = 0; a < rbbgIds.length; ++a) {
                    Long rbbgId = rbbgIds[a];
                    if (rbbgId == null) continue;
                    this.associateRBBGToDefaultReports(rbbgId, reportIdList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addExistingRBBGToExistingDevices(String[] rbbgNamesList, String resCrit) {
        try {
            List reportIdList = null;
            Long[] rbbgIds = new Long[rbbgNamesList.length];
            int j = 0;
            SelectQueryImpl sql = new SelectQueryImpl(new Table("ReportBuildingBlockGroup"));
            Column col = new Column("ReportBuildingBlockGroup", "RBBGID");
            sql.addSelectColumn(col);
            for (int i = 0; i < rbbgNamesList.length; ++i) {
                Criteria crit = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgNamesList[i], 0);
                sql.setCriteria(crit);
                DataObject dObj = DataAccess.get((SelectQuery)sql);
                Iterator it = dObj.getRows("ReportBuildingBlockGroup");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    rbbgIds[j] = (Long)row.get("RBBGID");
                    if (rbbgIds[j] == null) {
                        LOGGER.log(Level.WARNING, " RBBGID obtained for the rbbg " + rbbgNamesList[j] + "is NULL");
                    }
                    ++j;
                }
            }
            Criteria crit = null;
            if ("app".equals(resCrit)) {
                crit = new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)new String[]{"FortiGate", "Unknown CLF", "CiscoVPN", "ANCHIVA"}, 9);
            }
            if ((reportIdList = this.getReportIdToAddRBBG(crit)) != null && reportIdList.size() > 0) {
                for (int a = 0; a < rbbgIds.length; ++a) {
                    Long rbbgId = rbbgIds[a];
                    if (rbbgId == null) continue;
                    this.associateRBBGToDefaultReports(rbbgId, reportIdList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List getReportIdToAddRBBG(Criteria crit) {
        ArrayList<Long> reportIdList = new ArrayList<Long>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ResourcesToReportConfig"));
            Column selCol1 = new Column("ResourcesToReportConfig", "*");
            Column selCol2 = new Column("Resources", "*");
            String[] colName = new String[]{"RESOURCEID"};
            Join join_1 = new Join("ResourcesToReportConfig", "Resources", colName, colName, 2);
            query.addSelectColumn(selCol1);
            query.addSelectColumn(selCol2);
            query.addJoin(join_1);
            query.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator itr = doo.getRows("ResourcesToReportConfig");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Long repId = (Long)row.get("REPORTID");
                reportIdList.add(repId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportIdList;
    }

    private void associateRBBGToDefaultReports(Long rbbgId, List reportIdList) {
        try {
            DataObject addDO = DataAccess.constructDataObject();
            SelectQueryImpl select = new SelectQueryImpl(new Table("ResourcesToReportConfig"));
            Column col_1 = new Column("ResourcesToReportConfig", "*");
            Column col_2 = new Column("ReportConfigToRBBGMapping", "*");
            String[] colName1 = new String[]{"RESOURCEID"};
            String[] colName2 = new String[]{"REPORTID"};
            Join join_1 = new Join("ResourcesToReportConfig", "Resources", colName1, colName1, 2);
            Join join_2 = new Join("ResourcesToReportConfig", "ReportConfigToRBBGMapping", colName2, colName2, 2);
            select.addJoin(join_1);
            select.addJoin(join_2);
            select.addSelectColumn(col_1);
            select.addSelectColumn(col_2);
            DataObject doo = DataAccess.get((SelectQuery)select);
            Iterator itr = doo.getRows("ResourcesToReportConfig");
            while (itr.hasNext()) {
                Criteria crit2;
                Row row = (Row)itr.next();
                Long repId = (Long)row.get("REPORTID");
                Criteria crit1 = new Criteria(new Column("ReportConfigToRBBGMapping", "REPORTID"), (Object)repId, 0);
                Row resultRow = doo.getRow("ReportConfigToRBBGMapping", crit1.and(crit2 = new Criteria(new Column("ReportConfigToRBBGMapping", "RBBGID"), (Object)rbbgId, 0)));
                if (resultRow != null || !reportIdList.contains(repId)) continue;
                Row newRow = new Row("ReportConfigToRBBGMapping");
                newRow.set("RBBGID", (Object)rbbgId);
                newRow.set("REPORTID", (Object)repId);
                addDO.addRow(newRow);
            }
            if (addDO.getTableNames().size() > 0) {
                DataAccess.add((DataObject)addDO);
            }
        }
        catch (Exception dExp) {
            LOGGER.log(Level.WARNING, " Exception while associate RBBG To DefaultReports", dExp);
        }
    }

    public void destroy() {
    }

    public void stop() throws EnterpriseException {
        StatusPoll spObject = StatusPoll.getInstance();
        spObject.shut();
        String dbType = System.getProperty("DBType", "mysql");
        FirewallStatusNotifier statusNotifier = FirewallStatusNotifier.getInstance();
        statusNotifier.stopThread();
        if ("mysql".equals(dbType)) {
            MySQLErrorResolver errorResolver = MySQLErrorResolver.getInstance();
            errorResolver.deleteObserver((Observer)statusNotifier);
        }
        if (StartUPUtil.getInstance().isAdminServer()) {
            AdminServerUtil.getInstance().shutDown();
            return;
        }
        try {
            Map timeDetails = PacketUtil.getLastUpdateMap();
            Iterator itr = timeDetails.keySet().iterator();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UpdateQueryImpl updateSQL = null;
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Long time = (Long)timeDetails.get(name);
                updateSQL = new UpdateQueryImpl("Resources");
                Criteria crt = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)name, 0);
                updateSQL.setCriteria(crt);
                updateSQL.setUpdateColumn("LAST_UPDATE_TIME", (Object)sdf.format(new Date(time)));
                DataAccess.update((UpdateQuery)updateSQL);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (System.getProperty("cleanAutoNumberFix") != null) {
            new Autonumberfix(false).run();
        }
        this.ds.shutdown();
        WriterRepository.getInstance().shutdown();
        this.cleanUpOldFiles();
        this.cleanup.stopCleanUp();
        DWSManager dwsm = DWSManager.getInstance();
        dwsm.shut();
        SNMPQueryThread snmpThread = SNMPQueryThread.getInstance();
        snmpThread.stopSNMPThread();
        IPFIXStaticFlowHandler.getInstance().shutdown();
        METrack.shutdown();
        LOGGER.log(Level.INFO, "DService: Called ExportCleanup() stopCleanUp() ");
    }

    @Override
    public void setListenCISNotification(String v) {
    }

    private void cleanUpOldFiles() {
        LOGGER.log(Level.INFO, "DService: cleanUp of old files called .. ");
        final String[] filePattern = new String[]{"FirewallRecords", "SquidRecords", "UnParsedRecords"};
        String dir = System.getProperty("server.dir") + File.separator + "server" + File.separator + "records";
        File location = new File(dir);
        if (!location.exists()) {
            return;
        }
        File[] recordFiles = location.listFiles();
        this.deleteFiles(recordFiles);
        String tmpLoc = System.getProperty("server.dir") + File.separator + "server" + File.separator + "tmp";
        location = new File(tmpLoc);
        if (!location.exists()) {
            return;
        }
        File[] fNames = location.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean status = false;
                for (int i = 0; i < filePattern.length; ++i) {
                    String pattern = filePattern[i];
                    if (name.indexOf(pattern) < 0) continue;
                    status = true;
                    break;
                }
                return status;
            }
        });
        this.deleteFiles(fNames);
    }

    private void deleteFiles(File[] fNames) {
        if (fNames == null) {
            return;
        }
        for (int j = 0; j < fNames.length; ++j) {
            boolean deleted = fNames[j].delete();
            LOGGER.log(Level.INFO, "[DService] FileName to Delete is {0} Status is {1}", new Object[]{fNames[j], deleted});
        }
    }

    public void startScannerSearch() {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("SystemConfigurations");
            uq.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"virusScanner", 0));
            uq.setUpdateColumn("CONF_VALUE", (Object)"1");
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception in updation before running the anti-virus scanner script");
            e.printStackTrace();
        }
        String osName = System.getProperty("os.name");
        try {
            String commandToExecute = "";
            if (osName.equals("Linux") || osName.equals("SunOS")) {
                return;
            }
            if (osName.startsWith("Win")) {
                commandToExecute = "cmd  /c .\\..\\troubleshooting\\searchscans.vbs ";
            }
            LOGGER.log(Level.FINER, "Command to start Firewall server  {0}", commandToExecute);
            Runtime.getRuntime().exec(commandToExecute);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private boolean checkInstallationType() {
        long start = System.currentTimeMillis();
        boolean isAdminServer = false;
        String enterpriseTxt = System.getProperty("server.dir") + File.separator + "enterprise.txt";
        File enterpriseTxtFile = new File(enterpriseTxt);
        if (!enterpriseTxtFile.exists()) {
            return false;
        }
        try {
            StartUPUtil sUtil = StartUPUtil.getInstance();
            sUtil.initialize();
            isAdminServer = sUtil.isAdminServer();
            if (!isAdminServer) {
                File location = new File(System.getProperty("server.dir") + File.separator + "server" + File.separator + "tmp");
                File[] fNames = location.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean matched = name.endsWith(".txt");
                        LOGGER.log(Level.INFO, "Status Of Delete is " + matched + " for fileName " + name);
                        return matched;
                    }
                });
                this.deleteFiles(fNames);
            }
        }
        catch (EnterpriseException exp) {
            exp.printStackTrace();
        }
        long totalTimeTaken = System.currentTimeMillis() - start;
        return isAdminServer;
    }

    private void createComplianceCheckListXML(String dbType) {
        try {
            File checkListXml = new File(System.getProperty("server.dir") + File.separator + "conf" + File.separator + "FirewallAnalyzer" + File.separator + "CheckListQueries_" + dbType + ".xml");
            Long rbbgId = LaUtil.getRBBGID((String)"Service CheckList Queries");
            Criteria crt = new Criteria(new Column("ReportBuildingBlock", "RBBGID"), (Object)rbbgId, 0);
            DataObject doo = DataAccess.get((String)"ReportBuildingBlock", (Criteria)crt);
            if (!checkListXml.exists()) {
                Do2XmlConverter.transform((DataObject)doo, (String)checkListXml.toString(), (boolean)true);
            } else {
                DataObject doo2 = Xml2DoConverter.transform((URL)checkListXml.toURL());
                DataObject diff = doo.diff(doo2);
                if (diff.containsTable("ReportBuildingBlock")) {
                    DataAccess.update((DataObject)diff);
                    SelectQueryImpl selectquery = new SelectQueryImpl(new Table("ReportConfigToRBBGMapping"));
                    selectquery.addSelectColumn(new Column("ReportConfigToRBBGMapping", "*"));
                    Criteria crt1 = new Criteria(new Column("ReportConfigToRBBGMapping", "RBBGID"), (Object)rbbgId, 0);
                    selectquery.setCriteria(crt1);
                    DataObject dataOb = DataAccess.get((SelectQuery)selectquery);
                    Iterator reportIter = dataOb.getRows("ReportConfigToRBBGMapping");
                    while (reportIter.hasNext()) {
                        Row reportRow = (Row)reportIter.next();
                        Long reportId = (Long)reportRow.get("REPORTID");
                        HashMap map = new HashMap();
                        SQLGenerator sqlGen = new SQLGenerator(reportId, map);
                        sqlGen.setChecklistCrt(true);
                        DataObject dooSql = sqlGen.generate();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFWAForHighFlowRate() {
        if ("false".equals(System.getProperty("highFlow", "false"))) {
            return;
        }
        DataObject dobj = null;
        LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() seems highFlow property is set. So trying to run the pre-requisites for high flow.");
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dobj = DataAccess.get((List)tableNames, (Criteria)crt);
            if (!dobj.isEmpty()) {
                LOGGER.log(Level.INFO, "Seems high flow rate pre-requisties have already been performed in this server. So doing nothing !!");
                return;
            }
            LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() STEP-1 about to run the Raw table splitter task ");
            PacketUtil.executeFreeFlowTaskGroups(new String[]{"RawTableSplitter-1"});
            LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() Complete running of RawTableSplitter Task");
            RelationalAPI relAPI = RelationalAPI.getInstance();
            con = relAPI.getConnection();
            stmt = con.createStatement();
            try {
                LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() STEP-2 about to remove the index defined in RawTables");
                if ("postgres".equals(System.getProperty("DBType"))) {
                    stmt.executeUpdate("DROP INDEX FirewallRecords_TIME_IDX");
                    stmt.executeUpdate("DROP INDEX FirewallRecords_STARTTIME_IDX");
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS FirewallRecords_BK ( LIKE FirewallRecords INCLUDING DEFAULTS )");
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS SquidRecords_BK ( LIKE SquidRecords INCLUDING DEFAULTS )");
                } else if ("mysql".equals(System.getProperty("DBType"))) {
                    stmt.executeUpdate("DROP INDEX Firewall_TIME ON FirewallRecords");
                    stmt.executeUpdate("DROP INDEX Firewall_STARTTIME on FirewallRecords");
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS FirewallRecords_BK LIKE FirewallRecords");
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS SquidRecords_BK LIKE SquidRecords ");
                } else {
                    stmt.executeUpdate("DROP INDEX FirewallRecords.Firewall_TIME");
                    stmt.executeUpdate("DROP INDEX FirewallRecords.Firewall_STARTTIME");
                    stmt.executeUpdate("if NOT EXISTS (select * from sysobjects where name='FirewallRecords_BK') SELECT TOP 0 * into FirewallRecords_BK from FirewallRecords go");
                    stmt.executeUpdate("if NOT EXISTS (select * from sysobjects where name='SquidRecords_BK') SELECT TOP 0 * into SquidRecords_BK from SquidRecords go");
                }
            }
            catch (Exception exp) {
                LOGGER.log(Level.WARNING, "Exception occurred while dropping index on RawTables", exp);
            }
            LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() Complete removing index on RawTables");
            Row r = new Row("SystemConfigurations");
            r.set("CONF_NAME", (Object)"HF_INIT");
            r.set("CONF_VALUE", (Object)"true");
            dobj.addRow(r);
            DataAccess.add((DataObject)dobj);
            LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() Completed: Updating System Configuration");
        }
        catch (DataAccessException dExp) {
            LOGGER.log(Level.WARNING, " Exception occurred. ", dExp);
        }
        catch (SQLException sExp) {
            LOGGER.log(Level.WARNING, " Exception occurred. ", sExp);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exp) {
                con = null;
                stmt = null;
            }
        }
        LOGGER.log(Level.INFO, " DService.prepareFWAForHighFlowRate() Complete the Pre-requisites of converting the installation to support high flow");
    }
}

