/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.la.util.MetaTableCache;
import com.adventnet.la.util.dm.MssqlProcessHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DWSManager
implements Runnable {
    private static DWSManager mObj = null;
    private boolean dropTask = false;
    private boolean shutDown = false;
    private boolean runSplitter = false;
    private ArrayList dropKey = null;
    private ArrayList truncateKey = null;
    private String[] taskArray = new String[]{"MgmtRecords CleanUpTask"};
    private static boolean isMssql = "mssql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType"));

    private DWSManager() {
    }

    public static synchronized DWSManager getInstance() {
        if (mObj == null) {
            mObj = new DWSManager();
        }
        return mObj;
    }

    public void init() {
        Thread t = new Thread(mObj);
        t.start();
    }

    public void shut() {
        this.shutDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndTruncate(ArrayList dKey, ArrayList tKey, boolean rSplitter) {
        this.dropKey = dKey;
        this.truncateKey = tKey;
        this.runSplitter = rSplitter;
        if (this.dropKey.size() > 0 || this.truncateKey.size() > 0) {
            this.dropTask = true;
        }
        DWSManager dWSManager = mObj;
        synchronized (dWSManager) {
            mObj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutDown) {
            int archiveDWS;
            if (this.dropTask) {
                this.dropAndTruncateTask();
                this.dropTask = false;
            }
            if (this.runSplitter) {
                PacketUtil.executeFreeFlowTaskGroups(this.taskArray);
            }
            if ((archiveDWS = this.getArchiveDWS()) > -1) {
                LogIndexingAPI.getInstance().cleanupIndexesByDB(archiveDWS);
                this.archiveDeleteTask(archiveDWS);
            }
            DWSManager dWSManager = mObj;
            synchronized (dWSManager) {
                try {
                    mObj.wait(this.getAdjustedSleepTime());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAndTruncateTask() {
        Connection con = null;
        Statement stmt = null;
        try {
            RelationalAPI rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stmt = con.createStatement();
            this.dropTables(stmt);
            this.truncateTables(stmt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void archiveDeleteTask(int archiveDWS) {
        Long critTime = new Long(System.currentTimeMillis() - (long)archiveDWS * 86400000L);
        try {
            SelectQueryImpl squery = new SelectQueryImpl(new Table("FAArchivedFiles"));
            squery.addSelectColumn(new Column("FAArchivedFiles", "*"));
            Criteria crt = new Criteria(new Column("FAArchivedFiles", "ARCHIVED_TIME"), (Object)critTime, 7);
            squery.setCriteria(crt);
            DataObject dobj = DataAccess.get((SelectQuery)squery);
            Iterator iter = dobj.getRows("FAArchivedFiles");
            while (iter.hasNext()) {
                String fname = (String)((Row)iter.next()).get("FILE_NAME");
                new File(fname).delete();
            }
            FAServerUtil.getPersistence().delete(crt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dropTables(Statement stmt) throws Exception {
        if (this.dropKey.size() > 0) {
            String crit = "LOOKUP_TABLENAME like '%" + this.dropKey.get(0) + "%'";
            for (int i = 1; i < this.dropKey.size(); ++i) {
                crit = crit + " or LOOKUP_TABLENAME like '%" + this.dropKey.get(i) + "%'";
            }
            ResultSet rs = stmt.executeQuery("select TABLE_NAME,LOOKUP_TABLENAME from MetaTable where " + crit);
            String dropTables = "";
            MetaTableCache mtc = MetaTableCache.getInstance();
            String baseTable = "";
            String splitTable = "";
            while (rs.next()) {
                baseTable = rs.getString(1);
                splitTable = rs.getString(2);
                dropTables = dropTables + splitTable + ",";
                boolean result = mtc.remove(baseTable, splitTable);
                if (result) continue;
                System.out.println("Error while deleting the table " + splitTable + " stored in memory(MetaTableCache)");
            }
            if (dropTables.length() > 0) {
                dropTables = dropTables.substring(0, dropTables.length() - 1);
                this.dropTablesFromDatabase(dropTables, stmt);
                stmt.executeUpdate("delete from MetaTable where " + crit);
                System.out.println("Dropped tables : " + dropTables);
            }
            rs.close();
        }
    }

    private void dropTablesFromDatabase(String dropTableList, Statement stmt) {
        try {
            if (isMssql) {
                StringTokenizer stoken = new StringTokenizer(dropTableList, ",");
                while (stoken.hasMoreTokens()) {
                    String table = stoken.nextToken();
                    String dropTableQuery = "IF EXISTS(select * from sysobjects where name='" + table + "') DROP TABLE " + table;
                    stmt.executeUpdate(dropTableQuery);
                }
            } else if (isPostgres) {
                String dropTableQuery = "truncate table " + dropTableList;
                stmt.executeUpdate(dropTableQuery);
            } else {
                String dropTableQuery = "drop table if exists " + dropTableList;
                stmt.executeUpdate(dropTableQuery);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void truncateTables(Statement stmt) throws Exception {
        if (this.truncateKey.size() > 0) {
            String[] createQuery = new String[60];
            String crit = "LOOKUP_TABLENAME like '%" + this.truncateKey.get(0) + "%'";
            for (int i = 1; i < this.truncateKey.size(); ++i) {
                crit = crit + " or LOOKUP_TABLENAME like '%" + this.truncateKey.get(i) + "%'";
            }
            ResultSet rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable where " + crit);
            String dropTables = "";
            while (rs.next()) {
                dropTables = dropTables + rs.getString(1) + ",";
            }
            int count = 0;
            if (dropTables.length() > 0) {
                dropTables = dropTables.substring(0, dropTables.length() - 1);
                String[] tableNames = dropTables.split(",");
                MssqlProcessHandler sqlHandler = MssqlProcessHandler.getInstance();
                for (int i = 0; i < tableNames.length; ++i) {
                    String tableName = tableNames[i];
                    if (isMssql) {
                        String sqlTableQuery;
                        createQuery[count] = sqlTableQuery = sqlHandler.constructCompleteQuery(tableName);
                        ++count;
                        continue;
                    }
                    if (isPostgres || !(rs = stmt.executeQuery("show create table " + tableName)).next()) continue;
                    createQuery[count] = rs.getString(2);
                    ++count;
                }
                this.dropTablesFromDatabase(dropTables, stmt);
            }
            if (!isPostgres) {
                for (int i = 0; i < count; ++i) {
                    stmt.executeUpdate(createQuery[i]);
                }
            }
            System.out.println("Truncated tables : " + dropTables);
            rs.close();
        }
    }

    private long getAdjustedSleepTime() {
        GregorianCalendar gregCalen = new GregorianCalendar();
        gregCalen.set(11, 1);
        gregCalen.set(12, 0);
        gregCalen.set(13, 0);
        gregCalen.add(5, 1);
        return gregCalen.getTimeInMillis() - System.currentTimeMillis();
    }

    private int getArchiveDWS() {
        int archiveDWS = -1;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"archiveDWS", 0);
            query.setCriteria(crt);
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SystemConfigurations");
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                archiveDWS = Integer.parseInt((String)row.get("CONF_VALUE"));
            } else {
                archiveDWS = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return archiveDWS;
    }
}

