/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FileToDBLoader;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.InterfaceObject;
import com.adventnet.fa.server.ResourceDetails;
import com.adventnet.fa.server.rules.FWAPolicyParserRulesLoader;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.la.util.IPRange;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FACacheManager {
    private static final Logger LOGGER = Logger.getLogger(FACacheManager.class.getName());
    private static FACacheManager fm = null;
    private Persistence persistence = null;
    private HashSet users = new HashSet();
    private FixedHashMap fwToSyslogMap = new FixedHashMap(500);
    private FixedHashMap syslogCollectorMap = new FixedHashMap(500);
    public FixedHashMap prioritiesMap = new FixedHashMap(100);
    private FixedHashMap categoriesMap = new FixedHashMap(800);
    private FixedHashMap httpStatusCodes = new FixedHashMap(100);
    private FixedHashMap peerStatusCodes = new FixedHashMap(100);
    private FixedHashMap squidCacheCodes = new FixedHashMap(100);
    private List<Long> ipTo = new ArrayList<Long>();
    private List<Integer> countryId = new ArrayList<Integer>();
    private Long[] dum;
    private FixedHashMap countries = new FixedHashMap(300);
    private FixedHashMap deviceInterfaceIndexMap = new FixedHashMap(500);
    private FixedHashMap deviceSnmpMap = new FixedHashMap(500);
    private FixedHashMap identifiedInterfaceMap = new FixedHashMap(500);
    private FixedHashMap reportIDVsReportProfileName = new FixedHashMap(50);
    private List vdomSupportedDevList = new ArrayList();
    private static String file = System.getProperty("server.home") + File.separator + "conf" + File.separator + "FirewallAnalyzer" + File.separator + "CountryCode.csv";
    private ArrayList<String> defaultEncryptProtoList = new ArrayList();
    private ArrayList<String> encryptProtoList = new ArrayList();

    private FACacheManager() {
        this.init();
    }

    public static synchronized FACacheManager getInstance() {
        if (fm == null) {
            fm = new FACacheManager();
        }
        return fm;
    }

    private void init() {
        this.loadSyslogDetails();
        this.loadPriorities();
        this.loadSnmpDeviceMap();
        this.loadCategories();
        this.loadFrmDB("AuthUsers", "USERNAME", null, this.users, true);
        this.loadFrmDB("HttpStatusCode", "CODE", "HTTP_ID", this.httpStatusCodes);
        this.loadFrmDB("SquidCacheCode", "CODE", "CACHE_ID", this.squidCacheCodes);
        this.loadFrmDB("PeerStatusCode", "CODE", "PEER_ID", this.peerStatusCodes);
        this.loadFrmDB("GeoLocation", "COUNTRY_NAME", "COUNTRY_ID", this.countries);
        this.loadCountryRange();
        this.vdomSupportedDevList.add("Cisco");
        this.vdomSupportedDevList.add("FortiGate");
        this.defaultEncryptProtoList.add("scp");
        this.defaultEncryptProtoList.add("sftp");
        this.defaultEncryptProtoList.add("https");
        this.defaultEncryptProtoList.add("ftps");
        this.defaultEncryptProtoList.add("ssh");
        this.defaultEncryptProtoList.add("ssl");
        this.encryptProtoList = this.defaultEncryptProtoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEncryptProtocolsFromFile() {
        this.encryptProtoList = this.defaultEncryptProtoList;
        String homeDir = System.getProperty("server.dir");
        String encProtoFilePath = homeDir + File.separator + "server" + File.separator + "default" + File.separator + "EncryptedProtocolDetails.txt";
        File encProtoFile = new File(encProtoFilePath);
        FileInputStream is = null;
        BufferedReader reader = null;
        try {
            String proto;
            is = new FileInputStream(encProtoFile);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((proto = reader.readLine()) != null) {
                proto = proto.trim();
                this.encryptProtoList.add(proto);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public ArrayList<String> getEncryptProtoList() {
        return this.encryptProtoList;
    }

    public Object getHttpStatusID(String value) {
        return this.getID((Map)this.httpStatusCodes, "HttpStatusCode", "HTTP_ID", value);
    }

    public Object getSquidStatusID(String value) {
        return this.getID((Map)this.squidCacheCodes, "SquidCacheCode", "CACHE_ID", value);
    }

    public Object getPeerStatusID(String value) {
        return this.getID((Map)this.peerStatusCodes, "PeerStatusCode", "PEER_ID", value);
    }

    private Object getID(Map storage, String tableName, String fetchColumn, String value) {
        long start = System.currentTimeMillis();
        Object id = storage.get(value = value != null ? value.trim() : "UnKnown");
        if (id == null) {
            try {
                DataObject dao = this.getDO();
                Row r = new Row(tableName);
                r.set(2, (Object)value);
                dao.addRow(r);
                dao = DataAccess.add((DataObject)dao);
                id = r.get(fetchColumn);
                storage.put(value, (Long)id);
            }
            catch (Exception exp) {
                String msg = "Exception while updating values for table " + tableName + " with value " + value;
                LOGGER.log(Level.WARNING, msg, exp);
            }
        }
        return id;
    }

    public void loadPriorities() {
        try {
            DataObject prioritiesDO = this.loadDetails("Priorities");
            if (prioritiesDO.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unable to load Priorities from DB ");
                return;
            }
            Iterator priDoItr = prioritiesDO.getRows("Priorities");
            while (priDoItr.hasNext()) {
                Row priRow = (Row)priDoItr.next();
                String pri = (String)priRow.get("PRIORITY");
                String priName = (String)priRow.get("PRIORITY_NAME");
                this.prioritiesMap.put((Object)pri, (Object)priName.toLowerCase());
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public String getPriority(String priority) {
        String frmMemory = this.getPriorityFrmMem(priority);
        return frmMemory != null ? frmMemory : this.addPriority(priority);
    }

    private String getPriorityFrmMem(String name) {
        long start = System.currentTimeMillis();
        String toReturn = null;
        if (this.prioritiesMap.containsKey((Object)name.toLowerCase())) {
            toReturn = name;
        } else {
            Object[] keys = this.prioritiesMap.keySet().toArray();
            int size = keys.length;
            for (int i = 0; i < size; ++i) {
                String key = (String)keys[i];
                String value = (String)this.prioritiesMap.get((Object)key);
                if (!value.equalsIgnoreCase(name.toLowerCase())) continue;
                toReturn = key;
                break;
            }
        }
        return toReturn;
    }

    private String addPriority(String priority) {
        long start = System.currentTimeMillis();
        try {
            DataObject dao = this.getDO();
            Row r = new Row("Priorities");
            r.set(2, (Object)priority);
            r.set(3, (Object)priority);
            dao.addRow(r);
            DataAccess.add((DataObject)dao);
            this.prioritiesMap.put((Object)priority, (Object)priority.toLowerCase());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return priority;
    }

    public void reloadPriorities() {
        this.prioritiesMap = new FixedHashMap(100);
        this.loadPriorities();
    }

    private void loadCategories() {
        try {
            DataObject categoriesDO = this.loadDetails("Categories");
            if (categoriesDO.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unable to load Categories from DB ");
                return;
            }
            Iterator categoryDoItr = categoriesDO.getRows("Categories");
            while (categoryDoItr.hasNext()) {
                Row categoryRow = (Row)categoryDoItr.next();
                Long categoryId = (Long)categoryRow.get("CATEGORY_ID");
                String category = (String)categoryRow.get("CATEGORY_NAME");
                this.categoriesMap.put((Object)category, (Object)categoryId);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public long getCategoryId(String category) {
        long newCatId = 0L;
        long idFrmMemory = this.getCategoryIdFrmMem(category);
        if (idFrmMemory != 0L) {
            return idFrmMemory;
        }
        newCatId = this.addCategory(category);
        if (newCatId > 0L) {
            this.categoriesMap.put((Object)category, (Object)newCatId);
        }
        return newCatId;
    }

    private long getCategoryIdFrmMem(String name) {
        long toReturn = 0L;
        if (this.categoriesMap.containsKey((Object)name)) {
            Long val = (Long)this.categoriesMap.get((Object)name);
            toReturn = val;
        }
        return toReturn;
    }

    private long addCategory(String category) {
        long id = 0L;
        try {
            DataObject dao = this.getDO();
            Row r = new Row("Categories");
            r.set(2, (Object)category);
            dao.addRow(r);
            DataAccess.add((DataObject)dao);
            id = (Long)r.get(1);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return id;
    }

    public void addUser(Hashtable data) {
        if (data == null) {
            return;
        }
        String user = (String)data.get("USERNAME");
        if (user == null) {
            String uName = (String)data.get("USER");
            user = uName == null ? "Unknown" : uName;
        }
        this.addUser(user);
    }

    public void addUser(String username) {
        if (username == null) {
            return;
        }
        if (username.trim().length() <= 0) {
            username = "Unknown";
        }
        long start = System.currentTimeMillis();
        username = username.trim();
        String userInLowerCase = (username = username.replaceAll("\\\\\\\\", "\\\\")).toLowerCase();
        if (!this.users.contains(userInLowerCase)) {
            try {
                DataObject dao = this.getDO();
                Row r = new Row("AuthUsers");
                r.set(2, (Object)username);
                dao.addRow(r);
                dao = DataAccess.add((DataObject)dao);
                this.users.add(userInLowerCase);
                dao = null;
            }
            catch (Exception dExp) {
                LOGGER.log(Level.WARNING, "Exception while adding users to storage medium ", dExp);
            }
        }
    }

    public void updateSyslogToFWMap(Hashtable data) {
        String ip;
        if (data == null) {
            return;
        }
        String syslogID = (String)data.get("SYSLOG_SERVER");
        String resource = (String)data.get("RESOURCE");
        if (resource == null) {
            resource = (String)data.get("FW");
            resource = resource == null ? (String)data.get("Host") : resource;
        }
        syslogID = (ip = (String)data.get("SYSLOGIP")) != null ? syslogID + "," + ip : syslogID;
        this.updateSyslogToFWMap(resource, syslogID);
    }

    public void updateSyslogToFWMap(String resource, String syslogID) {
        if (resource == null) {
            LOGGER.log(Level.WARNING, "Resource is Null.Unable to update Firewall to SyslogServer Map.");
            return;
        }
        String lic_resourceName = FirewallLicenseManager.getInstance().getResourceNameFromDevice(resource);
        if (lic_resourceName != null) {
            resource = lic_resourceName;
        }
        this.fwToSyslogMap.put((Object)resource, (Object)syslogID);
    }

    public void removeResource(String resource) {
        String lic_resourceName = FirewallLicenseManager.getInstance().getResourceNameFromDevice(resource);
        if (lic_resourceName != null) {
            resource = lic_resourceName;
        }
        this.fwToSyslogMap.remove((Object)resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFrmDeviceRule(String resourceId, String ip, String newBaseDevRID) {
        try {
            Column column;
            Criteria crt;
            Long ddid;
            Long rid;
            block8: {
                rid = new Long(resourceId);
                ddid = null;
                List ddidToResList = null;
                List vdomList = FAServerUtil.getVdomDevicesList();
                crt = new Criteria(new Column("DeviceDetails", "RID"), (Object)rid, 0);
                Criteria profCrt = new Criteria(new Column("DIPToResourcesMapping", "RID"), (Object)rid, 0);
                DataObject dobj = DataAccess.constructDataObject();
                SelectQueryImpl sql = new SelectQueryImpl(new Table("DeviceDetails"));
                sql.addSelectColumn(new Column("DeviceDetails", "*"));
                sql.setCriteria(crt);
                dobj = DataAccess.get((SelectQuery)sql);
                if (!dobj.isEmpty()) {
                    ddid = (Long)dobj.getFirstValue("DeviceDetails", "DDID");
                    ddidToResList = FAServerUtil.getResForDDID(ddid);
                    if (vdomList.contains(ip) && ddidToResList.size() > 1) {
                        this.updateRIDInDeviceDetails(ddid, rid, newBaseDevRID);
                        column = new Column("DIPToResourcesMapping", "RID");
                        crt = new Criteria(column, (Object)rid, 0);
                        FAServerUtil.getPersistence().delete(crt);
                        break block8;
                    } else {
                        FAServerUtil.getPersistence().delete(crt);
                        FAServerUtil.removeResListForDDID(ddid);
                        return;
                    }
                }
                dobj = DataAccess.constructDataObject();
                sql = new SelectQueryImpl(new Table("DIPToResourcesMapping"));
                sql.addSelectColumn(new Column("DIPToResourcesMapping", "*"));
                sql.setCriteria(profCrt);
                dobj = DataAccess.get((SelectQuery)sql);
                if (!dobj.isEmpty()) {
                    ddid = (Long)dobj.getFirstValue("DIPToResourcesMapping", "DDID");
                    column = new Column("DIPToResourcesMapping", "RID");
                    crt = new Criteria(column, (Object)rid, 0);
                    FAServerUtil.getPersistence().delete(crt);
                } else if (vdomList.contains(ip)) {
                    ddid = this.getDDID(rid);
                }
            }
            column = new Column("DDSchedules", "RID");
            crt = new Criteria(column, (Object)rid, 0);
            DataAccess.delete((Criteria)crt);
            column = new Column("ChangeMgmtSchedules", "RID");
            crt = new Criteria(column, (Object)rid, 0);
            DataAccess.delete((Criteria)crt);
            column = new Column("ChangeMgmt2RptConfig", "RID");
            crt = new Criteria(column, (Object)rid, 0);
            DataAccess.delete((Criteria)crt);
            if (ddid == null) return;
            FAServerUtil.removeResForDDID(ddid, rid);
            return;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void updateRIDInDeviceDetails(Long ddid, Long rid, String newBaseDevRID) {
        try {
            Long tempRID = null;
            Long modBaseDevRID = new Long(newBaseDevRID);
            boolean updateNewBaseDevRID = false;
            List ridList = FAServerUtil.getResForDDID(ddid);
            for (int i = 0; i < ridList.size(); ++i) {
                tempRID = (Long)ridList.get(i);
                if (!modBaseDevRID.equals(tempRID)) continue;
                updateNewBaseDevRID = true;
            }
            tempRID = updateNewBaseDevRID ? modBaseDevRID : (Long)ridList.get(0);
            UpdateQueryImpl uq = new UpdateQueryImpl("DeviceDetails");
            Criteria crit = new Criteria(new Column("DeviceDetails", "DDID"), (Object)ddid, 0);
            uq.setCriteria(crit);
            uq.setUpdateColumn("RID", (Object)tempRID);
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private Long getDDID(Long rid) {
        Long ddid2 = null;
        ArrayList resList = null;
        try {
            Hashtable ddidToResMap = FAServerUtil.getDDIDToResMap();
            for (Long ddid2 : ddidToResMap.keySet()) {
                resList = (ArrayList)ddidToResMap.get(ddid2);
                if (!resList.contains(rid)) continue;
                return ddid2;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ddid2;
    }

    public void handleResObj(String resName, String physicalDevName, String ip) {
        try {
            String resObjKey = ip;
            ResourceDetails resObj = FAServerUtil.getResObject(ip);
            if (resObj == null) {
                resObj = FAServerUtil.getResObject(physicalDevName);
                resObjKey = physicalDevName;
            }
            if (resObj != null) {
                resObj.removeVdom(resName);
                int count = resObj.getResCount();
                if (count == 0) {
                    FAServerUtil.removeResObject(resObjKey);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public String handlePhysicalDevIPUpdation(String ip, String resourceId, Boolean isMainDevAvailable) {
        try {
            boolean mainDevExists;
            List vdomList = FAServerUtil.getVdomDevicesList();
            if (vdomList.contains(ip) && !(mainDevExists = isMainDevAvailable.booleanValue())) {
                String resIDs = FAServerUtil.getIPResMap(ip);
                String[] rids = resIDs.split(",");
                String tempRID = null;
                for (int i = 0; i < rids.length && (tempRID = rids[i]).equals(resourceId); ++i) {
                }
                if (tempRID != null || "null".equals(tempRID)) {
                    this.updateMainDevice(new Long(tempRID));
                    return tempRID;
                }
            }
            return null;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    private void updateMainDevice(Long tempRID) {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("Resources");
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)tempRID, 0);
            uq.setCriteria(crit);
            uq.setUpdateColumn("PHYSICALDEVIP", (Object)"");
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void removeSyslogServer(String syslogID) {
        if (syslogID == null) {
            LOGGER.log(Level.WARNING, "SyslogServer ID is Null.Unable to update Firewall to SyslogServer Map.");
            return;
        }
        LOGGER.log(Level.INFO, " Inside not null check & abt to delete {0} ", syslogID);
        Iterator itr = this.fwToSyslogMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String id = (String)this.fwToSyslogMap.get((Object)key);
            if (!syslogID.equals(id)) continue;
            itr.remove();
            LOGGER.log(Level.INFO, " Removed the syslog server with ID {0}", id);
            break;
        }
        this.syslogCollectorMap.remove((Object)syslogID);
        LOGGER.log(Level.INFO, " After deletion the Firewall<->Syslog Map is {0}", this.fwToSyslogMap);
    }

    public String getResourceNameFromIPAddress(String ip) {
        if (ip == null) {
            return null;
        }
        for (Map.Entry entry : this.fwToSyslogMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] array = value.split(",");
            if (array.length != 2 || !array[1].equals(ip)) continue;
            return key;
        }
        return null;
    }

    public Map getFwToSyslogMap() {
        return this.fwToSyslogMap;
    }

    private DataObject loadDetails(String tableName) {
        return this.loadDetails(tableName, null);
    }

    private DataObject loadDetails(String tableName, Criteria crt) {
        DataObject toReturn = null;
        try {
            Table ent = new Table(tableName);
            SelectQueryImpl selectquery = new SelectQueryImpl(ent);
            Column selectAtt = new Column(tableName, "*");
            selectquery.addSelectColumn(selectAtt);
            if (crt != null) {
                selectquery.setCriteria(crt);
            }
            toReturn = DataAccess.get((SelectQuery)selectquery);
        }
        catch (Exception exp) {
            String msg = "Exception while load details from table " + tableName;
            LOGGER.log(Level.WARNING, msg, exp);
        }
        return toReturn;
    }

    private void loadFrmDB(String tableName, String key, String value, Object storage) {
        this.loadFrmDB(tableName, key, value, storage, false);
    }

    private void loadFrmDB(String tableName, String key, String value, Object storage, boolean toLowerCase) {
        try {
            DataObject httpDO = this.loadDetails(tableName);
            if (httpDO.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unable to load details for {0} ", tableName);
                return;
            }
            Iterator httpDOItr = httpDO.getRows(tableName);
            while (httpDOItr.hasNext()) {
                Row httpRow = (Row)httpDOItr.next();
                String code = (String)httpRow.get(key);
                if (code != null) {
                    String string = code = toLowerCase ? code.toLowerCase() : code;
                }
                if (value != null) {
                    Long id = (Long)httpRow.get(value);
                    ((Map)storage).put(code, id);
                    continue;
                }
                ((Collection)storage).add(code);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void reloadSyslogDetails() {
        this.syslogCollectorMap = new FixedHashMap(500);
        this.loadSyslogDetails();
    }

    private void loadSyslogDetails() {
        try {
            DataObject syslogDO = this.loadDetails("SyslogCollectors");
            if (syslogDO.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unable to load SyslogCollectors from DB ");
                return;
            }
            Iterator sysDoItr = syslogDO.getRows("SyslogCollectors");
            while (sysDoItr.hasNext()) {
                Row sysRow = (Row)sysDoItr.next();
                Properties details = new Properties();
                Long sysID = (Long)sysRow.get("SYSLOGCOLLECTOR_ID");
                String syslogServerName = (String)sysRow.get("SYSLOGSERVERNAME");
                details.put("name", syslogServerName);
                Long port = (Long)sysRow.get("PORT");
                details.put("port", port + "");
                String status = (String)sysRow.get("STATUS");
                details.put("status", status);
                this.syslogCollectorMap.put((Object)("" + sysID), (Object)details);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception while populating SyslogCollectors details ", exp);
        }
    }

    public Map getSyslogCollectorMap() {
        return this.syslogCollectorMap;
    }

    public void updateStatusToSysColMap(String sysID, String status) {
        Properties details = (Properties)this.syslogCollectorMap.get((Object)sysID);
        details.put("status", status);
    }

    private void loadSnmpDeviceMap() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("InterfaceInfo"));
            query.addSelectColumn(new Column("InterfaceInfo", "*"));
            query.addSelectColumn(new Column("Resources", "*"));
            Join join = new Join("InterfaceInfo", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
            Criteria crit = new Criteria(new Column("Resources", "RESOURCETYPE"), (Object)"Firewall", 0);
            query.addJoin(join);
            query.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator itr = doo.getRows("InterfaceInfo");
            while (itr.hasNext()) {
                Row intRow = (Row)itr.next();
                Row resRow = doo.getFirstRow("Resources", intRow);
                String resName = (String)resRow.get("RESOURCENAME");
                String resId = (Long)intRow.get("RID") + "";
                long ifIndex = (Long)intRow.get("IF_INDEX");
                String ifName = (String)intRow.get("IF_NAME");
                String ifDisplay = (String)intRow.get("IF_DISPLAY");
                String ifNetwork = (String)intRow.get("IF_NETWORK");
                String resKey = resName + "_" + ifName;
                if ("".equals(ifNetwork)) {
                    this.addToIdentifiedInterfaceMap(resName, ifName);
                }
                this.deviceInterfaceIndexMap.put((Object)resKey, (Object)new Long(ifIndex));
                HashMap interHash = new HashMap();
                InterfaceObject interObject = new InterfaceObject(ifName, ifIndex, ifNetwork, ifDisplay);
                this.addToDeviceSnmpMap(resId, ifName, interObject);
                this.addToDeviceInterfaceMap(resId);
            }
            LOGGER.log(Level.INFO, "SNMP::::::FACacheManager::::::RID:::::::::::::Hash::::::" + this.deviceSnmpMap);
            LOGGER.log(Level.INFO, "SNMP::::::FACacheManager::::::RES_IF_IND::::::Hash::::::" + this.deviceInterfaceIndexMap);
            LOGGER.log(Level.INFO, "SNMP::::::FACacheManager::::::Iden_IFMap::::::Hash::::::" + this.identifiedInterfaceMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addToDeviceSnmpMap(String resId, String ifName, InterfaceObject interObject) {
        if (this.deviceSnmpMap.containsKey((Object)resId)) {
            HashMap tempHash = (HashMap)this.deviceSnmpMap.get((Object)resId);
            this.deviceSnmpMap.remove((Object)resId);
            tempHash.put(ifName, interObject);
            this.deviceSnmpMap.put((Object)resId, (Object)tempHash);
        } else {
            HashMap<String, InterfaceObject> interHash = new HashMap<String, InterfaceObject>();
            interHash.put(ifName, interObject);
            this.deviceSnmpMap.put((Object)resId, interHash);
        }
    }

    public HashMap getInterfaceDetails(String resId) {
        if (this.deviceSnmpMap.containsKey((Object)resId)) {
            return (HashMap)this.deviceSnmpMap.get((Object)resId);
        }
        return null;
    }

    public void addToDeviceInterfaceMap(String resId) {
        String resName = resId;
        try {
            HashMap interHash;
            SelectQueryImpl select = new SelectQueryImpl(new Table("Resources"));
            select.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)new Long(resId), 0);
            select.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)select);
            if (doo.containsTable("Resources")) {
                Row rRow = doo.getRow("Resources");
                resName = (String)rRow.get("RESOURCENAME");
            }
            if ((interHash = (HashMap)this.deviceSnmpMap.get((Object)resId)) != null && interHash.size() > 0) {
                for (String ifNamekey : interHash.keySet()) {
                    InterfaceObject intObject = (InterfaceObject)interHash.get(ifNamekey);
                    long ifIndex = intObject.getInterfaceIndex();
                    String resKey = resName + "_" + ifNamekey;
                    this.deviceInterfaceIndexMap.put((Object)resKey, (Object)new Long(ifIndex));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeDeviceInterfaceIndexMapEntry(String resName_ifName) {
        this.deviceInterfaceIndexMap.remove((Object)resName_ifName);
    }

    public Long getInterfaceIndex(String resName_ifName) {
        if (this.deviceInterfaceIndexMap == null || this.deviceInterfaceIndexMap.size() == 0) {
            return new Long(0L);
        }
        if (this.deviceInterfaceIndexMap.containsKey((Object)resName_ifName)) {
            return (Long)this.deviceInterfaceIndexMap.get((Object)resName_ifName);
        }
        return new Long(0L);
    }

    public HashMap getDeviceInterfaceIndexMap() {
        return this.deviceInterfaceIndexMap;
    }

    public boolean checkDeviceInterfaceIndexMap(String resName_ifName) {
        return this.deviceInterfaceIndexMap.containsKey((Object)resName_ifName);
    }

    public boolean checkIdentifiedInterfaceMap(String resName, String ifName) {
        HashSet interfaceSet;
        return this.identifiedInterfaceMap.containsKey((Object)resName) && (interfaceSet = (HashSet)this.identifiedInterfaceMap.get((Object)resName)).contains(ifName);
    }

    public HashSet getIdentifiedInterfacesForDevice(String resName) {
        if (this.identifiedInterfaceMap.containsKey((Object)resName)) {
            return (HashSet)this.identifiedInterfaceMap.get((Object)resName);
        }
        return null;
    }

    public void addToIdentifiedInterfaceMap(String resName, String ifName) {
        String snmpKey = resName + "_" + ifName;
        if (this.identifiedInterfaceMap.containsKey((Object)resName)) {
            HashSet interfaceSet = (HashSet)this.identifiedInterfaceMap.get((Object)resName);
            interfaceSet.add(ifName);
            this.identifiedInterfaceMap.put((Object)resName, (Object)interfaceSet);
        } else {
            HashSet<String> newSet = new HashSet<String>();
            newSet.add(ifName);
            this.identifiedInterfaceMap.put((Object)resName, newSet);
        }
    }

    public void removeIdentifiedInterface(String resName, String ifName) {
        if (this.identifiedInterfaceMap.containsKey((Object)resName)) {
            HashSet interfaceSet = (HashSet)this.identifiedInterfaceMap.get((Object)resName);
            interfaceSet.remove(ifName);
            if (interfaceSet.size() == 0) {
                this.identifiedInterfaceMap.remove((Object)resName);
            } else {
                this.identifiedInterfaceMap.put((Object)resName, (Object)interfaceSet);
            }
        }
    }

    public HashMap getIdentifiedInterfaceMap() {
        return this.identifiedInterfaceMap;
    }

    public boolean updateInterfaceDetails(String resName, String devId, String ifName, String upSpeed, String downSpeed, String ifIP, String ifMask) {
        if (upSpeed == null) {
            devId = this.getDeviceId(resName);
            if (devId == null) {
                return false;
            }
            try {
                DataObject doo = DataAccess.constructDataObject();
                Row newRow = new Row("InterfaceInfo");
                newRow.set("RID", (Object)new Long(devId));
                newRow.set("IF_NAME", (Object)ifName);
                newRow.set("IF_IP", (Object)"");
                newRow.set("IF_UPLINK_SPEED", (Object)new Float("1024"));
                newRow.set("IF_DOWNLINK_SPEED", (Object)new Float("1024"));
                newRow.set("IF_NETMASK", (Object)"");
                newRow.set("IF_NETWORK", (Object)"");
                newRow.set("IF_DISPLAY", (Object)ifName);
                doo.addRow(newRow);
                doo = DataAccess.update((DataObject)doo);
                Long dbIfIndex = (Long)doo.getFirstRow("InterfaceInfo").get("IF_INDEX");
                long ifIndex = dbIfIndex;
                InterfaceObject interObject = new InterfaceObject(ifName, ifIndex, "", ifName);
                HashMap<String, String> interfaceHash = new HashMap<String, String>();
                interfaceHash.put("ipAddress", ifIP);
                interfaceHash.put("ifIndex", ifIndex + "");
                interfaceHash.put("ifName", ifName);
                interfaceHash.put("netMask", "");
                interfaceHash.put("netWork", "");
                interObject.setInterfaceHash(interfaceHash);
                this.addToDeviceSnmpMap(devId, ifName, interObject);
                this.addToDeviceInterfaceMap(devId);
                this.addToIdentifiedInterfaceMap(resName, ifName);
                DepartmentUtil.updateInterfaceCriteriaHash((String)devId, (String)(ifIndex + ""), null, null, null);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        } else {
            try {
                Float downlinkSpeed;
                if (resName == null) {
                    resName = this.getResourceName(new Long(devId));
                }
                String ifNetwork = "";
                IPRange ipRange = new IPRange();
                ifIP = ifIP.replaceAll("\\s*", "");
                ifMask = ifMask.replaceAll("\\s*", "");
                String[] IPs = ifIP.split(",");
                String[] masks = ifMask.split(",");
                for (int i = 0; i < IPs.length; ++i) {
                    String mask = masks.length == IPs.length ? masks[i] : masks[0];
                    ifNetwork = ifNetwork + "," + IPRange.getNetwork((String)mask, (String)IPs[i]);
                }
                if (ifNetwork.length() > 1) {
                    ifNetwork = ifNetwork.substring(1);
                }
                UpdateQueryImpl query = new UpdateQueryImpl("InterfaceInfo");
                Criteria crt1 = new Criteria(new Column("InterfaceInfo", "RID"), (Object)new Long(devId), 0);
                Criteria crt2 = new Criteria(new Column("InterfaceInfo", "IF_NAME"), (Object)ifName, 0);
                query.setCriteria(crt1.and(crt2));
                Float uplinkSpeed = new Float(upSpeed);
                if (uplinkSpeed.floatValue() == 0.0f) {
                    uplinkSpeed = Float.valueOf(1024.0f);
                }
                if ((downlinkSpeed = new Float(downSpeed)).floatValue() == 0.0f) {
                    downlinkSpeed = Float.valueOf(1024.0f);
                }
                query.setUpdateColumn("IF_UPLINK_SPEED", (Object)uplinkSpeed);
                query.setUpdateColumn("IF_DOWNLINK_SPEED", (Object)downlinkSpeed);
                query.setUpdateColumn("IF_IP", (Object)ifIP);
                query.setUpdateColumn("IF_NETMASK", (Object)ifMask);
                query.setUpdateColumn("IF_NETWORK", (Object)ifNetwork);
                DataAccess.update((UpdateQuery)query);
                this.addToDeviceInterfaceMap(devId);
                this.removeIdentifiedInterface(resName, ifName);
                SelectQueryImpl select = new SelectQueryImpl(new Table("InterfaceInfo"));
                select.addSelectColumn(new Column("InterfaceInfo", "*"));
                select.setCriteria(crt1.and(crt2));
                DataObject doo = DataAccess.get((SelectQuery)select);
                Long ifIndexValue = (Long)doo.getFirstRow("InterfaceInfo").get("IF_INDEX");
                DepartmentUtil.updateInterfaceCriteriaHash((String)devId, (String)ifIndexValue.toString(), (String)ifIP, (String)ifNetwork, (String)ifMask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public Long addNewInterface(Long rid, String ifName, String ifIP, String speed, String ifMask) throws DataAccessException {
        return this.addNewInterface(rid, ifName, ifIP, speed, ifMask, null);
    }

    public Long addNewInterface(Long rid, String ifName, String ifIP, String speed, String ifMask, Long ifIndex) throws DataAccessException {
        Float linkSpeed = Float.valueOf(0.0f);
        String resName = this.getResourceName(rid);
        IPRange ipRange = new IPRange();
        String ifNetwork = "";
        if ("".equals(ifMask) || "".equals(ifIP)) {
            ifNetwork = "";
        } else {
            String[] IPs = ifIP.split(",");
            String[] masks = ifMask.split(",");
            for (int i = 0; i < IPs.length; ++i) {
                String mask = masks.length == IPs.length ? masks[i] : masks[0];
                ifNetwork = ifNetwork + "," + IPRange.getNetwork((String)mask, (String)IPs[i]);
            }
            if (ifNetwork.length() > 1) {
                ifNetwork = ifNetwork.substring(1);
            }
        }
        Row ifInfo = new Row("InterfaceInfo");
        ifInfo.set("RID", (Object)rid);
        ifInfo.set("IF_NAME", (Object)ifName);
        if (ifIndex != null) {
            ifInfo.set("IF_INDEX", (Object)ifIndex);
            linkSpeed = new Float((double)new Long(speed).longValue() * 1024.0);
        } else {
            linkSpeed = new Float((double)new Long(speed).longValue() / 1024.0);
        }
        if (linkSpeed.floatValue() == 0.0f) {
            linkSpeed = Float.valueOf(1024.0f);
        }
        ifInfo.set("IF_UPLINK_SPEED", (Object)linkSpeed);
        ifInfo.set("IF_DOWNLINK_SPEED", (Object)linkSpeed);
        ifInfo.set("IF_IP", (Object)ifIP);
        ifInfo.set("IF_NETMASK", (Object)ifMask);
        ifInfo.set("IF_NETWORK", (Object)ifNetwork);
        ifInfo.set("IF_DISPLAY", (Object)ifName);
        DataObject dObj = DataAccess.constructDataObject();
        dObj.addRow(ifInfo);
        DataAccess.add((DataObject)dObj);
        Long dbIfIndex = (Long)dObj.getFirstValue("InterfaceInfo", "IF_INDEX");
        InterfaceObject interObject = new InterfaceObject(ifName, dbIfIndex, "", ifName);
        HashMap<String, String> interfaceHash = new HashMap<String, String>();
        interfaceHash.put("ipAddress", ifIP);
        interfaceHash.put("ifIndex", dbIfIndex.toString());
        interfaceHash.put("ifName", ifName);
        interfaceHash.put("netMask", "");
        interfaceHash.put("netWork", "");
        interObject.setInterfaceHash(interfaceHash);
        this.addToDeviceSnmpMap(rid.toString(), ifName, interObject);
        this.addToDeviceInterfaceMap(rid.toString());
        this.addToIdentifiedInterfaceMap(resName, ifName);
        if ("".equals(ifMask)) {
            ifMask = null;
        }
        if ("".equals(ifNetwork)) {
            ifNetwork = null;
        }
        DepartmentUtil.updateInterfaceCriteriaHash((String)rid.toString(), (String)dbIfIndex.toString(), (String)ifIP, (String)ifNetwork, (String)ifMask);
        return dbIfIndex;
    }

    public void clearSnmpDetailsFromMemory(String resName, String resId) {
        try {
            if (this.deviceSnmpMap.containsKey((Object)resId)) {
                this.deviceSnmpMap.remove((Object)resId);
            }
            if (this.deviceInterfaceIndexMap != null) {
                this.callDeleteMapEntry(resName + "_", (HashMap)this.deviceInterfaceIndexMap);
            }
            if (this.identifiedInterfaceMap != null) {
                this.callDeleteMapEntry(resName, (HashMap)this.identifiedInterfaceMap);
            }
            Criteria crt1 = new Criteria(new Column("SnmpInfo", "RID"), (Object)new Long(resId), 0);
            DataAccess.delete((Criteria)crt1);
            Criteria crt2 = new Criteria(new Column("InterfaceInfo", "RID"), (Object)new Long(resId), 0);
            DataAccess.delete((Criteria)crt2);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Problem while deleting row from SnmpInfo, InterfaceInfo for Resource::::" + resId);
        }
    }

    public String getResourceName(Long rid) {
        try {
            SelectQueryImpl sel = new SelectQueryImpl(new Table("Resources"));
            sel.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rid, 0);
            sel.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sel);
            if (doo.isEmpty()) {
                return null;
            }
            return (String)doo.getFirstValue("Resources", "RESOURCENAME");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return null;
        }
    }

    public String getDisplayName(Long rid) {
        try {
            SelectQueryImpl sel = new SelectQueryImpl(new Table("Resources"));
            sel.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rid, 0);
            sel.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sel);
            if (doo.isEmpty()) {
                return null;
            }
            return (String)doo.getFirstValue("Resources", "DISPLAYNAME");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return null;
        }
    }

    private void callDeleteMapEntry(String keyPrefix, HashMap map) {
        ArrayList<String> memoryList = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (!key.startsWith(keyPrefix)) continue;
            memoryList.add(key);
        }
        this.deleteMapEntry(memoryList, map);
    }

    private void deleteMapEntry(List memList, HashMap map) {
        if (memList != null && memList.size() > 0) {
            for (int i = 0; i < memList.size(); ++i) {
                String keyEntry = (String)memList.get(i);
                map.remove(keyEntry);
            }
        }
    }

    public String getDeviceId(String resName) {
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("Resources"));
            select.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)resName, 0);
            select.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)select);
            if (doo.containsTable("Resources")) {
                Row rRow = doo.getRow("Resources");
                Long devId = (Long)rRow.get("RESOURCEID");
                return devId + "";
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    public Map getSyslogDetails(String resourceName) {
        if (resourceName == null) {
            LOGGER.log(Level.WARNING, "Error Condition: ResourceName is NULL ");
            return null;
        }
        String sysID = (String)this.fwToSyslogMap.get((Object)resourceName);
        if (sysID == null) {
            LOGGER.log(Level.WARNING, "Error Condition: SyslogCollector ID is NULL ");
            return null;
        }
        String[] array = sysID.split(",");
        if (array.length == 2) {
            sysID = array[0];
        }
        return (Properties)this.syslogCollectorMap.get((Object)sysID);
    }

    public void populateIPNumber(Hashtable data) {
        String dst;
        if (data == null) {
            return;
        }
        String src = (String)data.get("SRC");
        if (src == null) {
            data.put("SRC", "127.0.0.1");
        }
        if ((dst = (String)data.get("DST")) == null || "".equals(dst)) {
            dst = (String)data.get("DEST");
        }
        try {
            Long src_id = src != null ? new Long(IPRange.getIPNumber((String)src)) : new Long(0L);
            data.put("SRC_ID", src_id);
            Long dst_id = dst != null ? new Long(IPRange.getIPNumber((String)dst)) : new Long(0L);
            data.put("DST_ID", dst_id);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void addResource(String resource, String ip, Hashtable unifiedOutput, Boolean fromImport, Boolean considerAsVdom, String physicalDevName) {
        try {
            String supportedDevices;
            List<String> supportedDevicesList;
            String devType;
            LOGGER.log(Level.INFO, "FACacheManager.addResource() Called with resource --> " + resource + ",ip --> " + ip + ",fromImport -> " + fromImport + ",considerAsVdom -> " + considerAsVdom + ",physicalDevName -> " + physicalDevName);
            boolean isFromImport = fromImport;
            boolean isVdom = considerAsVdom;
            String physicalDevIP = isVdom ? "" : null;
            boolean updateVdomList = false;
            long start = System.currentTimeMillis();
            DataObject dao = this.getDO();
            String tableName = (String)unifiedOutput.get("tableName");
            String string = devType = tableName.equals("FirewallRecords") ? (String)unifiedOutput.get("FW_TYPE") : null;
            if (physicalDevName == null && "Cisco".equals(devType)) {
                physicalDevName = FAServerUtil.resolveDNSNow(ip);
            }
            String mappedRIDs = FAServerUtil.getIPResMap(ip);
            boolean isLogFromExternalSyslogServer = this.checkResFromExternalSyslogServer(devType, physicalDevName, resource, mappedRIDs, fromImport);
            if (this.vdomSupportedDevList.contains(devType) && (!isFromImport || isVdom) && !isLogFromExternalSyslogServer) {
                if (mappedRIDs != null) {
                    List excludedVdomList = FAServerUtil.getExcludedDevList();
                    if (!excludedVdomList.contains(ip)) {
                        boolean yetToDetectVdom = false;
                        DataObject tempDO = this.getFirstVdomRes(ip, physicalDevName);
                        if (!tempDO.isEmpty()) {
                            yetToDetectVdom = true;
                        }
                        if ("admin".equals(resource) || resource.indexOf("admin") > -1 || resource.equals(physicalDevName)) {
                            LOGGER.log(Level.INFO, "FACacheManager.addResource() ::: inside base device handling....yetToDetectVdom -> " + yetToDetectVdom);
                            if (yetToDetectVdom) {
                                this.updatePhysicalDevIPCol4FirstRes(tempDO, ip);
                            } else {
                                this.updatePhysicalDevIPVal4DummyBaseDev(ip, physicalDevName);
                            }
                            physicalDevIP = "";
                        } else {
                            LOGGER.log(Level.INFO, "FACacheManager.addResource() ::: inside other than base device handling....yetToDetectVdom -> " + yetToDetectVdom);
                            if (yetToDetectVdom) {
                                String valToUpdate = "";
                                this.updatePhysicalDevIPCol4FirstRes(tempDO, valToUpdate);
                            }
                            physicalDevIP = ip;
                        }
                        updateVdomList = true;
                    }
                } else if (!devType.equals("Cisco") && !physicalDevName.equals(resource)) {
                    LOGGER.log(Level.INFO, "FACacheManager.addResource() ::: inside very first log from device is vd!=root log handling...");
                    physicalDevIP = "";
                    FAServerUtil.addDeviceToVdomDevicesList(ip);
                }
            }
            DataObject resultDO = DataAccess.constructDataObject();
            Row row = new Row("Resources");
            row.set(2, (Object)resource);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            row.set(3, (Object)sdf.format(new Date(System.currentTimeMillis())));
            if ("FirewallRecords".equals(tableName)) {
                row.set(4, (Object)"Firewall");
                row.set(5, unifiedOutput.get("FW_TYPE"));
                row.set(6, unifiedOutput.get("LOG_FORMAT"));
            } else if ("SquidRecords".equals(tableName)) {
                row.set(4, (Object)"Squid");
                row.set(5, (Object)"Unknown CLF");
                row.set(6, (Object)"Common Log Format");
            } else {
                row.set(4, (Object)"Radius");
                row.set(5, (Object)"Unknown Radius Account Log");
                row.set(6, (Object)"Radius Account Log Format");
            }
            row.set(7, (Object)resource);
            row.set(8, (Object)new Float(1024.0f));
            row.set(11, (Object)new Float(1024.0f));
            row.set(10, (Object)ip);
            int licStatus = FirewallLicenseManager.getNewDeviceDefaultLicStatus();
            row.set(12, (Object)new Long(licStatus + ""));
            LOGGER.log(Level.INFO, "FACacheManager.addResource() ::: before inserting into DB,  physicalDevName -> " + physicalDevName + ",physicalDevIP -> " + physicalDevIP);
            if (physicalDevName != null) {
                row.set(13, (Object)physicalDevName);
                row.set(14, (Object)physicalDevIP);
            }
            dao.addRow(row);
            resultDO = this.getPersistence().add(dao);
            FAServerUtil.addToResourceList(resource);
            Long resID = (Long)resultDO.getFirstValue("Resources", "RESOURCEID");
            FAServerUtil.updateIPResMap(ip, resID.toString(), Boolean.TRUE);
            if (this.vdomSupportedDevList.contains(devType)) {
                if ("Cisco".equals(devType) || !physicalDevName.equals(resource)) {
                    String resObjKey = "FortiGate".equals(devType) ? physicalDevName : ip;
                    ResourceDetails resObj = FAServerUtil.getResObject(resObjKey);
                    if (resObj != null) {
                        resObj.addVdom(resource, physicalDevName);
                    } else {
                        resObj = new ResourceDetails(ip, resource, physicalDevName);
                        LOGGER.log(Level.INFO, "FACacheManager.addResource() ::: setting resource obj into memory with key::" + resObjKey);
                        FAServerUtil.setResObjHash(resObjKey, resObj);
                        FAServerUtil.updatePhysicalDevToIPMap(ip, physicalDevName);
                    }
                }
                if (isVdom || updateVdomList) {
                    DataObject dipDO;
                    List vdomList = FAServerUtil.getVdomDevicesList();
                    if (!vdomList.contains(ip)) {
                        FAServerUtil.addDeviceToVdomDevicesList(ip);
                    }
                    Criteria tempCrit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
                    tempCrit = tempCrit.and(new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0));
                    DataObject tempDO = DataAccess.get((String)"Resources", (Criteria)tempCrit);
                    Long tempID = (Long)tempDO.getFirstValue("Resources", "RESOURCEID");
                    tempCrit = new Criteria(new Column("DeviceDetails", "RID"), (Object)tempID, 0);
                    if (!(tempDO = DataAccess.get((String)"DeviceDetails", (Criteria)tempCrit)).isEmpty() && (dipDO = DataAccess.get((String)"DIPToResourcesMapping", (Criteria)(tempCrit = new Criteria(new Column("DIPToResourcesMapping", "DDID"), (Object)(tempID = (Long)tempDO.getFirstValue("DeviceDetails", "DDID")), 0)))).isEmpty()) {
                        Row ddRow = tempDO.getFirstRow("DeviceDetails");
                        String excludedRIDs = (String)ddRow.get("EXCLUDED_VDOMS");
                        if (excludedRIDs != null) {
                            excludedRIDs = excludedRIDs + "," + resID.toString();
                            ddRow.set("EXCLUDED_VDOMS", (Object)excludedRIDs);
                        } else {
                            ddRow.set("EXCLUDED_VDOMS", (Object)resID);
                        }
                        tempDO.updateRow(ddRow);
                        DataAccess.update((DataObject)tempDO);
                    }
                }
            }
            if ((supportedDevicesList = Arrays.asList((supportedDevices = FWAPolicyParserRulesLoader.getInstance().getPolicyParsingSupportedDevices()).split(","))).contains(devType)) {
                String excludedServices;
                SelectQueryImpl userInputSQL = new SelectQueryImpl(new Table("ComplianceUserInputs"));
                userInputSQL.addSelectColumn(new Column("ComplianceUserInputs", "*"));
                DataObject userInputDO = DataAccess.get((SelectQuery)userInputSQL);
                if (!userInputDO.isEmpty() && (excludedServices = (String)userInputDO.getFirstValue("ComplianceUserInputs", "SERVICES_ALLOWED")) != null) {
                    DataObject doo = DataAccess.constructDataObject();
                    Row userInputRow = new Row("ComplianceUserInputs");
                    userInputRow.set("RID", (Object)resID);
                    userInputRow.set("SERVICES_ALLOWED", (Object)excludedServices);
                    doo.addRow(userInputRow);
                    DataAccess.add((DataObject)doo);
                }
            }
            LOGGER.log(Level.INFO, "Time taken to complete the task is  --> ", new Long(System.currentTimeMillis() - start));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private boolean checkResFromExternalSyslogServer(String devType, String physicalDevName, String resource, String mappedRIDs, Boolean fromImport) {
        ResourceDetails resObj;
        boolean isFromImport = fromImport;
        return this.vdomSupportedDevList.contains(devType) && physicalDevName.equals(resource) && mappedRIDs != null && !isFromImport && (resObj = FAServerUtil.getResObject(physicalDevName)) == null;
    }

    private DataObject getDO() throws Exception {
        return this.getPersistence().constructDataObject();
    }

    private Persistence getPersistence() {
        if (this.persistence != null) {
            return this.persistence;
        }
        try {
            this.persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.persistence;
    }

    private DataObject getFirstVdomRes(String ip, String physicalDevName) throws Exception {
        SelectQueryImpl resQuery = new SelectQueryImpl(new Table("Resources"));
        resQuery.addSelectColumn(new Column("Resources", "*"));
        Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
        crit = crit.and(new Criteria(new Column("Resources", "PHYSICALDEVICENAME"), (Object)physicalDevName, 0));
        crit = crit.and(new Criteria(new Column("Resources", "PHYSICALDEVIP"), null, 0));
        resQuery.setCriteria(crit);
        DataObject doo = DataAccess.get((SelectQuery)resQuery);
        return doo;
    }

    private void updatePhysicalDevIPCol4FirstRes(DataObject dao, String ip) {
        try {
            Row row = dao.getFirstRow("Resources");
            row.set(14, (Object)ip);
            dao.updateRow(row);
            DataObject doo = DataAccess.update((DataObject)dao);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void updatePhysicalDevIPVal4DummyBaseDev(String ip, String physicalDevName) throws Exception {
        UpdateQueryImpl uq = new UpdateQueryImpl("Resources");
        Criteria crit = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ip, 0);
        crit = crit.and(new Criteria(new Column("Resources", "PHYSICALDEVICENAME"), (Object)physicalDevName, 0));
        crit = crit.and(new Criteria(new Column("Resources", "PHYSICALDEVIP"), (Object)"", 0));
        uq.setCriteria(crit);
        uq.setUpdateColumn("PHYSICALDEVIP", (Object)ip);
        DataAccess.update((UpdateQuery)uq);
    }

    public String getReportProfileNameForID(long reportProfileID) {
        LOGGER.log(Level.FINE, "FACacheManager.getReportProfileNameForID() Called with REPORTID ::::::: " + reportProfileID);
        return this.getProfileName(reportProfileID, "ReportConfig", "PROFILENAME", "REPORTID", (Map)this.reportIDVsReportProfileName);
    }

    private String getProfileName(long id, String tableName, String columnName, String criteriaColumnName, Map storage) {
        String profileName = null;
        try {
            profileName = (String)storage.get(new Long(id));
            LOGGER.log(Level.FINE, " FACacheManager.getProfileName() ProfileName reterived from Storage is ::::::::: {0} ", profileName);
            if (profileName == null) {
                LOGGER.log(Level.FINE, " Contents of Storage is ::::::::::: {0} ", storage);
                Criteria crt = new Criteria(new Column(tableName, criteriaColumnName), (Object)new Long(id), 0);
                LOGGER.log(Level.FINE, " FACacheManager.getProfileName(), Since Cache doesn't have this ... fetching from DB ....");
                SelectQueryImpl sql = new SelectQueryImpl(new Table("ReportConfig"));
                sql.addSelectColumn(new Column("ReportConfig", "*"));
                sql.addSelectColumn(new Column("ResourcesToReportConfig", "*"));
                sql.addSelectColumn(new Column("Resources", "*"));
                String[] jCols = new String[]{"REPORTID"};
                Join j1 = new Join("ReportConfig", "ResourcesToReportConfig", jCols, jCols, 1);
                String[] jCols_res = new String[]{"RESOURCEID"};
                Join j2 = new Join("ResourcesToReportConfig", "Resources", jCols_res, jCols_res, 1);
                sql.addJoin(j1);
                sql.addJoin(j2);
                sql.setCriteria(crt);
                DataObject dobj = DataAccess.get((SelectQuery)sql);
                LOGGER.log(Level.FINE, " FACacheManager.getProfileName() ............ DataObject reterived is :::::::::::: " + dobj);
                if (!dobj.isEmpty()) {
                    Iterator itr = dobj.getRows("Resources");
                    profileName = itr.hasNext() ? (String)dobj.getFirstValue("Resources", "DISPLAYNAME") : (String)dobj.getFirstValue(tableName, columnName);
                    LOGGER.log(Level.FINE, " FACacheManager.getProfileName() Value of profilename fetched from DB is :::::::{0} ", profileName);
                    if (profileName != null) {
                        storage.put(new Long(id), profileName);
                        LOGGER.log(Level.FINE, "FACacheManager.getProfileName() ::::: Added to storage ...");
                    }
                } else {
                    LOGGER.log(Level.INFO, " FACacheManager.getProfileName() DataObject is EMPTY !!! ");
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return profileName;
    }

    public void removeReportProfileMapping(long reportID) {
        this.reportIDVsReportProfileName.remove((Object)new Long(reportID));
    }

    public void removeFromReportConfig(String reportName) {
        try {
            Criteria crit = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)reportName, 2);
            DataAccess.delete((Criteria)crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCountryRange() {
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        boolean hasData = true;
        try {
            String query = "select IP_TO,COUNTRY_ID from CountryCode inner join GeoLocation on CountryCode.COUNTRY_CODE=GeoLocation.COUNTRY_CODE order by IP_TO";
            conn = RelationalAPI.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            if (!rs.next()) {
                FileToDBLoader.getInstance().loadIntoDatabase(stmt, "CountryCode", file, ",");
                rs = stmt.executeQuery(query);
                hasData = rs.next();
            }
            if (hasData) {
                do {
                    this.ipTo.add(rs.getLong(1));
                    this.countryId.add(rs.getInt(2));
                } while (rs.next());
            }
            this.dum = this.ipTo.toArray(new Long[this.ipTo.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    public int getCountryId(Object cntry_id) {
        int id = 0;
        try {
            if (cntry_id instanceof String) {
                id = ((Long)this.countries.get(cntry_id)).intValue();
            } else if (this.dum.length > 0) {
                int index = Arrays.binarySearch((Object[])this.dum, (Long)cntry_id);
                id = index >= 0 ? this.countryId.get(index) : this.countryId.get(Math.abs(index) - 1);
            }
        }
        catch (Exception ee) {
            id = ((Long)this.countries.get((Object)"Unknown")).intValue();
            LOGGER.log(Level.FINER, " Cannot find countryId due to exception : {0}", ee);
        }
        return id;
    }

    public String getCountryName(Object cntry_id) {
        if (cntry_id instanceof String) {
            cntry_id = Long.parseLong((String)cntry_id);
        }
        return (String)this.countries.get((Object)((Long)cntry_id));
    }
}

