/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.ServerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileToDBLoader {
    private static final Logger LOGGER = Logger.getLogger(FileToDBLoader.class.getName());
    private static FileToDBLoader fl = null;
    boolean isMssql = "mssql".equals(System.getProperty("DBType", "mysql"));
    boolean isPostgres = "postgres".equals(System.getProperty("DBType"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private String dbserver = "";
    private String dbname = "";
    private String dbuser = "";
    private String dbpass = "";
    private String commandToExecute = null;
    File file = null;
    private String table = null;

    private FileToDBLoader() {
        this.generateMssqlParams();
    }

    public static synchronized FileToDBLoader getInstance() {
        if (fl == null) {
            fl = new FileToDBLoader();
        }
        return fl;
    }

    private void generateMssqlParams() {
        if (this.isMssql) {
            String osName;
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"firewall");
            if (DBParams != null) {
                this.dbserver = (String)DBParams.get("DBServer");
                this.dbname = (String)DBParams.get("DBName");
                this.dbuser = (String)DBParams.get("DBUser");
                this.dbpass = (String)DBParams.get("DBPass");
                if (this.dbpass == null) {
                    this.dbpass = "";
                }
            }
            if ((osName = System.getProperty("os.name")).toLowerCase().indexOf("windows nt") > -1 || osName.equalsIgnoreCase("windows 2000") || osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("Windows 2003") || osName.equalsIgnoreCase("windows vista") || osName.startsWith("Win") && (osName.indexOf("95") < 0 || osName.indexOf("98") >= 0)) {
                this.commandToExecute = "cmd  /c ";
            } else if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                this.commandToExecute = "command.com /c ";
            }
        }
    }

    public void loadIntoDatabase(Statement stmt, String table, String file, String separator) {
        String query = null;
        String fullpath = "";
        try {
            File tmp = new File(file);
            fullpath = tmp.getCanonicalPath();
            fullpath = fullpath.replace('\\', '/');
            if (this.isPostgres) {
                query = "COPY " + table + " FROM '" + fullpath + "' DELIMITER ','";
                stmt.execute(query);
            } else if (this.isMssql) {
                this.loadDataInMssql(fullpath, table);
            } else {
                query = "LOAD DATA INFILE '" + fullpath + "' IGNORE INTO TABLE " + table + " FIELDS TERMINATED BY ',' LINES TERMINATED BY '\r\n'";
                stmt.execute(query);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDataInMssql(String file, String table) throws Exception {
        ServerUtil.BCPLOCK.lock();
        String command = null;
        BufferedReader in = null;
        FileOutputStream fos = null;
        try {
            int c;
            command = isWinAuthType ? this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + table + " in " + file + " -S " + this.dbserver + " -T -t \",\" -r \"\\n\" -e ..\\logs\\dbLoaderErr.txt -c -q" : this.commandToExecute + " ..\\bin\\bcp.exe " + this.dbname + ".dbo." + table + " in " + file + " -S " + this.dbserver + " -U " + this.dbuser + " -P \"" + this.dbpass + "\" -t \",\" -r \"\\n\" -e ..\\logs\\dbLoaderErr.txt -c -q";
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "dbLoadData.log");
            Process p = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ServerUtil.BCPLOCK.unlock();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    LOGGER.log(Level.INFO, " Exception while closing buffer reader ::: {0} ", ee);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {
                    LOGGER.log(Level.INFO, " Exception while closing fos ::: {0} ", ee);
                }
            }
        }
    }
}

