/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.la.SQLGenerator;
import com.adventnet.la.util.DNSResolver;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.mfw.message.MessageListener;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.OperationInfo;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.xml.Xml2DoConverter;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirewallAdder
implements MessageListener {
    private static final Logger LOGGER = Logger.getLogger(FirewallAdder.class.getName());
    private boolean addAlert = false;
    private boolean addProfile = true;
    private Xml2DoConverter doConverter;
    private static Logger logger = Logger.getLogger(FirewallAdder.class.getName());
    private String filePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "FirewallAnalyzer" + File.separator;
    private String confFile = this.filePath + "default-report.xml";
    private String squidConfFile = this.filePath + "squid-profiles.xml";
    private String radiusConfFile = this.filePath + "radius-profiles.xml";
    private String filterConfFile = this.filePath + "NotificationFilterConfiguration.xml";

    public void onMessage(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            OperationInfo opInfo = (OperationInfo)obj;
            DataObject doo = opInfo.getDataObject();
            if (doo == null) {
                return;
            }
            HashMap actionsForInsert = ((WritableDataObject)doo).getActionsFor("insert");
            if (doo.getTableNames().contains("Resources") && actionsForInsert != null) {
                this.handleFirewallAddition(opInfo, doo);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void handleSquidAddition(OperationInfo obj, DataObject doo, Long rId) throws Exception {
        if (!doo.getTableNames().contains("Resources")) {
            return;
        }
        logger.entering(FirewallAdder.class.getName(), "populateConfFiles");
        String sqName = (String)doo.getFirstValue("Resources", "RESOURCENAME");
        String type = (String)doo.getFirstValue("Resources", "TYPE");
        if (!"Squid".equals(type)) {
            return;
        }
        File sqFile = new File(this.squidConfFile);
        DataObject object = Xml2DoConverter.transform((URL)sqFile.toURL(), (boolean)false);
        logger.log(Level.FINE, "DataObject equivalent to the above url: is {0}", new Object[]{object});
        if (object.getTableNames().size() <= 0) {
            throw new Exception("Emtpy DataObject obtained.");
        }
        if (new Boolean(System.getProperty("Firewall.addProfile", "true")).booleanValue()) {
            this.addDetails(object, sqName, rId);
        }
    }

    private void handleFirewallAddition(OperationInfo obj, DataObject doo) throws Exception {
        if (!doo.getTableNames().contains("Resources")) {
            return;
        }
        logger.entering(FirewallAdder.class.getName(), "populateConfFiles");
        Iterator itr = doo.getRows("Resources");
        while (itr.hasNext()) {
            Row resRow = (Row)itr.next();
            String fwName = (String)resRow.get("RESOURCENAME");
            Long resId = (Long)resRow.get("RESOURCEID");
            String ressourceType = (String)resRow.get("RESOURCETYPE");
            String vendor = (String)resRow.get("VENDOR_TYPE");
            String ipaddr = (String)resRow.get("IPADDRESS");
            String logFormat = (String)resRow.get("LOG_FORMAT");
            LOGGER.log(Level.FINER, " FirewallAdder: LOG_FORMAT IS {0}  ", logFormat);
            SelectQueryImpl query = new SelectQueryImpl(new Table("Resources"));
            query.addSelectColumn(new Column("Resources", "*"));
            Criteria ipcrt = new Criteria(new Column("Resources", "IPADDRESS"), (Object)ipaddr, 0);
            Criteria vencrt = new Criteria(new Column("Resources", "VENDOR_TYPE"), (Object)vendor, 0);
            ipcrt = ipcrt.and(vencrt).and(new Criteria(new Column("Resources", "RESOURCENAME"), (Object)fwName, 1));
            query.setCriteria(ipcrt.and(vencrt));
            DataObject haObj = DataAccess.get((SelectQuery)query);
            String file = this.confFile;
            if (ressourceType.equalsIgnoreCase("Squid")) {
                file = this.squidConfFile;
            } else if (ressourceType.equalsIgnoreCase("Radius")) {
                file = this.radiusConfFile;
            }
            SelectQueryImpl aaquery = new SelectQueryImpl(new Table("AaaUser"));
            aaquery.addSelectColumn(new Column("AaaUser", "*"));
            Range limit = new Range(0, 1);
            aaquery.setRange(limit);
            SortColumn aaUsrSortCol = new SortColumn(new Column("AaaUser", "USER_ID"), true);
            aaquery.addSortColumn(aaUsrSortCol);
            DataObject aaObj = DataAccess.get((SelectQuery)aaquery);
            if (aaObj.isEmpty()) {
                logger.log(Level.INFO, "I'm sleeping for 25 seconds as i don't see anything in AaaUser table..");
                Thread.sleep(25000L);
            }
            File coFile = new File(file);
            DataObject object = Xml2DoConverter.transform((URL)coFile.toURL(), (boolean)false);
            if (ressourceType.equalsIgnoreCase("Firewall")) {
                ((WritableDataObject)object).clearOperations();
                object = this.getResourceSpecificDO(object, logFormat);
            }
            logger.log(Level.FINER, "DataObject equivalent to the above url: is {0}", new Object[]{object});
            if (object.getTableNames().size() <= 0) {
                throw new Exception("Emtpy DataObject obtained.");
            }
            if (new Boolean(System.getProperty("Firewall.addProfile", "true")).booleanValue()) {
                DataObject orgObj = null;
                if (haObj.containsTable("Resources")) {
                    orgObj = (DataObject)object.clone();
                }
                this.addDetails(object, fwName, resId);
                String enableHA = System.getProperty("Firewall.enableHA", "false");
                if (orgObj != null && "true".equals(enableHA)) {
                    this.addHAReport(orgObj, haObj, ipaddr + "_HA", resId);
                }
            }
            if (!new Boolean(System.getProperty("Firewall.addAlert")).booleanValue() || !ressourceType.equalsIgnoreCase("Firewall")) continue;
            this.addDefaultFilters(fwName, resId);
        }
    }

    private void addHAReport(DataObject object, DataObject haObj, String rName, Long rId) {
        try {
            Criteria crt = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)rName, 0);
            FAServerUtil.getPersistence().delete(crt);
            Row filterRow = new Row("Filters");
            filterRow.set("FILTERNAME", (Object)(rName + "_DefaultFilter"));
            object.addRow(filterRow);
            ArrayList<Object> rList = new ArrayList<Object>();
            rList.add(rId);
            Iterator itr = haObj.getRows("Resources");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                rList.add(row.get("RESOURCEID"));
            }
            for (int i = 0; i < rList.size(); ++i) {
                Long id = (Long)rList.get(i);
                Row laExpRow = new Row("LAExpression");
                laExpRow.set("TABLE_NAME", (Object)"Resources");
                laExpRow.set("COLUMN_NAME", (Object)"RESOURCEID");
                laExpRow.set("COMPARATOR", (Object)"=");
                laExpRow.set("VALUE", (Object)id);
                object.addRow(laExpRow);
                Row flt2LaExp = new Row("FilterToLAExpression");
                flt2LaExp.set("EXP_ID", laExpRow.get("EXP_ID"));
                flt2LaExp.set("FILTERNAME", filterRow.get("FILTERNAME"));
                object.addRow(flt2LaExp);
            }
            itr = object.getRows("ReportConfig");
            while (itr.hasNext()) {
                Row rc = (Row)itr.next();
                String profileName = (String)rc.get("PROFILENAME");
                rc.set("PROFILENAME", (Object)rName);
                rc.set("CREATED_ON", (Object)this.getTime());
                object.updateRow(rc);
                Row rptToFilter = new Row("ReportConfigToFilters");
                rptToFilter.set("FILTERNAME", filterRow.get("FILTERNAME"));
                rptToFilter.set("REPORTID", rc.get("REPORTID"));
                rptToFilter.set("TYPE", (Object)"Include");
                object.addRow(rptToFilter);
                Row rptToDefaultFilter = new Row("ReportConfigToDF");
                rptToDefaultFilter.set("FILTERNAME", filterRow.get("FILTERNAME"));
                rptToDefaultFilter.set("REPORTID", rc.get("REPORTID"));
                object.addRow(rptToDefaultFilter);
            }
            Criteria dCriteria = null;
            object.deleteRows("ResourcesToReportConfig", dCriteria);
            DataObject added = DataAccess.add((DataObject)object);
            itr = added.getRows("ReportConfig");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                Long reportId = (Long)r.get("REPORTID");
                SQLGenerator sqlGen = new SQLGenerator(reportId, new HashMap());
                DataObject dooSql = sqlGen.generate();
                DepartmentUtil.loadIntranetSettingsForReport((Long)reportId);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void addDetails(DataObject object, String rName, Long rId) throws Exception {
        Row filterRow = new Row("Filters");
        filterRow.set("FILTERNAME", (Object)(rName + "_DefaultFilter"));
        object.addRow(filterRow);
        Row laExpRow = new Row("LAExpression");
        laExpRow.set("TABLE_NAME", (Object)"Resources");
        laExpRow.set("COLUMN_NAME", (Object)"RESOURCEID");
        laExpRow.set("COMPARATOR", (Object)"=");
        laExpRow.set("VALUE", (Object)rId);
        object.addRow(laExpRow);
        Row flt2LaExp = new Row("FilterToLAExpression");
        flt2LaExp.set("EXP_ID", laExpRow.get("EXP_ID"));
        flt2LaExp.set("FILTERNAME", filterRow.get("FILTERNAME"));
        object.addRow(flt2LaExp);
        Iterator itr = object.getRows("ReportConfig");
        while (itr.hasNext()) {
            Row rc = (Row)itr.next();
            String profileName = (String)rc.get("PROFILENAME");
            rc.set("PROFILENAME", (Object)(rName + profileName));
            rc.set("CREATED_ON", (Object)this.getTime());
            object.updateRow(rc);
            Row rptToFilter = new Row("ReportConfigToFilters");
            rptToFilter.set("FILTERNAME", filterRow.get("FILTERNAME"));
            rptToFilter.set("REPORTID", rc.get("REPORTID"));
            rptToFilter.set("TYPE", (Object)"Include");
            object.addRow(rptToFilter);
            Row rptToDefaultFilter = new Row("ReportConfigToDF");
            rptToDefaultFilter.set("FILTERNAME", filterRow.get("FILTERNAME"));
            rptToDefaultFilter.set("REPORTID", rc.get("REPORTID"));
            object.addRow(rptToDefaultFilter);
        }
        itr = object.getRows("ResourcesToReportConfig");
        while (itr.hasNext()) {
            Row r = (Row)itr.next();
            r.set("RESOURCEID", (Object)rId);
        }
        LOGGER.log(Level.FINER, "TRK <->adding<->" + object);
        DataObject added = DataAccess.add((DataObject)object);
        itr = added.getRows("ReportConfig");
        while (itr.hasNext()) {
            Row r = (Row)itr.next();
            Long reportId = (Long)r.get("REPORTID");
            SQLGenerator sqlGen = new SQLGenerator(reportId, new HashMap());
            DataObject dooSql = sqlGen.generate();
            DepartmentUtil.loadIntranetSettingsForResource((Long)rId, (Long)reportId);
            DepartmentUtil.loadIntranetSettingsForReport((Long)reportId);
        }
    }

    private String getTime() {
        String pattern = "MM/dd/yyyy- HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }

    private void addDefaultFilters(String name, Long rid) throws Exception {
        String str;
        Row crit;
        File filterFile = new File(this.filterConfFile);
        DataObject object = Xml2DoConverter.transform((URL)filterFile.toURL(), (boolean)false);
        String email = this.getEmail(object);
        Row r = new Row("MailSettings");
        r.set("TO_ADDRESS", (Object)email);
        object.addRow(r);
        Iterator itr = object.getRows("LACriteria");
        while (itr.hasNext()) {
            crit = (Row)itr.next();
            str = (String)crit.get("CRITERIA_NAME");
            crit.set("CRITERIA_NAME", (Object)("Default_" + str));
            object.updateRow(crit);
            Row rr = new Row("LAExpression");
            rr.set("TABLE_NAME", (Object)"Resources");
            rr.set("COLUMN_NAME", (Object)"RESOURCEID");
            rr.set("COMPARATOR", (Object)"=");
            rr.set("VALUE", (Object)rid);
            object.addRow(rr);
            Row la2Crt = new Row("LACriteria2Expressions");
            la2Crt.set("CRIT_ID", crit.get("CRIT_ID"));
            la2Crt.set("EXP_ID", rr.get("EXP_ID"));
            object.addRow(la2Crt);
        }
        itr = object.getRows("NotificationFilters");
        while (itr.hasNext()) {
            crit = (Row)itr.next();
            str = (String)crit.get("FILTER_NAME");
            crit.set("FILTER_NAME", (Object)(name + str));
            object.updateRow(crit);
        }
        DataAccess.add((DataObject)object);
    }

    private String getEmail(DataObject doo) throws Exception {
        Long userId = (Long)doo.getFirstValue("UserToNotificationFilters", "USER_ID");
        Table table = new Table("AaaContactInfo");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        sql.addSelectColumn(new Column("AaaUserContactInfo", "*"));
        sql.addSelectColumn(new Column("AaaContactInfo", "*"));
        String[] cols = new String[]{"CONTACTINFO_ID"};
        Join j = new Join(table, new Table("AaaUserContactInfo"), cols, cols, 2);
        Criteria crt = new Criteria(new Column("AaaUserContactInfo", "USER_ID"), (Object)userId, 0);
        sql.addJoin(j);
        sql.setCriteria(crt);
        DataObject obtained = DataAccess.get((SelectQuery)sql);
        return (String)obtained.getFirstValue("AaaContactInfo", "EMAILID");
    }

    public void shutdown() {
        DNSResolver.getInstance().shutdown();
    }

    private DataObject getResourceSpecificDO(DataObject dobj, String logFormat) {
        String[] names = new String[]{"ReportConfig", "ReportConfigToRBBGMapping", "ResourcesToReportConfig"};
        List<String> list = Arrays.asList(names);
        DataObject defaultDO = null;
        try {
            Criteria crt = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)"default_format", 0);
            Iterator itr = dobj.getRows("ReportConfig", crt);
            if (!itr.hasNext()) {
                return null;
            }
            Row rr = (Row)itr.next();
            defaultDO = dobj.getDataObject(list, rr);
            rr.set("PROFILENAME", (Object)"_CompleteReportProfile");
            defaultDO.updateRow(rr);
            crt = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)logFormat, 2);
            if (!this.populateDefaultDataObject(dobj, defaultDO, list, crt, rr)) {
                crt = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)"all", 0);
                this.populateDefaultDataObject(dobj, defaultDO, list, crt, rr);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return defaultDO;
    }

    private boolean populateDefaultDataObject(DataObject dobj, DataObject defaultDO, List list, Criteria crt, Row rr) {
        boolean toReturn = false;
        try {
            Iterator itr = dobj.getRows("ReportConfig", crt);
            if (itr.hasNext()) {
                toReturn = true;
                Row r = (Row)itr.next();
                DataObject specific = dobj.getDataObject(list, r);
                LOGGER.log(Level.FINER, "Specific DO is {0} ", specific);
                Iterator rbbgs = specific.getRows("ReportConfigToRBBGMapping");
                while (rbbgs.hasNext()) {
                    Row rbbg = (Row)rbbgs.next();
                    rbbg.set("REPORTID", rr.get("REPORTID"));
                    defaultDO.addRow(rbbg);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return toReturn;
    }
}

