/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.ad.DHCPUserIPHandler;
import com.adventnet.fa.server.ad.ProxyUserHandler;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.imp.DataArchiver;
import com.adventnet.la.LaCacheManager;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirewallConstants
extends PureFirewallConstants {
    public static final String YET_TO_RUN = "0";
    public static final String RUNNING = "1";
    public static final String NO_VIRUS_SCANNER = "2";
    public static final String SHOW_ALERT = "3";
    public static final String ALERT_DISABLED = "4";
    private static int archiveRecords = 300;
    private static int maximumArchiveRecords = 5000;
    private static int archiveBufferSize = 8192;
    private static long archiveLoggingTime = 300000L;
    private static float archiveFileCreationTime = 8.64E7f;
    private static float archiveZipCreationTime = 6.048E8f;
    private static int firstArchiveZipCreationHour = 0;
    private static int firstArchiveZipCreationMin = 0;
    private static long selectedFirstZipTime;
    public static boolean archiveWrite;
    private static boolean enableArchiving;
    private static boolean enableIndexing;
    private static String archiveLocation;
    private static String destByPort;
    private static String displayCompliancePercentage;
    private static String liveBpsValue;
    private static String liveBpsNotation;
    private static String adminUserGroup;
    private static String avScanner;
    private static final Logger LOGGER;
    private static long rawDumpingInterval;
    private static int userIPConfig;
    private static UserMACHandler userMACHandlerInstance;
    private static boolean dhcpAsDevice;
    private static boolean dropNotification;
    private static boolean encryptionEnabled;
    private static boolean timeStampingVal;
    private static boolean enableProxyIndexing;
    private static String cmContextBasedNotification;
    private static Map wanIPs;
    private static boolean trafficIndex;
    static boolean newInitialCompressTime;

    public static void loadFromDatabase() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SystemConfigurations");
            while (iter.hasNext()) {
                String statusAlert;
                Row row = (Row)iter.next();
                String confName = (String)row.get("CONF_NAME");
                Object confValue = row.get("CONF_VALUE");
                if (confValue == null) continue;
                if (confName.equals("archiveFileCreationTime")) {
                    archiveFileCreationTime = Float.parseFloat(confValue.toString());
                    LOGGER.log(Level.INFO, "Archive File Creation Time ::" + archiveFileCreationTime);
                    continue;
                }
                if (confName.equals("archiveZipCreationTime")) {
                    archiveZipCreationTime = Float.parseFloat(confValue.toString());
                    LOGGER.log(Level.INFO, "Archive Zip Creation Time ::" + archiveZipCreationTime);
                    continue;
                }
                if (confName.equals("firstArchiveZipCreationHour")) {
                    firstArchiveZipCreationHour = Integer.parseInt(confValue.toString());
                    LOGGER.log(Level.INFO, "First Archive Zip Creation Hour ::" + firstArchiveZipCreationHour);
                    continue;
                }
                if (confName.equals("firstArchiveZipCreationMin")) {
                    firstArchiveZipCreationMin = Integer.parseInt(confValue.toString());
                    LOGGER.log(Level.INFO, "First Archive Zip Creation Minutes ::" + firstArchiveZipCreationMin);
                    continue;
                }
                if (confName.equals("enableArchiving")) {
                    enableArchiving = new Boolean(confValue.toString());
                    LOGGER.log(Level.INFO, "Enable Archiving ::" + enableArchiving);
                    continue;
                }
                if (confName.equals("dropNotification")) {
                    dropNotification = new Boolean(confValue.toString());
                    LOGGER.log(Level.INFO, "Drop Notification ::" + dropNotification);
                    continue;
                }
                if (confName.equals("archiveLocation")) {
                    archiveLocation = confValue.toString();
                    LOGGER.log(Level.INFO, "Archive Location ::" + archiveLocation);
                    continue;
                }
                if (confName.equals("enableIndexing")) {
                    enableIndexing = new Boolean(confValue.toString());
                    LOGGER.log(Level.INFO, "Enable Indexing ::" + enableIndexing);
                    continue;
                }
                if (confName.equals("virusScanner")) {
                    avScanner = confValue.toString();
                    LOGGER.log(Level.INFO, "Show AntiVirusScanAlert ::" + avScanner);
                    continue;
                }
                if (confName.equals("destByPort")) {
                    destByPort = confValue.toString();
                    LOGGER.log(Level.INFO, "destByPort ::" + destByPort);
                    continue;
                }
                if (confName.equals("displayCompPerc")) {
                    displayCompliancePercentage = confValue.toString();
                    LOGGER.log(Level.INFO, "displayCompliancePercentage ::" + displayCompliancePercentage);
                    continue;
                }
                if (confName.equals("userIPConfig")) {
                    userIPConfig = Integer.parseInt(confValue.toString());
                    FirewallConstants.setUserIPConfigValue(userIPConfig);
                    continue;
                }
                if (confName.equals("dhcpAsDevice")) {
                    dhcpAsDevice = Boolean.valueOf(confValue.toString());
                    continue;
                }
                if (confName.equals("archiveEncryption")) {
                    encryptionEnabled = Boolean.valueOf(confValue.toString());
                    LOGGER.log(Level.INFO, "Encryption enabled ::" + encryptionEnabled);
                    continue;
                }
                if (confName.equals("timeStamping")) {
                    timeStampingVal = Boolean.valueOf(confValue.toString());
                    LOGGER.log(Level.INFO, "TimeStamping Val ::" + timeStampingVal);
                    continue;
                }
                if (confName.equals("proxyLogIndexing")) {
                    enableProxyIndexing = Boolean.valueOf(confValue.toString());
                    LOGGER.log(Level.INFO, "Enable Indexing ::" + enableProxyIndexing);
                    continue;
                }
                if (confName.equals("adminUserGroup")) {
                    adminUserGroup = confValue.toString();
                    LOGGER.log(Level.INFO, "adminUserGroup ::" + adminUserGroup);
                    continue;
                }
                if (confName.equals("contextBasedCMNotification")) {
                    cmContextBasedNotification = confValue.toString();
                    LOGGER.log(Level.INFO, "cmContextBasedNotification ::" + cmContextBasedNotification);
                    continue;
                }
                if (confName.equals("ExvirtualFirewalls")) {
                    String excludedIPs = confValue.toString();
                    FAServerUtil.getExcludedFirewallList(excludedIPs);
                    LOGGER.log(Level.INFO, "virtualFirewall-disabled ::" + excludedIPs);
                    continue;
                }
                if (confName.equals("sonicwallWANIP")) {
                    String twoWanInt = confValue.toString();
                    FirewallConstants.generateWanIpMap(twoWanInt);
                    LOGGER.log(Level.INFO, "sonicwallWANIP ::" + twoWanInt);
                    continue;
                }
                if (confName.equals("indexTrafficLog")) {
                    trafficIndex = Boolean.parseBoolean(confValue.toString());
                    FAServerUtil.indexTrafficChanges(trafficIndex);
                    LOGGER.log(Level.INFO, "index traffic logs ::" + trafficIndex);
                    continue;
                }
                if (confName.equals("liveBpsVal")) {
                    liveBpsValue = confValue.toString();
                    FirewallConstants.convertToNotation(liveBpsValue);
                    LOGGER.log(Level.INFO, "Live Bps Value ::" + liveBpsValue);
                    continue;
                }
                if (!confName.equals("statusAlertConfig") || !(statusAlert = confValue.toString()).contains("archivefalse")) continue;
                archiveWrite = false;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static String getAVScanner() {
        if (avScanner.equals(YET_TO_RUN)) {
            try {
                SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
                query.addSelectColumn(new Column("SystemConfigurations", "*"));
                query.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"virusScanner", 0));
                DataObject obj = DataAccess.get((SelectQuery)query);
                Row row = obj.getFirstRow("SystemConfigurations");
                avScanner = (String)row.get("CONF_VALUE");
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Error while updating AVScanner status in FirewallConstants::" + e.getMessage());
            }
        }
        return avScanner;
    }

    public static void setAVScanner(String status) {
        avScanner = status;
    }

    public static boolean dropNotification() {
        return dropNotification;
    }

    public static void setDestByPort(String destinationByPort) {
        destByPort = destinationByPort;
    }

    public static String getDestByPort() {
        return destByPort;
    }

    public static void setDisplayCompPercSetting(String displayCompliancePercentageValue) {
        displayCompliancePercentage = displayCompliancePercentageValue;
    }

    public static String getDisplayCompPercSetting() {
        return displayCompliancePercentage;
    }

    public static void setAdminUserGroup(String adminUserGrp) {
        adminUserGroup = adminUserGrp;
    }

    public static String getAdminUserGroup() {
        return adminUserGroup;
    }

    public static void setNotificationType(String contextBasedNotiStatus) {
        cmContextBasedNotification = contextBasedNotiStatus;
    }

    public static String getNotificationType() {
        return cmContextBasedNotification;
    }

    public static void setDropNotification(boolean temp) {
        if (temp == dropNotification) {
            return;
        }
        try {
            FirewallConstants.updateDatabase("dropNotification", String.valueOf(temp));
            dropNotification = temp;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static long getRawDumpingTime() {
        return rawDumpingInterval;
    }

    public static void setRawDumpingTime(long temp) {
        rawDumpingInterval = temp;
    }

    public static void setMaximumArchiveRecords(int size) {
        maximumArchiveRecords = size;
    }

    public static int getMaximumArchiveRecords() {
        return maximumArchiveRecords;
    }

    public static void setArchiveRecords(int aRec) {
        archiveRecords = aRec;
    }

    public static void setArchiveBufferSize(int size) {
        archiveBufferSize = size;
    }

    public static void setArchiveLoggingTime(long milliseconds) {
        archiveLoggingTime = milliseconds;
    }

    public static int getArchiveRecords() {
        return archiveRecords;
    }

    public static int getArchiveBufferSize() {
        return archiveBufferSize;
    }

    public static long getArchiveLoggingTime() {
        return archiveLoggingTime;
    }

    public static void setArchiveFileInterval(float hours) {
        archiveFileCreationTime = hours * 60.0f * 60.0f * 1000.0f;
    }

    public static void setFirstZipCreationTime(long newTime) {
        selectedFirstZipTime = newTime;
        if (System.currentTimeMillis() > selectedFirstZipTime) {
            selectedFirstZipTime += 86400000L;
        }
    }

    public static void setFirstArchiveZipHour(int hour) {
        firstArchiveZipCreationHour = hour;
    }

    public static void setFirstArchiveZipMin(int min) {
        firstArchiveZipCreationMin = min;
    }

    public static void setArchiveWriteStatus(boolean archWrite) {
        archiveWrite = archWrite;
    }

    public static void setNewInitialCompressTime(boolean temp) {
        newInitialCompressTime = temp;
    }

    public static boolean getNewInitialCompressTime() {
        return newInitialCompressTime;
    }

    public static void setArchiveZipInterval(float hours) {
        archiveZipCreationTime = hours * 60.0f * 60.0f * 1000.0f;
    }

    public static void setArchiveLocation(String location) {
        archiveLocation = location;
    }

    public static String convertToNotation(String byteval) {
        liveBpsNotation = "1024".equals(byteval) ? "Kbps" : ("(1024*1024)".equals(byteval) ? "Mbps" : "Gbps");
        return liveBpsNotation;
    }

    public static void setliveBpsNotation(String val) {
        liveBpsNotation = val;
    }

    public static String getliveBpsNotation() {
        return liveBpsNotation;
    }

    public static String getArchiveLocation() {
        String fwaDefaultDir;
        if (archiveLocation != null && "archive".equals(archiveLocation)) {
            fwaDefaultDir = FirewallConstants.checkDefaultFolder();
            archiveLocation = fwaDefaultDir + File.separator + "archive";
        }
        if (archiveLocation == null) {
            fwaDefaultDir = FirewallConstants.checkDefaultFolder();
            archiveLocation = fwaDefaultDir + File.separator + "archive";
        }
        return archiveLocation;
    }

    private static String checkDefaultFolder() {
        String defDir = System.getProperty("server.dir") + File.separator + "server" + File.separator + "default";
        File defaultDir = new File(defDir);
        if (!defaultDir.exists()) {
            defaultDir.mkdir();
        }
        return defDir;
    }

    public static float getArchiveFileHours() {
        return archiveFileCreationTime / 3600000.0f;
    }

    public static float getArchiveZipHours() {
        return archiveZipCreationTime / 3600000.0f;
    }

    public static int getFirstArchiveZipHour() {
        return firstArchiveZipCreationHour;
    }

    public static int getFirstArchiveZipMin() {
        return firstArchiveZipCreationMin;
    }

    public static long getArchiveZipLong() {
        return (long)archiveZipCreationTime;
    }

    public static float getArchiveFileLong() {
        return (long)archiveFileCreationTime;
    }

    public static float getFirstZipCreationTime() {
        return selectedFirstZipTime;
    }

    public static boolean getArchiveWriteStatus() {
        return archiveWrite;
    }

    public static boolean needToArchive() {
        return enableArchiving;
    }

    public static void enableArchiving(boolean temp) {
        if (enableArchiving == temp) {
            return;
        }
        if (temp) {
            DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
            archiver.enableArchiving();
            enableArchiving = temp;
        } else {
            enableArchiving = temp;
            DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
            archiver.disableArchiving();
        }
    }

    public static boolean isIndexingEnabled() {
        return enableIndexing;
    }

    public static void enableIndexing(boolean temp) {
        if (enableIndexing == temp) {
            return;
        }
        try {
            if (temp) {
                FirewallConstants.updateConfigValue("enableIndexing", "true");
            } else {
                FirewallConstants.updateConfigValue("enableIndexing", "false");
            }
            FirewallConstants.fFlushLogFiles();
            enableIndexing = temp;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static boolean isProxyIndexingEnabled() {
        return enableProxyIndexing;
    }

    public static void enableProxyLogIndexing(boolean temp) {
        if (enableProxyIndexing == temp) {
            return;
        }
        try {
            if (temp) {
                FirewallConstants.updateConfigValue("proxyLogIndexing", "true");
            } else {
                FirewallConstants.updateConfigValue("proxyLogIndexing", "false");
            }
            enableProxyIndexing = temp;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void createInstantZipFile() {
        DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
        archiver.createInstantZipFile();
    }

    public static void createInstantZipFile(int indexallVar) {
        DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
        archiver.createInstantZipFile(indexallVar);
    }

    public static void updateDatabase() {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("SystemConfigurations");
            Criteria crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"archiveFileCreationTime", 0);
            query.setCriteria(crt);
            query.setUpdateColumn("CONF_VALUE", (Object)String.valueOf(archiveFileCreationTime));
            DataAccess.update((UpdateQuery)query);
            query = new UpdateQueryImpl("SystemConfigurations");
            crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"archiveZipCreationTime", 0);
            query.setCriteria(crt);
            query.setUpdateColumn("CONF_VALUE", (Object)String.valueOf(archiveZipCreationTime));
            DataAccess.update((UpdateQuery)query);
            query = new UpdateQueryImpl("SystemConfigurations");
            crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"firstArchiveZipCreationHour", 0);
            query.setCriteria(crt);
            query.setUpdateColumn("CONF_VALUE", (Object)String.valueOf(firstArchiveZipCreationHour));
            DataAccess.update((UpdateQuery)query);
            query = new UpdateQueryImpl("SystemConfigurations");
            crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"firstArchiveZipCreationMin", 0);
            query.setCriteria(crt);
            query.setUpdateColumn("CONF_VALUE", (Object)String.valueOf(firstArchiveZipCreationMin));
            DataAccess.update((UpdateQuery)query);
            query = new UpdateQueryImpl("SystemConfigurations");
            crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"enableArchiving", 0);
            query.setCriteria(crt);
            query.setUpdateColumn("CONF_VALUE", (Object)String.valueOf(enableArchiving));
            DataAccess.update((UpdateQuery)query);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void flushLogFiles() {
        LogIndexingAPI.getInstance().flush();
        DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
        archiver.flushAllArchivedRecords();
    }

    public static void fFlushLogFiles() {
        LogIndexingAPI.getInstance().fflush();
        DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
        archiver.flushAllArchivedRecords();
    }

    public static void updateDatabase(String key, Object value) throws Exception {
        UpdateQueryImpl query = new UpdateQueryImpl("SystemConfigurations");
        Criteria crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)key, 0);
        query.setCriteria(crt);
        query.setUpdateColumn("CONF_VALUE", value);
        DataAccess.update((UpdateQuery)query);
    }

    public static void updateArchiveLocation(File archiveDirPath) {
        try {
            if (!archiveDirPath.exists()) {
                archiveDirPath.mkdirs();
            }
            String absArchivePath = archiveDirPath.getAbsolutePath();
            FirewallConstants.updateConfigValue("archiveLocation", absArchivePath);
            FirewallConstants.setArchiveLocation(absArchivePath);
            LOGGER.log(Level.INFO, "Latest Archive Dirctory ::::::: " + absArchivePath);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private static void updateConfigValue(String colName, String colValue) {
        try {
            Criteria crit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)colName, 0);
            DataAccess.delete((Criteria)crit);
            DataObject doo = DataAccess.constructDataObject();
            Row row = new Row("SystemConfigurations");
            row.set("CONF_NAME", (Object)colName);
            row.set("CONF_VALUE", (Object)colValue);
            doo.addRow(row);
            DataAccess.add((DataObject)doo);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static int getUserIPConfigValue() {
        return userIPConfig;
    }

    private static void setUserIPConfigValue(int value) {
        FirewallLicenseManager.getInstance();
        if (!FirewallLicenseManager.showPremiumFeatures()) {
            userIPConfig = 0;
            userMACHandlerInstance = null;
            return;
        }
        if (value == 1) {
            userMACHandlerInstance = new ProxyUserHandler();
            userMACHandlerInstance.init();
        } else if (value == 2) {
            userMACHandlerInstance = new DHCPUserIPHandler();
            userMACHandlerInstance.init();
        } else {
            userMACHandlerInstance = null;
        }
        userIPConfig = value;
    }

    public static void updateUserIPConfigValue(String value) {
        int configValue = Integer.parseInt(value);
        if (userIPConfig == configValue) {
            return;
        }
        FirewallConstants.setUserIPConfigValue(configValue);
        FirewallConstants.updateConfigValue("userIPConfig", value);
    }

    public static UserMACHandler getUserMACHandlerInstance() {
        return userMACHandlerInstance;
    }

    public static void updateDHCPAsDevice(boolean val) {
        if (dhcpAsDevice ^ val) {
            dhcpAsDevice = val;
            FirewallConstants.updateConfigValue("dhcpAsDevice", String.valueOf(val));
        }
    }

    public static boolean isDHCPAsDevice() {
        return dhcpAsDevice;
    }

    public static boolean isEncryptionEnabled() {
        return encryptionEnabled;
    }

    public static void enableEncryption(boolean temp) {
        if (encryptionEnabled == temp) {
            return;
        }
        FirewallConstants.updateConfigValue("archiveEncryption", String.valueOf(temp));
        encryptionEnabled = temp;
        DataArchiver archiver = (DataArchiver)FwParserEngine.getInstance().getDataArchiver();
        archiver.createInstantZipFile();
    }

    public static boolean isTimeStampingEnabled() {
        return timeStampingVal;
    }

    public static void enableTimeStamping(boolean temp) {
        if (timeStampingVal == temp) {
            return;
        }
        FirewallConstants.updateConfigValue("timeStamping", String.valueOf(temp));
        timeStampingVal = temp;
    }

    public static void generateWanIpMap(String twoWanInt) {
        if (twoWanInt != null) {
            String[] arry = twoWanInt.split(",");
            for (int i = 0; i < arry.length; ++i) {
                String[] temp = arry[i].split("/");
                Long rid = (Long)LaCacheManager.getInstance().getFirewallId(temp[1]);
                if (rid == null) continue;
                wanIPs.put(temp[0], temp[1]);
            }
            FirewallConstants.addToWanIPMap(null, null);
        }
    }

    public static String getWanIPfromMap(String serialNo) {
        return (String)wanIPs.get(serialNo);
    }

    public static void addToWanIPMap(String serialNumber, String resName) {
        try {
            if (serialNumber != null) {
                wanIPs.put(serialNumber, resName);
            }
            String value = "";
            if (!wanIPs.isEmpty()) {
                for (Map.Entry entry1 : wanIPs.entrySet()) {
                    value = value + entry1.getKey() + "/" + entry1.getValue() + ",";
                }
                value = value.substring(0, value.length() - 1);
            }
            FirewallConstants.updateConfValue("sonicwallWANIP", value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTrafficIndex(boolean status) {
        trafficIndex = status;
    }

    public static boolean getTrafficIndex() {
        return trafficIndex;
    }

    public static void setliveBpsValue(String bpsValue) {
        liveBpsValue = bpsValue;
        FirewallConstants.setliveBpsNotation(FirewallConstants.convertToNotation(liveBpsValue));
    }

    public static String getliveBpsValue() {
        return liveBpsValue;
    }

    public static void updateConfValue(String confName, String confValue) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria Crit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)confName, 0);
            query.setCriteria(Crit);
            DataObject obj = DataAccess.get((SelectQuery)query);
            if (obj.isEmpty()) {
                Row row = new Row("SystemConfigurations");
                row.set("CONF_NAME", (Object)confName);
                row.set("CONF_VALUE", (Object)confValue);
                obj.addRow(row);
                DataAccess.add((DataObject)obj);
            } else {
                Row r = obj.getFirstRow("SystemConfigurations");
                r.set("CONF_VALUE", (Object)confValue);
                obj.updateRow(r);
                DataAccess.update((DataObject)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        archiveWrite = true;
        enableArchiving = true;
        enableIndexing = true;
        archiveLocation = null;
        destByPort = "false";
        displayCompliancePercentage = "true";
        liveBpsValue = "1024";
        liveBpsNotation = "Kbps";
        adminUserGroup = "Admin Users,Employee_Administrator";
        avScanner = "notavailable";
        LOGGER = Logger.getLogger(FirewallConstants.class.getName());
        rawDumpingInterval = 111103L;
        userIPConfig = 0;
        userMACHandlerInstance = null;
        dhcpAsDevice = false;
        dropNotification = false;
        encryptionEnabled = false;
        timeStampingVal = false;
        enableProxyIndexing = true;
        cmContextBasedNotification = "true";
        wanIPs = new HashMap();
        trafficIndex = false;
        newInitialCompressTime = false;
    }
}

