/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.Device;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.LaUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.tools.prevalent.Wield;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class FirewallLicenseManager {
    private static int licenseCount = 5000;
    private static int resourceCount = 0;
    private static Hashtable deviceHash = new Hashtable();
    private static List managedDeviceList = new ArrayList();
    private Wield w = Wield.getInstance();
    private static FirewallLicenseManager fwaLic = null;
    private static boolean showUnLicMess = false;
    public static final int MANAGED = 1;
    public static final int UNMANAGED = 0;
    private static boolean showPremiumFeatures = true;
    private static String displayString = null;
    private static String licUserType = null;
    private String[] premiumRbbList = new String[]{"UnUsed Rules"};
    private static boolean renewLic = false;
    private long daysToExpire = 0L;
    private static boolean isAdminServer = false;
    private static List unmanagedDeviceList = new ArrayList();
    private static String primaryContact = null;

    public FirewallLicenseManager() {
        this.resetDeviceLicense();
    }

    public static synchronized FirewallLicenseManager getInstance() {
        if (fwaLic == null) {
            if ("true".equals(System.getProperty("isAdminServer"))) {
                isAdminServer = true;
            }
            fwaLic = new FirewallLicenseManager();
        }
        return fwaLic;
    }

    public void resetDeviceLicense() {
        resourceCount = 0;
        showUnLicMess = false;
        managedDeviceList.clear();
        unmanagedDeviceList.clear();
        this.getLicenseDetails();
        this.populateDeviceObject();
    }

    public boolean getRenewLic() {
        return renewLic;
    }

    public long getDaysToExpire() {
        return this.daysToExpire;
    }

    public int getDeviceHashSize() {
        return deviceHash.size();
    }

    public boolean showUnLicensedMessage() {
        return showUnLicMess;
    }

    public Device getDeviceObject(String resource) {
        return (Device)deviceHash.get(resource.toLowerCase());
    }

    public long getDevicePacketCount(String resource) {
        Device device = (Device)deviceHash.get(resource.toLowerCase());
        if (device != null) {
            return device.getPacketCount();
        }
        return 0L;
    }

    public static int getNewDeviceDefaultLicStatus() {
        int managedDeviceCount = managedDeviceList.size();
        if (managedDeviceCount < licenseCount) {
            return 1;
        }
        return 0;
    }

    public int getLicenseStatus(String resource) {
        Device device = (Device)deviceHash.get(resource.toLowerCase());
        if (device != null) {
            return device.getLicenseStatus();
        }
        return 1;
    }

    public void addNewDevice(String resource) {
        this.increaseResourceCount();
        Device deviceObj = null;
        if (resourceCount <= licenseCount) {
            deviceObj = new Device(1, System.currentTimeMillis());
        } else {
            deviceObj = new Device(0, System.currentTimeMillis());
            showUnLicMess = true;
        }
        deviceObj.setResourceName(resource);
        deviceObj.increaseCounter();
        deviceHash.put(resource.toLowerCase(), deviceObj);
        this.resetDeviceLicense();
    }

    public String getResourceNameFromDevice(String resource) {
        Device device = (Device)deviceHash.get(resource.toLowerCase());
        return device != null ? device.getResourceName() : resource;
    }

    public Map getUpdateTimeMap() {
        HashMap<String, Long> updateTime = new HashMap<String, Long>();
        Set keys = deviceHash.keySet();
        for (String deviceName : keys) {
            Device device = (Device)deviceHash.get(deviceName);
            Long time = new Long(device.getLatestUpdateTime());
            updateTime.put(device.getResourceName(), time);
        }
        return updateTime;
    }

    private void increaseResourceCount() {
        ++resourceCount;
    }

    private void getLicenseDetails() {
        Properties moduleProp = this.w.getModuleProperties("NA");
        this.daysToExpire = this.w.getEvaluationDays();
        licUserType = this.w.getUserType();
        renewLic = this.daysToExpire == 0L && "never".equals(this.w.getEvaluationExpiryDate()) ? false : (this.daysToExpire <= 15L && licUserType.equals("R") ? true : this.daysToExpire <= 5L && licUserType.equals("T"));
        if (moduleProp == null) {
            System.out.println("No Module Properties Specified for Firewall Analyzer Module");
        } else {
            String licenseLimit = moduleProp.getProperty("NumberOfFirewalls");
            if (!"unlimited".equalsIgnoreCase(licenseLimit)) {
                try {
                    licenseCount = Integer.parseInt(licenseLimit);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Unable to get the number of Firewalls allowed. Incorrect Number Format");
                }
            }
            if ("Professional-NG".equals(displayString = this.w.getLicenseTypeString())) {
                showPremiumFeatures = false;
                displayString = "Professional";
            } else {
                showPremiumFeatures = true;
            }
            LaUtil.getInstance().setPremiumRBBList((HashSet)(!showPremiumFeatures ? new HashSet<String>(Arrays.asList(this.premiumRbbList)) : null));
        }
        moduleProp = this.w.getModuleProperties("LicenseDetails");
        if (moduleProp != null) {
            primaryContact = moduleProp.getProperty("PrimaryContact");
        }
    }

    private void populateDeviceObject() {
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("Resources"));
            select.addSelectColumn(new Column("Resources", "*"));
            SortColumn sortCol = new SortColumn(new Column("Resources", "RESOURCEID"), true);
            select.addSortColumn(sortCol);
            DataObject obj = DataAccess.get((SelectQuery)select);
            Iterator iter = obj.getRows("Resources");
            Hashtable<String, Device> newHash = new Hashtable<String, Device>();
            ArrayList<Long> unManResources = new ArrayList<Long>();
            boolean resRow = false;
            int licensed = 0;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String name = (String)row.get("RESOURCENAME");
                String ip = (String)row.get("IPADDRESS");
                Long resId = (Long)row.get("RESOURCEID");
                Long licStatus = (Long)row.get("LIC_STATUS");
                LaCacheManager.getInstance().updateIpToResource(ip, name);
                Timestamp time = (Timestamp)row.get("LAST_UPDATE_TIME");
                long preCount = 0L;
                long preTime = System.currentTimeMillis();
                String lowerCaseDeviceName = name.toLowerCase();
                if (deviceHash != null && deviceHash.containsKey(lowerCaseDeviceName)) {
                    Device preDevice = (Device)deviceHash.get(lowerCaseDeviceName);
                    preCount = preDevice.getPacketCount();
                    preTime = preDevice.getLatestUpdateTime();
                }
                long lastTime = time != null ? time.getTime() : preTime;
                ++resourceCount;
                int deviceLicStatus = licStatus.intValue();
                if (deviceLicStatus == 1) {
                    ++licensed;
                }
                if (!isAdminServer && licensed > licenseCount) {
                    deviceLicStatus = 0;
                    unManResources.add(resId);
                }
                Device deviceObj = null;
                if (deviceLicStatus == 1) {
                    deviceObj = new Device(1, lastTime);
                    managedDeviceList.add(lowerCaseDeviceName);
                    unmanagedDeviceList.remove(lowerCaseDeviceName);
                } else {
                    deviceObj = new Device(0, lastTime);
                    managedDeviceList.remove(lowerCaseDeviceName);
                    unmanagedDeviceList.add(lowerCaseDeviceName);
                    showUnLicMess = true;
                }
                deviceObj.setPacketCount(preCount);
                deviceObj.setResourceName(name);
                newHash.put(lowerCaseDeviceName, deviceObj);
            }
            if (!isAdminServer && unManResources != null & unManResources.size() > 0) {
                for (int i = 0; i < unManResources.size(); ++i) {
                    Long resId = (Long)unManResources.get(i);
                    this.updateManageORUnManage(resId, 0L);
                }
            }
            deviceHash = newHash;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static boolean showPremiumFeatures() {
        return showPremiumFeatures;
    }

    public static String getDisplayString() {
        return displayString;
    }

    public int getResourceCount() {
        return resourceCount;
    }

    public int getLicenseCount() {
        return licenseCount;
    }

    public String getPrimaryContact() {
        return primaryContact;
    }

    public int getManagedDeviceCount() {
        return managedDeviceList.size();
    }

    public int getBalanceLicenseCount() {
        int managedDeviceCount = managedDeviceList.size();
        return licenseCount - managedDeviceCount;
    }

    public boolean isManagedDevice(String host) {
        return managedDeviceList.contains(host.toLowerCase());
    }

    public boolean isUnManagedDevice(String host) {
        return unmanagedDeviceList.contains(host.toLowerCase());
    }

    public int showExcessDeviceCount() {
        return resourceCount - licenseCount;
    }

    public static String getLicUserType() {
        return licUserType;
    }

    public String getLicenseUpdateResult(String resIdList, long status) {
        if (resIdList != null) {
            ArrayList<Long> resList = new ArrayList<Long>();
            StringTokenizer sToken = new StringTokenizer(resIdList, ",");
            while (sToken.hasMoreTokens()) {
                resList.add(new Long(sToken.nextToken()));
            }
            if (status == 1L) {
                try {
                    int dbManagedCount = 0;
                    ArrayList<Long> tempList = resList;
                    SelectQueryImpl query = new SelectQueryImpl(new Table("Resources"));
                    query.addSelectColumn(new Column("Resources", "*"));
                    Criteria crit = new Criteria(new Column("Resources", "LIC_STATUS"), (Object)new Long("1"), 0);
                    query.setCriteria(crit);
                    DataObject resultDO = DataAccess.get((SelectQuery)query);
                    Iterator resItr = resultDO.getRows("Resources");
                    while (resItr.hasNext()) {
                        ++dbManagedCount;
                        Row rRow = (Row)resItr.next();
                        Long deviceId = (Long)rRow.get("RESOURCEID");
                        if (!tempList.contains(deviceId)) continue;
                        tempList.remove(deviceId);
                    }
                    int toManage = dbManagedCount + tempList.size();
                    if (toManage > licenseCount) {
                        return "more";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                for (int i = 0; i < resList.size(); ++i) {
                    Long resId = (Long)resList.get(i);
                    this.updateManageORUnManage(resId, status);
                }
                return "success";
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return "fail";
    }

    private void updateManageORUnManage(Long resId, long status) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("Resources");
            Criteria crt = new Criteria(new Column("Resources", "RESOURCEID"), (Object)resId, 0);
            query.setCriteria(crt);
            query.setUpdateColumn("LIC_STATUS", (Object)new Long(status));
            FAServerUtil.getPersistence().update((UpdateQuery)query);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void restrictToProfEdition() {
        FirewallConstants.updateUserIPConfigValue("0");
        try {
            UpdateQueryImpl update1 = new UpdateQueryImpl("UserResourceView");
            update1.setUpdateColumn("VIEW_RESOURCE", (Object)"1=1");
            DataAccess.update((UpdateQuery)update1);
            UpdateQueryImpl update2 = new UpdateQueryImpl("NotificationFilters");
            update2.setUpdateColumn("OWNER_NAME", (Object)"admin");
            DataAccess.update((UpdateQuery)update2);
            UpdateQueryImpl update3 = new UpdateQueryImpl("AnomalyFilters");
            update3.setUpdateColumn("OWNER_NAME", (Object)"admin");
            DataAccess.update((UpdateQuery)update3);
            Criteria crt = new Criteria(new Column("ReportConfig", "PROFILENAME"), (Object)"*_Scheduled_ChangeMgmt_Report", 2);
            DataAccess.delete((Criteria)crt);
            UpdateQueryImpl notiUpdate = new UpdateQueryImpl("DDNotifications");
            notiUpdate.setUpdateColumn("ENABLED", (Object)new Boolean(false));
            DataAccess.update((UpdateQuery)notiUpdate);
            UpdateQueryImpl uq = new UpdateQueryImpl("DeviceDetails");
            uq.setUpdateColumn("GEN_CONF_MGMT_RPT", (Object)new Boolean(false));
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

