/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirewallStatusNotifier
extends Thread
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(FirewallStatusNotifier.class.getName());
    private static FirewallStatusNotifier statusNotifier = null;
    private long waitTime = 86400000L;
    private long flowValue = Long.parseLong(System.getProperty("maxFlowNotify", "1500"));
    private boolean threadStarted = false;
    private boolean firstTime = true;
    private double minDiskSpace = Double.parseDouble(LaUtil.getMinDiscSpace());
    ResourceBundle bundle = ProductBundle.getInstance().getBundle();
    private boolean diskAlert = false;
    private boolean flowAlert = false;
    private String failedPorts = "";
    private String corruptedTable = null;
    private HashSet notifiedTables = null;
    private Object syncObj = new Object();
    private HashMap notifyOptions = null;
    private String notifyMails = null;

    private FirewallStatusNotifier() {
        LOGGER.log(Level.INFO, "FirewallStatusNotifier Thread started");
    }

    public static synchronized FirewallStatusNotifier getInstance() {
        if (statusNotifier == null) {
            statusNotifier = new FirewallStatusNotifier();
        }
        return statusNotifier;
    }

    private void setMinDiscValue() {
        double mDisk;
        if (this.minDiskSpace == 5.0 && (mDisk = Double.parseDouble(System.getProperty("minDiskSpace", "2.0"))) < this.minDiskSpace) {
            this.minDiskSpace = mDisk;
        }
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg instanceof String) {
            this.corruptedTable = (String)arg;
            this.resumeThreadForTableCorruption();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        this.resetNotifyParams();
        if (this.firstTime) {
            this.threadStarted = true;
            this.firstTime = false;
            this.notifiedTables = new HashSet();
            this.setMinDiscValue();
            this.start();
        } else {
            this.threadStarted = true;
            Object object = this.syncObj;
            synchronized (object) {
                this.syncObj.notify();
            }
        }
    }

    public void stopThread() {
        this.threadStarted = false;
        this.waitTime = 86400000L;
        this.notifyOptions = null;
        this.notifyMails = null;
        this.corruptedTable = null;
        this.resetNotifyParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeThreadForTableCorruption() {
        if (this.threadStarted && this.checkTableNotification()) {
            Object object = this.syncObj;
            synchronized (object) {
                this.syncObj.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.threadStarted) {
            try {
                Object messageContent;
                this.resetNotifyParams();
                if (this.notifyOptions == null) {
                    this.checkDiskSpace();
                    this.checkPortStatus();
                    continue;
                }
                if (this.notifyOptions.containsKey("disk")) {
                    this.checkDiskSpace();
                }
                if (this.notifyOptions.containsKey("port")) {
                    this.checkPortStatus();
                }
                this.checkFlowRate();
                if (this.corruptedTable != null) {
                    this.notifiedTables.add(this.corruptedTable);
                }
                if ((messageContent = this.constructMailMessageContent()) == null) continue;
                this.sendStatusNotification((String)messageContent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    Object e = this.syncObj;
                    synchronized (e) {
                        this.syncObj.wait(this.waitTime);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void resetNotifyParams() {
        this.diskAlert = false;
        this.flowAlert = false;
        this.failedPorts = "";
        this.updateThreadParameters();
    }

    public String getErrorDetailsForUI() {
        String errorDetails = "";
        if (this.diskAlert) {
            errorDetails = errorDetails + this.bundle.getString("StatusAlert.DiskError");
        }
        if (!"".equals(this.failedPorts)) {
            if (!"".equals(errorDetails)) {
                errorDetails = errorDetails + ",";
            }
            errorDetails = errorDetails + " " + this.bundle.getString("StatusAlert.PortError");
        }
        if (this.notifyOptions != null && this.notifyOptions.containsKey("archivefalse")) {
            if (!"".equals(errorDetails)) {
                errorDetails = errorDetails + ",";
            }
            errorDetails = errorDetails + " " + this.bundle.getString("StatusAlert.ArchiveError");
        }
        if (!"".equals(errorDetails)) {
            errorDetails = errorDetails + ". " + this.bundle.getString("StatusAlert.FixMess");
        }
        if (this.corruptedTable != null) {
            errorDetails = this.bundle.getString("StatusAlert.TableError");
        }
        return errorDetails;
    }

    public String getCorruptedTableName() {
        return this.corruptedTable;
    }

    public boolean getThreadRunStatus() {
        return this.threadStarted;
    }

    public HashMap getStatusAlertMap() {
        return this.notifyOptions;
    }

    public String getNotifyMails() {
        return this.notifyMails;
    }

    public HashSet getNotifiedTables() {
        return this.notifiedTables;
    }

    private boolean checkTableNotification() {
        if (this.corruptedTable != null) {
            return !this.notifiedTables.contains(this.corruptedTable);
        }
        return false;
    }

    private void checkDiskSpace() {
        LaUtil.getInstance();
        double freeDiskSpace = Double.parseDouble(LaUtil.getFreeDiskSpace());
        if (freeDiskSpace < this.minDiskSpace && freeDiskSpace > 0.0) {
            this.diskAlert = true;
        }
    }

    private void checkPortStatus() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SyslogCollectors"));
            query.addSelectColumn(new Column("SyslogCollectors", "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("SyslogCollectors");
            while (iter.hasNext()) {
                Row sysRow = (Row)iter.next();
                Long port = (Long)sysRow.get("PORT");
                String status = (String)sysRow.get("STATUS");
                if (!"FAILED".equalsIgnoreCase(status)) continue;
                this.failedPorts = this.failedPorts + port + ",";
            }
            if (this.failedPorts.endsWith(",")) {
                this.failedPorts = this.failedPorts.substring(0, this.failedPorts.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkFlowRate() {
        String flowStr = FAServerUtil.getFlowRate();
        String[] elements = flowStr.split(",");
        long flowRate = Long.parseLong(elements[0]);
        if (flowRate > this.flowValue) {
            this.flowAlert = true;
        }
    }

    private void sendStatusNotification(String messageContent) {
        String mailSubject = this.bundle.getString("StatusAlert.MailSubject");
        String mailHost = "";
        String mailPort = "";
        String mailFrom = "";
        String tlsValue = "";
        String authUser = "";
        String authPass = "";
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("MailServerSettings"));
            Column col = new Column("MailServerSettings", "*");
            Criteria crt = new Criteria(new Column("MailServerSettings", "TYPE"), (Object)"FIREWALL", 0);
            sql.addSelectColumn(col);
            sql.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row r = doo.getFirstRow("MailServerSettings");
            mailFrom = (String)r.get("SENDER_MAILID");
            mailHost = (String)r.get("SMTPSERVER");
            mailPort = ((Long)r.get("SMTPSERVERPORT")).toString();
            authUser = (String)r.get("USERNAME");
            authPass = (String)r.get("PASSWORD");
            tlsValue = (String)r.get("ACTIVE_TLS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SmtpMailer statusMailer = new SmtpMailer(mailHost, mailFrom, this.notifyMails, mailSubject, null, authUser, authPass, mailPort, tlsValue);
            statusMailer.sendMessage(messageContent);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private String constructMailMessageContent() {
        StringBuffer mailContent = new StringBuffer();
        boolean isContentEmpty = true;
        if (this.notifyOptions != null && this.notifyOptions.containsKey("table") && (this.notifiedTables.size() > 0 || this.corruptedTable != null)) {
            mailContent.append("<li><b>");
            mailContent.append(this.bundle.getString("StatusAlert.TableSub"));
            mailContent.append("</b></li>");
            mailContent.append(this.bundle.getString("StatusAlert.TableDesc1"));
            mailContent.append(" (");
            mailContent.append(this.toBeNotifiedTablesList());
            if (!this.notifiedTables.contains(this.corruptedTable)) {
                mailContent.append(",");
                mailContent.append(this.corruptedTable);
            }
            mailContent.append(") ");
            mailContent.append(" ");
            mailContent.append(this.bundle.getString("StatusAlert.TableDesc2"));
            mailContent.append(" ");
            mailContent.append(this.bundle.getString("StatusAlert.ContactMail"));
            mailContent.append("<br><br>");
            isContentEmpty = false;
        }
        if (this.diskAlert) {
            mailContent.append("<li><b>");
            mailContent.append(this.bundle.getString("StatusAlert.DiskSub"));
            mailContent.append("</b></li>");
            mailContent.append(this.bundle.getString("StatusAlert.DiskDesc"));
            mailContent.append("(");
            mailContent.append(this.minDiskSpace);
            mailContent.append(" GB.) ");
            mailContent.append(this.bundle.getString("StatusAlert.DiskAction"));
            mailContent.append("<br><br>");
            isContentEmpty = false;
        }
        if (!"".equals(this.failedPorts)) {
            mailContent.append("<li><b>");
            mailContent.append(this.bundle.getString("StatusAlert.PortSub"));
            mailContent.append("</b></li>");
            mailContent.append(this.bundle.getString("StatusAlert.PortDesc1"));
            mailContent.append(" (");
            mailContent.append(this.failedPorts);
            mailContent.append(") ");
            mailContent.append(this.bundle.getString("StatusAlert.PortDesc2"));
            mailContent.append(this.bundle.getString("StatusAlert.PortMess"));
            mailContent.append("<br><br>");
            isContentEmpty = false;
        }
        if (this.flowAlert) {
            mailContent.append("<li><b>");
            mailContent.append(this.bundle.getString("StatusAlert.FlowRateSub"));
            mailContent.append("</b></li>");
            mailContent.append(this.bundle.getString("StatusAlert.FlowRateMess"));
            mailContent.append("<br>");
            mailContent.append("<a href=\"http://www.manageengine.com/products/firewall/system_requirement.html\">http://www.manageengine.com/products/firewall/system_requirement.html</a>");
            mailContent.append("<br>");
            isContentEmpty = false;
        }
        if (this.notifyOptions != null && this.notifyOptions.containsKey("archivefalse")) {
            mailContent.append("<li><b>");
            mailContent.append(this.bundle.getString("StatusAlert.ArchiveSub"));
            mailContent.append("</b></li>");
            mailContent.append(this.bundle.getString("StatusAlert.ArchiveMess"));
            mailContent.append("<br>");
            isContentEmpty = false;
        }
        if (!isContentEmpty) {
            StringBuffer completeContent = new StringBuffer();
            completeContent.append(this.bundle.getString("StatusAlert.MailStart"));
            completeContent.append(",<br>");
            completeContent.append("<ul>");
            completeContent.append(mailContent.toString());
            completeContent.append("</ul><br>");
            completeContent.append(this.disableStatusAlertLink());
            return completeContent.toString();
        }
        return null;
    }

    private String toBeNotifiedTablesList() {
        String corruptTabs = "";
        if (this.notifiedTables != null) {
            String[] tableArr = this.notifiedTables.toArray(new String[0]);
            int tabLength = tableArr.length;
            for (int i = 0; i < tabLength; ++i) {
                corruptTabs = corruptTabs + tableArr[i] + ",";
            }
        }
        if (corruptTabs.endsWith(",")) {
            corruptTabs = corruptTabs.substring(0, corruptTabs.length() - 1);
        }
        return corruptTabs;
    }

    private void updateThreadParameters() {
        String notiOpt = this.getStatusConfigurations("statusAlertConfig");
        this.populateNotifyOptions(notiOpt);
        this.notifyMails = this.getStatusConfigurations("statusAlertEmails");
    }

    public String getStatusConfigurations(String confName) {
        String confValue = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria crit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)confName, 0);
            query.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)query);
            if (!doo.isEmpty()) {
                Row row = doo.getFirstRow("SystemConfigurations");
                confValue = (String)row.get("CONF_VALUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return confValue;
    }

    private void populateNotifyOptions(String notiOptions) {
        if (notiOptions != null) {
            StringTokenizer stoken = new StringTokenizer(notiOptions, ",");
            this.notifyOptions = new HashMap();
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                if ("table".equals(token = token.trim())) {
                    this.notifyOptions.put("table", "true");
                } else if ("disk".equals(token)) {
                    this.notifyOptions.put("disk", "true");
                } else if ("port".equals(token)) {
                    this.notifyOptions.put("port", "true");
                }
                if (token.startsWith("minDisk")) {
                    String minVal = token.substring(8, token.length());
                    this.notifyOptions.put("minDisk", minVal);
                    this.setMinDiskSpace(minVal);
                }
                if (token.startsWith("archive")) {
                    this.notifyOptions.put(token, "true");
                }
                if (!token.startsWith("sTime")) continue;
                String sTime = token.substring(6, token.length());
                this.notifyOptions.put("sTime", sTime);
                this.setWaitTime(sTime);
            }
        }
    }

    private void setWaitTime(String userScheduleTime) {
        Long userInput = Long.parseLong(userScheduleTime);
        this.waitTime = userInput * 60L * 60L * 1000L;
    }

    private void setMinDiskSpace(String minDisk) {
        this.minDiskSpace = Double.parseDouble(minDisk);
    }

    private String disableStatusAlertLink() {
        String message = "";
        String hostName = "localhost";
        String protocol = FAServerUtil.getServerProtocol();
        String port = FAServerUtil.getServerPort();
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            hostName = "localhost";
        }
        if (protocol != null && port != null) {
            message = "<p><a href=\"" + protocol + "://" + hostName + ":" + port + "/fw/fwaStatusAlert.do?action=disable\">" + this.bundle.getString("StatusAlert.DiableLink") + "</a>&nbsp;" + this.bundle.getString("StatusAlert.MailSubject") + "</p><br/>";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNow() {
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notify();
        }
    }
}

