/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.imp.ImportLogManager;
import com.adventnet.la.DefaultDataFormatter;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LiveVPNCount
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LiveVPNCount.class.getName());
    private static LiveVPNCount vpnNotifier = null;
    private static boolean shutdown = true;
    public Hashtable resVsUserMap = new Hashtable();

    private LiveVPNCount() {
        LOGGER.log(Level.INFO, "LiveVPNCount Thread started");
    }

    public static synchronized LiveVPNCount getInstance() {
        if (vpnNotifier == null) {
            vpnNotifier = new LiveVPNCount();
        }
        return vpnNotifier;
    }

    public void init() {
        Thread t = new Thread(vpnNotifier);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LiveVPNCount liveVPNCount;
                    if (shutdown) {
                        liveVPNCount = vpnNotifier;
                        synchronized (liveVPNCount) {
                            LOGGER.log(Level.WARNING, "LiveVPNCount Shut down mode waiting period is" + ImportLogManager.logicalDelay(new String[]{"10", "00"}, 30L) * 1000L + "<--in mIll sec");
                            vpnNotifier.wait(ImportLogManager.logicalDelay(new String[]{"10", "00"}, 30L) * 1000L);
                        }
                        shutdown = false;
                    }
                    this.getAllDetails();
                    liveVPNCount = vpnNotifier;
                    synchronized (liveVPNCount) {
                        vpnNotifier.wait(1800000L);
                    }
                }
            }
            catch (Exception e) {
                e.getMessage();
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private Map getLiveMap(String resIP, String resourceName) {
        Vector handlers;
        Map vpnHashMap = new TreeMap();
        int index = -1;
        ParserEngineContext context = FwParserEngine.getInstance().getContext();
        if (resIP != null) {
            index = context.findFormatFromLearnings(resIP);
        }
        if (index > -1 && (handlers = context.getHandlerInstances(index)) != null) {
            for (int ii = 0; ii < handlers.size(); ++ii) {
                ParserEngineHandler noti = (ParserEngineHandler)handlers.elementAt(ii);
                vpnHashMap = noti.getLiveData(resourceName);
            }
        }
        return vpnHashMap;
    }

    public void getAllDetails() {
        ArrayList al = (ArrayList)FAServerUtil.getResList();
        for (String resName : al) {
            String resIP = LaCacheManager.getInstance().getResourceIp(resName);
            Map userMap = this.getLiveMap(resIP, resName);
            this.resVsUserMap.put(resName, userMap);
        }
        this.getFromMap();
    }

    private void getFromMap() {
        if (this.resVsUserMap.size() > 0) {
            Set set = this.resVsUserMap.entrySet();
            for (Map.Entry entry : set) {
                String rname = (String)entry.getKey();
                String rid = LaCacheManager.getInstance().getResourceID(entry.getKey().toString()).toString();
                this.formatDetails((Map)entry.getValue(), rid);
            }
        }
    }

    private void formatDetails(Map vpnHashMap, String rid) {
        if (vpnHashMap.size() > 0) {
            String[] keys = new String[]{"TIME", "RID", "ALLUSERS", "SRC_IP", "TOTAL_COUNT", "START_TIME"};
            String[] values = new String[]{"roundedTime", "rid", "allUsers", "allsrcIp", "totalSize", "allusrTime"};
            String allUsers = "";
            String allsrcIp = "";
            String allusrTime = "";
            long totalSize = vpnHashMap.size();
            Timestamp roundedTime = Timestamp.valueOf(this.roundoffDate());
            long resid = Long.parseLong(rid);
            for (Timestamp hashKey : vpnHashMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnHashMap.get(hashKey);
                String user = vpnObj.getUser();
                allUsers = allUsers + user + "#!";
                String src = vpnObj.getSource();
                allsrcIp = allsrcIp + src + "#!";
                String vpn = vpnObj.getVPNName();
                Timestamp time = vpnObj.getVPNTime();
                long inUnixTim = time.getTime();
                allusrTime = allusrTime + inUnixTim + "#!";
                int duration = new Long(vpnObj.getLiveDuration()).intValue();
                String strDuration = new DefaultDataFormatter().formatDuration(duration);
                String timeVal = LiveVPNCount.getI18nTimeValue(strDuration);
            }
            LOGGER.log(Level.FINER, "Live VPN Count" + roundedTime + "<--RID->" + rid + "<--allusers--->" + allUsers + "<--totalcount-->" + totalSize + "<--allip-->" + allsrcIp + "<--allunixtime-->" + allusrTime);
            HashMap<String, Object> toInsert = new HashMap<String, Object>();
            toInsert.put("TIME", roundedTime);
            toInsert.put("RID", resid);
            toInsert.put("ALLUSERS", allUsers);
            toInsert.put("SRC_IP", allsrcIp);
            toInsert.put("TOTAL_COUNT", totalSize);
            toInsert.put("START_TIME", allusrTime);
            this.updateDB(toInsert);
        }
    }

    public String roundoffDate() {
        return this.roundoffDate(System.currentTimeMillis());
    }

    public String roundoffDate(long timeMs) {
        long roundedtimeMs = Math.round((double)timeMs / 1800000.0) * 1800000L;
        System.out.println(roundedtimeMs);
        Date d = new Date(--roundedtimeMs);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s = f.format(d);
        return s;
    }

    private void updateDB(HashMap values) {
        try {
            DataObject doo = DataAccess.constructDataObject();
            Row row1 = new Row("live_vpn_basic");
            row1.set("TIME", (Object)((Timestamp)values.get("TIME")));
            row1.set("RID", (Object)((Long)values.get("RID")));
            row1.set("ALLUSERS", (Object)((String)values.get("ALLUSERS")));
            row1.set("SRC_IP", (Object)((String)values.get("SRC_IP")));
            row1.set("TOTAL_COUNT", (Object)((Long)values.get("TOTAL_COUNT")));
            row1.set("START_TIME", (Object)((String)values.get("START_TIME")));
            doo.addRow(row1);
            DataAccess.add((DataObject)doo);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while inserting data into live_vpn_basic table");
            e.getMessage();
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LiveVPNCount lvc = LiveVPNCount.getInstance();
        lvc.getAllDetails();
    }

    public static String getI18nTimeValue(String time) {
        ResourceBundle bundle = ProductBundle.getInstance().getBundle();
        if (time.indexOf("Days") >= 0) {
            time = time.replaceAll("Days", bundle.getString("DataFormater.Days"));
        } else if (time.indexOf("Day") >= 0) {
            time = time.replaceAll("Day", bundle.getString("DataFormater.Day"));
        }
        if (time.indexOf("Hrs") >= 0) {
            time = time.replaceAll("Hrs", bundle.getString("DataFormater.Hrs"));
        } else if (time.indexOf("Hr") >= 0) {
            time = time.replaceAll("Hr", bundle.getString("DataFormater.Hr"));
        }
        if (time.indexOf("Mins") >= 0) {
            time = time.replaceAll("Mins", bundle.getString("DataFormater.Mins"));
        } else if (time.indexOf("Min ") >= 0) {
            time = time.replaceAll("Min", bundle.getString("DataFormater.Min"));
        }
        if (time.indexOf("mSecs") >= 0) {
            time = time.replaceAll("mSecs", bundle.getString("DataFormater.mSecs"));
        } else if (time.indexOf(" Secs") >= 0) {
            time = time.replaceAll("Secs", bundle.getString("DataFormater.Secs"));
        }
        return time;
    }
}

