/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.fa.server.FACacheManager;
import com.adventnet.la.ReportTask;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.TaskContext;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolicyOptimizationScheduleTask
extends ReportTask {
    private static final Logger LOGGER = Logger.getLogger(PolicyOptimizationScheduleTask.class.getName());
    private static Persistence persistence = null;
    Row tTaskInputRow = null;
    ResourceBundle rb = ProductBundle.getInstance().getBundle();

    public void executeTask(TaskContext context) {
        String scheduleType = null;
        Long reportId = new Long(0L);
        try {
            HashMap rMap = this.getReportIdAndScheduleType(context);
            if (rMap != null) {
                reportId = (Long)rMap.get("reportId");
                scheduleType = (String)rMap.get("scheduleType");
            }
            try {
                DataObject dobj = this.getDO(reportId, scheduleType);
                HashMap reportMap = this.generateAndSendReport(reportId, scheduleType, dobj);
                HashMap updateMap = (HashMap)reportMap.get("map");
                String rID = (String)updateMap.get("rID");
                String resourceName = FACacheManager.getInstance().getDisplayName(new Long(rID));
                updateMap.put("resourceNames", resourceName);
                reportMap.put("map", updateMap);
                updateMap = (HashMap)reportMap.get("criteriaMap");
                updateMap.put("resourceName", resourceName);
                updateMap.put("hidefromto", "true");
                reportMap.put("criteriaMap", updateMap);
                this.exportReportAndSendNotification(reportId, reportMap, dobj);
                if (this.mailID == null || "".equals(this.mailID)) {
                    this.mailID = "-";
                }
                this.updateStatus(true, reportId, this.rb.getString("Device.Details.Msg") + " " + this.mailID, this.startTime);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        catch (Exception exp) {
            this.updateStatus(false, reportId, this.rb.getString("Exception.DataObject"), this.startTime);
            exp.printStackTrace();
            return;
        }
    }

    protected HashMap getReportIdAndScheduleType(TaskContext context) throws Exception {
        String scheduleType = null;
        Long reportId = new Long(0L);
        HashMap<String, Object> rMap = null;
        try {
            DataObject tTaskInput = context.getTaskInputDO();
            persistence = PersistenceDBUtil.getPersistence();
            if (tTaskInput != null) {
                if (!tTaskInput.containsTable("ReportTaskInput")) {
                    this.tTaskInputRow = tTaskInput.getFirstRow("Task_Input");
                    DataObject tempDO = persistence.get("ReportTaskInput", this.tTaskInputRow);
                    this.tTaskInputRow = tempDO.getFirstRow("ReportTaskInput");
                } else {
                    this.tTaskInputRow = tTaskInput.getFirstRow("ReportTaskInput");
                }
                reportId = (Long)this.tTaskInputRow.get("REPORTID");
                scheduleType = (String)this.tTaskInputRow.get("SCHEDULETYPE");
                rMap = new HashMap<String, Object>();
                rMap.put("reportId", reportId);
                rMap.put("scheduleType", scheduleType);
                return rMap;
            }
            LOGGER.log(Level.FINER, "Unable to run report task<->{0}", context);
            return rMap;
        }
        catch (Exception exp) {
            this.updateStatus(false, reportId, this.rb.getString("Exception.DataObject"), this.startTime);
            exp.printStackTrace();
            return rMap;
        }
    }
}

