/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.ProtocolIdentifierRange;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtocolUtility {
    private static final Logger LOGGER = Logger.getLogger(ProtocolUtility.class.getName());
    private static Map identifierMap = new LinkedHashMap();
    private static Map groupsMap = new LinkedHashMap();
    private static List protocolsList = new ArrayList();
    private static List protocolIdList = new ArrayList();
    private static ProtocolIdentifierRange tcpRangeIdentifier = new ProtocolIdentifierRange();
    private static ProtocolIdentifierRange udpRangeIdentifier = new ProtocolIdentifierRange();
    private static String l3protocol = "([\\d]*)/(tcp|udp)";
    private static Pattern pattern = Pattern.compile(l3protocol);

    public static void reloadProtocols() {
        identifierMap.clear();
        groupsMap.clear();
        protocolsList.clear();
        protocolIdList.clear();
        tcpRangeIdentifier.clearMemory();
        udpRangeIdentifier.clearMemory();
        ProtocolUtility.loadProtocols();
    }

    public static String doYouKnow(String protocol) {
        String lower = protocol.toLowerCase();
        String proto = (String)identifierMap.get(lower);
        if (proto == null) {
            String checkPort = null;
            String checkProto = null;
            Matcher m = pattern.matcher(lower);
            if (m.matches()) {
                checkPort = m.group(1);
                checkProto = m.group(2);
            }
            if (checkPort != null) {
                if ("tcp".equals(checkProto)) {
                    proto = tcpRangeIdentifier.getProtocolFromRangeList(checkPort);
                } else if ("udp".equals(checkProto)) {
                    proto = udpRangeIdentifier.getProtocolFromRangeList(checkPort);
                }
            }
        }
        return proto;
    }

    public static Map getIdentifierMap() {
        return identifierMap;
    }

    public static Map getGroupsMap() {
        return groupsMap;
    }

    public static ProtocolIdentifierRange getIdentifierRangeObject(String l3proto) {
        if ("tcp".equals(l3proto)) {
            return tcpRangeIdentifier;
        }
        return udpRangeIdentifier;
    }

    public static List getProtocolsList() {
        return protocolsList;
    }

    public static List getProtocolIdList() {
        return protocolIdList;
    }

    public static Long changeProtoToID(String value) {
        int i = protocolsList.indexOf(value);
        if (i != -1) {
            return (Long)protocolIdList.get(i);
        }
        return null;
    }

    public static String changeIDToProto(Long value) {
        int i = protocolIdList.indexOf(value);
        if (i != -1) {
            return (String)protocolsList.get(i);
        }
        return null;
    }

    public static Set getProtocolGroups() {
        return groupsMap.keySet();
    }

    public static boolean isUnknownIdentifier(String identifier) {
        boolean toReturn;
        boolean bl = toReturn = !identifierMap.containsKey(identifier = identifier.toLowerCase());
        if (toReturn) {
            if (identifier.indexOf("tcp") > 0) {
                toReturn = !tcpRangeIdentifier.contains(identifier);
            } else if (identifier.indexOf("udp") > 0) {
                toReturn = !udpRangeIdentifier.contains(identifier);
            }
        }
        return toReturn;
    }

    public static Map getGroupMap() {
        return groupsMap;
    }

    public static boolean containsGroup(String group) {
        return groupsMap.containsKey(group);
    }

    public static boolean containsProtocol(String proto) {
        return protocolsList.contains(proto);
    }

    public static Map getProtocolsMap() {
        HashMap protocolsMap = new HashMap();
        for (Map.Entry entry : identifierMap.entrySet()) {
            String proto = (String)entry.getValue();
            ArrayList list = (ArrayList)protocolsMap.get(proto);
            if (list == null) {
                list = new ArrayList();
                protocolsMap.put(proto, list);
            }
            list.add(entry.getKey());
        }
        return protocolsMap;
    }

    public static void loadProtocols() {
        try {
            Table parent = new Table("ProtocolGroups");
            SelectQueryImpl query = new SelectQueryImpl(parent);
            String[] jcol1 = new String[]{"PG_ID"};
            String[] jcol2 = new String[]{"PROTOCOL_GROUP"};
            String[] jcol3 = new String[]{"PROTOCOL_ID"};
            Join join1 = new Join(parent, new Table("Protocols"), jcol1, jcol2, 1);
            Join join2 = new Join(new Table("Protocols"), new Table("ProtocolIdentifiers"), jcol3, jcol3, 1);
            query.addSortColumn(new SortColumn(new Column("ProtocolGroups", "PG_ID"), true));
            query.addSelectColumn(new Column("ProtocolGroups", "*"));
            query.addSelectColumn(new Column("Protocols", "*"));
            query.addSelectColumn(new Column("ProtocolIdentifiers", "*"));
            query.addJoin(join1);
            query.addJoin(join2);
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator groupIter = obj.getRows("ProtocolGroups");
            while (groupIter.hasNext()) {
                Row groupRow = (Row)groupIter.next();
                String group = (String)groupRow.get("PROTOCOL_GROUP");
                ArrayList<String> tempList = new ArrayList<String>();
                Iterator protoIter = obj.getRows("Protocols", groupRow);
                while (protoIter.hasNext()) {
                    Row protoRow = (Row)protoIter.next();
                    String protocol = (String)protoRow.get("PROTOCOL_NAME");
                    Long proto_id = (Long)protoRow.get("PROTOCOL_ID");
                    tempList.add(protocol);
                    protocolsList.add(protocol);
                    protocolIdList.add(proto_id);
                    Iterator idIter = obj.getRows("ProtocolIdentifiers", protoRow);
                    while (idIter.hasNext()) {
                        Row idRow = (Row)idIter.next();
                        String identifier = idRow.get("NAME").toString().toLowerCase();
                        if (identifier.indexOf("[ran") > 0) {
                            boolean updateMem = true;
                            if (identifier.indexOf("tcp") > 0) {
                                updateMem = tcpRangeIdentifier.updateRange(identifier, protocol);
                            } else if (identifier.indexOf("udp") > 0) {
                                updateMem = udpRangeIdentifier.updateRange(identifier, protocol);
                            }
                        }
                        identifierMap.put(identifier, protocol);
                    }
                }
                groupsMap.put(group, tempList);
            }
            LOGGER.log(Level.INFO, "Identifiers Table newly added ");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    static {
        ProtocolUtility.loadProtocols();
    }
}

