/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.la.LaUtil;
import com.adventnet.la.QueryHandler;
import com.adventnet.la.QueryHandlerImpl;
import com.adventnet.persistence.DataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ReportFilter
implements QueryHandler {
    private static Map exclusionMap = new HashMap();
    private static Map srcLearning = new HashMap();
    private static Map destLearning = new HashMap();
    private static Map protoLearning = new HashMap();

    public static void setExclusionMap(Long reportId, Map exclusion) {
        if (exclusion.isEmpty()) {
            exclusionMap.remove(reportId);
        } else {
            exclusionMap.put(reportId, exclusion);
        }
    }

    public static Map getExclusionMap(Long reportId) {
        if (exclusionMap.get(reportId) == null) {
            return new HashMap();
        }
        return (Map)exclusionMap.get(reportId);
    }

    public static boolean isFilterApplied(Long reportId) {
        return exclusionMap.containsKey(reportId);
    }

    public StringBuffer handleSQL(StringBuffer sql, DataObject filters, Map reportCtxt) {
        StringBuffer newSql = sql;
        try {
            String andor;
            String value;
            String comp;
            String col;
            String[] temp;
            int i;
            Long reportId = null;
            try {
                String id = reportCtxt.get("reportId") == null ? null : reportCtxt.get("reportId").toString();
                reportId = Long.valueOf(id);
            }
            catch (NumberFormatException e) {
                reportId = null;
            }
            if (reportId == null || !exclusionMap.containsKey(reportId)) {
                return sql;
            }
            String tableName = LaUtil.getInstance().getOldTableName(new String(sql));
            Map map = (Map)exclusionMap.get(reportId);
            String[] src = map.get("SRC") == null ? null : (String[])map.get("SRC");
            String[] dest = map.get("DEST") == null ? null : (String[])map.get("DEST");
            String[] proto = map.get("PROTOCOL_NAME") == null ? null : (String[])map.get("PROTOCOL_NAME");
            String learningTable = tableName;
            if (tableName.lastIndexOf("_") != -1) {
                learningTable = tableName.substring(0, tableName.lastIndexOf("_"));
            }
            if (src != null && srcLearning.containsKey(learningTable)) {
                for (i = 0; i < src.length; ++i) {
                    temp = src[i].split("\\$");
                    col = temp[0];
                    comp = temp[1];
                    value = temp[2];
                    andor = i == 0 || comp.indexOf(" NOT ") != -1 || comp.indexOf("!") != -1 ? " and " : " or ";
                    newSql = this.appendCriteria(newSql, andor, comp, tableName, col, value);
                }
            }
            if (dest != null && destLearning.containsKey(learningTable)) {
                for (i = 0; i < dest.length; ++i) {
                    temp = dest[i].split("\\$");
                    col = temp[0];
                    comp = temp[1];
                    value = temp[2];
                    andor = i == 0 || comp.indexOf(" NOT ") != -1 || comp.indexOf("!") != -1 ? " and " : " or ";
                    newSql = this.appendCriteria(newSql, andor, comp, tableName, col, value);
                }
            }
            if (proto != null && protoLearning.containsKey(learningTable)) {
                proto = (String[])map.get(protoLearning.get(learningTable));
                for (i = 0; i < proto.length; ++i) {
                    temp = proto[i].split("\\$");
                    col = temp[0];
                    comp = temp[1];
                    value = temp[2];
                    andor = i == 0 || comp.indexOf(" NOT ") != -1 || comp.indexOf("!") != -1 ? " and " : " or ";
                    newSql = this.appendCriteria(newSql, andor, comp, tableName, col, value);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return sql;
        }
        return newSql;
    }

    private StringBuffer appendCriteria(StringBuffer sql, String andor, String comp, String tableName, String col, String value) {
        String unionString = LaUtil.containsUnion((String)sql.toString());
        if (unionString == null) {
            new QueryHandlerImpl().appendCriteria(sql, andor, comp, tableName, col, value, true);
        } else {
            Vector sqls = LaUtil.getInstance().tokenize(sql.toString(), unionString, false);
            StringBuffer result = new StringBuffer();
            for (int j = 0; j < sqls.size(); ++j) {
                if (j > 0) {
                    result.append(" ");
                    result.append(unionString);
                    result.append(" ");
                }
                StringBuffer tempBuffer = new StringBuffer(sqls.get(j).toString());
                new QueryHandlerImpl().appendCriteria(tempBuffer, andor, comp, tableName, col, value, true);
                result.append(tempBuffer);
            }
            sql = result;
        }
        return sql;
    }

    static {
        srcLearning.put("Attack_Vs_Cli", "SRC");
        srcLearning.put("Cache_Vs_Cli", "SRC");
        srcLearning.put("Evt_Vs_Cli", "SRC");
        srcLearning.put("Http_Vs_Url", "SRC");
        srcLearning.put("Peer_Vs_Url", "SRC");
        srcLearning.put("Req_Vs_Cli", "SRC");
        srcLearning.put("Rules_Vs_Pro", "SRC");
        srcLearning.put("Spam_Vs_Cli", "SRC");
        srcLearning.put("User_Vs_Bandwidth", "SRC");
        srcLearning.put("User_Vs_Protocol", "SRC");
        srcLearning.put("VPN_Evt_Vs_Pro", "SRC");
        srcLearning.put("Virus_Vs_Cli", "SRC");
        srcLearning.put("MgmtRecords", "SRC");
        destLearning.put("Attack_Vs_Cli", "DEST");
        destLearning.put("Cache_Vs_Cli", "DEST");
        destLearning.put("Http_Vs_Url", "DEST");
        destLearning.put("Peer_Vs_Url", "DEST");
        destLearning.put("Req_Vs_Cli", "DEST");
        destLearning.put("Rules_Vs_Pro", "DEST");
        destLearning.put("Spam_Vs_Cli", "DEST");
        destLearning.put("User_Vs_Protocol", "DEST");
        destLearning.put("VPN_Evt_Vs_Pro", "DEST");
        destLearning.put("Virus_Vs_Cli", "DEST");
        destLearning.put("Dest_Vs_Bandwidth", "DEST");
        protoLearning.put("Attack_Vs_Cli", "PROTOCOL_NAME");
        protoLearning.put("Protocol_Bandwidth", "PROTOCOL_ID");
        protoLearning.put("Req_Vs_Cli", "PROTOCOL_ID");
        protoLearning.put("Rules_Vs_Pro", "PROTOCOL_ID");
        protoLearning.put("Spam_Vs_Cli", "PROTOCOL_ID");
        protoLearning.put("User_Vs_Protocol", "PROTOCOL_ID");
        protoLearning.put("VPN_Evt_Vs_Pro", "PROTOCOL_ID");
        protoLearning.put("Virus_Vs_Cli", "PROTOCOL_NAME");
    }
}

