/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.InterfaceObject;
import com.adventnet.la.util.IPRange;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.snmp.beans.SnmpTable;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SNMPQueryThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(SNMPQueryThread.class.getName());
    private static String snmpCommunity = "public";
    private static int snmpPort = 161;
    private static Long resourceId = null;
    private static String snmpDevice = null;
    private static SNMPQueryThread snmpThread = null;
    private boolean threadStarted = false;
    private boolean stopThread = false;
    private boolean isMultipleQuery = false;
    private Object syncObj = new Object();
    private FACacheManager faCache = FACacheManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSNMPThread() {
        if (!this.threadStarted) {
            this.start();
            this.threadStarted = true;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.syncObj.notify();
            }
        }
    }

    public static SNMPQueryThread getInstance() {
        if (snmpThread == null) {
            snmpThread = new SNMPQueryThread();
            snmpThread.setName("SNMPQueryThread");
        }
        return snmpThread;
    }

    public void stopSNMPThread() {
        this.stopThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.log(Level.INFO, "SNMPQueryThread has been started============>>>>" + snmpDevice);
        while (!this.stopThread) {
            try {
                if (this.isMultipleQuery) {
                    this.snmpQuery2AllDevices();
                    continue;
                }
                this.querySNMPInformation();
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, "SNMP Error:::::::::::::Problem while querying the device::::::" + snmpDevice);
                ee.printStackTrace();
            }
            finally {
                try {
                    Object ee = this.syncObj;
                    synchronized (ee) {
                        this.isMultipleQuery = false;
                        this.syncObj.wait();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setSNMPQueryParameters(String device, String devId, String community, int port) {
        snmpDevice = device;
        snmpCommunity = community;
        snmpPort = port;
        resourceId = new Long(devId);
    }

    public void setMultipleQueryParam(boolean multiQ) {
        this.isMultipleQuery = multiQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void querySNMPInformation() {
        SnmpTable table = new SnmpTable();
        HashMap<String, InterfaceObject> snmpHash = new HashMap<String, InterfaceObject>();
        try {
            String tableOID = "ipAddrTable";
            table.setTargetHost(snmpDevice);
            table.setCommunity(snmpCommunity);
            table.setTargetPort(snmpPort);
            String mibFile = System.getProperty("server.home") + File.separator + "server" + File.separator + "mibs" + File.separator + "RFC1213-MIB";
            table.loadMibs("\"" + mibFile + "\"");
            table.setTableOID(tableOID);
            table.setTableOIDWoStart(tableOID);
            table.run();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "SNMP Error:::::Problem while setting the SnmpTable values:::DeviceName::::" + snmpDevice + ":::" + ex);
            LOGGER.log(Level.INFO, "SNMP Error:::::Community_Port::::::::::" + snmpCommunity + "_" + snmpPort);
        }
        try {
            String[][] a1 = table.getIndices();
            if (a1 != null) {
                for (int i = 0; i < a1.length; ++i) {
                    for (int j = 0; j < a1[i].length; ++j) {
                        String autoIfIndex;
                        HashMap<String, String> interfaceHash = new HashMap<String, String>();
                        String interfaceIP = a1[i][j];
                        String[] ans = table.getRow("ipAddrTable", a1[i][j]);
                        interfaceHash.put("ipAddress", interfaceIP);
                        String ifName = null;
                        String index = null;
                        String netMask = null;
                        String netWork = null;
                        for (int k = 0; k < ans.length; ++k) {
                            String snmpOID = table.getColumnName(k);
                            String snmpCompValue = ans[k];
                            int indexStart = snmpCompValue.lastIndexOf(":");
                            String oidValue = snmpCompValue.substring(indexStart + 2, snmpCompValue.length());
                            if ("ipAdEntIfIndex".equals(snmpOID)) {
                                index = oidValue;
                                interfaceHash.put("ifIndex", index);
                                continue;
                            }
                            if (!"ipAdEntNetMask".equals(snmpOID)) continue;
                            netMask = oidValue;
                            interfaceHash.put("netMask", netMask);
                        }
                        if (index == null || "null".equalsIgnoreCase(index)) continue;
                        if (index != null) {
                            String snmpDescOID = "ifDescr." + index;
                            table.setObjectID(snmpDescOID);
                            ifName = table.snmpGet();
                            if (ifName != null) {
                                ifName = this.handleSNMPDescription(ifName);
                                interfaceHash.put("ifName", ifName);
                            }
                            String speedOID = "ifSpeed." + index;
                            table.setObjectID(speedOID);
                            String speedVal = table.snmpGet();
                            interfaceHash.put("ifSpeed", speedVal);
                        }
                        if (netMask != null) {
                            IPRange ipRange = new IPRange();
                            netWork = IPRange.getNetwork(netMask, (String)interfaceIP);
                            interfaceHash.put("netWork", netWork);
                        }
                        if ("null".equals(autoIfIndex = this.getAutoGenIfIndex(ifName))) {
                            autoIfIndex = index;
                        }
                        interfaceHash.put("ifIndex", autoIfIndex);
                        LOGGER.log(Level.INFO, "SNMP Info:::::::Device::::::ORG_IFINDEX::::::AUTO_IFINDEX::::::" + snmpDevice + ":::::" + index + ":::::" + autoIfIndex);
                        InterfaceObject interObject = new InterfaceObject(ifName, Long.parseLong(autoIfIndex), netWork, ifName);
                        interObject.setInterfaceHash(interfaceHash);
                        snmpHash.put(ifName, interObject);
                        LOGGER.log(Level.INFO, "SNMP Info:::::::Device::::::::::::" + snmpDevice + ":::::Values:::::" + interfaceHash);
                    }
                }
                this.faCache.addToDeviceInterfaceMap(resourceId + "");
                this.updateInterfaceInfo(snmpHash);
            } else {
                LOGGER.log(Level.INFO, "SNMP Error::::::Unable to get IPAddress table OID's. Could be of Time out:::::" + snmpDevice);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "SNMP Error:::::::::::::Unable to get SNMP details for the device::::::::::::::" + snmpDevice);
            e.printStackTrace();
        }
        finally {
            table.releaseResources();
        }
    }

    private String getAutoGenIfIndex(String ifName) {
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("InterfaceInfo"));
            Criteria crt1 = new Criteria(new Column("InterfaceInfo", "RID"), (Object)resourceId, 0);
            Criteria crt2 = new Criteria(new Column("InterfaceInfo", "IF_NAME"), (Object)ifName, 0);
            select.addSelectColumn(new Column("InterfaceInfo", "*"));
            select.setCriteria(crt1.and(crt2));
            DataObject doo = DataAccess.get((SelectQuery)select);
            Long ifIndexValue = (Long)doo.getFirstRow("InterfaceInfo").get("IF_INDEX");
            return ifIndexValue.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    private String handleSNMPDescription(String ifDesc) {
        if (ifDesc.indexOf("'") > 0) {
            ifDesc = ifDesc.substring(ifDesc.indexOf("'") + 1, ifDesc.lastIndexOf("'"));
        }
        return ifDesc;
    }

    private void snmpQuery2AllDevices() {
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("Resources"));
            select.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCETYPE"), (Object)"Firewall", 0);
            select.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)select);
            Iterator iter = doo.getRows("Resources");
            while (iter.hasNext()) {
                Row rRow = (Row)iter.next();
                snmpDevice = (String)rRow.get("IPADDRESS");
                resourceId = (Long)rRow.get("RESOURCEID");
                this.updateSNMPInfo(snmpCommunity, snmpPort + "", resourceId + "");
                this.querySNMPInformation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateSNMPInfo(String community, String port, String resId) {
        try {
            UpdateQueryImpl uquery = new UpdateQueryImpl("SnmpInfo");
            Criteria crt = new Criteria(new Column("SnmpInfo", "RID"), (Object)new Long(resId), 0);
            uquery.setCriteria(crt);
            uquery.setUpdateColumn("SNMP_COMMUNITY", (Object)community);
            uquery.setUpdateColumn("SNMP_PORT", (Object)new Long(port));
            DataAccess.update((UpdateQuery)uquery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateInterfaceInfo(HashMap snmpHash) {
        if (snmpHash == null || snmpHash.size() == 0) {
            return;
        }
        for (String key : snmpHash.keySet()) {
            InterfaceObject intObject = (InterfaceObject)snmpHash.get(key);
            HashMap interfaceHash = intObject.getInterfaceHash();
            String ifName = (String)interfaceHash.get("ifName");
            String ifSpeed = (String)interfaceHash.get("ifSpeed");
            double ifSpd = new Float(ifSpeed).doubleValue();
            if (ifSpd > 1024.0) {
                ifSpeed = ifSpd / 1024.0 + "";
            }
            try {
                SelectQueryImpl selQuery = new SelectQueryImpl(new Table("InterfaceInfo"));
                selQuery.addSelectColumn(new Column("InterfaceInfo", "*"));
                Criteria crit1 = new Criteria(new Column("InterfaceInfo", "RID"), (Object)resourceId, 0);
                Criteria crit2 = new Criteria(new Column("InterfaceInfo", "IF_NAME"), (Object)ifName, 0);
                selQuery.setCriteria(crit1.and(crit2));
                DataObject obj = DataAccess.get((SelectQuery)selQuery);
                if (obj.getTableNames().size() <= 0) {
                    DataObject doo = DataAccess.constructDataObject();
                    Row row = new Row("InterfaceInfo");
                    row.set("RID", (Object)resourceId);
                    row.set("IF_INDEX", (Object)new Long((String)interfaceHash.get("ifIndex")));
                    row.set("IF_NAME", (Object)ifName);
                    row.set("IF_IP", interfaceHash.get("ipAddress"));
                    row.set("IF_UPLINK_SPEED", (Object)new Float(ifSpeed));
                    row.set("IF_DOWNLINK_SPEED", (Object)new Float(ifSpeed));
                    row.set("IF_NETMASK", interfaceHash.get("netMask"));
                    row.set("IF_NETWORK", interfaceHash.get("netWork"));
                    row.set("IF_DISPLAY", (Object)ifName);
                    doo.addRow(row);
                    doo = DataAccess.update((DataObject)doo);
                } else {
                    UpdateQueryImpl query = new UpdateQueryImpl("InterfaceInfo");
                    query.setCriteria(crit1.and(crit2));
                    query.setUpdateColumn("IF_UPLINK_SPEED", (Object)new Float(ifSpeed));
                    query.setUpdateColumn("IF_DOWNLINK_SPEED", (Object)new Float(ifSpeed));
                    query.setUpdateColumn("IF_IP", interfaceHash.get("ipAddress"));
                    query.setUpdateColumn("IF_NETMASK", interfaceHash.get("netMask"));
                    query.setUpdateColumn("IF_NETWORK", interfaceHash.get("netWork"));
                    DataAccess.update((UpdateQuery)query);
                }
                this.faCache.removeIdentifiedInterface(snmpDevice, ifName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

