/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.ComlianceScheduleUtility;
import com.adventnet.fa.server.ComplianceGenerator;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.LaUtil;
import com.adventnet.la.ReportExporter;
import com.adventnet.la.ReportUtil;
import com.adventnet.la.util.Mailer;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.TransactionManager;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class StandardComplianceScheduleTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(StandardComplianceScheduleTask.class.getName());
    DataObject tTaskInput = null;
    Row tTaskInputRow = null;
    private static Persistence persistence = null;
    protected String moduleName = "FIREWALL";
    protected String frmAddress = "firewallreport@localdomain.com";
    protected String mailSubject = "Firewall Analyzer Reports";
    protected String team = "FirewallAnalyzer Team";
    protected String rptCategory = "\n Report for Devices: \t";
    String smtpMailHost = "192.168".concat(".4.41");
    String smtpMailPort = "25";
    String smtpUserName = null;
    String smtpPassword = null;
    String smtpTls = null;
    ResourceBundle rb = ProductBundle.getInstance().getBundle();
    String dear = "Dear";
    String resultOf = "This mail is the result of";
    String gEngine = "Generation Engine.";
    String fileAttach = "file is attached with this mail.";
    String rDetails = "Report details:";
    String rName = "Report Name";
    String genTime = "Generated Time";
    String fromTime = "From";
    String toTime = "To";
    String rCriteria = "Report Criteria";
    String rIncluded = "Reports Included";
    String note = "Note";
    protected String mailID;
    boolean updatePolicyScheduleDetails = false;
    protected long startTime = System.currentTimeMillis();
    SimpleDateFormat displayFormat = new SimpleDateFormat("EEE, MMM d, yyyy, HH:mm:ss");
    Date date = new Date(this.startTime);
    String tstamp = this.displayFormat.format(this.date);
    ReportUtil rptUtil = new ReportUtil();
    String schName = null;
    boolean isPolicyReport = false;
    StandardComplianceScheduleTask sct = null;
    private static final ReentrantLock LOCK = new ReentrantLock();
    SimpleDateFormat newTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private HashMap generateCompSchedule(long reportId, DataObject dobj) {
        HashMap map = new HashMap();
        try {
            String profileName = (String)dobj.getFirstValue("ReportConfig", "PROFILENAME");
            int startindex = profileName.indexOf("_");
            String devid = profileName.substring(profileName.indexOf("_") + 1, profileName.indexOf("_", startindex + 1));
            Long rID = new Long(devid);
            String deviceType = StandardComplianceScheduleTask.getDeviceType(rID);
            int asta = profileName.lastIndexOf("_");
            String complianceName = profileName.substring(asta + 1);
            ComplianceGenerator cg = new ComplianceGenerator();
            ComlianceScheduleUtility csu = ComlianceScheduleUtility.getInstance();
            String resourceName = (String)LaCacheManager.getInstance().getResourceName(rID);
            String displayName = FACacheManager.getInstance().getDisplayName(rID);
            Long latestConfigVersion = new Long(-1L);
            try {
                latestConfigVersion = csu.getLatestConfigVersionNo(rID, displayName);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            long newrepid = StandardComplianceScheduleTask.getReportIdforRID(rID);
            cg.regenerate(rID, displayName, complianceName, null, newrepid, null, resourceName, latestConfigVersion, deviceType);
            map = this.generateAndSendReport(reportId, dobj, complianceName, resourceName, displayName, devid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext context) {
        Long reportId = new Long(0L);
        String scheduleType = null;
        HashMap reportMap = null;
        DataObject dobj = null;
        TransactionManager txMgr = null;
        boolean commit = false;
        try {
            HashMap rMap = this.getReportIdAndScheduleType(context);
            if (rMap != null) {
                reportId = (Long)rMap.get("reportId");
                scheduleType = (String)rMap.get("scheduleType");
            }
            dobj = this.getDO(reportId, scheduleType);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Exception while getting the DataObject before generating scheduled compliance report...");
            this.updateStatus(false, reportId, this.rb.getString("Exception.DataObject"), this.startTime);
            exp.printStackTrace();
            return;
        }
        try {
            LOCK.lock();
            txMgr = DataAccess.getTransactionManager();
            txMgr.begin();
            try {
                reportMap = this.generateCompSchedule(reportId, dobj);
                commit = true;
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, "Exception while generating scheduled compliance report...");
                this.updateStatus(false, reportId, "Exception while generating scheduled compliance report..", this.startTime);
                ee.printStackTrace();
            }
            finally {
                try {
                    this.doCommit(txMgr, commit);
                }
                catch (Exception exp) {
                    LOGGER.log(Level.INFO, "Exception while commiting/rollback the transaction...");
                    this.updateStatus(false, reportId, "Exception while commiting/rollback the transaction...", this.startTime);
                    exp.printStackTrace();
                    commit = false;
                }
            }
            if (commit) {
                this.exportReportAndSendNotification(reportId, reportMap, dobj);
                if (this.mailID == null || "".equals(this.mailID)) {
                    this.mailID = "-";
                }
                this.updateStatus(true, reportId, this.rb.getString("Device.Details.Msg") + " " + this.mailID, this.startTime);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception while executing the compliance report task...");
            this.updateStatus(false, reportId, "Exception while executing the compliance report task...", this.startTime);
            ex.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
    }

    private void doCommit(TransactionManager txMgr, boolean commit) throws Exception {
        if (txMgr.getStatus() == 1 || !commit) {
            txMgr.rollback();
        } else {
            txMgr.commit();
        }
    }

    protected HashMap getReportIdAndScheduleType(TaskContext context) throws Exception {
        String scheduleType = null;
        Long reportId = new Long(0L);
        HashMap<String, Object> rMap = null;
        try {
            DataObject tTaskInput = context.getTaskInputDO();
            persistence = PersistenceDBUtil.getPersistence();
            if (tTaskInput != null) {
                if (!tTaskInput.containsTable("ReportTaskInput")) {
                    this.tTaskInputRow = tTaskInput.getFirstRow("Task_Input");
                    DataObject tempDO = persistence.get("ReportTaskInput", this.tTaskInputRow);
                    this.tTaskInputRow = tempDO.getFirstRow("ReportTaskInput");
                } else {
                    this.tTaskInputRow = tTaskInput.getFirstRow("ReportTaskInput");
                }
                reportId = (Long)this.tTaskInputRow.get("REPORTID");
                scheduleType = (String)this.tTaskInputRow.get("SCHEDULETYPE");
                rMap = new HashMap<String, Object>();
                rMap.put("reportId", reportId);
                rMap.put("scheduleType", scheduleType);
                return rMap;
            }
            LOGGER.log(Level.FINER, "Unable to run report task<->{0}", context);
            return rMap;
        }
        catch (Exception exp) {
            this.updateStatus(false, reportId, this.rb.getString("Exception.DataObject"), this.startTime);
            exp.printStackTrace();
            return rMap;
        }
    }

    public void updateStatus(boolean status, Long reportId, String error, long time) {
        block8: {
            try {
                SelectQueryImpl sq = new SelectQueryImpl(new Table("SystemStatus"));
                sq.addSelectColumn(new Column("SystemStatus", "*"));
                Long userId = (Long)this.getValue(reportId, "REPORTID", "ReportConfig", "USERID");
                Criteria crt = new Criteria(new Column("SystemStatus", "USER_ID"), (Object)userId, 0);
                crt = crt.and(new Criteria(new Column("SystemStatus", "REPORT_ID"), (Object)reportId, 0));
                crt = crt.and(new Criteria(new Column("SystemStatus", "TASKNAME"), (Object)this.schName, 0));
                sq.setCriteria(crt);
                DataObject statusDO = DataAccess.get((SelectQuery)sq);
                Row statusRow = null;
                if (statusDO.isEmpty()) {
                    statusDO = persistence.constructDataObject();
                    statusRow = new Row("SystemStatus");
                    statusRow.set("USER_ID", (Object)userId);
                    statusRow.set("REPORT_ID", (Object)reportId);
                    statusRow.set("TASKNAME", (Object)this.schName);
                    statusRow.set("MODULE_NAME", (Object)this.moduleName);
                    statusRow.set("OPERATION_NAME", (Object)"Report Scheduling");
                    statusDO.addRow(statusRow);
                } else {
                    statusRow = statusDO.getFirstRow("SystemStatus");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                statusRow.set("PERFORMED_AT", (Object)sdf.format(new Date(time)));
                statusRow.set("STATUS", (Object)status);
                if (error != null) {
                    statusRow.set("ERRORS", (Object)error);
                } else {
                    statusRow.set("ERRORS", null);
                }
                statusDO.updateRow(statusRow);
                persistence.update(statusDO);
                if (!this.updatePolicyScheduleDetails) break block8;
                try {
                    UpdateQueryImpl uq = new UpdateQueryImpl("PolicyReportScheduleDetails");
                    Criteria crit = new Criteria(new Column("PolicyReportScheduleDetails", "REPORTID"), (Object)reportId, 0);
                    uq.setCriteria(crit);
                    uq.setUpdateColumn("STATUS", (Object)status);
                    DataAccess.update((UpdateQuery)uq);
                }
                catch (Exception ee) {
                    LOGGER.log(Level.FINER, "[ReportTask] Exception while updating Status into PolicyReportScheduleDetails table. ");
                }
                this.updatePolicyScheduleDetails = false;
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "[ReportTask] Exception while updating Status in DB. ");
                exp.printStackTrace();
            }
        }
    }

    private Object getValue(Object criteria, String criteriaColumn, String tableName, String reqColumnName) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table(tableName));
        Column columns = new Column(tableName, "*");
        sql.addSelectColumn(columns);
        sql.setCriteria(new Criteria(new Column(tableName, criteriaColumn), criteria, 0));
        DataObject userDo = persistence.get((SelectQuery)sql);
        return userDo.getFirstValue(tableName, reqColumnName);
    }

    public HashMap getReportParams(HashMap map, Long reportId) throws Exception {
        return new HashMap();
    }

    public HashMap generateAndSendReport(Long reportId, DataObject dobj, String complianceName, String resourceName, String displayName, String rID) throws Exception {
        String reportName = complianceName;
        String saveReport = complianceName + " Compliance_" + displayName;
        String reportFormat = (String)dobj.getFirstValue("ReportConfig", "REPORTFORMAT");
        if (saveReport == null || saveReport.equals("-") || saveReport.equals("")) {
            saveReport = "Cherry_Report";
        }
        boolean rFormat = true;
        Date currentTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss");
        saveReport = saveReport + "_" + dateFormat.format(currentTime) + ".pdf";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("saveReportAs", File.separator + saveReport);
        map.put("reportFormat", "pdf");
        map.put("mailSubject", complianceName + " Compliance Report For " + displayName);
        HashMap subreportParams = this.getReportParams(map, reportId);
        subreportParams.put("reportFormat", "pdf");
        HashMap criteriaMap = this.getCriteriaMap(reportId, subreportParams);
        if (criteriaMap != null) {
            map.put("resourceNames", (String)criteriaMap.get("resourceName"));
            map.put("reportList", ((String)criteriaMap.get("reportList")).replaceAll("\n", " "));
            map.put("criteriaConfigured", (String)criteriaMap.get("criteria"));
            map.put("pdfHome_ReportName", (String)criteriaMap.get("pdfHome_ReportName"));
            map.put("pdfHome_GroupName", (String)criteriaMap.get("pdfHome_GroupName"));
            map.put("pdfHome_Devices", (String)criteriaMap.get("pdfHome_Devices"));
            map.put("pdfHome_GenTime", (String)criteriaMap.get("pdfHome_GenTime"));
            map.put("pdfHome_FromTime", (String)criteriaMap.get("pdfHome_FromTime"));
            map.put("pdfHome_ToTime", (String)criteriaMap.get("pdfHome_ToTime"));
            map.put("pdfHome_ReportList", (String)criteriaMap.get("pdfHome_ReportList"));
            map.put("pdfHome_Criteria", (String)criteriaMap.get("pdfHome_Criteria"));
            map.put("pdf_NoData", (String)criteriaMap.get("pdf_NoData"));
            map.put("pdf_To", (String)criteriaMap.get("pdf_To"));
            map.put("pdf_Of", (String)criteriaMap.get("pdf_Of"));
        }
        map.put("rpt", "Compliance");
        map.put("rId", rID);
        map.put("objectSummaryTITLE", "Firewall Object Details");
        map.put("compType", reportName);
        map.put("reportName", reportName);
        map.put("resourceName", criteriaMap.get("resourceName"));
        subreportParams.put("reportName", reportName);
        subreportParams.put("resourceName", criteriaMap.get("resourceName"));
        try {
            this.dear = this.rb.getString("reportmail.Dear");
            this.resultOf = this.rb.getString("reportmail.resultof");
            this.gEngine = this.rb.getString("reportmail.GE");
            this.fileAttach = this.rb.getString("reportmail.fileattach");
            this.rDetails = this.rb.getString("reportmail.RD");
            this.rName = this.rb.getString("pdfHome_ReportName");
            this.genTime = this.rb.getString("reportmail.GT");
            this.fromTime = this.rb.getString("AddSchedule.FromTime");
            this.toTime = this.rb.getString("WebPage.ToTime");
            this.rCriteria = this.rb.getString("reportmail.RC");
            this.rIncluded = this.rb.getString("viewAppReport.ReportsIncluded");
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception while setting the ResourceBundle ", exp);
        }
        if (this.rb != null) {
            map.put("resourceBundle", this.rb);
        }
        this.updateLatestGenReport(reportId, saveReport);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("subreportParams", subreportParams);
        returnMap.put("map", map);
        returnMap.put("reportName", reportName);
        returnMap.put("reportFormat", reportFormat);
        returnMap.put("saveReport", saveReport);
        returnMap.put("criteriaMap", criteriaMap);
        returnMap.put("rFormat", rFormat);
        return returnMap;
    }

    private void exportReportAndSendNotification(Long reportId, HashMap rMap, DataObject dobj) throws Exception {
        String url = ReportExporter.getInstance().exportReportToFile(reportId, (HashMap)rMap.get("subreportParams"), (HashMap)rMap.get("map"));
        LOGGER.log(Level.INFO, "UrL<->{0}", url);
        String reportSave = System.getProperty("EC_ReportSave", "mail");
        String fwa_SavePath = LaUtil.getReportSavePath();
        if (reportSave.equals("save")) {
            this.saveCustomReport((String)rMap.get("reportName"), url, fwa_SavePath);
        } else if (reportSave.equals("mailsave") || fwa_SavePath != null) {
            this.saveCustomReport((String)rMap.get("reportName"), url, fwa_SavePath);
            this.sendMail(dobj, url, (String)rMap.get("saveReport"), (Boolean)rMap.get("rFormat"), (Map)rMap.get("map"));
        } else {
            this.sendMail(dobj, url, (String)rMap.get("saveReport"), (Boolean)rMap.get("rFormat"), (Map)rMap.get("map"));
        }
    }

    protected void saveCustomReport(String reportName, String url, String fwa_ReportSavePath) {
        try {
            url = url.substring(0, url.lastIndexOf(File.separator));
            String defaultLocation = System.getProperty("server.home") + File.separator + "reports";
            String path = System.getProperty("EC_reportSavePath", defaultLocation);
            if ("reports".equals(path)) {
                path = defaultLocation;
            }
            if (fwa_ReportSavePath != null) {
                path = fwa_ReportSavePath;
            }
            String reportLocation = path + File.separator + reportName;
            LOGGER.log(Level.INFO, "source path is  !!!! {0}", url);
            LOGGER.log(Level.INFO, "destination path is  !!!! {0}", reportLocation);
            File src = new File(url);
            File dst = new File(reportLocation);
            this.copyDirectory(src, dst);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, ioe.getMessage());
        }
    }

    public void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdirs();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                this.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else {
            int len;
            if (!srcPath.exists()) {
                LOGGER.log(Level.INFO, "File or directory does not exist.");
                return;
            }
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        LOGGER.log(Level.INFO, "Directory copied.");
    }

    private void updateLatestGenReport(Long reportId, String latestReportName) {
        String reportLocation = System.getProperty("server.home");
        File reportDir = new File(reportLocation = reportLocation + File.separator + "server" + File.separator + "reports" + File.separator + reportId);
        if (reportDir.exists()) {
            String[] fileContents = reportDir.list();
            for (int fi = 0; fi < fileContents.length; ++fi) {
                String fileName = fileContents[fi];
                if (!fileName.endsWith(".pdf") && !fileName.endsWith(".zip") && !fileName.endsWith(".csv")) continue;
                new File(reportDir + File.separator + fileName).delete();
            }
        }
        try {
            int fileLength = latestReportName.length();
            String fileName = latestReportName.substring(0, fileLength - 4);
            DataObject doo = DataAccess.get((String)"ReportConfig", (Criteria)new Criteria(new Column("ReportConfig", "REPORTID"), (Object)reportId, 0));
            Row row = doo.getFirstRow("ReportConfig");
            row.set("LAST_GENERATED_REPORT", (Object)fileName);
            doo.updateRow(row);
            PersistenceDBUtil.getPersistence().update(doo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected HashMap getCriteriaMap(Long reportId, Map subReportParams) {
        return LaUtil.getInstance().getCriteriaMap(reportId, subReportParams);
    }

    protected DataObject getDO(Long reportId, String scheduleType) throws Exception {
        DataObject doo = null;
        try {
            if (persistence == null) {
                persistence = PersistenceDBUtil.getPersistence();
            }
            ArrayList<Row> criteria = new ArrayList<Row>();
            Row row1 = new Row("ReportConfig");
            row1.set("REPORTID", (Object)reportId);
            criteria.add(row1);
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add("ReportConfig");
            tableNames.add("AaaUser");
            boolean[] boolArray = new boolean[]{false, false};
            SelectQuery sq = QueryConstructor.get(tableNames, (boolean[])boolArray, (Criteria)QueryConstructor.formCriteria(criteria));
            doo = persistence.get(sq);
            Table table = new Table("MailServerSettings");
            sq = new SelectQueryImpl(table);
            Column col = new Column("MailServerSettings", "*");
            sq.addSelectColumn(col);
            DataObject mailObject = persistence.get(sq);
            doo.merge(mailObject);
        }
        catch (Exception exp) {
            this.updateStatus(false, reportId, this.rb.getString("Exception.Mail.Server") + " " + reportId, this.startTime);
            throw exp;
        }
        return doo;
    }

    protected void sendMail(DataObject dobj, String url, String saveReport, boolean rFormat, Map criteriaMap) throws Exception {
        this.mailID = (String)dobj.getFirstValue("ReportConfig", "MAILID");
        String mailComment = (String)dobj.getFirstValue("ReportConfig", "NOTE");
        String profileName = (String)criteriaMap.get("mailSubject");
        String userName = (String)dobj.getFirstValue("AaaUser", "FIRST_NAME");
        Long reportId = (Long)dobj.getFirstValue("ReportConfig", "REPORTID");
        HashMap<String, String> rmap = new HashMap<String, String>();
        this.rptCategory = "\n " + this.rb.getString("Mail.Report.Device.Details") + " \t";
        rmap.put("report", this.rptCategory);
        Mailer mailer = new Mailer();
        if (dobj.containsTable("MailServerSettings")) {
            this.smtpMailHost = (String)dobj.getFirstValue("MailServerSettings", "SMTPSERVER");
            Long smtpPort = (Long)dobj.getFirstValue("MailServerSettings", "SMTPSERVERPORT");
            String string = this.smtpMailPort = smtpPort != null ? smtpPort.toString() : null;
            if (this.smtpMailPort != null) {
                mailer.setSmtpPort(this.smtpMailPort);
            }
            this.smtpUserName = (String)dobj.getFirstValue("MailServerSettings", "USERNAME");
            this.smtpPassword = (String)dobj.getFirstValue("MailServerSettings", "PASSWORD");
            this.smtpTls = (String)dobj.getFirstValue("MailServerSettings", "ACTIVE_TLS");
            if (this.smtpTls != null) {
                mailer.setTLS(this.smtpTls);
            }
            if (dobj.getFirstValue("MailServerSettings", "SENDER_MAILID") != null) {
                this.frmAddress = (String)dobj.getFirstValue("MailServerSettings", "SENDER_MAILID");
            }
            if (this.smtpUserName != null && !"".equals(this.smtpUserName)) {
                mailer.setUserName(this.smtpUserName);
            }
            if (this.smtpPassword != null && !"".equals(this.smtpPassword)) {
                mailer.setPassword(this.smtpPassword);
            }
        }
        mailer.setMailHost(this.smtpMailHost);
        mailer.setFromAddress(this.frmAddress);
        mailer.setToAddress(this.mailID);
        mailer.initialize();
        mailer.setMailSubject(profileName);
        StringBuffer messageA = new StringBuffer();
        StringBuffer messageB = new StringBuffer();
        StringBuffer messageC = new StringBuffer();
        StringBuffer messageD = new StringBuffer();
        StringBuffer comMessage = new StringBuffer();
        messageA.append(this.dear + " ");
        messageA.append(userName);
        messageA.append(", \n\n  " + this.resultOf + " ");
        messageA.append(this.mailSubject);
        messageA.append(" " + this.gEngine);
        messageB.append(messageA.toString());
        if (rFormat) {
            comMessage.append(saveReport);
        } else {
            comMessage.append(profileName);
            comMessage.append(".zip");
        }
        comMessage.append("]");
        if (url == null) {
            messageB.append(" \n" + this.rb.getString("Gen.Report.Problem1") + ".[");
            messageB.append(comMessage.toString());
            messageB.append(" \n\n" + this.rb.getString("Gen.Report.Problem2") + ":");
        } else {
            messageB.append("\n [");
            messageB.append(comMessage.toString());
            messageB.append(" " + this.fileAttach);
            messageB.append(" \n\n" + this.rDetails);
        }
        messageC.append("\n\n " + this.rName + ": \t");
        messageC.append(profileName);
        messageC.append(rmap.remove("report") + ": ");
        messageC.append(criteriaMap.get("resourceName"));
        messageC.append("\n " + this.genTime + ": \t");
        messageC.append(this.tstamp);
        messageC.append("\n \n " + this.rIncluded + " : " + criteriaMap.get("reportList"));
        if (mailComment != null && !"".equals(mailComment)) {
            messageC.append("\n \n " + this.rb.getString("ResolveDNS.Note") + " :\t");
            messageC.append(mailComment);
        }
        messageD.append(messageB.toString());
        messageD.append(messageC.toString());
        mailer.setAutoReplyText(messageD.toString());
        if (url != null) {
            String isPdfStr = System.getProperty("pdfReport", "false");
            String string = isPdfStr = "false".equals(isPdfStr) ? System.getProperty("EC_pdfReport", "false") : isPdfStr;
            if (rFormat) {
                if ("true".equals(isPdfStr)) {
                    LOGGER.log(Level.FINER, "EXPORT AS PDF-REPORT");
                    mailer.addFilesToAttach(url);
                } else {
                    LOGGER.log(Level.FINER, "EXPORT AS ZIP-REPORT");
                    mailer.addFilesToAttach(this.createZip(url, saveReport, profileName, userName));
                }
            } else {
                mailer.addFilesToAttach(this.createZip(url, saveReport, profileName, userName));
            }
        }
        if (this.mailID != null && !"".equals(this.mailID)) {
            try {
                mailer.constructMessage();
                boolean result = mailer.sendIt();
                if (!result) {
                    String msg = this.rb.getString("Report.Scheduler.Msg") + " " + profileName + " " + this.rb.getString("Report.Scheduler.Mail") + " " + this.mailID;
                    LOGGER.log(Level.FINER, msg);
                    this.updateStatus(false, reportId, msg, this.startTime);
                    Mailer mailer2 = new Mailer();
                    if (this.smtpUserName != null && !"".equals(this.smtpUserName)) {
                        mailer2.setUserName(this.smtpUserName);
                    }
                    if (this.smtpPassword != null && !"".equals(this.smtpPassword)) {
                        mailer2.setPassword(this.smtpPassword);
                    }
                    mailer2.setMailHost(this.smtpMailHost);
                    mailer2.setFromAddress(this.frmAddress);
                    mailer2.setToAddress(this.mailID);
                    mailer2.initialize();
                    mailer2.setMailSubject(this.mailSubject + " - " + profileName);
                    StringBuffer failMessage = new StringBuffer();
                    failMessage.append(messageA.toString());
                    failMessage.append(" \n" + this.rb.getString("Send.Report.Problem") + ".[");
                    failMessage.append(comMessage.toString());
                    failMessage.append(" " + this.rb.getString("File.Size.Problem"));
                    failMessage.append(" \n\n" + this.rb.getString("Gen.Report.Problem2") + ":");
                    failMessage.append(messageC.toString());
                    mailer2.setAutoReplyText(failMessage.toString());
                    mailer2.constructMessage();
                    mailer2.sendIt();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createZip(String filePath, String saveReport, String profileName, String userName) {
        int index = filePath.lastIndexOf(File.separator);
        String basePath = filePath.substring(0, index);
        String fileName = filePath.substring(index + 1);
        String preZipName = saveReport;
        if (saveReport.indexOf("pdf") != -1) {
            int nameLen = saveReport.length();
            preZipName = saveReport.substring(0, nameLen - 4);
        }
        String zipFile = basePath + File.separator + preZipName + ".zip";
        File baseFile = new File(filePath);
        String baseFileName = saveReport + ".html";
        if (fileName.endsWith("pdf")) {
            baseFileName = fileName;
        }
        String zipEncoding = ProductBundle.getInstance().getString("mail.ZipEncoding");
        FileOutputStream fos = null;
        ZipOutputStream zip = null;
        FileInputStream fis = null;
        try {
            HashMap<String, File> map = new HashMap<String, File>();
            map.put(baseFileName, baseFile);
            String dirName = fileName + "_files";
            File directory = new File(basePath + File.separator + dirName);
            if (directory.isDirectory()) {
                File[] arr = directory.listFiles();
                for (int i = 0; i < arr.length; ++i) {
                    String elementName = dirName + File.separator + arr[i].getName();
                    map.put(elementName, arr[i]);
                }
            }
            fos = new FileOutputStream(zipFile);
            zip = new ZipOutputStream((OutputStream)fos);
            zip.setEncoding(zipEncoding);
            zip.setLevel(9);
            zip.setMethod(8);
            for (String key : map.keySet()) {
                File zFile = (File)map.get(key);
                ZipEntry entry = new ZipEntry(key);
                entry.setTime(zFile.lastModified());
                int fileLength = (int)zFile.length();
                fis = new FileInputStream(zFile);
                byte[] wholeFile = new byte[fileLength];
                int bytesRead = fis.read(wholeFile, 0, fileLength);
                zip.putNextEntry(entry);
                zip.write(wholeFile, 0, fileLength);
                zip.closeEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.FINER, "[ Report Scheduler ]: Unable to create zip profile [ {0}]mail to [{1}]", new Object[]{profileName, userName});
            String string = filePath;
            return string;
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return zipFile;
    }

    public void stopTask() {
    }

    public static String getDeviceType(Long rid) {
        try {
            SelectQueryImpl sel = new SelectQueryImpl(new Table("Resources"));
            sel.addSelectColumn(new Column("Resources", "*"));
            Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rid, 0);
            sel.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sel);
            if (doo.isEmpty()) {
                return null;
            }
            return (String)doo.getFirstValue("Resources", "VENDOR_TYPE");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return null;
        }
    }

    public static Long getReportIdforRID(Long rid) {
        try {
            SelectQueryImpl sel = new SelectQueryImpl(new Table("ResourcesToReportConfig"));
            sel.addSelectColumn(new Column("ResourcesToReportConfig", "*"));
            Criteria crit = new Criteria(new Column("ResourcesToReportConfig", "RESOURCEID"), (Object)rid, 0);
            sel.setCriteria(crit);
            DataObject doo = DataAccess.get((SelectQuery)sel);
            if (doo.isEmpty()) {
                return null;
            }
            return (Long)doo.getFirstValue("ResourcesToReportConfig", "REPORTID");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return null;
        }
    }
}

