/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.la.DefaultDataFormatter;
import com.adventnet.la.LaUtil;
import com.adventnet.la.enterprise.dc.DCManager;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

public class StatusPoll
implements Runnable {
    private static StatusPoll sPollObj = null;
    private boolean shutDown = false;
    private boolean firstTimeSkip = true;
    private String from = "firewallreport@localdomain.com";
    private String mailHost = "smtp";
    private String mailPort = "25";
    private String user = null;
    private String password = null;
    private String tls = "no";
    private String smsPort = "COM1";
    String osname = System.getProperty("os.name", "Windows");
    ProductBundle pb = ProductBundle.getInstance();
    ResourceBundle bundle = this.pb.getBundle();
    private Map timeMap = null;
    boolean isAdminServer = "true".equals(System.getProperty("isAdminServer"));
    private String subject = this.isAdminServer ? this.bundle.getString("CAAlert.Subject.Value") : this.bundle.getString("FWAlert.Subject");

    public static synchronized StatusPoll getInstance() {
        if (sPollObj == null) {
            sPollObj = new StatusPoll();
        }
        return sPollObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRunningThread() {
        StatusPoll statusPoll = sPollObj;
        synchronized (statusPoll) {
            sPollObj.notify();
        }
    }

    public void init() {
        Thread t = new Thread((Runnable)sPollObj, "StatusPollThread");
        t.start();
    }

    public void shut() {
        this.shutDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutDown) {
            long waitTime = 0L;
            try {
                DataObject dobj = FAServerUtil.getFwAvailConfig(null, "collDown");
                waitTime = this.getMinWaitingTime();
                if (!this.firstTimeSkip) {
                    if (this.isAdminServer) {
                        this.timeMap = DCManager.getInstance().getCollectorDownTime();
                        if (!this.timeMap.isEmpty()) {
                            this.triggerAlertTask(dobj);
                        }
                    } else {
                        this.triggerAlertTask(dobj);
                    }
                }
                this.firstTimeSkip = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StatusPoll statusPoll = sPollObj;
            synchronized (statusPoll) {
                try {
                    sPollObj.wait(waitTime * 60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void triggerAlertTask(DataObject dobj) throws Exception {
        String mapTableName;
        String tableName;
        String colName = "";
        if (this.isAdminServer) {
            tableName = "Collectors";
            mapTableName = "FWAAToCollectors";
            colName = "DISPLAYNAME";
        } else {
            tableName = "Resources";
            mapTableName = "FWAAToResources";
            colName = "RESOURCENAME";
        }
        Iterator iter1 = dobj.getRows("FWAvailabilityAlert");
        while (iter1.hasNext()) {
            Row baseRow = (Row)iter1.next();
            String alertType = (String)baseRow.get("ALERTTYPE");
            long interval = (Long)baseRow.get("TIME_INTERVAL");
            boolean enabled = (Boolean)baseRow.get("ENABLED");
            if (!enabled) continue;
            Iterator iter2 = dobj.getRows(mapTableName, baseRow);
            String messages = "";
            String smsMsg = "";
            while (iter2.hasNext()) {
                long timeDiff;
                long lastTime = 0L;
                Row z = dobj.getRow(tableName, (Row)iter2.next());
                String deviceName = (String)z.get(colName);
                if (this.isAdminServer) {
                    Long cid = new Long(z.get("CID").toString());
                    lastTime = Long.parseLong(this.timeMap.get(cid).toString());
                } else {
                    this.timeMap = PacketUtil.getLastUpdateMap();
                    lastTime = (Long)this.timeMap.get(deviceName);
                }
                if ((timeDiff = System.currentTimeMillis() - lastTime) <= interval * 60000L) continue;
                String dispName = (String)z.get("DISPLAYNAME");
                messages = messages + "<br><br>" + this.composeMessage(dispName, lastTime, timeDiff);
                smsMsg = smsMsg + this.composeSmsMessage(dispName, lastTime, timeDiff);
            }
            if (messages.length() <= 0) continue;
            if (alertType.indexOf("sms") > -1 && this.getSmsSettings()) {
                String toNo = (String)baseRow.get("TO_NUMBER");
                String test = LaUtil.getInstance().sendSms(this.smsPort, toNo, smsMsg);
            }
            if (alertType.indexOf("email") > -1 && this.getMailSettings()) {
                String to = (String)baseRow.get("TO_ADDRESS");
                String sub = (String)baseRow.get("SUBJECT");
                String faaId = baseRow.get("FAA_ID").toString();
                this.fwaaMail(to, messages, faaId, sub);
            }
            if (alertType.indexOf("snmp") <= -1) continue;
            String path = (String)baseRow.get("LOCATION");
            this.fwaaSnmp(path);
        }
    }

    private long getMinWaitingTime() throws Exception {
        DataObject dobj = FAServerUtil.getFwAvailConfig();
        long waitTime = 0L;
        Iterator iter1 = dobj.getRows("FWAvailabilityAlert");
        while (iter1.hasNext()) {
            Row row = (Row)iter1.next();
            long interval = (Long)row.get("TIME_INTERVAL");
            if (waitTime != 0L && interval >= waitTime) continue;
            waitTime = interval;
        }
        return waitTime;
    }

    private boolean getMailSettings() {
        boolean mailSet = false;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("MailServerSettings"));
            Column col = new Column("MailServerSettings", "*");
            Criteria crt = new Criteria(new Column("MailServerSettings", "TYPE"), (Object)"FIREWALL", 0);
            sql.addSelectColumn(col);
            sql.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row r = doo.getFirstRow("MailServerSettings");
            this.from = (String)r.get("SENDER_MAILID");
            this.mailHost = (String)r.get("SMTPSERVER");
            this.mailPort = ((Long)r.get("SMTPSERVERPORT")).toString();
            this.user = (String)r.get("USERNAME");
            this.password = (String)r.get("PASSWORD");
            this.tls = (String)r.get("ACTIVE_TLS");
            mailSet = true;
        }
        catch (Exception e) {
            System.out.println("Error while fetching Mail server setting in StatusPoll thread");
        }
        return mailSet;
    }

    private String composeMessage(String device, long lastTime, long timeDiff) {
        String message = "";
        if (this.isAdminServer) {
            message = this.bundle.getString("CAAlert.Mess1") + "  " + device + "<b> " + this.bundle.getString("CAAlert.Mess2") + " " + new DefaultDataFormatter().formatDuration(new Long(timeDiff / 1000L).intValue()) + "</b>. " + this.bundle.getString("CAAlert.Mess3") + " " + new Date(lastTime).toString() + ".";
        } else {
            String msg = this.bundle.getString("FWAlert.Mess1");
            message = msg.replace("${ProductName}", this.pb.getRebrandingString("ProductName"));
            message = message + "  " + device + "<b> " + this.bundle.getString("FWAlert.Mess2") + " " + new DefaultDataFormatter().formatDuration(new Long(timeDiff / 1000L).intValue()) + "</b>. " + this.bundle.getString("FWAlert.Mess3") + " " + new Date(lastTime).toString() + ".";
        }
        return message;
    }

    private String composeDisableLink(String faa_id) {
        String protocol = FAServerUtil.getServerProtocol();
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            hostName = "localhost";
        }
        String port = FAServerUtil.getServerPort();
        String message = "";
        if (protocol != null && port != null) {
            message = "<a href=\"" + protocol + "://" + hostName + ":" + port + "/fw/fwAvailAlert.do?mode=disable&faa_id=" + faa_id + "\">" + this.bundle.getString("FWAlert.DisableLink") + "</a>";
        }
        return message;
    }

    private String composeSmsMessage(String device, long lastTime, long timeDiff) {
        String smsMsg = "";
        smsMsg = this.isAdminServer ? "Admin Server was unable to communicate with  " + device + " collector for the past " + new DefaultDataFormatter().formatDuration(new Long(timeDiff / 1000L).intValue()) + " Last communicate at " + new Date(lastTime).toString() + "." : "Firewall Analyzer did not receive logs from  " + device + " for the past " + new DefaultDataFormatter().formatDuration(new Long(timeDiff / 1000L).intValue()) + " Last log was received on " + new Date(lastTime).toString() + ".";
        return smsMsg;
    }

    private boolean getSmsSettings() {
        boolean smsSet = false;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("SmsServerSettings"));
            Column col = new Column("SmsServerSettings", "*");
            Criteria crt = new Criteria(new Column("SmsServerSettings", "TYPE"), (Object)"FIREWALL", 0);
            sql.addSelectColumn(col);
            sql.setCriteria(crt);
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Row r = doo.getFirstRow("SmsServerSettings");
            this.smsPort = (String)r.get("PORT");
            smsSet = true;
        }
        catch (Exception e) {
            System.out.println("Error while fetching Sms Settings in StatusPoll thread");
        }
        return smsSet;
    }

    private void fwaaMail(String to, String messages, String faaId, String sub) {
        try {
            this.subject = sub != null ? sub : this.subject;
            messages = this.isAdminServer ? messages + "<br><br>" + this.composeDisableLink(faaId) : messages + "<br><br><b>" + this.bundle.getString("FWAAlert.mess4") + "</b><ul><li>" + this.bundle.getString("FWAAlert.mess5") + "<li>" + this.bundle.getString("FWAAlert.mess6") + "<li>" + this.bundle.getString("FWAAlert.mess7") + "</ul><br>" + this.composeDisableLink(faaId);
            SmtpMailer mailer = new SmtpMailer(this.mailHost, this.from, to, this.subject, null, this.user, this.password, this.mailPort, this.tls);
            mailer.sendMessage(messages);
        }
        catch (Exception e) {
            System.out.println("While mail sending faild .... thread StatusPoll.." + e);
        }
    }

    private void fwaaSnmp(String path) {
        String cmd = null;
        try {
            if (this.osname.startsWith("Win")) {
                cmd = "cmd /c " + path;
            } else if (this.osname.startsWith("Lin")) {
                cmd = "sh " + path;
            }
            if (cmd != null) {
                Runtime rt = Runtime.getRuntime();
                rt.exec(cmd);
            }
        }
        catch (Exception e) {
            System.out.println("While Script(SNMP) execute faild .... thread StatusPoll.." + e);
        }
    }
}

