/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.ad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractUserIPHandler
implements UserMACHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractUserIPHandler.class.getName());
    protected HashMap configurationMap;
    protected FixedHashMap dataMap = null;
    protected String configTableName = null;
    protected static final int DATA_MAP_SIZE = 50000;
    protected String dataColumnName = null;

    protected abstract String getServerName(DataObject var1, Object var2);

    protected abstract void handleEmptyServer(Object var1, String var2);

    @Override
    public void putData(String serverName, String ipAddress, String value) {
        if (value == null || value.equals((String)this.dataMap.get((Object)(serverName + "#" + ipAddress)))) {
            return;
        }
        boolean isUpdated = this.updateExistingMACData(serverName, ipAddress, value.trim());
        if (!isUpdated) {
            this.addUpdateDataIntoDB(serverName, ipAddress, value.trim());
        }
    }

    @Override
    public String getReplacementValue(String resourceName, String ipAddress) {
        String serverName = (String)this.configurationMap.get(resourceName);
        if (serverName == null) {
            return ipAddress;
        }
        String replacementVal = (String)this.dataMap.get((Object)(serverName + "#" + ipAddress));
        replacementVal = replacementVal != null ? replacementVal : (this.dataMap.size() < 50000 ? ipAddress : this.getReplacementValueFromDB(serverName, ipAddress));
        return replacementVal;
    }

    @Override
    public boolean isConfiguredServer(String serverName) {
        if (this.configurationMap == null) {
            return false;
        }
        return this.configurationMap.containsValue(serverName.trim());
    }

    @Override
    public boolean isConfiguredResource(String resourceName) {
        if (this.configurationMap == null) {
            return false;
        }
        return this.configurationMap.containsKey(resourceName.trim());
    }

    @Override
    public void deleteResourceDetails(String resName) {
        if (this.isConfiguredResource(resName)) {
            this.configurationMap.remove(resName);
        } else if (this.isConfiguredServer(resName)) {
            this.deleteServerConfigDetails(resName);
        }
    }

    @Override
    public void removeData(String serverName, String ipAddress) {
        if (this.dataMap.get((Object)(serverName + "#" + ipAddress)) != null) {
            this.dataMap.remove((Object)(serverName + "#" + ipAddress));
        }
        try {
            Criteria crit1 = new Criteria(new Column("UserMACDetails", "SERVERNAME"), (Object)serverName, 0);
            Criteria crit2 = new Criteria(new Column("UserMACDetails", "IPADDRESS"), (Object)ipAddress, 0);
            Criteria crit = crit1.and(crit2);
            DataAccess.delete((Criteria)crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateConfigDetails(String serverName, String deviceNames) {
        this.deleteServerConfigDetailsFrmMemory(serverName);
        String[] deviceNameArr = deviceNames.split(",");
        for (int i = 0; i < deviceNameArr.length; ++i) {
            String devName = deviceNameArr[i].trim();
            this.configurationMap.put(devName, serverName);
        }
    }

    @Override
    public void clearConfiguredDeviceDetails(String deviceNames) {
        String[] deviceNameArr = deviceNames.split(",");
        for (int i = 0; i < deviceNameArr.length; ++i) {
            String devName = deviceNameArr[i].trim();
            this.configurationMap.remove(devName);
        }
    }

    private void deleteServerConfigDetails(String serverName) {
        this.deleteServerConfigDetailsFrmMemory(serverName);
        FAServerUtil.deleteUserIPConfigData(serverName);
    }

    private void deleteServerConfigDetailsFrmMemory(String serverName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(serverName);
        Collection collectionVals = this.configurationMap.values();
        collectionVals.removeAll(list);
    }

    protected void loadConfigurationDetails() {
        try {
            DataObject configDO = this.getDataObject(this.configTableName, null);
            if (configDO.isEmpty()) {
                return;
            }
            DataObject resDO = this.getDataObject("Resources", null);
            Iterator itr = configDO.getRows(this.configTableName);
            StringBuffer serverNameBuffer = new StringBuffer();
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                String resourceIds = (String)row.get("RESOURCES");
                Object serverId = row.get("SERVER");
                String serverName = this.getServerName(resDO, serverId);
                if (serverName == null) continue;
                if (resourceIds == null) {
                    this.handleEmptyServer(serverId, serverName);
                    continue;
                }
                serverNameBuffer.append(serverName + ",");
                String[] arr = resourceIds.split(",");
                long[] resIdArr = new long[arr.length];
                for (int j = 0; j < arr.length; ++j) {
                    resIdArr[j] = Long.parseLong(arr[j]);
                }
                Iterator resItr = resDO.getRows("Resources", new Criteria(new Column("Resources", "RESOURCEID"), (Object)resIdArr, 8));
                while (resItr.hasNext()) {
                    String resName = (String)((Row)resItr.next()).get("RESOURCENAME");
                    this.configurationMap.put(resName, serverName);
                }
            }
            if (serverNameBuffer.length() > 0) {
                this.loadDBDataIntoMemory(serverNameBuffer.substring(0, serverNameBuffer.length() - 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDBDataIntoMemory(String serverNames) {
        long startTime = System.currentTimeMillis();
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("UserMACDetails"));
            select.addSelectColumn(new Column("UserMACDetails", "*"));
            Criteria crit1 = new Criteria(new Column("UserMACDetails", "SERVERNAME"), (Object)serverNames.split(","), 8);
            Criteria crit2 = new Criteria(new Column("UserMACDetails", this.dataColumnName), null, 1);
            Criteria crit = crit1.and(crit2);
            select.addSortColumn(new SortColumn("UserMACDetails", "UMDID", false));
            select.setRange(new Range(1, 50000));
            DataObject dobj = DataAccess.get((SelectQuery)select);
            Iterator itr = dobj.getRows("UserMACDetails");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                String serverName = (String)row.get("SERVERNAME");
                String ip = (String)row.get("IPADDRESS");
                String user = (String)row.get(this.dataColumnName);
                this.dataMap.put((Object)(serverName + "#" + ip), (Object)user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - startTime;
        LOGGER.log(Level.FINER, "Time taken to load UserMACDetails into memory is " + time + "mSec");
    }

    protected DataObject getDataObject(String tableName, Criteria crit) {
        DataObject loadedDO = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(tableName));
            selectQuery.addSelectColumn(new Column(tableName, "*"));
            if (crit != null) {
                selectQuery.setCriteria(crit);
            }
            loadedDO = DataAccess.get((SelectQuery)selectQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loadedDO;
    }

    protected boolean updateExistingMACData(String serverName, String ipAddress, String value) {
        return false;
    }

    private void addUpdateDataIntoDB(String serverName, String ipAddress, String value) {
        String replacementStr = this.getReplacementValueFromDB(serverName, ipAddress);
        if (replacementStr.equals(value)) {
            return;
        }
        if (replacementStr.equals(ipAddress)) {
            try {
                DataObject doo = DataAccess.constructDataObject();
                Row row = new Row("UserMACDetails");
                row.set("SERVERNAME", (Object)serverName);
                row.set("IPADDRESS", (Object)ipAddress);
                row.set(this.dataColumnName, (Object)value);
                doo.addRow(row);
                DataAccess.add((DataObject)doo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                UpdateQueryImpl query = new UpdateQueryImpl("UserMACDetails");
                Criteria crit1 = new Criteria(new Column("UserMACDetails", "SERVERNAME"), (Object)serverName, 0);
                Criteria crit2 = new Criteria(new Column("UserMACDetails", "IPADDRESS"), (Object)ipAddress, 0);
                Criteria crit = crit1.and(crit2);
                query.setCriteria(crit);
                query.setUpdateColumn(this.dataColumnName, (Object)value);
                DataAccess.update((UpdateQuery)query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dataMap.put((Object)(serverName + "#" + ipAddress), (Object)value);
    }

    private String getReplacementValueFromDB(String serverName, String ipAddress) {
        String user;
        String replacementStr = ipAddress;
        Criteria crit1 = new Criteria(new Column("UserMACDetails", "SERVERNAME"), (Object)serverName, 0);
        Criteria crit2 = new Criteria(new Column("UserMACDetails", "IPADDRESS"), (Object)ipAddress, 0);
        Criteria crit = crit1.and(crit2);
        DataObject dobj = this.getDataObject("UserMACDetails", crit);
        Row row = null;
        try {
            row = dobj.getRow("UserMACDetails");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (row != null && (user = (String)row.get(this.dataColumnName)) != null) {
            replacementStr = user;
            this.dataMap.put((Object)(serverName + "#" + ipAddress), (Object)replacementStr);
        }
        return replacementStr;
    }
}

