/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.dataCollection.DCReport;
import com.adventnet.fa.server.dataCollection.DeviceManager;
import com.adventnet.fa.server.dataCollection.Profile;
import com.adventnet.fa.server.dataCollection.Report;
import com.adventnet.fa.server.dataCollection.SnmpReport;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeviceConfig {
    public static final int SNMP_V1 = 0;
    public static final int SNMP_V2 = 1;
    public static final int SNMP_V3 = 3;
    private static Map<String, Profile> profileMap;
    private static File configFile;
    private static Map<String, Long> rbbgMap;
    private static Map<String, String> format;

    public static void init() {
        format = new HashMap<String, String>();
        format.put("Cisco", "cisco");
        format.put("Netscreen Native", "netscreen");
        format.put("SRX Log Format", "default");
        format.put("FortiGate", "fortigate");
        format.put("CiscoVPN", "ciscovpn");
        format.put("Unknown (WELF)", "default");
        profileMap = new HashMap<String, Profile>();
        configFile = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "ReportConfig.xml");
        rbbgMap = new HashMap<String, Long>();
        try {
            DeviceConfig.loadConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadConfiguration() {
        DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuild = null;
        Document doc = null;
        Element rootElement = null;
        FileInputStream is = null;
        try {
            dBuild = dBuildFac.newDocumentBuilder();
            try {
                is = new FileInputStream(configFile);
            }
            catch (FileNotFoundException fnf) {
                System.out.println("File is not found at " + configFile.getAbsolutePath());
                fnf.printStackTrace();
                return;
            }
            doc = dBuild.parse(is);
        }
        catch (Exception exp) {
            System.out.println("Exception while parsing XML file " + configFile.getAbsolutePath());
            exp.printStackTrace();
            return;
        }
        rootElement = doc.getDocumentElement();
        NodeList profileList = rootElement.getElementsByTagName("Profile");
        int size = profileList.getLength();
        for (int i = 0; i < size; ++i) {
            Element profElement = (Element)profileList.item(i);
            Profile profile = DeviceConfig.getProfile(profElement);
            profileMap.put(profile.getName(), profile);
        }
        if (Boolean.getBoolean("DEBUG")) {
            DeviceConfig.printProfileInMem();
        }
        DeviceManager dm = DeviceManager.getInstance();
        dm.loadAllResProf();
    }

    private static Profile getProfile(Element profElement) {
        String profileName = profElement.getAttribute("name");
        Profile profile = new Profile(profileName);
        NodeList reportList = profElement.getElementsByTagName("Report");
        int size = reportList.getLength();
        for (int i = 0; i < size; ++i) {
            Element repElement = (Element)reportList.item(i);
            Report report = DeviceConfig.getReport(repElement);
            if (report == null) continue;
            profile.addReport(report);
        }
        return profile;
    }

    private static Report getReport(Element repElement) {
        Report report = null;
        String rbbgName = repElement.getAttribute("name");
        Long rbbgId = DeviceConfig.getRbbgId(rbbgName);
        if (rbbgId == null) {
            return null;
        }
        String proto = repElement.getAttribute("mode");
        NodeList childList = repElement.getChildNodes();
        report = proto.equals("snmp") ? DeviceConfig.getSnmpReport(rbbgName, rbbgId, repElement, childList) : DeviceConfig.getDCReport(rbbgName, rbbgId, repElement, childList);
        return report;
    }

    private static Report getSnmpReport(String rbbgName, Long rbbgId, Element repElement, NodeList childList) {
        String strVersion = repElement.getAttribute("version");
        int version = DeviceConfig.getVersion(strVersion);
        SnmpReport report = new SnmpReport(rbbgName, rbbgId, version);
        int size = childList.getLength();
        for (int i = 0; i < size; ++i) {
            Element ele;
            try {
                ele = (Element)childList.item(i);
            }
            catch (ClassCastException cce) {
                System.out.println("Exception while casting nodes inside <Report> to Element ");
                cce.printStackTrace();
                continue;
            }
            String tag = ele.getTagName();
            String value = ele.getTextContent();
            if (tag.equalsIgnoreCase("mib")) {
                report.setMib(value);
                continue;
            }
            if (tag.equalsIgnoreCase("oid")) {
                report.addOid(value);
                continue;
            }
            if (tag.equalsIgnoreCase("table")) {
                String tableOID = ele.getAttribute("oid");
                report.setTableOID(tableOID);
                String[] cols = DeviceConfig.getColumns(ele.getChildNodes());
                report.setColNames(cols);
                continue;
            }
            if (tag.equalsIgnoreCase("dependencymib")) {
                report.addDependencyMib(value);
                continue;
            }
            if (!tag.equalsIgnoreCase("parameters")) continue;
            Properties prop = DeviceConfig.getParameters(ele);
            report.setProperties(prop);
        }
        return report;
    }

    public static int getVersion(String strVersion) {
        if ("v2".equals(strVersion)) {
            return 1;
        }
        if ("v3".equals(strVersion)) {
            return 3;
        }
        return 0;
    }

    private static Report getDCReport(String rbbgName, Long rbbgId, Element repElement, NodeList childList) {
        String proto = repElement.getAttribute("mode");
        DCReport report = proto.equalsIgnoreCase("dc") ? new DCReport(rbbgName, rbbgId) : new DCReport(rbbgName, rbbgId, proto);
        int size = childList.getLength();
        for (int i = 0; i < size; ++i) {
            Element ele;
            try {
                ele = (Element)childList.item(i);
            }
            catch (ClassCastException cce) {
                System.out.println("Exception while casting nodes inside <Report> to Element ");
                cce.printStackTrace();
                continue;
            }
            String tag = ele.getTagName();
            String value = ele.getTextContent();
            if (!tag.equalsIgnoreCase("cmd")) continue;
            report.setCmd(value);
        }
        return report;
    }

    private static String[] getColumns(NodeList cols) {
        int size = cols.getLength();
        String[] columns = new String[size];
        for (int i = 0; i < size; ++i) {
            Element ele;
            try {
                ele = (Element)cols.item(i);
            }
            catch (ClassCastException cce) {
                System.out.println("Exception while casting nodes inside <table> to Element ");
                cce.printStackTrace();
                continue;
            }
            columns[i] = ele.getAttribute("name");
        }
        return columns;
    }

    private static Properties getParameters(Element parameterEle) {
        Properties prop = new Properties();
        NodeList params = parameterEle.getChildNodes();
        int size = params.getLength();
        for (int i = 0; i < size; ++i) {
            Element ele;
            try {
                ele = (Element)params.item(i);
            }
            catch (ClassCastException cce) {
                System.out.println("Exception while casting nodes inside <Parameters> to Element ");
                cce.printStackTrace();
                continue;
            }
            String name = ele.getAttribute("name");
            String value = ele.getAttribute("value");
            prop.setProperty(name, value);
        }
        return prop;
    }

    public static Long getRbbgId(String rbbgName) {
        Long rbbgId = rbbgMap.get(rbbgName);
        if (rbbgId == null) {
            try {
                SelectQueryImpl query = new SelectQueryImpl(new Table("ReportBuildingBlockGroup"));
                query.addSelectColumn(new Column("ReportBuildingBlockGroup", "RBBGID"));
                query.addSelectColumn(new Column("ReportBuildingBlockGroup", "RBBGNAME"));
                Criteria crit = new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgName, 0);
                query.setCriteria(crit);
                DataObject dataObj = DataAccess.get((SelectQuery)query);
                rbbgId = (Long)dataObj.getFirstValue("ReportBuildingBlockGroup", "RBBGID");
                rbbgMap.put(rbbgName, rbbgId);
            }
            catch (Exception e) {
                System.out.println("Exception while fetching RBBGID for " + rbbgName);
                e.printStackTrace();
                rbbgId = null;
            }
        }
        return rbbgId;
    }

    public static Profile getDefaultProfile(String name) {
        String origName = format.get(name);
        Profile toReturn = null;
        toReturn = origName != null ? profileMap.get(origName) : profileMap.get(name);
        if (toReturn == null) {
            toReturn = profileMap.get("default");
        }
        return toReturn;
    }

    public static void main(String[] args) {
        DeviceConfig.init();
        DeviceConfig.printProfileInMem();
    }

    private static void printProfileInMem() {
        Set<String> s = profileMap.keySet();
        for (String str : s) {
            Profile p = profileMap.get(str);
            System.out.println(" *************  Profile : " + p.getName() + " *************** Key in Map : " + str);
            Set<Report> reports = p.getReports();
            for (Report rep : reports) {
                System.out.println("Report Name: " + rep.getName());
                System.out.println("RBBGID: " + rep.getRbbgId());
                System.out.println("Protocol : " + rep.getProtocol());
                System.out.println("Interval : " + rep.getInterval());
            }
        }
    }
}

