/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.dataCollection.DataFetcher;
import com.adventnet.fa.server.dataCollection.DeviceConfig;
import com.adventnet.fa.server.dataCollection.FetcherException;
import com.adventnet.fa.server.dataCollection.Profile;
import com.adventnet.fa.server.dataCollection.Report;
import com.adventnet.fa.server.dataCollection.ReportScheduler;
import com.adventnet.fa.server.dataCollection.SnmpFetcher;
import com.adventnet.fa.server.dataCollection.SnmpReport;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceManager {
    private static final Logger LOGGER = Logger.getLogger(DeviceManager.class.getName());
    private static final long INIT_DELAY = 120L;
    private Map<Long, Profile> resProfiles;
    private Map<String, DataFetcher> fetcherMap;
    private ScheduledThreadPoolExecutor scheduler;
    private Map<Long, ScheduledFuture> taskMap;
    private static DeviceManager dman;
    private int threadPoolSize = Integer.parseInt(System.getProperty("FetcherThreads", "1"));

    private DeviceManager() {
        this.resProfiles = new HashMap<Long, Profile>();
        this.fetcherMap = new HashMap<String, DataFetcher>();
        this.scheduler = new ScheduledThreadPoolExecutor(this.threadPoolSize);
        this.taskMap = new HashMap<Long, ScheduledFuture>();
    }

    public static DeviceManager getInstance() {
        if (dman == null) {
            dman = new DeviceManager();
        }
        return dman;
    }

    private void loadResProf(Set<Long> rids, boolean isFirstTime) {
        this.loadProfFromDB(rids);
        Set<Long> profiledRids = null;
        profiledRids = rids == null ? this.resProfiles.keySet() : rids;
        this.populateScheduler(profiledRids, isFirstTime);
        if (Boolean.getBoolean("DEBUG")) {
            this.printAllProperties();
        }
    }

    private void loadProfFromDB(Set<Long> rids) {
        SelectQueryImpl sel = new SelectQueryImpl(new Table("ReportSettings"));
        Object snmpId = null;
        Criteria crit = new Criteria(new Column("ReportSettings", "SNMPID"), snmpId, 1);
        if (rids != null) {
            long[] temp = new long[rids.size()];
            int i = 0;
            for (Long rid : rids) {
                temp[i++] = rid;
            }
            crit = crit.and(new Criteria(new Column("ReportSettings", "RID"), (Object)temp, 8));
        }
        sel.setCriteria(crit);
        Join snmpJoin = new Join("ReportSettings", "SnmpInfo", new String[]{"SNMPID"}, new String[]{"RID"}, 1);
        sel.addJoin(snmpJoin);
        Join resJoin = new Join("ReportSettings", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
        sel.addJoin(resJoin);
        sel.addSelectColumn(new Column("ReportSettings", "*"));
        sel.addSelectColumn(new Column("SnmpInfo", "*"));
        sel.addSelectColumn(new Column("Resources", "*"));
        SortColumn sort = new SortColumn(new Column("ReportSettings", "RID"), true);
        sel.addSortColumn(sort);
        DataObject dObj = null;
        Iterator iter = null;
        try {
            dObj = DataAccess.get((SelectQuery)sel);
            iter = dObj.getRows("ReportSettings");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return;
        }
        Profile prof = null;
        while (iter.hasNext()) {
            try {
                Long rid;
                Row repSet = (Row)iter.next();
                Row snmpInfo = dObj.getRow("SnmpInfo", repSet);
                Row resource = dObj.getRow("Resources", repSet);
                Long rbbgId = (Long)repSet.get("RBBGID");
                Long interval = (Long)repSet.get("TIME_INTERVAL");
                String vendor = (String)resource.get("VENDOR_TYPE");
                Profile defaultProf = DeviceConfig.getDefaultProfile(vendor.trim());
                Report rep = null;
                if (snmpInfo != null) {
                    Integer version = (Integer)snmpInfo.get("VERSION");
                    SnmpReport temp = (SnmpReport)defaultProf.getReport(rbbgId, "snmp");
                    if (version < temp.getVersion()) continue;
                    SnmpReport snmpRep = null;
                    try {
                        snmpRep = (SnmpReport)temp.clone();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    snmpRep.setVersion(version);
                    rep = snmpRep;
                }
                if ((prof = this.resProfiles.get(rid = (Long)repSet.get("RID"))) == null) {
                    prof = new Profile(rid + "");
                    this.resProfiles.put(rid, prof);
                }
                if (interval > 0L) {
                    rep.setInterval(interval.intValue());
                    prof.setScheduled(true);
                }
                prof.addReport(rep);
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "Exception while loading data in DB into Memory");
                dae.printStackTrace();
            }
        }
        try {
            this.loadFetcherMap(dObj);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while loading fetcherMap in memory {0} ", e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadFetcherMap(DataObject dObj) throws Exception {
        Iterator iter = dObj.getRows("Resources");
        SelectQueryImpl sel = new SelectQueryImpl(new Table("DIPCredentials"));
        sel.addSelectColumn(new Column("DIPCredentials", "*"));
        DataObject dipObj = DataAccess.get((SelectQuery)sel);
        SelectQueryImpl sel_v3 = new SelectQueryImpl(new Table("SnmpV3"));
        sel_v3.addSelectColumn(new Column("SnmpV3", "*"));
        DataObject snmpv3Obj = DataAccess.get((SelectQuery)sel_v3);
        Object nullObj = null;
        while (iter.hasNext()) {
            Row resRow = (Row)iter.next();
            Long rid = (Long)resRow.get("RESOURCEID");
            Criteria resCrit = new Criteria(new Column("ReportSettings", "RID"), (Object)rid, 0);
            Criteria finalCrit = resCrit.and(new Column("ReportSettings", "SNMPID"), nullObj, 1);
            Row repSettings = dObj.getRow("ReportSettings", finalCrit);
            if (repSettings == null) continue;
            Row snmpInfo = dObj.getRow("SnmpInfo", repSettings);
            String remoteHost = (String)resRow.get("IPADDRESS");
            String comm = (String)snmpInfo.get("SNMP_COMMUNITY");
            Long port = (Long)snmpInfo.get("SNMP_PORT");
            int version = (Integer)snmpInfo.get("VERSION");
            Profile prof = this.resProfiles.get(rid);
            Set<Report> reports = prof.getReports();
            ArrayList<String> mibs = new ArrayList<String>();
            for (Report rep : reports) {
                if (!"snmp".equals(rep.getMode())) continue;
                mibs.addAll(((SnmpReport)rep).getDependencyMib());
                mibs.add(((SnmpReport)rep).getMib());
            }
            String strMib = this.getMibStr(mibs);
            SnmpFetcher sf = new SnmpFetcher(remoteHost, version, comm, port, strMib);
            if (version == DeviceConfig.getVersion("v3")) {
                Long id = (Long)snmpInfo.get("RID");
                Criteria crit = new Criteria(new Column("SnmpV3", "SNMPID"), (Object)id, 0);
                Row v3row = snmpv3Obj.getRow("SnmpV3", crit);
                sf.setV3Params(v3row);
            }
            String key = rid + "-" + sf.getMode();
            this.fetcherMap.put(key, sf);
        }
    }

    private void populateScheduler(Set<Long> profiledRids, boolean firstTime) {
        if (profiledRids == null) {
            return;
        }
        long[] rids = new long[profiledRids.size()];
        int i = 0;
        for (Long rid : profiledRids) {
            rids[i++] = rid;
        }
        SelectQueryImpl sel = new SelectQueryImpl(new Table("Resources"));
        Join resJoin = new Join("Resources", "ReportSettings", new String[]{"RESOURCEID"}, new String[]{"RID"}, 2);
        sel.addJoin(resJoin);
        Join interfaceJoin = new Join("ReportSettings", "InterfaceInfo", new String[]{"RID"}, new String[]{"RID"}, 1);
        sel.addJoin(interfaceJoin);
        sel.addSelectColumn(new Column("Resources", "*"));
        sel.addSelectColumn(new Column("ReportSettings", "*"));
        sel.addSelectColumn(new Column("InterfaceInfo", "*"));
        Criteria crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)rids, 8);
        crit = crit.and(new Column("ReportSettings", "TIME_INTERVAL"), (Object)1L, 4);
        crit = crit.and(new Column("ReportSettings", "ENABLED"), (Object)Boolean.TRUE, 0);
        sel.setCriteria(crit);
        try {
            DataObject dObj = DataAccess.get((SelectQuery)sel);
            Iterator resIter = dObj.getRows("Resources");
            while (resIter.hasNext()) {
                Set<Report> reports;
                Row resRow = (Row)resIter.next();
                Long rid = (Long)resRow.get("RESOURCEID");
                String vendor_type = (String)resRow.get("VENDOR_TYPE");
                Profile prof = this.resProfiles.get(rid);
                if (prof == null || (reports = prof.getScheduledReports()).isEmpty()) continue;
                HashMap<String, Long> interfaceInfoMap = new HashMap<String, Long>();
                HashMap<Long, String> interfaceIdMap = new HashMap<Long, String>();
                Criteria crit1 = new Criteria(new Column("InterfaceInfo", "RID"), (Object)rid, 0);
                Iterator iter = dObj.getRows("InterfaceInfo", crit1);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String ifName = (String)row.get("IF_NAME");
                    Long ifIndex = (Long)row.get("IF_INDEX");
                    interfaceInfoMap.put(ifName, ifIndex);
                    interfaceIdMap.put(ifIndex, ifName);
                }
                Report liveReport = prof.getReport("LiveReports");
                int interval = liveReport.getInterval();
                try {
                    ReportScheduler sch = new ReportScheduler(rid, vendor_type, interfaceInfoMap, interfaceIdMap, interval, firstTime);
                    if (!"false".equals(System.getProperty("isDemo", "false"))) continue;
                    LOGGER.log(Level.INFO, "Scheduler added with interval {0} for rid {1} ", new Object[]{interval, rid});
                    ScheduledFuture<?> sf = this.scheduler.scheduleWithFixedDelay(sch, 120L, interval * 60, TimeUnit.SECONDS);
                    this.taskMap.put(rid, sf);
                }
                catch (FetcherException fe) {
                    LOGGER.log(Level.INFO, "FetcherException while populating scheduler, so ReportScheduler not added for rid {0} {1}", new Object[]{rid, fe.getMessage()});
                    fe.printStackTrace();
                }
            }
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "Report Schedulers are not triggered due to the below exception");
            dae.printStackTrace();
        }
    }

    void printThreadPool() {
        LOGGER.log(Level.INFO, "Core pool: {0} Pool size: {1} Queue size: {2}", new Object[]{this.scheduler.getCorePoolSize(), this.scheduler.getPoolSize(), this.scheduler.getQueue().size()});
    }

    private String getMibStr(List<String> mibs) {
        String strMib = null;
        String mibLocation = System.getProperty("server.home") + File.separator + "server" + File.separator + "mibs" + File.separator;
        for (String mib : mibs) {
            if (strMib == null) {
                strMib = "\"" + mibLocation + mib + "\"";
                continue;
            }
            strMib = strMib + "|\"" + mibLocation + mib + "\"";
        }
        return strMib;
    }

    void loadAllResProf() {
        this.loadResProf(null, false);
    }

    public Profile getProfile(Long rid) {
        return this.resProfiles.get(rid);
    }

    public boolean isProfileExist(Long rid) {
        return this.resProfiles.containsKey(rid);
    }

    public Collection<Profile> getProfiles() {
        return this.resProfiles.values();
    }

    public Set<Long> getAllRids() {
        return this.resProfiles.keySet();
    }

    public Set<Long> getAllRids(Long rbbgId) {
        if (rbbgId == null) {
            return this.getAllRids();
        }
        HashSet<Long> result = new HashSet<Long>();
        Set<Long> rids = this.resProfiles.keySet();
        for (Long rid : rids) {
            Profile prof = this.resProfiles.get(rid);
            if (!prof.containsRbbg(rbbgId)) continue;
            result.add(rid);
        }
        return result;
    }

    public Set<Long> getDisabledRids() {
        HashSet<Long> toReturn = new HashSet<Long>();
        SelectQueryImpl sel = new SelectQueryImpl(new Table("ReportSettings"));
        sel.addSelectColumn(new Column("ReportSettings", "*"));
        Criteria crit = new Criteria(new Column("ReportSettings", "ENABLED"), (Object)0, 1);
        sel.setCriteria(crit);
        Iterator iter = null;
        try {
            DataObject dObj = DataAccess.get((SelectQuery)sel);
            iter = dObj.getRows("ReportSettings");
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while getting disabled rids from ReportSettings");
            dae.printStackTrace();
            return toReturn;
        }
        while (iter.hasNext()) {
            Row r = (Row)iter.next();
            toReturn.add((Long)r.get("RID"));
        }
        return toReturn;
    }

    public void updateProfiles(Set<Long> rids, boolean isFirstTime) {
        for (Long rid : rids) {
            if (!this.resProfiles.containsKey(rid)) continue;
            this.deleteProfile(rid);
        }
        this.loadResProf(rids, isFirstTime);
        if (Boolean.getBoolean("DEBUG")) {
            this.printAllProperties();
        }
    }

    public DataFetcher getFetcher(String key) {
        return this.fetcherMap.get(key);
    }

    public void deleteProfile(Long rid) {
        DataFetcher df;
        this.resProfiles.remove(rid);
        LOGGER.log(Level.FINER, "No of scheduler threads before removing {0}", this.scheduler.getQueue().size());
        ScheduledFuture sf = this.taskMap.remove(rid);
        if (sf != null) {
            sf.cancel(false);
        }
        if ((df = this.fetcherMap.remove(rid + "-snmp")) != null) {
            df.close();
        }
        if ((df = this.fetcherMap.remove(rid + "-dc")) != null) {
            df.close();
        }
    }

    public void disableProfile(Long rid, boolean todo) {
        if (todo) {
            LOGGER.log(Level.FINER, "No of scheduler threads before removing {0}", this.scheduler.getQueue().size());
            ScheduledFuture sf = this.taskMap.remove(rid);
            if (sf != null) {
                sf.cancel(false);
            }
        } else {
            HashSet<Long> rids = new HashSet<Long>();
            rids.add(rid);
            boolean firstTime = false;
            this.populateScheduler(rids, firstTime);
            this.printAllProperties();
        }
    }

    public Map<String, String[]> getReportData(Long rid, String rbbgName) {
        Profile prof = this.resProfiles.get(rid);
        if (prof == null) {
            LOGGER.log(Level.FINER, "Live Settings Profile doesn't exists for rid {0}", rid);
            return null;
        }
        Report rep = prof.getReport(rbbgName);
        if (rep == null) {
            LOGGER.log(Level.FINER, "RBBG {0} doesn't exists for rid {1}", new Object[]{rbbgName, rid});
            return null;
        }
        SelectQueryImpl sel = new SelectQueryImpl(new Table("ReportSettings"));
        sel.addSelectColumn(new Column("ReportSettings", "*"));
        Criteria resCrit = new Criteria(new Column("ReportSettings", "RID"), (Object)rid, 0);
        Criteria repCrit = new Criteria(new Column("ReportSettings", "RBBGID"), (Object)rep.getRbbgId(), 0);
        sel.setCriteria(resCrit.and(repCrit));
        DataObject dObj = null;
        try {
            dObj = DataAccess.get((SelectQuery)sel);
            Boolean enabled = (Boolean)dObj.getFirstValue("ReportSettings", "ENABLED");
            if (!enabled.booleanValue()) {
                return null;
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return null;
        }
        DataFetcher df = this.fetcherMap.get(rid + "-" + rep.getMode());
        LinkedHashMap<String, String[]> resultMap = new LinkedHashMap<String, String[]>();
        try {
            int i;
            int version = 1;
            if ("snmp".equals(rep.getMode())) {
                version = ((SnmpReport)rep).getVersion();
            }
            String[][] result = null;
            try {
                Level level;
                result = df.execReport(rep);
                if (version != 0) {
                    result = this.transposeMatrix(result);
                }
                if ((level = LOGGER.getLevel()) != null && !level.equals(Level.INFO)) {
                    String[][] arr$ = result;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String[] row;
                        for (String cell : row = arr$[i$]) {
                            LOGGER.log(Level.INFO, " {0} ", cell);
                        }
                    }
                }
            }
            catch (FetcherException fe) {
                LOGGER.log(Level.INFO, "FetcherException while getting data for report {0} {1}", new Object[]{rbbgName, fe.getMessage()});
                fe.printStackTrace();
                String[] oids = ((SnmpReport)rep).getOids();
                result = new String[1][0];
            }
            String[] colHeaders = new String[result[0].length];
            for (i = 0; i < result[0].length; ++i) {
                colHeaders[i] = rep.getProperty("column" + (i + 1));
            }
            resultMap.put("$headers$", colHeaders);
            for (i = 0; i < result.length && result[i].length > 0; ++i) {
                resultMap.put(result[i][0], result[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap = null;
        }
        return resultMap;
    }

    public boolean testConnection(Long rid, int retries) {
        String sysDescrOid = ".1.3.6.1.2.1.1.1.0";
        SnmpFetcher sf = (SnmpFetcher)this.fetcherMap.get(rid + "-snmp");
        try {
            sf.getScalarOid(sysDescrOid);
        }
        catch (FetcherException fe) {
            if (retries == 0) {
                LOGGER.log(Level.INFO, "FetcherException while testing the SNMP connection {0}", fe.getMessage());
                fe.printStackTrace();
                return false;
            }
            return this.testConnection(rid, retries - 1);
        }
        return true;
    }

    private String[][] transposeMatrix(String[][] a) {
        int noOfRow = a.length;
        int noOfCol = a[0].length;
        String[][] result = new String[noOfCol][noOfRow];
        for (int i = 0; i < noOfRow; ++i) {
            for (int j = 0; j < noOfCol; ++j) {
                result[j][i] = a[i][j];
            }
        }
        return result;
    }

    private void printAllProperties() {
        Set<Long> rids = this.resProfiles.keySet();
        for (Long rid : rids) {
            LOGGER.log(Level.INFO, "{0}", this.resProfiles.get(rid));
        }
        LOGGER.log(Level.INFO, "Fetcher map is populated for {0}", this.fetcherMap.keySet().toString());
        LOGGER.log(Level.INFO, "ReportScheduler queue size is {0}", this.scheduler.getQueue().size());
    }
}

