/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import com.adventnet.fa.server.dataCollection.Report;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Profile {
    private String name;
    private Set<Report> reports;
    private boolean scheduled = false;

    Profile(String name) {
        this.name = name;
        this.reports = new LinkedHashSet<Report>();
    }

    boolean addReport(Report rep) {
        boolean result = this.reports.add(rep);
        return result;
    }

    public Report getReport(String rbbgName, String mode) {
        for (Report temp : this.reports) {
            if (!rbbgName.equals(temp.getName()) || !mode.equals(temp.getMode())) continue;
            return temp;
        }
        return null;
    }

    public Report getReport(Long rbbgId, String mode) {
        for (Report temp : this.reports) {
            if (!rbbgId.equals(temp.getRbbgId()) || !mode.equals(temp.getMode())) continue;
            return temp;
        }
        return null;
    }

    public Report getReport(String rbbgName) {
        for (Report temp : this.reports) {
            if (!rbbgName.equals(temp.getName())) continue;
            return temp;
        }
        return null;
    }

    Set<Report> getScheduledReports() {
        HashSet<Report> result = new HashSet<Report>();
        for (Report temp : this.reports) {
            if (temp.getInterval() <= 0) continue;
            result.add(temp);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Profile name: " + this.name);
        for (Report rep : this.reports) {
            sb.append(rep.toString());
        }
        return sb.toString();
    }

    public Set<Report> getReports() {
        return this.reports;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public boolean containsRbbg(Long rbbgId) {
        for (Report rep : this.reports) {
            if (rep.getRbbgId() != rbbgId) continue;
            return true;
        }
        return false;
    }
}

