/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.dataCollection.DataFetcher;
import com.adventnet.fa.server.dataCollection.DeviceManager;
import com.adventnet.fa.server.dataCollection.FetcherException;
import com.adventnet.fa.server.dataCollection.Profile;
import com.adventnet.fa.server.dataCollection.Report;
import com.adventnet.fa.server.dataCollection.SnmpFetcher;
import com.adventnet.fa.server.dataCollection.SnmpReport;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.IPRange;
import com.adventnet.la.util.nf.NotificationEngine;
import com.adventnet.la.util.nf.NotifierException;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReportScheduler
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DeviceManager.class.getName());
    private DeviceManager dman = DeviceManager.getInstance();
    private Long rid;
    private boolean isZoneBased;
    private int interval;
    private Map<String, Long> interfaceInfoMap;
    private Map<Long, String> interfaceIdMap;
    private Map<Long, int[]> interfaceVsOidInstances;
    private Set<Long> wanIfIndex;
    private Map<Long, Long> ifInMap;
    private Map<Long, Long> ifOutMap;
    private Map<Long, double[]> ifSpeedMap;
    private long recordTime = 0L;
    private DataObject dataObject = null;
    private boolean updateInterfaceInfo = false;
    private boolean runHourlyTask = false;
    private String resName = null;
    private static FirewallLicenseManager fwaLic = null;

    ReportScheduler(Long rid, String vendor_type, Map<String, Long> interfaceInfoMap, Map<Long, String> interfaceIdMap, int interval, boolean isFirstTime) throws FetcherException {
        this.rid = rid;
        this.isZoneBased = vendor_type.equalsIgnoreCase("Netscreen Native");
        this.resName = (String)LaCacheManager.getInstance().getResourceName(rid);
        this.interval = interval;
        this.interfaceInfoMap = interfaceInfoMap;
        this.interfaceIdMap = interfaceIdMap;
        this.interfaceVsOidInstances = new HashMap<Long, int[]>();
        this.wanIfIndex = new HashSet<Long>();
        this.ifInMap = new HashMap<Long, Long>();
        this.ifOutMap = new HashMap<Long, Long>();
        this.ifSpeedMap = new HashMap<Long, double[]>();
        this.updateInterfaceInfo = isFirstTime;
        this.runHourlyTask = isFirstTime;
        fwaLic = FirewallLicenseManager.getInstance();
    }

    @Override
    public void run() {
        try {
            int lic_status = fwaLic.getLicenseStatus(this.resName);
            if (lic_status != 1) {
                LOGGER.log(Level.FINER, "Skipped schedule for resource {0} as its unmanaged", this.resName);
                return;
            }
            if (this.interfaceVsOidInstances.isEmpty()) {
                this.populateInterfaces();
                this.populateIfSpeedMap();
                this.printAllProperties();
            }
            Profile prof = this.dman.getProfile(this.rid);
            Set<Report> reports = prof.getScheduledReports();
            for (Report rep : reports) {
                String mode = rep.getMode();
                DataFetcher df = this.dman.getFetcher(this.rid + "-" + mode);
                LOGGER.log(Level.INFO, "Schedule is being executed for rid {0}", this.rid);
                String[][] result = null;
                try {
                    result = df.execReport(rep);
                }
                catch (FetcherException fe) {
                    this.insertZeroValues();
                    LOGGER.log(Level.INFO, " FetcherException while executing the schedule, so I insert ZERO values in Live_Report_Hr table for all interfaces {0}", fe.getMessage());
                    throw fe;
                }
                Level level = LOGGER.getLevel();
                if (level != null && !level.equals(Level.INFO)) {
                    this.dman.printThreadPool();
                    for (int i = 0; i < result.length; ++i) {
                        String[] t = result[i];
                        for (int j = 0; j < result[i].length; ++j) {
                            LOGGER.log(Level.INFO, " {0} {1} {2}", new Object[]{i, j, t[j]});
                        }
                    }
                }
                if (!"LiveReports".equals(rep.getName())) continue;
                this.storeLiveRep(rep, result);
                LOGGER.log(Level.FINER, "Result is {0} {1} matrix", new Object[]{result.length, result[0].length});
            }
        }
        catch (FetcherException fe) {
            LOGGER.log(Level.INFO, " FetcherException in DeviceManager scheduler for rid {0} {1}", new Object[]{this.rid, fe.getMessage()});
            fe.printStackTrace();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception in DeviceManager scheduler for rid {0} ", this.rid);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLiveRep(Report rep, String[][] result) {
        int version = 1;
        if ("snmp".equals(rep.getMode())) {
            version = ((SnmpReport)rep).getVersion();
        }
        long devInBytes = 0L;
        long devOutBytes = 0L;
        long ifInByteCnt = 0L;
        long ifOutByteCnt = 0L;
        Long ifPrevInCnt = null;
        Long ifPrevOutCnt = null;
        int duration = this.interval * 60;
        long currentTime = System.currentTimeMillis();
        boolean isWANCntReset = false;
        if (this.recordTime > 0L) {
            duration = (int)((currentTime - this.recordTime) / 1000L);
        }
        this.recordTime = currentTime;
        long roundOff = 60000L - currentTime % 60000L;
        Timestamp hour = new Timestamp(currentTime + roundOff);
        int colCount = version == 0 ? result.length : result[0].length;
        int[] ifIndexCol = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            ifIndexCol[i] = version == 0 ? Integer.parseInt(result[i][0]) : Integer.parseInt(result[0][i]);
        }
        DataObject dObj = null;
        try {
            dObj = DataAccess.constructDataObject();
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while constructing DataObject {0}", dae.getMessage());
            dae.printStackTrace();
            return;
        }
        for (Long ifInd : this.interfaceVsOidInstances.keySet()) {
            long bps = 0L;
            long bpsOut = 0L;
            long bpsIn = 0L;
            long ifTotBytes = 0L;
            long ifOutBytes = 0L;
            long ifInBytes = 0L;
            ifOutByteCnt = 0L;
            ifInByteCnt = 0L;
            Row row = new Row("Live_Report_Hr");
            row.set("RID", (Object)this.rid);
            row.set("HOUR", (Object)hour);
            row.set("IF_IND", (Object)ifInd);
            ifPrevInCnt = this.ifInMap.get(ifInd);
            ifPrevOutCnt = this.ifOutMap.get(ifInd);
            int[] instances = this.interfaceVsOidInstances.get(ifInd);
            try {
                for (int instance : instances) {
                    int i = Arrays.binarySearch(ifIndexCol, instance);
                    if (i <= -1) continue;
                    if (version != 0) {
                        ifInByteCnt += Long.parseLong(result[1][i]);
                        ifOutByteCnt += Long.parseLong(result[2][i]);
                        continue;
                    }
                    ifInByteCnt += Long.parseLong(result[i][1]);
                    ifOutByteCnt += Long.parseLong(result[i][2]);
                }
                LOGGER.log(Level.FINER, "{0} {1} {2} ", new Object[]{this.rid, hour, ifInd});
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "NumberFormatException while parsing ifInOct and ifOutOct in scheduler {0}", e.getMessage());
                e.printStackTrace();
                continue;
            }
            this.ifInMap.put(ifInd, ifInByteCnt);
            this.ifOutMap.put(ifInd, ifOutByteCnt);
            if (ifPrevInCnt == null || ifPrevOutCnt == null) {
                LOGGER.log(Level.FINER, " Skipping insert this time for IF_INDEX {0} , but storing value {1} {2} ", new Object[]{ifInd, ifInByteCnt, ifOutByteCnt});
                continue;
            }
            ifInBytes = ifInByteCnt - ifPrevInCnt;
            ifOutBytes = ifOutByteCnt - ifPrevOutCnt;
            ifTotBytes = ifInBytes + ifOutBytes;
            bpsIn = ifInBytes * 8L / (long)duration;
            bpsOut = ifOutBytes * 8L / (long)duration;
            bps = bpsIn + bpsOut;
            if (ifInBytes < 0L || ifOutBytes < 0L) {
                if (this.wanIfIndex.contains(ifInd)) {
                    isWANCntReset = true;
                }
                String msg = ifInBytes < 0L ? "ifInOctet has been reset" : "ifOutOctet has been reset";
                LOGGER.log(Level.WARNING, " {0} for rid {1}, so I skipped inserting data into Live_Report_Hr for ifIndex {2} and 0", new Object[]{msg, this.rid, ifInd});
                continue;
            }
            row.set("DURATION", (Object)duration);
            row.set("BYTES_INBOUND", (Object)ifInBytes);
            row.set("BYTES_OUTBOUND", (Object)ifOutBytes);
            row.set("TOTAL_BYTES", (Object)ifTotBytes);
            row.set("BPS_IN", (Object)bpsIn);
            row.set("BPS_OUT", (Object)bpsOut);
            row.set("BPS", (Object)bps);
            try {
                dObj.addRow(row);
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "DataAccessException while adding a Row Object of 'Live_Report_Hr' into DataObject {0} ", dae.getMessage());
                dae.printStackTrace();
                try {
                    dObj.deleteRow(row);
                }
                catch (DataAccessException dae1) {
                    dae1.printStackTrace();
                }
            }
            HashMap<String, Object> bwAlert = new HashMap<String, Object>();
            bwAlert.put("RESOURCENAME", this.resName);
            bwAlert.put("RESOURCE", this.resName);
            bwAlert.put("IF_INDEX", ifInd);
            bwAlert.put("IF_NAME", this.interfaceIdMap.get(ifInd));
            bwAlert.put("BPS_IN", bpsIn);
            bwAlert.put("BPS_OUT", bpsOut);
            bwAlert.put("BPS", bps);
            double[] speed = this.ifSpeedMap.get(ifInd);
            long bps_in_perc = (long)((double)(bpsIn * 100L) / (speed[1] * 1024.0));
            long bps_out_perc = (long)((double)(bpsOut * 100L) / (speed[0] * 1024.0));
            long bps_perc = (long)((double)(bps * 100L) / ((speed[0] + speed[1]) * 1024.0));
            bwAlert.put("BPS_IN_PERC", bps_in_perc);
            bwAlert.put("BPS_OUT_PERC", bps_out_perc);
            bwAlert.put("BPS_PERC", bps_perc);
            LOGGER.log(Level.FINER, "bwAlert {0} ", ((Object)bwAlert).toString());
            try {
                NotificationEngine.getInstance().publish(bwAlert, 1);
            }
            catch (NotifierException ne) {
                ne.printStackTrace();
            }
            if (!this.wanIfIndex.contains(ifInd)) continue;
            devInBytes += ifInBytes;
            devOutBytes += ifOutBytes;
        }
        if (!isWANCntReset) {
            Row devrow = new Row("Live_Report_Hr");
            devrow.set("RID", (Object)this.rid);
            devrow.set("HOUR", (Object)hour);
            devrow.set("DURATION", (Object)duration);
            devrow.set("IF_IND", (Object)0L);
            devrow.set("BYTES_INBOUND", (Object)devInBytes);
            devrow.set("BYTES_OUTBOUND", (Object)devOutBytes);
            devrow.set("TOTAL_BYTES", (Object)(devInBytes + devOutBytes));
            devrow.set("BPS_IN", (Object)(devInBytes * 8L / (long)duration));
            devrow.set("BPS_OUT", (Object)(devOutBytes * 8L / (long)duration));
            devrow.set("BPS", (Object)((devInBytes + devOutBytes) * 8L / (long)duration));
            try {
                dObj.addRow(devrow);
                LOGGER.log(Level.FINER, "{0} {1} 0 ", new Object[]{this.rid, hour});
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "Exception while adding device specific row into Live_Report_Hr");
                dae.printStackTrace();
            }
        }
        if (this.dataObject == null) {
            try {
                DataAccess.add((DataObject)dObj);
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "DataAccessException while storing data into DB, Will try to insert this DataObject in the next cycle {0} ", dae.getMessage());
                LOGGER.log(Level.INFO, "DataObject that I tried to Insert is {0}", dObj);
                dae.printStackTrace();
                this.dataObject = dObj;
                return;
            }
        }
        try {
            this.dataObject.append(dObj);
            DataAccess.add((DataObject)this.dataObject);
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "Consecutive DataAccessException while storing data into DB, so dropping the DataObject {0} ", dae.getMessage());
            LOGGER.log(Level.INFO, "DataObject that I tried to Insert is {0}", this.dataObject);
            dae.printStackTrace();
            return;
        }
        finally {
            this.dataObject = null;
        }
        if (this.runHourlyTask && hour.getMinutes() % 5 == 0) {
            this.runHourlyTask = false;
            PacketUtil.executeTaskGroups(new String[]{"ConfigurationTablePopulator-4"});
        }
    }

    private void insertZeroValues() {
        DataObject dObj = null;
        long currentTime = System.currentTimeMillis();
        long roundOff = 60000L - currentTime % 60000L;
        Timestamp hour = new Timestamp(currentTime + roundOff);
        int duration = this.interval * 60;
        try {
            dObj = DataAccess.constructDataObject();
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "Exception while adding device specific row into Live_Report_Hr");
            dae.printStackTrace();
        }
        Row row = new Row("Live_Report_Hr");
        row.set("RID", (Object)this.rid);
        row.set("HOUR", (Object)hour);
        row.set("DURATION", (Object)duration);
        row.set("BYTES_INBOUND", (Object)0L);
        row.set("BYTES_OUTBOUND", (Object)0L);
        row.set("TOTAL_BYTES", (Object)0L);
        row.set("BPS_IN", (Object)0L);
        row.set("BPS_OUT", (Object)0L);
        row.set("BPS", (Object)0L);
        for (Long ifInd : this.interfaceVsOidInstances.keySet()) {
            Row temp = (Row)row.clone();
            temp.set("IF_IND", (Object)ifInd);
            try {
                dObj.addRow(temp);
                LOGGER.log(Level.FINER, "{0} {1} {2} ", new Object[]{this.rid, hour, ifInd});
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "DataAccessException while adding ZERO value row into DataObject for RID {0} IF_INDEX {1}", new Object[]{this.rid, ifInd});
                dae.printStackTrace();
            }
        }
        Row temp = (Row)row.clone();
        temp.set("IF_IND", (Object)0L);
        try {
            dObj.addRow(temp);
            LOGGER.log(Level.FINER, "{0} {1} 0 ", new Object[]{this.rid, hour});
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while adding ZERO value row into DataObject for RID {0} IF_INDEX {1}", new Object[]{this.rid, 0L});
            dae.printStackTrace();
        }
        try {
            DataAccess.add((DataObject)dObj);
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while storing ZERO value data into DB for RID {0}", this.rid);
            dae.printStackTrace();
        }
    }

    private void populateInterfaces() throws FetcherException {
        SnmpFetcher sf = (SnmpFetcher)this.dman.getFetcher(this.rid + "-snmp");
        Profile prof = this.dman.getProfile(this.rid);
        Report rep = prof.getReport("LiveReports");
        String ifSpeedOid = rep.getProperty("ifSpeed");
        String zoneIndexOid = this.isZoneBased ? rep.getProperty("zoneIndexOid") : rep.getProperty("ifIndexOid");
        String zoneNameOid = this.isZoneBased ? rep.getProperty("zoneNameOid") : rep.getProperty("ifNameOid");
        String[][] ipAddrTable = null;
        String[][] ifSpeed_InIfTable = null;
        String[][] IfIdVsZoneId = null;
        String[][] zoneIdVsZoneName = sf.getTableOid(new String[]{zoneIndexOid, zoneNameOid});
        this.processZoneNames(zoneIdVsZoneName);
        HashMap<Integer, Integer> interfaceIdVsZoneId = new HashMap<Integer, Integer>();
        if (this.isZoneBased) {
            for (String[] temp1 : IfIdVsZoneId = sf.getTableOid(new String[]{rep.getProperty("ifIndexOid"), rep.getProperty("ifZoneOid")})) {
                interfaceIdVsZoneId.put(Integer.valueOf(temp1[0]), Integer.valueOf(temp1[1]));
            }
        }
        if (ifSpeedOid != null) {
            try {
                ifSpeed_InIfTable = sf.getTableOid(new String[]{zoneIndexOid, ifSpeedOid});
            }
            catch (FetcherException fe) {
                LOGGER.log(Level.INFO, "FetcherException while getting data from RFC1213-MIB.ifTable {0}", fe.getMessage());
                throw fe;
            }
        }
        String ipTableIndex = rep.getProperty("ipAdEntIfIndex");
        String ipTableAddr = rep.getProperty("ipAdEntAddr");
        String ipTableMask = rep.getProperty("ipAdEntNetMask");
        try {
            ipAddrTable = sf.getTableOid(new String[]{ipTableIndex, ipTableAddr, ipTableMask});
        }
        catch (FetcherException fe) {
            LOGGER.log(Level.INFO, "FetcherException while getting data from RFC1213-MIB.ipAddrTable {0}", fe.getMessage());
            throw fe;
        }
        for (String[] temp : zoneIdVsZoneName) {
            String zoneName = temp[1];
            int zoneId = Integer.parseInt(temp[0]);
            Long if_index = this.interfaceInfoMap.get(zoneName);
            if (if_index == null && (if_index = this.addNewInterface(zoneName, ifSpeed_InIfTable, ipAddrTable, zoneId, interfaceIdVsZoneId)) == null) {
                LOGGER.log(Level.INFO, "The interface {0} is not added as this should be a switchPort", zoneName);
                continue;
            }
            if (this.isZoneBased) {
                int[] arr = new int[15];
                int count = 0;
                Set keySet = interfaceIdVsZoneId.keySet();
                for (Integer entry : keySet) {
                    if (!((Integer)interfaceIdVsZoneId.get(entry)).equals(zoneId)) continue;
                    arr[count++] = entry;
                }
                int[] interfaces = new int[count];
                System.arraycopy(arr, 0, interfaces, 0, count);
                this.interfaceVsOidInstances.put(if_index, interfaces);
                continue;
            }
            this.interfaceVsOidInstances.put(if_index, new int[]{zoneId});
        }
        if (this.updateInterfaceInfo) {
            this.updateInterfaceInfo = false;
            this.updateInterfaceInfo(interfaceIdVsZoneId, zoneIdVsZoneName, ipAddrTable, ifSpeed_InIfTable);
        }
        this.findWANInterfaces(this.interfaceInfoMap);
    }

    private void populateIfSpeedMap() {
        double[] speed;
        DataObject dObj;
        SelectQueryImpl sel = new SelectQueryImpl(new Table("InterfaceInfo"));
        sel.addSelectColumn(new Column("InterfaceInfo", "*"));
        Criteria crit = new Criteria(new Column("InterfaceInfo", "RID"), (Object)this.rid, 0);
        sel.setCriteria(crit);
        Iterator iter = null;
        try {
            dObj = DataAccess.get((SelectQuery)sel);
            iter = dObj.getRows("InterfaceInfo");
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while fetching data from InterfaceInfo");
            dae.printStackTrace();
            return;
        }
        while (iter.hasNext()) {
            Row r = (Row)iter.next();
            Long if_index = (Long)r.get("IF_INDEX");
            speed = new double[]{((Float)r.get("IF_UPLINK_SPEED")).floatValue(), ((Float)r.get("IF_DOWNLINK_SPEED")).floatValue()};
            this.ifSpeedMap.put(if_index, speed);
        }
        sel = new SelectQueryImpl(new Table("Resources"));
        sel.addSelectColumn(new Column("Resources", "*"));
        crit = new Criteria(new Column("Resources", "RESOURCEID"), (Object)this.rid, 0);
        sel.setCriteria(crit);
        try {
            dObj = DataAccess.get((SelectQuery)sel);
            Row r = dObj.getFirstRow("Resources");
            speed = new double[]{((Float)r.get("BANDWIDTH")).floatValue(), ((Float)r.get("UP_LINK_SPEED")).floatValue()};
            this.ifSpeedMap.put(0L, speed);
        }
        catch (DataAccessException dae) {
            LOGGER.log(Level.INFO, "DataAccessException while fetching data from Resources");
            dae.printStackTrace();
            return;
        }
    }

    private Long addNewInterface(String zoneName, String[][] ifSpeed_InIfTable, String[][] ipAddrTable, int zoneId, Map<Integer, Integer> interfaceIdVsZoneId) {
        int i;
        String ifIP = "";
        String ifMask = "";
        String speed = "1048576";
        Long if_index = null;
        if (ifSpeed_InIfTable != null) {
            for (i = 0; i < ifSpeed_InIfTable.length; ++i) {
                try {
                    if (Integer.parseInt(ifSpeed_InIfTable[i][0]) != zoneId) continue;
                    speed = ifSpeed_InIfTable[i][1];
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.INFO, "NumberFormatException while finding ifSpeed for interface/zone {0}", zoneName);
                }
            }
        }
        if (ipAddrTable != null) {
            for (i = 0; i < ipAddrTable.length; ++i) {
                String ip;
                long l;
                int zoneIdFromIPTable;
                int n = zoneIdFromIPTable = this.isZoneBased ? interfaceIdVsZoneId.get(Integer.valueOf(ipAddrTable[i][0])) : Integer.parseInt(ipAddrTable[i][0]);
                if (zoneIdFromIPTable != zoneId || (l = IPRange.getAddrLong((String)(ip = ipAddrTable[i][1]))) == 0L) continue;
                ifIP = ifIP + "," + ip;
                ifMask = ifMask + "," + ipAddrTable[i][2];
                break;
            }
            if (ifMask.length() > 1) {
                ifMask = ifMask.substring(1);
            }
            if (ifIP.length() > 1) {
                ifIP = ifIP.substring(1);
                try {
                    if_index = FACacheManager.getInstance().addNewInterface(this.rid, zoneName, ifIP, speed, ifMask);
                    this.interfaceInfoMap.put(zoneName, if_index);
                    this.interfaceIdMap.put(if_index, zoneName);
                }
                catch (DataAccessException dae) {
                    dae.printStackTrace();
                }
            }
        }
        return if_index;
    }

    private void findWANInterfaces(Map<String, Long> interfaceInfoMap) {
        Long if_index;
        Row r;
        SelectQueryImpl sel = new SelectQueryImpl(new Table("InterfaceInfo"));
        sel.addSelectColumn(new Column("InterfaceInfo", "*"));
        Criteria resCrit = new Criteria(new Column("InterfaceInfo", "RID"), (Object)this.rid, 0);
        sel.setCriteria(resCrit);
        DataObject dObj = null;
        Iterator iter = null;
        try {
            dObj = DataAccess.get((SelectQuery)sel);
            iter = dObj.getRows("InterfaceInfo");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return;
        }
        if (DepartmentUtil.isDeptAdded()) {
            while (iter.hasNext()) {
                r = (Row)iter.next();
                if_index = (Long)r.get("IF_INDEX");
                String addr = (String)r.get("IF_IP");
                String[] addrs = addr.split(",");
                boolean isInternal = false;
                for (String ip : addrs) {
                    isInternal = DepartmentUtil.isInIntranetRange((Object)this.rid, (String)ip);
                    if (isInternal) continue;
                    this.wanIfIndex.add(if_index);
                    break;
                }
                LOGGER.log(Level.FINER, "Rid {0} IF_INDEX {1} addr {2} isInternal {3}", new Object[]{this.rid, if_index, addr, isInternal});
            }
        }
        if (this.wanIfIndex.isEmpty()) {
            try {
                iter = dObj.getRows("InterfaceInfo");
            }
            catch (DataAccessException dae) {
                dae.printStackTrace();
                return;
            }
            while (iter.hasNext()) {
                r = (Row)iter.next();
                if_index = (Long)r.get("IF_INDEX");
                this.wanIfIndex.add(if_index);
            }
        }
    }

    private void updateInterfaceInfo(Map<Integer, Integer> interfaceIdVsZoneId, String[][] zoneIdVsZoneName, String[][] ipAddrTable, String[][] ifSpeed_InIfTable) {
        int[] ipTableIndexes = new int[ipAddrTable.length];
        int count = 0;
        for (String[] entry : ipAddrTable) {
            ipTableIndexes[count++] = Integer.parseInt(entry[0]);
        }
        int[] ifSpeedIndexes = null;
        if (ifSpeed_InIfTable != null) {
            count = 0;
            ifSpeedIndexes = new int[ifSpeed_InIfTable.length];
            for (String[] entry : ifSpeed_InIfTable) {
                ifSpeedIndexes[count++] = Integer.parseInt(entry[0]);
            }
        }
        double devSpeed = 0.0;
        for (Long if_Index : this.interfaceVsOidInstances.keySet()) {
            int[] instances = this.interfaceVsOidInstances.get(if_Index);
            String ifIP = "";
            String ifMask = "";
            String ifName = "";
            int ipTableIndex = -1;
            long ifSpeed = 0L;
            for (int instance : instances) {
                int ifSpeedIndex;
                String ipAddress;
                long l;
                ipTableIndex = Arrays.binarySearch(ipTableIndexes, instance);
                if (ipTableIndex >= 0 && (l = IPRange.getAddrLong((String)(ipAddress = ipAddrTable[ipTableIndex][1]))) != 0L) {
                    ifIP = ifIP + "," + ipAddrTable[ipTableIndex][1];
                    ifMask = ifMask + "," + ipAddrTable[ipTableIndex][2];
                }
                if (ifSpeedIndexes == null || (ifSpeedIndex = Arrays.binarySearch(ifSpeedIndexes, instance)) < 0) continue;
                ifSpeed += Long.parseLong(ifSpeed_InIfTable[ifSpeedIndex][1]);
            }
            if (ipTableIndex >= 0) {
                int zoneId = this.isZoneBased ? interfaceIdVsZoneId.get(Integer.valueOf(ipAddrTable[ipTableIndex][0])) : Integer.parseInt(ipAddrTable[ipTableIndex][0]);
                for (String[] entry : zoneIdVsZoneName) {
                    if (zoneId != Integer.parseInt(entry[0])) continue;
                    ifName = entry[1];
                }
            }
            if (ifMask.length() > 1) {
                ifMask = ifMask.substring(1);
            }
            if (ifIP.length() > 1) {
                ifIP = ifIP.substring(1);
                FACacheManager.getInstance().updateInterfaceDetails(null, this.rid.toString(), ifName, ifSpeed + "", ifSpeed + "", ifIP, ifMask);
            }
            if (!this.wanIfIndex.contains(if_Index)) continue;
            devSpeed += (double)ifSpeed;
        }
        if (devSpeed > 0.0) {
            UpdateQueryImpl uquery = new UpdateQueryImpl("Resources");
            Criteria crt = new Criteria(new Column("Resources", "RESOURCEID"), (Object)this.rid, 0);
            uquery.setCriteria(crt);
            uquery.setUpdateColumn("BANDWIDTH", (Object)devSpeed);
            uquery.setUpdateColumn("UP_LINK_SPEED", (Object)devSpeed);
            LOGGER.log(Level.INFO, " Updating Resources table for rid {0} UP_LINK_SPEED {1} DOWN_LINK_SPEED {2}", new Object[]{this.rid, devSpeed, devSpeed});
            try {
                DataAccess.update((UpdateQuery)uquery);
            }
            catch (DataAccessException dae) {
                LOGGER.log(Level.INFO, "DataAccessException while updating Resources.UP_LINK_SPEED {0}  Resources.BANDWIDTH {1} for rid {3}", new Object[]{devSpeed, devSpeed, this.rid});
                dae.printStackTrace();
            }
        }
    }

    private void processZoneNames(String[][] zoneIdVsZoneName) {
        for (int i = 0; i < zoneIdVsZoneName.length; ++i) {
            zoneIdVsZoneName[i][1] = this.getIfName(zoneIdVsZoneName[i][1]);
        }
    }

    private String getIfName(String ifDesc) {
        if (ifDesc.indexOf("'") > 0) {
            ifDesc = ifDesc.substring(ifDesc.indexOf("'") + 1, ifDesc.lastIndexOf("'"));
        }
        if (ifDesc.indexOf("(") > 0) {
            ifDesc = ifDesc.substring(0, ifDesc.indexOf("(") - 1).trim();
        }
        return ifDesc;
    }

    private void printAllProperties() {
        LOGGER.log(Level.INFO, "RID {0} interfaceVsOidInstances -- InterfaceInfo.IF_INDEX and their mapping to IF-MIB.ifIndex", this.rid);
        for (Long l : this.interfaceVsOidInstances.keySet()) {
            LOGGER.log(Level.INFO, " InterfaceInfo.IF_INDEX {0} is mapped to instances {1}", new Object[]{l, Arrays.toString(this.interfaceVsOidInstances.get(l))});
        }
        LOGGER.log(Level.INFO, "RID {0} wanIfIndex List  -- id's of Outside Interface as in InterfaceInfo", this.rid);
        for (Long l : this.wanIfIndex) {
            LOGGER.log(Level.INFO, " {0} ", l);
        }
    }
}

