/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dataCollection;

import com.adventnet.fa.server.dataCollection.DataFetcher;
import com.adventnet.fa.server.dataCollection.FetcherException;
import com.adventnet.fa.server.dataCollection.Report;
import com.adventnet.fa.server.dataCollection.SnmpReport;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.persistence.Row;
import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpEngineEntry;
import com.adventnet.snmp.snmp2.SnmpEngineTable;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.snmp.snmp2.usm.USMUserTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SnmpFetcher
extends DataFetcher {
    private static final Logger LOGGER = Logger.getLogger(SnmpFetcher.class.getName());
    private static final String DEFAULT_MIB = System.getProperty("server.home") + File.separator + "server" + File.separator + "mibs" + File.separator + "RFC1213-MIB";
    private int def_max_repetition = 9;
    private SnmpTarget target = new SnmpTarget();
    private int version = 0;

    public SnmpFetcher(String remoteHost, int version, String comm, long port, String mibs) {
        super("snmp");
        if (Boolean.getBoolean("DEBUG")) {
            this.target.setDebug(true);
        }
        try {
            this.def_max_repetition = Integer.parseInt(System.getProperty("MAX_SNMP_PDU", "9"));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            this.def_max_repetition = 9;
        }
        this.target.setLoadFromCompiledMibs(true);
        this.target.setTargetHost(remoteHost);
        this.target.setTargetPort((int)port);
        this.version = version;
        if (version == 1) {
            this.target.setCommunity(comm);
            this.target.setSnmpVersion(1);
        } else if (version == 3) {
            this.target.setSnmpVersion(3);
        } else {
            this.target.setCommunity(comm);
            this.target.setSnmpVersion(0);
        }
        try {
            this.target.loadMibs(DEFAULT_MIB);
            if (Boolean.getBoolean("DEBUG")) {
                LOGGER.log(Level.INFO, "Loading default MIB {0}", DEFAULT_MIB);
            }
            if (mibs != null) {
                if (Boolean.getBoolean("DEBUG")) {
                    LOGGER.log(Level.INFO, "Loading MIBs {0}", mibs);
                }
                this.target.loadMibs(mibs);
            }
        }
        catch (FileNotFoundException fnf) {
            LOGGER.log(Level.INFO, "IMPORTANT:::::: Mib file is not found {0}", DEFAULT_MIB);
            fnf.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getRepetition(SnmpReport rep) throws FetcherException {
        String dynamicRepetition = rep.getProperty("dynamicRepetitionOid");
        if (dynamicRepetition != null) {
            return Integer.parseInt(this.getScalarOid(dynamicRepetition));
        }
        int repetition = rep.getRepetition();
        if (repetition == -1 && rep.getProperty("staticRepetitionOid") != null) {
            String staticRepetition = rep.getProperty("staticRepetitionOid");
            repetition = Integer.parseInt(this.getScalarOid(staticRepetition));
            rep.setRepetition(repetition);
        }
        return repetition;
    }

    void setV3Params(Row snmpv3) throws Exception {
        String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
        HashMap cons = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"firewall");
        String driver = (String)cons.get("DBDriver");
        String dbURL = (String)cons.get("DBUrl");
        String userName = (String)cons.get("DBUser");
        String pwd = (String)cons.get("DBPass");
        this.target.setV3DatabaseFlag(true);
        this.target.initJdbcParams(driver, dbURL, userName, pwd);
        String uname = (String)snmpv3.get("UNAME");
        this.target.setPrincipal(uname);
        String ctxName = (String)snmpv3.get("CONTEXT_NAME");
        if (ctxName != null) {
            this.target.setContextName(ctxName);
        }
        this.target.validateUser(true);
        Integer authProto = (Integer)snmpv3.get("AUTH_PROTOCOL");
        this.target.setAuthProtocol(authProto.intValue());
        if (authProto != 20) {
            this.target.setAuthPassword((String)snmpv3.get("AUTH_PASSWORD"));
        }
        Integer privProto = (Integer)snmpv3.get("ENCRYPT_PROTOCOL");
        this.target.setPrivProtocol(privProto.intValue());
        if (privProto != 51) {
            this.target.setPrivPassword((String)snmpv3.get("ENCRYPT_PASSWORD"));
        }
        int securityLevel = 0;
        if (authProto == 20 && privProto == 51) {
            securityLevel = 0;
        } else if (authProto != 20 && privProto == 51) {
            securityLevel = 1;
        } else if (authProto != 20 && privProto != 51) {
            securityLevel = 3;
        }
        this.target.setSecurityLevel((byte)securityLevel);
        int res = this.target.create_v3_tables();
        LOGGER.log(Level.INFO, "Create V3 Tables status code {0}", res);
    }

    @Override
    public void close() {
        int port;
        String addr;
        SnmpEngineTable engine;
        SnmpEngineEntry engineEntry;
        if (this.version == 3 && (engineEntry = (engine = this.target.getSnmpEngineTable()).getEntry(addr = this.target.getTargetHost(), port = this.target.getTargetPort())) != null) {
            byte[] engineID = engineEntry.getEngineID();
            engine.removeEntry(addr, port);
            byte[] username = this.target.getPrincipal().getBytes();
            USMUserTable usm = this.target.getUSMTable();
            boolean res = usm.removeEntry(username, engineID);
        }
        this.target.releaseResources();
    }

    public void loadMibs(String mibs) {
        try {
            this.target.loadMibs(mibs);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while loading MIB file {0}", e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized String getScalarOid(String oid) throws FetcherException {
        String errString;
        this.target.setObjectID(oid);
        String var = this.target.snmpGet();
        if (var == null) {
            throw new FetcherException(this.target.getErrorString());
        }
        if (this.version != 0 && (errString = this.getErrForIncompleteReq()) != null) {
            throw new FetcherException(errString);
        }
        return var;
    }

    public synchronized String[][] getTableOid(String[] oids) throws FetcherException {
        String errString;
        this.target.setObjectIDList(oids);
        String[][] res = this.target.snmpGetAllList();
        if (res == null) {
            throw new FetcherException(this.target.getErrorString());
        }
        if (this.version != 0 && (errString = this.getErrForIncompleteReq()) != null) {
            throw new FetcherException(errString);
        }
        return res;
    }

    @Override
    public synchronized String[][] execReport(Report temp) throws FetcherException {
        String errString;
        SnmpReport rep = (SnmpReport)temp;
        String[][] result = null;
        String[] oids = rep.getOids();
        if (this.version != 0) {
            result = this.customizedGetTable(rep);
            LOGGER.log(Level.FINER, "SNMP Repetition is set to {0}", rep.getRepetition());
        } else {
            this.target.setObjectIDList(oids);
            result = this.target.snmpGetAllList();
        }
        if (result == null) {
            throw new FetcherException(this.target.getErrorString());
        }
        if (this.version != 0 && (errString = this.getErrForIncompleteReq()) != null) {
            throw new FetcherException(errString);
        }
        return result;
    }

    private String[][] customizedGetTable(SnmpReport rep) throws FetcherException {
        String[] oids = rep.getOids();
        MibOperations mibOps = this.target.getMibOperations();
        MibModule module = mibOps.getMibModule(rep.getMib());
        int repetition = this.getRepetition(rep);
        String[][] result = new String[oids.length][];
        int counter = 0;
        for (String oid : oids) {
            MibNode node = module.getMibNode(oid);
            if (node.getAccess() == 0) {
                result[counter] = this.getNAColumn(node, repetition);
            } else {
                SnmpVarBind[] varBindArr = this.getTableColumn(node, repetition);
                String[] temp = new String[varBindArr.length];
                int count = 0;
                for (SnmpVarBind varBind : varBindArr) {
                    SnmpVar temp_var = varBind.getVariable();
                    SnmpOID temp_oid = varBind.getObjectID();
                    temp[count++] = mibOps.toString(temp_var, temp_oid);
                }
                result[counter] = temp;
            }
            if (repetition == -1) {
                repetition = result[counter].length;
                LOGGER.log(Level.FINER, "Repetition calculated in customizedGetTable() is {0} ", repetition);
            }
            ++counter;
        }
        return result;
    }

    private String[] getNAColumn(MibNode node, int repetition) throws FetcherException {
        byte type = node.getSyntax().getType();
        if (type != 4) {
            return null;
        }
        String[] result = null;
        int[] origOid = node.getOID();
        while (node.getAccess() == 0) {
            node = node.getNextLeafNode();
        }
        SnmpVarBind[] varBindArr = this.getTableColumn(node, repetition);
        result = new String[varBindArr.length];
        int counter = 0;
        for (SnmpVarBind varBind : varBindArr) {
            int[] oid = varBind.getObjectID().toIntArray();
            if (oid.length <= origOid.length) {
                result[counter++] = "null";
                continue;
            }
            int naOidLen = oid[origOid.length];
            String oidVal = new String(oid, origOid.length + 1, naOidLen);
            result[counter++] = oidVal;
        }
        return result;
    }

    private SnmpVarBind[] getTableColumn(MibNode node, int repetition) throws FetcherException {
        int counter;
        int max;
        String oid;
        String originateOid = oid = node.getNumberedOIDString();
        ArrayList<SnmpVarBind> res = new ArrayList<SnmpVarBind>();
        byte oidType = node.getSyntax().getType();
        int n = max = oidType == 2 || oidType == 65 ? this.def_max_repetition * 2 : this.def_max_repetition;
        if (repetition != -1 && repetition < max) {
            this.target.setMaxRepetitions(repetition);
        } else {
            this.target.setMaxRepetitions(max);
        }
        do {
            SnmpVar v;
            SnmpVarBind varBind;
            SnmpOID tempOid;
            this.target.setObjectIDList(new String[]{originateOid});
            SnmpOID baseOid = new SnmpOID(oid);
            SnmpVarBind[][] temp = this.target.snmpGetBulkVariableBindings();
            SnmpVarBind[] result = null;
            String errString = null;
            if (this.version != 0) {
                errString = this.getErrForIncompleteReq();
            }
            if (temp == null || errString != null) {
                throw new FetcherException(errString);
            }
            result = temp[0];
            counter = 0;
            SnmpVarBind[] arr$ = result;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && SnmpTarget.isInSubTree((SnmpOID)baseOid, (SnmpOID)(tempOid = (varBind = arr$[i$]).getObjectID())) && (this.version != 1 || (v = varBind.getVariable()).getError() != -126); ++i$) {
                res.add(varBind);
                originateOid = tempOid.toString();
                ++counter;
            }
        } while (counter == max);
        SnmpVarBind[] result = new SnmpVarBind[res.size()];
        res.toArray(result);
        return result;
    }

    private String getErrForIncompleteReq() {
        String err = null;
        if (this.target.getErrorCode() != 0) {
            err = "Error ::: " + this.target.getErrorString();
        } else if (this.target.getExceptionCode() != 0) {
            err = "Exception ::: " + SnmpException.exceptionString((byte)((byte)this.target.getExceptionCode()));
        }
        return err;
    }

    public static boolean testNow(String remoteHost, int port, String comm, Map v3Map) {
        LOGGER.log(Level.FINER, " V3 Map {0}", v3Map);
        String sysDescrOid = ".1.3.6.1.2.1.1.1.0";
        SnmpTarget target = new SnmpTarget();
        if (Boolean.getBoolean("DEBUG")) {
            target.setDebug(true);
        }
        target.setLoadFromCompiledMibs(true);
        target.setTargetHost(remoteHost);
        target.setTargetPort(port);
        target.setCommunity(comm);
        if ("v2".equals(v3Map.get("version"))) {
            target.setSnmpVersion(1);
        } else if ("v3".equals(v3Map.get("version"))) {
            target.setSnmpVersion(3);
            target.setPrincipal((String)v3Map.get("userName"));
            target.setContextName((String)v3Map.get("ctxName"));
            Integer authProto = (Integer)v3Map.get("authProto");
            Integer encProto = (Integer)v3Map.get("encProto");
            target.setAuthProtocol(authProto.intValue());
            target.setAuthPassword((String)v3Map.get("authPwd"));
            target.setPrivProtocol(encProto.intValue());
            target.setPrivPassword((String)v3Map.get("encPwd"));
            if (authProto == 20 && encProto == 51) {
                target.setSecurityLevel((byte)0);
            } else if (authProto != 20 && encProto == 51) {
                target.setSecurityLevel((byte)1);
            } else if (authProto != 20 && encProto != 51) {
                target.setSecurityLevel((byte)3);
            }
            int code = target.create_v3_tables();
        } else {
            target.setSnmpVersion(0);
        }
        try {
            target.loadMibs(DEFAULT_MIB);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to load RFC1213-MIB");
            e.printStackTrace();
            return false;
        }
        target.setObjectID(sysDescrOid);
        String var = target.snmpGet();
        if (var == null) {
            LOGGER.log(Level.INFO, "Unable to get response from {0} for sysDescr. Err is {1}", new Object[]{remoteHost, target.getErrorString()});
            return false;
        }
        return true;
    }

    public SnmpTarget getTarget() {
        return this.target;
    }
}

