/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.logging.Logger;

public class BarracudaUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(BarracudaUnifier.class.getName());
    private static final Integer TYPE = new Integer(36);

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String resource = (String)data.get("FW");
        data.put("FW_TYPE", "Barracuda");
        data.put("LOG_FORMAT", "Barracuda");
        data.put("RECORD_TYPE", "Traffic");
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        this.handleTime(data);
        this.handlePriority(data);
        this.localEmptyHandle(data);
        String status = (String)data.get("STATUS");
        if ("Allow".equals(status)) {
            return null;
        }
        this.handleStatus(data, status);
        this.checkProtocolSyntax(data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "BYTES", "DURATION", "SENT_PKT", "RECEIVED_PKT", "STATUS_CODE"};
        this.strToLong(strToLong, data);
        return data;
    }

    private void localEmptyHandle(Hashtable data) {
        if ("".equals((String)data.get("RULE"))) {
            data.put("RULE", "default");
        }
        if ("".equals((String)data.get("SRC_INTERFACE"))) {
            data.remove("SRC_INTERFACE");
        }
        if ("".equals((String)data.get("DST_INTERFACE"))) {
            data.remove("DST_INTERFACE");
        }
    }

    private void handleTime(Hashtable data) {
        try {
            String dateFormat = (String)data.get("DATE_FORMAT");
            if (dateFormat != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                String dateString = (String)data.get("DATE_STRING");
                if (dateString != null && data.get("NO_YEAR") != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    int year = cal.get(1);
                    cal.setTime(sdf.parse(dateString));
                    cal.set(1, year);
                    data.put("TIME", new Timestamp(cal.getTime().getTime()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleStatus(Hashtable data, String status) {
        if ("Drop".equals(status) || "Block".equals(status)) {
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            data.put("PRIORITY", "4");
            data.put("li", "1");
        } else {
            data.put("STATUS", "permit");
            this.checkSrcDstInterfaces(data, "FW");
            this.checkDuration(data);
        }
    }

    protected void checkProtocolSyntax(Hashtable data) {
        String protocol = (String)data.get("PROTOCOL");
        if (protocol == null || "".equals(protocol)) {
            String port = (String)data.get("DEST_PORT");
            String proto = (String)data.get("PROTO");
            if (port != null) {
                proto = port + "/" + proto;
                data.put("PROTOCOL", proto);
            }
        }
        super.checkForLearnMe(data);
    }

    private void checkDuration(Hashtable data) {
        Long duration = Long.valueOf((String)data.get("DURATION"));
        String action = (String)data.get("STATUS");
        if ("permit".equals(action)) {
            duration = duration / 1000L;
            data.put("DURATION", duration);
        }
    }

    private void handlePriority(Hashtable data) {
        String sev = (String)data.get("PRIORITY");
        if (sev != null) {
            int priority = Integer.parseInt(sev);
            try {
                data.put("PRIORITY", "" + (priority %= 8));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

