/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.store.DBHashMap;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheManager {
    private static final Logger LOGGER = Logger.getLogger(CacheManager.class.getName());
    private static boolean enableDNS = true;
    private static CacheManager cm = null;
    public static final String FW_TABLE_NAME = "Firewalls";
    public static final String SYS_TO_FW_TABLE_NAME = "SyslogCollectorToFWMap";
    public static final String HOST_TABLE_NAME = "Hosts";
    public static final String TIME_TABLE_NAME = "TimeInHours";
    public static final String DAY_TABLE_NAME = "TimeInDays";
    public static final String MONTH_TABLE_NAME = "TimeInMonths";
    public static final String PROTOCOL_TABLE_NAME = "Protocols";
    public static final String PRIORITY_TABLE_NAME = "Priorities";
    private Vector days = new Vector();
    private Vector time = new Vector();
    private Vector months = new Vector();
    private static Persistence persistence = null;
    private int max_count = 50;
    private boolean debug = false;
    private Vector dnsInQ = new Vector();
    private Vector dnsOutQ = new Vector();
    private boolean shutdown = false;
    Object synHost = new Object();
    private Integer syncDNSName = new Integer(0);
    private DBHashMap dns_map = null;
    private DBHashMap hosts_map = null;
    private DBHashMap firewalls_map = null;
    private DBHashMap crunchIds_map = null;
    private DBHashMap authUsers_map = null;
    private DBHashMap protocols_map = null;
    private DBHashMap priorities_map = null;
    private DBHashMap intPriorityMap = null;

    private CacheManager() {
        if (System.getProperty("DEBUG") != null) {
            this.debug = true;
        }
    }

    public static CacheManager getInstance() {
        if (cm == null) {
            cm = new CacheManager();
        }
        return cm;
    }

    public void initialize() {
    }

    private void initializeTime() {
        Table ent = new Table(TIME_TABLE_NAME);
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        Column selectAtt = new Column(TIME_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        try {
            DataObject queryConnDO = CacheManager.getPersistence().get((SelectQuery)selectquery);
            Iterator it = queryConnDO.getRows(TIME_TABLE_NAME);
            while (it.hasNext()) {
                Row timeRow = (Row)it.next();
                this.time.addElement((Integer)timeRow.get("TIH_ID"));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void initializeDays() {
        Table ent = new Table(DAY_TABLE_NAME);
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        Column selectAtt = new Column(DAY_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        try {
            DataObject queryConnDO = CacheManager.getPersistence().get((SelectQuery)selectquery);
            Iterator it = queryConnDO.getRows(DAY_TABLE_NAME);
            while (it.hasNext()) {
                Row dyRow = (Row)it.next();
                this.days.addElement((Integer)dyRow.get("TID_ID"));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void initializeMonths() {
        Table ent = new Table(MONTH_TABLE_NAME);
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        Column selectAtt = new Column(MONTH_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        try {
            DataObject queryConnDO = CacheManager.getPersistence().get((SelectQuery)selectquery);
            Iterator it = queryConnDO.getRows(MONTH_TABLE_NAME);
            while (it.hasNext()) {
                Row dyRow = (Row)it.next();
                this.months.addElement((Integer)dyRow.get("TIM_ID"));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public synchronized Object getRadiusID(String host, String sysLogServer) {
        if (this.debug) {
            LOGGER.log(Level.FINER, "Called Squid ID<->" + host + "<->" + sysLogServer);
        }
        Object id = this.getFirewallId(host);
        if (this.debug) {
            LOGGER.log(Level.FINER, "getFirewallID<->" + id);
        }
        if (id == null) {
            try {
                DataObject rec = CacheManager.constructNewDO();
                Row resource = new Row("Resources");
                resource.set("RESOURCENAME", (Object)host);
                resource.set("DISPLAYTYPE", (Object)host);
                resource.set("SIMULATED", (Object)new Boolean("true"));
                resource.set("CREATIONTIME", (Object)new Long(System.currentTimeMillis()));
                resource.set("TYPE", (Object)"Radius");
                rec.addRow(resource);
                if (sysLogServer != null) {
                    Object rid = resource.get("RESOURCEID");
                    Row sysToFwTable = new Row(SYS_TO_FW_TABLE_NAME);
                    try {
                        Long sys_id = Long.valueOf(sysLogServer);
                        sysToFwTable.set("SYSLOGCOLLECTOR_ID", (Object)sys_id);
                        rec.addRow(sysToFwTable);
                        sysToFwTable.set("RID", rid);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.FINER, " Unable to parse SYSLOGSERVER :: " + sysLogServer);
                        nfe.printStackTrace();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINER, " Unable to add SYSLOGSERVER :: " + sysLogServer);
                        e.printStackTrace();
                    }
                }
                DataObject added = CacheManager.getPersistence().add(rec);
                id = added.getFirstValue("Resources", "RESOURCEID");
                if (this.debug) {
                    LOGGER.log(Level.FINER, "BUG This should never happen.... bug here check the code flow<->" + host + "<->" + id);
                }
                this.firewalls_map.put((Object)host, id);
            }
            catch (Exception dExp) {
                dExp.printStackTrace();
            }
        }
        return id;
    }

    public synchronized Object getSquidID(String host, String sysLogServer) {
        if (this.debug) {
            LOGGER.log(Level.FINER, "Called Squid ID<->" + host + "<->" + sysLogServer);
        }
        Object id = this.getFirewallId(host);
        if (this.debug) {
            LOGGER.log(Level.FINER, "getFirewallID<->" + id);
        }
        if (id == null) {
            try {
                DataObject rec = CacheManager.constructNewDO();
                Row resource = new Row("Resources");
                resource.set("RESOURCENAME", (Object)host);
                resource.set("DISPLAYTYPE", (Object)host);
                resource.set("SIMULATED", (Object)new Boolean("true"));
                resource.set("CREATIONTIME", (Object)new Long(System.currentTimeMillis()));
                resource.set("TYPE", (Object)"Squid");
                rec.addRow(resource);
                if (sysLogServer != null) {
                    Object rid = resource.get("RESOURCEID");
                    Row sysToFwTable = new Row(SYS_TO_FW_TABLE_NAME);
                    sysToFwTable.set("RID", rid);
                    try {
                        Long sys_id = Long.valueOf(sysLogServer);
                        sysToFwTable.set("SYSLOGCOLLECTOR_ID", (Object)sys_id);
                        rec.addRow(sysToFwTable);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.FINER, " Unable to parse SYSLOGSERVER :: " + sysLogServer);
                        nfe.printStackTrace();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINER, " Unable to add SYSLOGSERVER :: " + sysLogServer);
                        e.printStackTrace();
                    }
                }
                DataObject added = CacheManager.getPersistence().add(rec);
                id = added.getFirstValue("Resources", "RESOURCEID");
                if (this.debug) {
                    LOGGER.log(Level.FINER, "BUG This should never happen.... bug here check the code flow<->" + host + "<->" + id);
                }
                this.firewalls_map.put((Object)host, id);
            }
            catch (Exception dExp) {
                dExp.printStackTrace();
            }
        }
        return id;
    }

    public synchronized Object getFirewallID(String ip, String name, String format, String type, String syslogServer) {
        if (this.debug) {
            LOGGER.log(Level.FINER, "MyVal<->" + ip + "<->" + name);
        }
        Object id = this.getFirewallId(ip);
        if (this.debug) {
            LOGGER.log(Level.FINER, "MyVal<->" + ip + "<->" + name + "<->" + id);
        }
        if (id == null) {
            if (this.debug) {
                LOGGER.log(Level.FINER, ip + " added  ::: " + name);
            }
            DataObject rec = CacheManager.constructNewDO();
            Row resource = new Row("Resources");
            resource.set("RESOURCENAME", (Object)name);
            resource.set("DISPLAYTYPE", (Object)ip);
            resource.set("SIMULATED", (Object)new Boolean("true"));
            resource.set("CREATIONTIME", (Object)new Long(System.currentTimeMillis()));
            resource.set("TYPE", (Object)"Firewall");
            Row fwTable = new Row(FW_TABLE_NAME);
            fwTable.set("FW_ID", resource.get("RESOURCEID"));
            fwTable.set("FW_NAME", (Object)name);
            fwTable.set("FW_INT_IPADDRESS", (Object)ip);
            fwTable.set("LOG_FORMAT", (Object)format);
            fwTable.set("FW_TYPE", (Object)type);
            try {
                id = resource.get("RESOURCEID");
                rec.addRow(resource);
                rec.addRow(fwTable);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (syslogServer != null) {
                Long sys_id = null;
                Row sysToFwTable = new Row(SYS_TO_FW_TABLE_NAME);
                sysToFwTable.set("RID", id);
                try {
                    sys_id = Long.valueOf(syslogServer);
                    sysToFwTable.set("SYSLOGCOLLECTOR_ID", (Object)sys_id);
                    rec.addRow(sysToFwTable);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINER, " Unable to parse SYSLOGSERVER :: " + syslogServer);
                    nfe.printStackTrace();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, " Unable to add SYSLOGSERVER :: " + syslogServer);
                    e.printStackTrace();
                }
            }
            try {
                rec = CacheManager.getPersistence().add(rec);
                id = rec.getFirstValue("Resources", "RESOURCEID");
                this.firewalls_map.put((Object)ip, id);
                if (this.debug) {
                    LOGGER.log(Level.FINER, "MyVal3<->" + id);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.debug) {
            LOGGER.log(Level.FINER, "MyVal4<->" + id);
        }
        return id;
    }

    private synchronized Object getAuthUserId(String userName) throws DataAccessException {
        Long userID = null;
        try {
            if (userName == null || userName.trim().length() <= 0) {
                userName = "Unknown";
            }
            Object temp = this.getAuthUserID(userName);
            if (this.debug) {
                LOGGER.log(Level.FINER, "AuthUserID<->" + temp);
            }
            if (temp == null) {
                Row r = new Row("AuthUsers");
                r.set("USERNAME", (Object)userName);
                DataObject doo = CacheManager.getPersistence().constructDataObject();
                doo.addRow(r);
                DataObject added = CacheManager.getPersistence().add(doo);
                userID = (Long)added.getFirstValue("AuthUsers", "AUTHUSER_ID");
                if (this.debug) {
                    LOGGER.log(Level.FINER, "BUG This should never happen.... bug here check the code flow<->" + userName + "<->" + userID);
                }
                this.authUsers_map.put((Object)userName, (Object)userID);
            } else {
                userID = (Long)temp;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return userID;
    }

    public synchronized Object getCrunchIdentifier(Object fwKey, String srcName, String src, String userName, String type) throws DataAccessException {
        Object hostId = this.getHostID(srcName, src);
        Object authUserId = this.getAuthUserId(userName);
        if (this.debug) {
            LOGGER.log(Level.FINER, "GetCRunchID<->" + hostId + "<->" + authUserId);
        }
        String key = fwKey + "_" + hostId + "_" + authUserId;
        if (this.debug) {
            LOGGER.log(Level.FINER, "CrunchID<->" + this.getCrunchId(fwKey, hostId, authUserId, type));
        }
        Long crID = (Long)this.getCrunchId(fwKey, hostId, authUserId, type);
        if (this.debug) {
            LOGGER.log(Level.FINER, "CrunchID<->" + crID);
        }
        if (crID == null) {
            crID = this.addFwToCRIDRow(fwKey, hostId, authUserId, type);
            if (this.debug) {
                LOGGER.log(Level.FINER, "BUG This should never happen.... bug here check the code flow<->" + key + "<->" + crID);
            }
            this.crunchIds_map.put((Object)key, (Object)crID);
        }
        return crID;
    }

    private synchronized Long addFwToCRIDRow(Object fwKey, Object hostId, Object authUserId, String type) throws DataAccessException {
        DataObject doo = CacheManager.getPersistence().constructDataObject();
        Row rr = new Row("CrunchIdentifier");
        rr.set("TYPE", (Object)type);
        doo.addRow(rr);
        Row r = null;
        if ("Squid".equals(type)) {
            r = new Row("SquidToCrunchIDMapping");
            r.set("SQ_ID", fwKey);
        } else if ("Radius".equals(type)) {
            r = new Row("RadiusToCrunchIDMapping");
            r.set("RADIUS_ID", fwKey);
        } else {
            r = new Row("FwToCrunchIDMapping");
            r.set("FW_ID", fwKey);
        }
        r.set("CRUNCH_ID", rr.get("CRUNCH_ID"));
        r.set("HOST_ID", (Object)((Long)hostId));
        r.set("AUTHUSER_ID", (Object)((Long)authUserId));
        doo.addRow(r);
        DataObject added = CacheManager.getPersistence().add(doo);
        if ("Squid".equals(type)) {
            return (Long)added.getFirstValue("SquidToCrunchIDMapping", "CRUNCH_ID");
        }
        if ("Radius".equals(type)) {
            return (Long)added.getFirstValue("RadiusToCrunchIDMapping", "CRUNCH_ID");
        }
        return (Long)added.getFirstValue("FwToCrunchIDMapping", "CRUNCH_ID");
    }

    public synchronized Object getPriorityID(String name) {
        if (name == null) {
            return null;
        }
        Object id = this.getPriorityId(name);
        if (id == null) {
            id = this.getIntPriorityId(name);
        }
        if (id == null) {
            DataObject rec = CacheManager.constructNewDO();
            Row prTable = new Row(PRIORITY_TABLE_NAME);
            if (name != null) {
                prTable.set("PRIORITY_NAME", (Object)name);
                prTable.set("PRIORITY", (Object)name);
            }
            try {
                rec.addRow(prTable);
                CacheManager.getPersistence().add(rec);
                id = rec.getFirstValue(PRIORITY_TABLE_NAME, "PRIORITY_ID");
                this.priorities_map.put((Object)name, id);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return id;
    }

    public synchronized Object getProtocolID(String name) {
        if (name != null) {
            name = name.trim();
        }
        Object id = null;
        id = this.getProtocolId(name);
        if (id == null) {
            DataObject rec = CacheManager.constructNewDO();
            Row prTable = new Row(PROTOCOL_TABLE_NAME);
            id = prTable.get("PROTOCOL_ID");
            prTable.set("PROTOCOL_NAME", (Object)name);
            prTable.set("PROTOCOL_GROUP", (Object)new Long(11L));
            try {
                rec.addRow(prTable);
                rec = CacheManager.getPersistence().add(rec);
                id = rec.getFirstValue(PROTOCOL_TABLE_NAME, "PROTOCOL_ID");
                this.protocols_map.put((Object)name, id);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return id;
    }

    private void debug(String print) {
        if (this.debug) {
            LOGGER.log(Level.FINER, print);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getHostID(String name, String ip) {
        Object object = this.synHost;
        synchronized (object) {
            Object id = null;
            if (name != null) {
                name = name.trim();
            }
            if (ip != null) {
                ip = ip.trim();
            }
            if (ip == null) {
                ip = name;
            }
            if (ip != null && (ip.equalsIgnoreCase(name) || name == null)) {
                name = this.getDNSName(ip);
            }
            id = this.getHostIdforIp(ip);
            this.debug("HOSTID<->" + id);
            if (id == null) {
                Table ent = new Table(HOST_TABLE_NAME);
                SelectQueryImpl selectquery = new SelectQueryImpl(ent);
                Column selectAtt1 = new Column(HOST_TABLE_NAME, "HOST_ID");
                selectquery.addSelectColumn(selectAtt1);
                Column selectAtt2 = new Column(HOST_TABLE_NAME, "HOST_IPADDRESS");
                Column selectAtt3 = new Column(HOST_TABLE_NAME, "HOST_NAME");
                Criteria ct = new Criteria(selectAtt2, (Object)ip, 0);
                selectquery.setCriteria(ct);
                Criteria ct1 = new Criteria(selectAtt3, (Object)name, 0);
                selectquery.setCriteria(ct1);
                try {
                    DataObject queryConnDO = CacheManager.getPersistence().get((SelectQuery)selectquery);
                    Iterator it = queryConnDO.getRows(HOST_TABLE_NAME);
                    while (it.hasNext()) {
                        Row hsRow = (Row)it.next();
                        id = hsRow.get("HOST_ID");
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            if (id == null) {
                if (this.debug) {
                    LOGGER.log(Level.FINER, " ADDING HOST :: " + name + "   :: " + ip);
                }
                DataObject rec = CacheManager.constructNewDO();
                Row hostTable = new Row(HOST_TABLE_NAME);
                try {
                    hostTable.set("HOST_IPADDRESS", (Object)ip);
                    hostTable.set("HOST_NAME", (Object)name);
                    rec.addRow(hostTable);
                    CacheManager.getPersistence().add(rec);
                    id = hostTable.get("HOST_ID");
                    if (this.debug) {
                        LOGGER.log(Level.FINER, "BUG This should never happen.... bug here check the code flow<->" + ip + "<->" + id);
                    }
                    this.hosts_map.put((Object)ip, id);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, " Error occured while inserting HOST " + name + "   ::  " + ip);
                    ex.printStackTrace();
                }
            }
            this.synHost.notifyAll();
            return id;
        }
    }

    Integer getHour(Calendar cal) {
        String yr = String.valueOf(cal.get(1));
        String mo = String.valueOf(cal.get(2) + 1);
        String dy = String.valueOf(cal.get(5));
        String hr = String.valueOf(cal.get(11));
        if (mo.length() == 1) {
            mo = "0" + mo;
        }
        if (hr.length() == 1) {
            hr = "0" + hr;
        }
        if (dy.length() == 1) {
            dy = "0" + dy;
        }
        hr = yr + mo + dy + hr;
        Integer hour = null;
        try {
            hour = new Integer(Integer.parseInt(hr));
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.FINER, " Unable to parse HOUR :: " + hour);
            nfe.printStackTrace();
        }
        return hour;
    }

    public synchronized Integer getTimeID(Calendar cal) {
        Integer hr = this.getHour(cal);
        if (hr == null) {
            return null;
        }
        int hour = hr;
        Vector timeCache = this.time;
        if (!timeCache.contains(hr)) {
            DataObject rec = CacheManager.constructNewDO();
            Row timeTable = new Row(TIME_TABLE_NAME);
            timeTable.set("TIH_ID", (Object)hr);
            timeTable.set("HOUR", (Object)new Integer(hour % 100));
            timeTable.set("TID_ID", (Object)this.getDayID(hour / 100, cal));
            try {
                rec.addRow(timeTable);
                CacheManager.getPersistence().add(rec);
                timeCache.addElement(hr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return hr;
    }

    public synchronized Integer getDayID(int day, Calendar cal) {
        Vector dayCache = this.days;
        Integer dy = new Integer(day);
        if (!dayCache.contains(dy)) {
            DataObject rec = CacheManager.constructNewDO();
            Row dayTable = new Row(DAY_TABLE_NAME);
            dayTable.set("TID_ID", (Object)dy);
            dayTable.set("DAYOFMONTH", (Object)new Integer(day % 100));
            dayTable.set("TIM_ID", (Object)this.getMonthID(day / 100));
            dayTable.set("DAYOFWEEK", (Object)new Integer(cal.get(7)));
            dayTable.set("WEEKOFMONTH", (Object)new Integer(cal.get(4)));
            dayTable.set("WEEKOFYEAR", (Object)new Integer(cal.get(3)));
            try {
                rec.addRow(dayTable);
                CacheManager.getPersistence().add(rec);
                dayCache.addElement(dy);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return dy;
    }

    public synchronized Integer getMonthID(int month) {
        Vector monthCache = this.months;
        Integer mo = new Integer(month);
        if (!monthCache.contains(mo)) {
            DataObject rec = CacheManager.constructNewDO();
            Row monthTable = new Row(MONTH_TABLE_NAME);
            monthTable.set("TIM_ID", (Object)mo);
            monthTable.set("MONTH", (Object)new Integer(month % 100));
            monthTable.set("YEAR", (Object)new Integer(month / 100));
            try {
                rec.addRow(monthTable);
                CacheManager.getPersistence().add(rec);
                monthCache.addElement(mo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mo;
    }

    public static Persistence getPersistence() {
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persistence;
    }

    public static DataObject constructNewDO() {
        DataObject dataObject = null;
        try {
            dataObject = CacheManager.getPersistence().constructDataObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdown) {
            try {
                if (this.dnsInQ.size() > 0) {
                    Vector vector = this.dnsInQ;
                    synchronized (vector) {
                        this.dnsOutQ = this.dnsInQ;
                        this.dnsInQ = new Vector();
                    }
                }
                for (int i = 0; i < this.dnsOutQ.size(); ++i) {
                    String ip = (String)this.dnsOutQ.elementAt(i);
                    this.populateDNSName(ip);
                }
                this.dnsOutQ.removeAllElements();
                Object i = this.synHost;
                synchronized (i) {
                    try {
                        this.synHost.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void populateDNSName(String address) {
        String name = address;
        this.debug("dns lookin up<->" + address);
        try {
            InetAddress addr = InetAddress.getByName(address);
            name = addr.getCanonicalHostName();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (name == null) {
            name = address;
        }
        this.dns_map.put((Object)address, (Object)name);
        if (address.equals(name)) {
            return;
        }
        UpdateQueryImpl update = new UpdateQueryImpl(HOST_TABLE_NAME);
        update.setUpdateColumn("HOST_NAME", (Object)name);
        Criteria crit = new Criteria(new Column(HOST_TABLE_NAME, "HOST_IPADDRESS"), (Object)address, 0);
        update.setCriteria(crit);
        this.debug(" DNS LOOKUP RESULT: " + address + " WITH HOSTNAME ==" + name);
        try {
            DataAccess.update((UpdateQuery)update);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public String getDNSName(String address) {
        if (!enableDNS) {
            return address;
        }
        Criteria crt = new Criteria(new Column(HOST_TABLE_NAME, "HOST_IPADDRESS"), (Object)address, 0);
        String name = (String)this.dns_map.get((Object)address, crt);
        if (name == null) {
            this.dnsInQ.addElement(address);
            return address;
        }
        return name;
    }

    private void init() {
        Table ent = new Table("Resources");
        SelectQueryImpl selectquery = new SelectQueryImpl(ent);
        Column selectAtt = new Column("Resources", "*");
        selectquery.addSelectColumn(selectAtt);
        this.firewalls_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, "Resources", "RESOURCEID");
        this.initializeTime();
        ent = new Table(PRIORITY_TABLE_NAME);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(PRIORITY_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        this.priorities_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, PRIORITY_TABLE_NAME, "PRIORITY_ID");
        ent = new Table(PRIORITY_TABLE_NAME);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(PRIORITY_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        this.intPriorityMap = new DBHashMap(this.max_count, (SelectQuery)selectquery, PRIORITY_TABLE_NAME, "PRIORITY_ID");
        this.initializeDays();
        this.initializeMonths();
        ent = new Table(PROTOCOL_TABLE_NAME);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(PROTOCOL_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        this.protocols_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, PROTOCOL_TABLE_NAME, "PROTOCOL_ID");
        ent = new Table(HOST_TABLE_NAME);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(HOST_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        this.hosts_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, HOST_TABLE_NAME, "HOST_ID");
        ent = new Table(HOST_TABLE_NAME);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(HOST_TABLE_NAME, "*");
        selectquery.addSelectColumn(selectAtt);
        this.dns_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, HOST_TABLE_NAME, "HOST_NAME");
        String base = "CrunchIdentifier";
        String child = "FwToCrunchIDMapping";
        String child2 = "SquidToCrunchIDMapping";
        String child3 = "RadiusToCrunchIDMapping";
        Column col1 = new Column(base, "*");
        Column col2 = new Column(child, "*");
        Column col3 = new Column(child2, "*");
        Column col4 = new Column(child3, "*");
        ent = new Table(base);
        String[] jCols = new String[]{"CRUNCH_ID"};
        Join j1 = new Join(ent, new Table(child), jCols, jCols, 1);
        Join j2 = new Join(ent, new Table(child2), jCols, jCols, 1);
        Join j3 = new Join(ent, new Table(child3), jCols, jCols, 1);
        SelectQueryImpl sq_fw = new SelectQueryImpl(ent);
        sq_fw.addSelectColumn(col1);
        sq_fw.addSelectColumn(col2);
        sq_fw.addSelectColumn(col3);
        sq_fw.addSelectColumn(col4);
        sq_fw.addJoin(j1);
        sq_fw.addJoin(j2);
        sq_fw.addJoin(j3);
        this.crunchIds_map = new DBHashMap(this.max_count, (SelectQuery)sq_fw, base, "CRUNCH_ID");
        String tableName = "AuthUsers";
        ent = new Table(tableName);
        selectquery = new SelectQueryImpl(ent);
        selectAtt = new Column(tableName, "*");
        selectquery.addSelectColumn(selectAtt);
        this.authUsers_map = new DBHashMap(this.max_count, (SelectQuery)selectquery, tableName, "AUTHUSER_ID");
        if (this.debug) {
            LOGGER.log(Level.FINER, "firewalls<->" + this.firewalls_map + "<->priorities<->" + this.priorities_map + "<->protocols<->" + this.protocols_map + "<->hosts<->" + this.hosts_map + "<->crunch<->" + this.crunchIds_map + "<->authusers<->" + this.authUsers_map);
        }
    }

    public synchronized Object getHostIdforIp(String key) {
        Criteria crt = new Criteria(new Column(HOST_TABLE_NAME, "HOST_IPADDRESS"), (Object)key, 0);
        if (this.debug) {
            LOGGER.log(Level.FINER, "hosts_map<->" + this.hosts_map);
        }
        Object val = this.hosts_map.get((Object)key, crt);
        if (this.debug) {
            LOGGER.log(Level.FINER, "hosts_map after<->" + this.hosts_map + "<->" + val);
        }
        return val;
    }

    public synchronized Object getHostId(String key) {
        Criteria crt = new Criteria(new Column(HOST_TABLE_NAME, "HOST_NAME"), (Object)key, 0);
        if (this.debug) {
            LOGGER.log(Level.FINER, "hosts_map<->" + this.hosts_map);
        }
        Object val = this.hosts_map.get((Object)key, crt);
        if (this.debug) {
            LOGGER.log(Level.FINER, "hosts_map after<->" + this.hosts_map + "<->" + val);
        }
        return val;
    }

    public synchronized Object getFirewallId(String key) {
        Criteria crt = new Criteria(new Column("Resources", "RESOURCENAME"), (Object)key, 0);
        return this.firewalls_map.get((Object)key, crt);
    }

    public synchronized Object getCrunchId(Object fwKey, Object hostId, Object userid, String type) {
        String key = fwKey + "_" + hostId + "_" + userid;
        Criteria crt = new Criteria(new Column("CrunchIdentifier", "TYPE"), (Object)type, 0);
        if ("Squid".equals(type)) {
            crt = crt.and(new Criteria(new Column("SquidToCrunchIDMapping", "SQ_ID"), fwKey, 0));
            crt = crt.and(new Criteria(new Column("SquidToCrunchIDMapping", "HOST_ID"), hostId, 0));
            crt = crt.and(new Criteria(new Column("SquidToCrunchIDMapping", "AUTHUSER_ID"), (Object)((Long)userid), 0));
        } else if ("Radius".equals(type)) {
            crt = crt.and(new Criteria(new Column("RadiusToCrunchIDMapping", "RADIUS_ID"), fwKey, 0));
            crt = crt.and(new Criteria(new Column("RadiusToCrunchIDMapping", "HOST_ID"), hostId, 0));
            crt = crt.and(new Criteria(new Column("RadiusToCrunchIDMapping", "AUTHUSER_ID"), (Object)((Long)userid), 0));
        } else {
            crt = crt.and(new Criteria(new Column("FwToCrunchIDMapping", "FW_ID"), fwKey, 0));
            crt = crt.and(new Criteria(new Column("FwToCrunchIDMapping", "HOST_ID"), hostId, 0));
            crt = crt.and(new Criteria(new Column("FwToCrunchIDMapping", "AUTHUSER_ID"), (Object)((Long)userid), 0));
        }
        return this.crunchIds_map.get((Object)key, crt);
    }

    public synchronized Object getAuthUserID(String key) {
        Criteria crt = new Criteria(new Column("AuthUsers", "USERNAME"), (Object)key, 0);
        return this.authUsers_map.get((Object)key, crt);
    }

    public synchronized Object getProtocolId(String key) {
        Criteria crt = new Criteria(new Column(PROTOCOL_TABLE_NAME, "PROTOCOL_NAME"), (Object)key, 0);
        return this.protocols_map.get((Object)key, crt);
    }

    private Object getIntPriorityId(Object key) {
        Criteria crt = new Criteria(new Column(PRIORITY_TABLE_NAME, "PRIORITY"), key, 0);
        Object value = this.intPriorityMap.get(key, crt);
        if (value != null) {
            this.priorities_map.put(key, value);
        }
        return value;
    }

    public synchronized Object getPriorityId(String key) {
        Criteria crt = new Criteria(new Column(PRIORITY_TABLE_NAME, "PRIORITY_NAME"), (Object)key, 0);
        return this.priorities_map.get((Object)key, crt);
    }

    public void clearAll() {
        LOGGER.log(Level.FINER, "Sizes host<->" + this.hosts_map.size() + "fw<->" + this.firewalls_map.size() + "crunch<->" + this.crunchIds_map.size() + "auth<->" + this.authUsers_map.size() + "proto<->" + this.protocols_map.size() + "prio<->" + this.priorities_map.size() + " intprio<->" + this.intPriorityMap.size());
        this.hosts_map.clear();
        this.firewalls_map.clear();
        this.crunchIds_map.clear();
        this.authUsers_map.clear();
        this.protocols_map.clear();
        this.priorities_map.clear();
        this.intPriorityMap.clear();
    }
}

