/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CiscoIOSUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(CiscoIOSUnifier.class.getName());
    private static final Integer TYPE = new Integer(3);
    private List l3Protocols = new ArrayList();
    private Map connectionMap = null;
    private String[] connectionArray = null;

    public CiscoIOSUnifier() {
        this.l3Protocols.add("icmp");
        this.l3Protocols.add("tcp");
        this.l3Protocols.add("udp");
        this.connectionMap = new FixedHashMap(50000);
        this.connectionArray = new String[]{"SRC", "SRC_PORT", "DST", "DST_PORT"};
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String resource;
        data.put("ResourceType", "CiscoPIX");
        data.put("SYSLOGIP", host);
        data.put("rtype", TYPE);
        this.assignPreParserTime(data);
        String cid = (String)data.get("cid");
        if ("B".equals(cid)) {
            this.populateConnectionMap(data);
            return null;
        }
        if ("T".equals(cid)) {
            this.populateDuration(data);
        }
        if ((resource = (String)data.get("RESOURCE")) == null) {
            resource = host;
            data.put("RESOURCE", resource);
        }
        data.put("FW_TYPE", "Cisco IOS");
        data.put("LOG_FORMAT", "Cisco IOS");
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "DURATION", "RCVD"};
        this.strToLong(strToLong, data);
        this.checkForLearnMe(data);
        this.checkStatus(data);
        this.checkPriority(data);
        data.put("FW", data.get("RESOURCE"));
        return data;
    }

    private void populateConnectionMap(Hashtable data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.connectionArray.length; ++i) {
            buffer.append(data.get(this.connectionArray[i]));
        }
        this.connectionMap.put(buffer.toString(), data.get("TIME"));
    }

    private void populateDuration(Hashtable data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.connectionArray.length; ++i) {
            buffer.append(data.get(this.connectionArray[i]));
        }
        Timestamp startTime = (Timestamp)this.connectionMap.remove(buffer.toString());
        Timestamp endTime = (Timestamp)data.get("TIME");
        if (startTime == null) {
            return;
        }
        long duration = (endTime.getTime() - startTime.getTime()) / 1000L;
        if (duration > 0L) {
            data.put("DURATION", new Long(duration));
        }
    }

    private void checkStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if (status != null && status.toLowerCase().indexOf("den") > -1) {
            data.put("STATUS", "deny");
            data.put("li", "1");
            data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
        }
    }

    @Override
    public void checkForLearnMe(Hashtable data) {
        String protocol = (String)data.get("L3_PROTOCOL");
        if (this.l3Protocols.contains(protocol)) {
            String destPort = (String)data.get("DST_PORT");
            if (destPort != null) {
                protocol = destPort + "/" + protocol;
            }
            data.put("PROTOCOL", protocol);
        } else if (protocol != null) {
            data.put("PROTOCOL", protocol);
        }
        super.checkForLearnMe(data);
    }
}

