/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class DHCPLogUnifier
extends AbstractLogUnifier {
    private String dateFormat = "yyyy-MM-ddHH:mm:ss";

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        boolean isAddAsResource;
        UserMACHandler dhcpHandler;
        boolean isConfiguredServer;
        boolean isUnManagedDevice;
        String resource;
        String ipAddress = (String)data.get("IPADDRESS");
        String userName = null;
        userName = (String)data.get("USERNAME");
        if (userName != null && "".equals(userName.trim())) {
            userName = (String)data.get("MACADDRESS");
        }
        if ((resource = (String)data.get("RESOURCE")) == null || "".equals(resource)) {
            resource = host;
        }
        if (isUnManagedDevice = FirewallLicenseManager.getInstance().isUnManagedDevice(resource)) {
            return null;
        }
        FAServerUtil.handleNewDHCPServer(resource);
        if (FirewallConstants.getUserIPConfigValue() == 2 && !"true".equals((String)data.get("others")) && (isConfiguredServer = (dhcpHandler = FirewallConstants.getUserMACHandlerInstance()).isConfiguredServer(resource))) {
            long time = System.currentTimeMillis();
            if ("true".equals((String)data.get("RELEASE"))) {
                dhcpHandler.removeData(resource, ipAddress);
            } else {
                dhcpHandler.putData(resource, ipAddress, userName);
            }
        }
        if (isAddAsResource = FirewallConstants.isDHCPAsDevice()) {
            data.put("li", "1");
            data.put("rtype", 25);
            data.put("FW_TYPE", "DHCP");
            data.put("LOG_FORMAT", "DHCP");
            data.put("EVENT_TYPE", PureFirewallConstants.DHCP_LOG);
            if (ipAddress != null) {
                data.put("SRC", ipAddress);
                data.put("SRCNAME", ipAddress);
            }
            if (userName != null) {
                data.put("USERNAME", userName);
            }
            data.put("RESOURCE", resource);
            data.put("FW", resource);
            this.handleTime(data);
            return data;
        }
        return null;
    }

    @Override
    protected void handleUserIPIntegration(String host, Hashtable data) {
    }

    private void handleTime(Hashtable data) {
        String dateString = (String)data.get("DATE_STRING");
        SimpleDateFormat sdf = null;
        String temp = (String)data.get("DATE_FORMAT");
        sdf = temp != null ? new SimpleDateFormat(temp) : new SimpleDateFormat(this.dateFormat);
        try {
            if (data.get("NO_YEAR") != null) {
                GregorianCalendar cal = new GregorianCalendar();
                int year = cal.get(1);
                cal.setTime(sdf.parse(dateString));
                cal.set(1, year);
                long msTime = cal.getTime().getTime();
                data.put("TIME", new Timestamp(msTime));
            } else {
                data.put("TIME", new Timestamp(sdf.parse(dateString).getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

