/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.la.util.nf.AuditHandler;
import com.adventnet.la.util.nf.NotificationFilter;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FirewallAuditHandler
implements AuditHandler {
    private static final Logger LOGGER = Logger.getLogger(FirewallAuditHandler.class.getName());

    public void logAudit(NotificationFilter filter, Map noti, String errorString) {
        String criticality = filter.getCriticality();
        String alertOwner = filter.getAlertOwner();
        String notification = filter.getNotification();
        int status = 0;
        if (errorString == null) {
            status = 1;
        }
        if (notification.equals("empty")) {
            status = 3;
        }
        String recordCol = "FirewallRecords.LRID";
        Long recordId = (Long)noti.get("LRID");
        if (recordId == null) {
            recordId = (Long)noti.get("SQID");
            recordCol = "SquidRecords.SQID";
            if (recordId == null) {
                recordId = (Long)noti.get("IF_INDEX");
                recordCol = "InterfaceInfo.IF_INDEX";
            }
        }
        String atVal = (String)noti.get("RESOURCE");
        String resource = null;
        if (atVal != null) {
            resource = atVal;
        }
        try {
            DataObject dObject = DataAccess.constructDataObject();
            Row row = new Row("LAAlertAudit");
            row.set("NF_ID", filter.getFilterId());
            row.set("NOTIFIEDTIME", (Object)new Long(System.currentTimeMillis()));
            row.set("TYPE", (Object)"Firewall");
            row.set("SOURCE", (Object)resource);
            row.set("STATUS", (Object)new Integer(status));
            row.set("CRITICALITY", (Object)criticality);
            row.set("OWNERNAME", (Object)alertOwner);
            row.set("ERROR_DETAILS", (Object)errorString);
            row.set("RECORD_COLUMN", (Object)recordCol);
            row.set("RECORD_ID", (Object)recordId);
            dObject.addRow(row);
            DataAccess.add((DataObject)dObject);
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " EXCEPTION WHILE ADDING AUDIT=========");
            ee.printStackTrace();
        }
    }
}

