/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreeBSDUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(FreeBSDUnifier.class.getName());
    private static final Integer TYPE = new Integer(10);
    private Pattern ipAndPortPattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)\\.(\\d+)");

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        this.handleTime(data);
        this.handleSrcAndDest(data);
        this.resolveBytes(data);
        this.handleStatus(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION", "SENT_PKT", "RECEIVED_PKT", "TRAN_PORT", "STATUS_CODE", "POLICY_ID"};
        this.strToLong(strToLong, data);
        data.put("FW_TYPE", "Free BSD");
        data.put("LOG_FORMAT", "FreeBSD");
        int destPort = (Integer)data.get("DEST_PORT");
        this.checkForLearnMe(data, destPort);
        return data;
    }

    private void handleStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if ("b".equalsIgnoreCase(status)) {
            data.put("STATUS", "deny");
            data.put("li", "1");
            if (data.get("RULE") == null) {
                data.put("RULE", "default");
            }
        }
    }

    private void resolveBytes(Hashtable data) {
        String bytes = (String)data.get("BYTES");
        if (bytes != null) {
            String inOrOut = (String)data.get("IN_OR_OUT");
            if (inOrOut != null && "OUT".equals(inOrOut)) {
                data.put("SENT", bytes);
            } else {
                data.put("RECEIVED", bytes);
            }
        }
    }

    private void checkForLearnMe(Hashtable data, int destPort) {
        String proto = (String)data.get("L3_PROTOCOL");
        if (proto != null) {
            if (destPort != 0) {
                proto = destPort + "/" + proto;
            }
            data.put("PROTOCOL", proto);
        }
        super.checkForLearnMe(data);
    }

    private String handleSrcAndDest(Hashtable data) {
        String temp = (String)data.get("SRC");
        String destPort = null;
        if (temp != null) {
            this.resolveIpAndPort(data, temp, "SRC");
        }
        if ((temp = (String)data.get("DEST")) != null) {
            this.resolveIpAndPort(data, temp, "DEST");
        }
        return destPort;
    }

    private void resolveIpAndPort(Hashtable data, String ipAndPort, String portKey) {
        Matcher matcher = this.ipAndPortPattern.matcher(ipAndPort);
        if (matcher.find()) {
            String ip = matcher.group(1);
            String port = matcher.group(2);
            data.put(portKey, ip);
            data.put(portKey + "_PORT", port);
        }
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        if (data.get("PRIORITY") != null) {
            try {
                int pri = Integer.parseInt((String)data.get("PRIORITY"));
                if (pri > 7) {
                    data.put("PRIORITY", "" + (pri %= 8));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void handleTime(Hashtable data) {
        String timeString = (String)data.get("TIME");
        String dateString = (String)data.get("DATE");
        if (timeString == null) {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
            return;
        }
        if (dateString != null && !"true".equals(timeString)) {
            dateString = dateString + " " + timeString;
            String dateForm = (String)data.get("DATE_FORMAT");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateForm);
                GregorianCalendar cal = new GregorianCalendar();
                int year = cal.get(1);
                cal.setTime(dateFormat.parse(dateString));
                cal.set(1, year);
                data.put("TIME", new Timestamp(cal.getTime().getTime()));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.FINER, " Exception while parsing FreeBSD Time String :: {0} ", new Object[]{timeString});
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
            }
        } else if (data.get("TIME_FORMAT") != null) {
            String timeFormat = (String)data.get("TIME_FORMAT");
            try {
                SimpleDateFormat format = new SimpleDateFormat(timeFormat);
                GregorianCalendar cal = new GregorianCalendar();
                int year = cal.get(1);
                int month = cal.get(2);
                int date = cal.get(5);
                cal.setTime(format.parse(timeString));
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, date);
                data.put("TIME", new Timestamp(cal.getTime().getTime()));
            }
            catch (Exception ee) {
                ee.printStackTrace();
                LOGGER.log(Level.FINER, " Exception while parsing FreeBSD Time String :: {0} ", new Object[]{timeString});
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
            }
        } else if (data.get("DATE_FORMAT") != null) {
            this.assignPreParserTime(data);
        }
    }
}

