/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HuaweiUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(HuaweiUnifier.class.getName());
    private static final Integer TYPE = new Integer(42);

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        this.handleDateAndTime(data);
        this.handleStatus(data);
        this.checkPriority(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        data.put("FW_TYPE", "HUAWEI");
        data.put("LOG_FORMAT", "Huawei");
        int destPort = (Integer)data.get("DEST_PORT");
        this.checkForLearnMe(data, destPort);
        return data;
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        try {
            int pri = Integer.parseInt((String)data.get("PRIORITY"));
            if (pri > 7) {
                data.put("PRIORITY", String.valueOf(pri %= 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void handleDateAndTime(Hashtable data) {
        String timeString = (String)data.get("TIME");
        String dateString = (String)data.get("DATE");
        if (timeString == null) {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
            return;
        }
        if (dateString != null && !"".equals(timeString)) {
            dateString = dateString + " " + timeString;
            String dateFormat = (String)data.get("DATE_FORMAT");
            String timeFormat = (String)data.get("TIME_FORMAT");
            try {
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat(dateFormat + timeFormat);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dateTimeFormat.parse(dateString));
                data.put("TIME", new Timestamp(cal.getTime().getTime()));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.FINER, " Exception while parsing Huawei time string :: {0} ", new Object[]{timeString});
                data.put("TIME", new Timestamp(System.currentTimeMillis()));
            }
        }
    }

    private void checkForLearnMe(Hashtable data, int destPort) {
        String proto = (String)data.get("PROTOCOL");
        if (proto == null) {
            proto = (String)data.get("PROTOCOL_ID");
            if (destPort != 0) {
                proto = destPort + "/" + proto;
            }
        }
        data.put("PROTOCOL", proto);
        super.checkForLearnMe(data);
    }

    private void handleStatus(Hashtable data) {
        String status = (String)data.get("STATUS");
        if (data.get("SENT") != null || data.get("RECEIVED") != null) {
            data.put("STATUS", "permit");
            if (data.get("RULE") == null) {
                data.put("RULE", "default");
            }
        } else {
            data.put("STATUS", "deny");
        }
    }
}

