/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.WELFLogUnifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;

public class LeadSecLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(LeadSecLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(14);
    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private HashMap l3ProtocolMap = new HashMap();

    public LeadSecLogUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        boolean isPolicyIdInt;
        String module = (String)data.get("MODULE");
        if ("security_option".equals(module) || "webui".equals(module)) {
            return null;
        }
        String policyId = (String)data.get("RULE");
        String status = (String)data.get("STATUS");
        boolean bl = policyId != null && !"".equals(policyId) ? Character.isDigit(policyId.charAt(0)) : (isPolicyIdInt = false);
        if (policyId != null && !"".equals(policyId) && isPolicyIdInt && status == null) {
            int policy = Integer.parseInt(policyId);
            if (policy <= 50) {
                data.put("li", "1");
                data.put("status", "deny");
                status = "deny";
            } else {
                status = "permit";
            }
        }
        if (data.get("INT_DEST") != null) {
            data.put("DEST", data.get("INT_DEST"));
            data.put("DEST_NAME", data.get("INT_DEST_NAME"));
        }
        this.handleTime(data);
        this.checkStatus(status, data);
        this.checkForAttack(data);
        this.checkForPolicyAddition(data);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        data.put("FW_TYPE", "LeadSec Firewall");
        data.put("LOG_FORMAT", "LeadSec Native Format");
        this.checkProtocolSyntax(data);
        this.checkArgument(data);
        this.checkPriority(data);
        return data;
    }

    private void checkForPolicyAddition(Hashtable data) {
        String act = (String)data.get("STATUS");
        if ("add".equalsIgnoreCase(act) || "set".equalsIgnoreCase(act)) {
            String[] keys = new String[]{"SRC", "SRC_NAME", "DEST", "DEST_NAME"};
            int size = keys.length;
            for (int i = 0; i < size; ++i) {
                data.remove(keys[i]);
            }
        }
    }

    @Override
    public void checkProtocolSyntax(Hashtable data) {
        String l3Proto = (String)data.get("L3_PROTOCOL");
        if (l3Proto != null) {
            if (l3Proto.equals("47")) {
                data.put("PROTOCOL", "gre");
            } else {
                l3Proto = this.getStringL3Protocol(l3Proto);
                data.put("L3_PROTOCOL", l3Proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    l3Proto = destPort.toString() + "/" + l3Proto;
                }
                data.put("PROTOCOL", l3Proto);
            }
        }
        super.checkProtocolSyntax(data);
    }

    private void handleTime(Hashtable data) {
        Date finalDate = null;
        String time = (String)data.get("TIME");
        try {
            if (time != null && !"".equals(time)) {
                SimpleDateFormat leadSecFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                finalDate = leadSecFormat.parse(time);
            } else {
                finalDate = new Date();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            finalDate = new Date();
        }
        SimpleDateFormat fwaFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = fwaFormat.format(finalDate);
        data.put("TIME", time);
    }

    private void checkStatus(String status, Hashtable data) {
        if (status == null && "".equals(status)) {
            return;
        }
        if ("DROP".equals(status) || "deny".equals(status)) {
            data.put("li", "1");
            data.put("STATUS", "deny");
        }
    }

    private void checkForAttack(Hashtable data) {
        String module = (String)data.get("MODULE");
        if ("acm".equalsIgnoreCase(module)) {
            data.put("li", "1");
            data.put("RECORD_TYPE", "attack");
        }
    }
}

