/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.fa.server.dc.WELFLogUnifier;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetScreenLogUnifier
extends WELFLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(NetScreenLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(11);
    private HashMap l3ProtocolMap = new HashMap();
    private Map fwToUserMap = null;
    private Map fwToVpnMap = new HashMap();
    private Map resourceMap = null;
    private Map temp = new HashMap();
    private static Pattern regex = Pattern.compile(":\\/\\/([^\\/]+)\\/");
    boolean userToIPMapPopulated = false;
    private FwConfigMgmt configMgmt = null;

    public NetScreenLogUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
        this.configMgmt = FwConfigMgmt.getInstance();
        this.fwToUserMap = Collections.synchronizedMap(new FixedHashMap(100));
        this.resourceMap = Collections.synchronizedMap(new FixedHashMap(50));
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        if (data.get("ACTION") != null) {
            this.handleLiveData(data);
        }
        this.handleSPLog(data);
        this.checkPriority(data);
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        this.getOriginalTime(data);
        data.put("rtype", TYPE);
        this.assignPreParserTime(data);
        data.put("SYSLOGIP", host);
        if (this.dropInfoEvents(data)) {
            return null;
        }
        this.checkAdminSupport(data, host);
        if (this.addVpnSupport(data, host)) {
            return null;
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        this.checkProtocolSyntax(data);
        this.checkArgument(data);
        this.assignNameForAttack(data, "port scan");
        this.updateUserInfo(data);
        this.checkParams(data);
        this.checkSrcDstInterfaces(data, "FW");
        this.handleDestName(data);
        return data;
    }

    private void handleDestName(Hashtable data) {
        String url;
        Matcher mat;
        if (data.get("REQUEST") != null && data.get("DEST_NAME") == null && (mat = regex.matcher(url = (String)data.get("REQUEST"))).find() && mat.groupCount() >= 1) {
            String dstName = mat.group(1);
            data.put("DEST_NAME", dstName);
        }
    }

    private void checkParams(Hashtable data) {
        String status = (String)data.get("STATUS");
        if ("BLOCKED".equals(status) || "block".equals(status) || "D".equals(status) || "R".equals(status)) {
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", PureFirewallConstants.FIREWALL_DENIED_LOG);
            data.put("li", "1");
        }
        if ("A".equals(status)) {
            data.put("STATUS", "permit");
        }
        if (data.get("TIME_DUR") != null) {
            try {
                long dur = Long.parseLong((String)data.get("TIME_DUR"));
                if ((dur /= 1000L) <= 0L) {
                    dur = 1L;
                }
                data.put("DURATION", new Long(dur));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        if ("TCP_DENIED".equals(data.get("RESULT_CODE"))) {
            data.put("STATUS", "deny");
            data.put("EVENT_TYPE", PureFirewallConstants.CONTENT_FILTERING_DENY);
            data.put("li", "1");
        }
    }

    private void getOriginalTime(Hashtable data) {
        try {
            String start_time = (String)data.get("START_TIME");
            String duration = (String)data.get("DURATION");
            if (start_time != null && duration != null) {
                SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date_format.parse((String)data.get("DATE_STRING")));
                ((Calendar)cal).add(13, Integer.parseInt(duration));
                data.put("DATE_STRING", date_format.format(cal.getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private boolean addVpnSupport(Hashtable data, String host) {
        String vpnType = (String)data.get("VPNType");
        String src = (String)data.get("SRC");
        if ("IKE".equals(vpnType)) {
            String uname = (String)data.get("USERNAME");
            String key = (String)data.get("KEY");
            if (key.equals("passed")) {
                this.addVPNObject(data, host);
                if (src != null) {
                    this.temp.put(src + host, data.get("USERNAME"));
                }
                return true;
            }
            if (key.equals("expired") || key.equals("terminated") || key.equals("aborted")) {
                this.removeVPNObject(data, host);
                this.temp.values().remove(uname);
            } else if (key.equals("failed")) {
                data.put("EVENT_TYPE", new Integer(10));
                data.remove("VPN");
            }
            if (uname.equals("")) {
                data.put("USERNAME", "Unknown");
            }
            data.put("li", "1");
        }
        if (data.get("SENT") != null && this.temp.get(src + host) != null) {
            this.handleIntermitant(data, host);
        }
        return false;
    }

    @Override
    public void checkProtocolSyntax(Hashtable data) {
        String l3Proto = (String)data.get("L3_PROTOCOL");
        if (l3Proto != null) {
            if (l3Proto.equals("47")) {
                data.put("PROTOCOL", "gre");
            } else {
                l3Proto = this.getStringL3Protocol(l3Proto);
                data.put("L3_PROTOCOL", l3Proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    l3Proto = destPort.toString() + "/" + l3Proto;
                }
                data.put("PROTOCOL", l3Proto);
            }
        }
        super.checkProtocolSyntax(data);
    }

    private void checkAdminSupport(Hashtable data, String host) {
        if (data.get("ADMINLOG") != null) {
            data.put("EVENT_TYPE", "1");
            data.put("DEST", host);
            String[] strToInt = new String[]{"EVENT_TYPE"};
            this.strToInt(strToInt, data);
            if (data.get("PROTOCOL") == null) {
                data.put("PROTOCOL", "Unknown");
            }
            if (data.get("FAILOVER") != null) {
                data.put("SRC", "0.0.0.0");
                data.put("SUBTYPE", "5");
            } else if (data.get("LOGINFAIL") != null) {
                data.put("SUBTYPE", "3");
                data.put("STATUS", "Failed");
            } else if (data.get("ISLOGOUT") != null) {
                data.put("SUBTYPE", "2");
                data.put("STATUS", "Success");
                try {
                    String changedBy = (String)data.get("USERNAME");
                    String resource = (String)data.get("FW");
                    Long rID = (Long)LaCacheManager.getInstance().getFirewallId(resource);
                    this.configMgmt.initiateConfigFetching("Netscreen Native", resource, changedBy, rID);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (data.get("CMD") != null) {
                if (data.get("SRC") == null) {
                    data.put("SRC", "0.0.0.0");
                }
                data.put("SUBTYPE", "4");
            } else {
                data.put("SUBTYPE", "1");
                data.put("STATUS", "Success");
            }
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(user);
                long duration = 0L;
                if (vpnObj != null) {
                    Timestamp startTime = vpnObj.getVPNTime();
                    Timestamp endTime = this.getTimeStamp(data);
                    duration = endTime.getTime() - startTime.getTime();
                    duration /= 1000L;
                    if (vpnObj.getSentBytes() != null) {
                        data.put("SENT", vpnObj.getSentBytes());
                        data.put("RECEIVED", vpnObj.getRcvdBytes());
                    }
                }
                data.put("DURATION", new Long(duration));
            } else {
                data.put("DURATION", new Long(0L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleIntermitant(Hashtable data, String host) {
        data.put("SUBTYPE", "7");
        data.put("USERNAME", (String)this.temp.get((String)data.get("SRC") + host));
        Map vpnObjMap = (Map)this.fwToVpnMap.get(data.get("FW"));
        if (vpnObjMap != null) {
            PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(data.get("USERNAME"));
            this.aggregateSentAndRcvd(vpnObj, data);
            data.put("TRAN_IP", (String)data.get("SRC"));
            data.put("VPN", "IKE");
        }
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = (String)data.get("FW");
            String user = (String)data.get("USERNAME");
            data.put("TIME", this.getTimeStamp(data));
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            vpnObjMap.put(user, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateUserInfo(Hashtable data) {
        String userIP = (String)data.get("USER_IP");
        String resource = (String)data.get("FW");
        String logID = (String)data.get("LOG_ID");
        if ("00543".equals(logID)) {
            Map userToIPMap = (Map)this.fwToUserMap.get(resource);
            Object userName = userToIPMap.remove(userIP);
            return;
        }
        if (userIP != null) {
            String userName = (String)data.get("USERNAME");
            Map<String, String> userToIPMap = (Map<String, String>)this.fwToUserMap.get(resource);
            if (userToIPMap == null) {
                userToIPMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToUserMap.put(resource, userToIPMap);
            }
            userToIPMap.put(userIP, userName);
            this.userToIPMapPopulated = true;
        } else if (this.userToIPMapPopulated) {
            Map userToIPMap = (Map)this.fwToUserMap.get(resource);
            if (userToIPMap == null) {
                return;
            }
            String source = (String)data.get("SRC");
            String user = (String)data.get("USERNAME");
            String userNameFrmMemory = (String)userToIPMap.get(source);
            if (userNameFrmMemory != null && user == null) {
                data.put("USERNAME", userNameFrmMemory);
            }
        }
    }

    private void handleLiveData(Hashtable data) {
        try {
            PIXVPNObject pObj;
            Map<String, PIXVPNObject> idMap;
            String id = (String)data.get("SRC") + ":" + (String)data.get("SRC_PORT");
            String fw = (String)data.get("FW");
            Timestamp time = this.getTimeStamp(data);
            if ("create".equals(data.get("ACTION"))) {
                data.put("TIME", time);
                idMap = (Map)this.resourceMap.get(fw);
                if (idMap == null) {
                    idMap = Collections.synchronizedMap(new FixedHashMap(200));
                    this.resourceMap.put(fw, idMap);
                }
                pObj = new PIXVPNObject(data);
                idMap.put(id, pObj);
                data.put("DROP_LOG", "true");
            }
            if (data.get("REQUEST") != null) {
                idMap = (Map<String, PIXVPNObject>)this.resourceMap.get(fw);
                if (idMap != null && (pObj = (PIXVPNObject)idMap.get(data.get("SRCIP"))) != null) {
                    pObj.setUser((String)data.get("REQUEST"));
                }
                data.put("DROP_LOG", "true");
            }
            if ("destroy".equals(data.get("ACTION"))) {
                long duration = 0L;
                Map idMap2 = (Map)this.resourceMap.get(fw);
                PIXVPNObject pObj2 = (PIXVPNObject)idMap2.remove(id);
                if (pObj2 != null) {
                    Timestamp startTime = pObj2.getVPNTime();
                    duration = time.getTime() - startTime.getTime();
                    duration /= 1000L;
                    if (pObj2.getUser() != null) {
                        data.put("REQUEST", pObj2.getUser());
                    }
                }
                data.put("DURATION", new Long(duration));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleSPLog(Hashtable data) {
        if ("milter".equals(data.get("RECORD_TYPE"))) {
            String fw = (String)data.get("FW");
            Map srcMap = (Map)this.resourceMap.get(fw);
            if (data.get("SENT") == null) {
                if (srcMap == null) {
                    srcMap = Collections.synchronizedMap(new FixedHashMap(50));
                    this.resourceMap.put(fw, srcMap);
                }
                srcMap.put(data.get("SRC"), data.get("FROM_EMAIL"));
                data.put("DROP_LOG", "true");
            } else if (srcMap != null && srcMap.containsKey(data.get("SRC"))) {
                data.put("TO_EMAIL", (String)srcMap.get(data.get("SRC")));
                srcMap.remove(data.get("SRC"));
            } else {
                data.put("DROP_LOG", "true");
            }
            data.put("RECORD_TYPE", "spam");
        }
    }

    @Override
    public void checkPriority(Hashtable data) {
        super.checkPriority(data);
        if (data == null) {
            return;
        }
        try {
            int pri = Integer.parseInt((String)data.get("PRIORITY"));
            if (pri > 7) {
                data.put("PRIORITY", "" + (pri %= 8));
            }
            if (data.get("DROP_LOG") != null && pri < 5) {
                data.put("EVENT_TYPE", PureFirewallConstants.HIGH_SEVERITY_LOG);
                if (!"true".equals(data.get("ADMINLOG")) || data.get("SRC") != null) {
                    data.remove("DROP_LOG");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Timestamp getTimeStamp(Hashtable data) {
        SimpleDateFormat sdf = new SimpleDateFormat((String)data.get("DATE_FORMAT"));
        long time = System.currentTimeMillis();
        try {
            time = sdf.parse((String)data.get("DATE_STRING")).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Timestamp(time);
    }
}

