/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import java.sql.Timestamp;
import java.util.Hashtable;

public class PIXVPNObject {
    private String resource = null;
    private String tunnel_id = null;
    private String tran_ip = null;
    private Long sent = new Long(0L);
    private Long rcvd = new Long(0L);
    private String source = null;
    private String user = null;
    private String virtualInterface = null;
    private String vpn = null;
    private String groupVpn = null;
    private Timestamp timestamp = null;
    private Timestamp startTime;

    public PIXVPNObject(Hashtable data) {
        this.resource = (String)data.get("RESOURCE");
        this.tunnel_id = (String)data.get("TUNNEL_ID");
        this.tran_ip = (String)data.get("TRAN_IP");
        this.sent = (Long)data.get("SENT");
        this.rcvd = (Long)data.get("RECEIVED");
        this.source = (String)data.get("SRC");
        this.user = (String)data.get("USER");
        this.virtualInterface = (String)data.get("VIRT_INT_ID");
        this.vpn = (String)data.get("VPN");
        this.groupVpn = (String)data.get("GROUP_VPN");
        this.timestamp = (Timestamp)data.get("TIME");
        this.startTime = new Timestamp(System.currentTimeMillis());
    }

    public String getVPNName() {
        return this.vpn;
    }

    public void setVPNName(String vpn) {
        this.vpn = vpn;
    }

    public Timestamp getVPNTime() {
        return this.timestamp;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getTunnelId() {
        return this.tunnel_id;
    }

    public void setTunnelId(String tunnel) {
        this.tunnel_id = tunnel;
    }

    public String getTranIp() {
        if (this.tran_ip == null) {
            this.tran_ip = this.source;
        }
        return this.tran_ip;
    }

    public void setTranIp(String tranip) {
        this.tran_ip = tranip;
    }

    public Long getSentBytes() {
        return this.sent;
    }

    public void setSentBytes(Long bytes) {
        this.sent = bytes;
    }

    public Long getRcvdBytes() {
        return this.rcvd;
    }

    public void setRcvdBytes(Long bytes) {
        this.rcvd = bytes;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getVirtualInterface() {
        return this.virtualInterface;
    }

    public void setVirtualInterface(String vInterface) {
        this.virtualInterface = vInterface;
    }

    public long getLiveDuration() {
        long liveDuration = (System.currentTimeMillis() - this.startTime.getTime()) / 1000L;
        return liveDuration;
    }

    public void setGroupVpn(String groupVpn) {
        this.groupVpn = groupVpn;
    }

    public String getGroupVpn() {
        return this.groupVpn;
    }
}

