/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.rules.FwConfigMgmt;
import com.adventnet.la.LaCacheManager;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

public class SRXUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(SRXUnifier.class.getName());
    private static final Integer TYPE = new Integer(11);
    private static boolean telnetdevice = false;
    private HashMap l3ProtocolMap = new HashMap();
    private static Map appMap = new HashMap();
    private FwConfigMgmt configMgmt = null;

    public SRXUnifier() {
        this.l3ProtocolMap.put("17", "udp");
        this.l3ProtocolMap.put("6", "tcp");
        this.l3ProtocolMap.put("1", "icmp");
        this.configMgmt = FwConfigMgmt.getInstance();
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        if ("true".equals((String)data.get("DROP_LOG"))) {
            return null;
        }
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        this.handleTime(data);
        if (!this.checkAdminLog(data, host)) {
            return null;
        }
        this.handleSrcDst(data);
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        this.checkForVPN(data);
        this.checkProtocol(data);
        this.checkSrcDstInterfaces(data, "FW");
        this.checkForLearnMe(data);
        this.handleStatus(data);
        this.handlePriority(data);
        if (this.checkApplication(data)) {
            return null;
        }
        return data;
    }

    private void checkForVPN(Hashtable data) {
        String vpnIdentifier = (String)data.get("VPN_IDENTIFIER");
        if (vpnIdentifier != null && vpnIdentifier.toLowerCase().contains("vpn")) {
            data.put("VPN", vpnIdentifier);
            data.put("li", "1");
        }
    }

    private boolean checkAdminLog(Hashtable data, String host) {
        String dummySrc = "0.0.0.0";
        if (data.get("ADMINLOG") != null) {
            data.put("DEST", host);
            String type = (String)data.get("SUBTYPE");
            if (data.get("SRCIP") != null) {
                data.put("SRC", data.get("SRCIP"));
                data.put("SUBTYPE", 1);
                data.put("STATUS", "Success");
                telnetdevice = true;
                return true;
            }
            data.put("SRC", dummySrc);
            if (type != null && type.indexOf("command") > -1) {
                data.put("SUBTYPE", "4");
            } else {
                type = "login".equals(type) ? "1" : "2";
                data.put("SUBTYPE", type);
                data.put("STATUS", "Success");
                if ("2".equals(type)) {
                    try {
                        String changedBy = (String)data.get("USERNAME");
                        String resource = (String)data.get("FW");
                        Long rID = (Long)LaCacheManager.getInstance().getFirewallId(resource);
                        this.configMgmt.initiateConfigFetching("SRX Log Format", resource, changedBy, rID);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (telnetdevice) {
                    telnetdevice = false;
                    return false;
                }
            }
            data.put("PROTOCOL", "Unknown");
        }
        return true;
    }

    private void checkProtocol(Hashtable data) {
        if (data.get("L3_PROTOCOL") != null) {
            try {
                String destPort;
                String protocol = (String)data.get("L3_PROTOCOL");
                String l3Proto = (String)this.l3ProtocolMap.get(protocol);
                Integer dstPort = (Integer)data.get("DEST_PORT");
                if (l3Proto != null) {
                    protocol = !"icmp".equals(l3Proto) && dstPort != null ? dstPort + "/" + l3Proto : l3Proto;
                } else if ((protocol.equalsIgnoreCase("UDP") || protocol.equalsIgnoreCase("TCP")) && (destPort = data.get("DEST_PORT").toString()) != null) {
                    protocol = destPort + "/" + protocol;
                }
                data.put("PROTOCOL", protocol);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handlePriority(Hashtable data) {
        try {
            int pri;
            if (data.get("PRIORITY") != null && (pri = Integer.parseInt((String)data.get("PRIORITY"))) > 7) {
                data.put("PRIORITY", "" + (pri %= 8));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void handleSrcDst(Hashtable data) {
        String recordType = (String)data.get("RECORD_TYPE");
        if ("attack".equals(recordType)) {
            if (data.get("SRC") == null) {
                data.put("SRC", "unknown");
            }
            if (data.get("DEST") == null) {
                data.put("DEST", "unknown");
            }
            try {
                String source = (String)data.get("SRC");
                if (source.contains(":")) {
                    String[] src = source.split(":");
                    String dest = (String)data.get("DEST");
                    String[] dst = dest.split(":");
                    data.put("SRC", src[0]);
                    data.put("SRC_PORT", src[1]);
                    data.put("DEST", dst[0]);
                    data.put("DEST_PORT", dst[1]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void handleStatus(Hashtable data) {
        String rcdType = (String)data.get("RECORD_TYPE");
        if (rcdType != null && !"mgmt".equals(rcdType)) {
            String attackName = (String)data.get("VIRUS");
            String status = (String)data.get("STATUS");
            if ("URL Blocked".equals(status) || "DROP".equalsIgnoreCase(status) || "deny".equals(status)) {
                data.put("STATUS", "denied");
            } else {
                data.put("STATUS", "permit");
            }
            if (attackName != null) {
                if ("Port scan".equals(attackName = attackName.replace("!", ""))) {
                    data.put("VIRUS", "PortScan");
                } else {
                    data.put("VIRUS", attackName);
                }
            }
            if ("webfilter".equals(rcdType) && data.get("URL") != null && data.get("OBJ") != null) {
                String url = (String)data.get("URL");
                String obj = (String)data.get("OBJ");
                data.put("REQUEST", url + obj);
            }
            if ("attack".equals(rcdType) && data.get("VIRUS") == null) {
                data.put("VIRUS", (String)data.get("ATTACK"));
            }
        }
    }

    private void handleTime(Hashtable data) {
        try {
            String dateFormat = (String)data.get("DATE_FORMAT");
            if (dateFormat != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                String dateString = (String)data.get("DATE_STRING");
                if (dateString != null) {
                    if (data.get("NO_YEAR") != null) {
                        GregorianCalendar cal = new GregorianCalendar();
                        int year = cal.get(1);
                        cal.setTime(sdf.parse(dateString));
                        cal.set(1, year);
                        data.put("TIME", new Timestamp(cal.getTime().getTime()));
                    }
                } else {
                    String time = (String)data.remove("TIMEINMILLI");
                    data.put("TIME", sdf.format(new Date(new Long(time))));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkApplication(Hashtable data) {
        String mapKey = (String)data.get("MAP_KEY");
        if (mapKey != null && data.get("APP") != null) {
            String app = (String)data.get("APP");
            String nestedApp = (String)data.get("NESTED_APP");
            if (!nestedApp.equals("UNKNOWN")) {
                app = app + "-(" + nestedApp + ")";
            }
            appMap.put(mapKey, app);
            data.clear();
            return true;
        }
        if (data.get("SENT") != null && appMap.containsKey(mapKey)) {
            data.put("TRAN_PORT", appMap.get(mapKey));
        }
        return false;
    }
}

