/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SidewinderLogUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(AbstractLogUnifier.class.getName());
    private static final Integer TYPE = new Integer(1);
    private Map idMap = Collections.synchronizedMap(new FixedHashMap());
    private Pattern loginPattern = null;
    private HashSet typeSet = new HashSet();

    public SidewinderLogUnifier() {
        this.loginPattern = Pattern.compile("from\\s*(\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3})");
        this.typeSet.add("t_http_req");
        this.typeSet.add("t_dns_req");
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        String logType;
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        if (this.typeSet.contains(logType = (String)data.get("LOGTYPE"))) {
            return null;
        }
        this.assignPreParserTime(data);
        String sessionId = (String)data.get("SESSIONID");
        long logTime = ((Timestamp)data.get("TIME")).getTime();
        if (sessionId != null) {
            if (this.idMap.get(sessionId) == null) {
                this.idMap.put(sessionId, logTime);
            } else {
                long startTime = (Long)this.idMap.remove(sessionId);
                long duration = (logTime - startTime) / 1000L;
                data.put("DURATION", duration);
            }
        }
        if (data.get("START_TIME") != null && data.get("STARTDATE_FORMAT") != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(data.get("STARTDATE_FORMAT").toString());
                long startTime = new Timestamp(format.parse(data.get("START_TIME").toString()).getTime()).getTime();
                long duration = (logTime - startTime) / 1000L;
                data.put("DURATION", duration);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                LOGGER.log(Level.FINER, " Exception while parsing Start Date");
            }
        }
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        this.checkAdminSupport(data);
        if (data.get("SRC") == null) {
            return null;
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        this.handleProtocol(data);
        this.checkPriority(data);
        this.checkSrcDstInterfaces(data, "FW");
        data.put("FW_TYPE", "Sidewinder");
        data.put("LOG_FORMAT", "Sidewinder SEF");
        return data;
    }

    private void handleProtocol(Hashtable data) {
        String l3Proto = (String)data.get("PROTO");
        if (l3Proto != null) {
            if (l3Proto.equals("47")) {
                data.put("PROTOCOL", "gre");
            } else {
                l3Proto = this.getStringL3Protocol(l3Proto);
                data.put("L3_PROTOCOL", l3Proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    l3Proto = destPort.toString() + "/" + l3Proto;
                }
                data.put("PROTOCOL", l3Proto);
            }
        }
        super.checkForLearnMe(data);
    }

    private void checkAdminSupport(Hashtable data) {
        String command = (String)data.get("CMD");
        String msg = (String)data.get("MSG");
        if (command == null || msg == null) {
            return;
        }
        data.put("li", "1");
        if (command.indexOf("login") > -1) {
            data.put("EVENT_TYPE", new Integer("1"));
            if ("1".equals(data.get("RESULT"))) {
                data.put("SUBTYPE", "1");
            } else {
                data.put("SUBTYPE", "3");
            }
            Matcher m = this.loginPattern.matcher(msg);
            String src = null;
            if (m.find()) {
                src = m.group(1);
                data.put("SRC", src);
                if (data.get("DEST") == null) {
                    data.put("DEST", data.get("FW"));
                }
            }
        }
    }
}

