/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class SonicwallSSLVPNUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(SonicwallSSLVPNUnifier.class.getName());
    private static final Integer TYPE = new Integer(23);
    private Map fwToVpnMap = new HashMap();
    private Map fwToterminatedVpnMap = new HashMap();
    private boolean isNetExtender = false;

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        if (data.get("FW") == null) {
            data.put("FW", host);
        }
        data.put("VPN", "SSLVPN");
        data.put("li", "1");
        data.put("rtype", TYPE);
        this.checkPriority(data);
        this.handleTime(data);
        this.handleSonicwallSSL(data, host);
        if ("true".equals(data.get("DROP_LOG"))) {
            return null;
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION"};
        this.strToLong(strToLong, data);
        data.put("li", "1");
        return data;
    }

    private void handleTime(Hashtable data) {
        String time = (String)data.get("DATE_STRING");
        String dateFormat = (String)data.get("DATE_FORMAT");
        if (time == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            data.put("TIME", new Timestamp(sdf.parse(time).getTime()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void handleSonicwallSSL(Hashtable data, String host) {
        String msg = (String)data.get("MSG");
        String usr = (String)data.get("USERNAME");
        Map vpnObjMap = (Map)this.fwToVpnMap.get(data.get("FW"));
        if (msg != null) {
            if (msg.indexOf("login successful") > -1) {
                this.addVPNObject(data, host);
            } else if (msg.indexOf("uniqueness enforcement") > -1) {
                this.removeVPNObject(data, host);
            } else if (msg.indexOf("NetExtender connected") > -1) {
                if (vpnObjMap != null && vpnObjMap.get(usr) != null) {
                    PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(usr);
                    this.fwToterminatedVpnMap.put(data.get("FW") + usr + data.get("SRC"), vpnObj);
                }
            } else {
                if (msg.indexOf("failed") > -1) {
                    data.put("EVENT_TYPE", new Integer(10));
                    data.put("li", "1");
                    data.remove("VPN");
                    return;
                }
                if (msg.indexOf("NetExtender disconnected") > -1) {
                    String key = data.get("FW") + usr + data.get("SRC");
                    if (this.fwToterminatedVpnMap.get(key) != null) {
                        PIXVPNObject vpnObj = (PIXVPNObject)this.fwToterminatedVpnMap.remove(key);
                        data.put("TRAN_IP", data.get("SRC"));
                        data.put("SRC", vpnObj.getSource());
                        data.put("GROUP_VPN", vpnObj.getGroupVpn());
                    }
                    data.remove("DEST");
                    this.isNetExtender = true;
                    return;
                }
                if (msg.indexOf("logged out") > -1) {
                    PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(usr);
                    if (!this.isNetExtender) {
                        data.remove("DEST");
                        return;
                    }
                    data.put("DROP_LOG", "true");
                }
            }
        }
        data.put("DROP_LOG", "true");
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String user;
            String resource = (String)data.get("FW");
            String dummyKey = user = (String)data.get("USERNAME");
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            vpnObj.setVPNName((String)data.remove("VPN"));
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            vpnObjMap.put(dummyKey, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            String user;
            data.remove("DEST");
            String resource = (String)data.get("FW");
            String dummyKey = user = (String)data.get("USERNAME");
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(dummyKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }
}

