/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.PureFirewallConstants;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.la.util.FixedHashMap;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

public class StonesoftUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(StonesoftUnifier.class.getName());
    private static final Integer TYPE = new Integer(38);
    private FACacheManager fCache = FACacheManager.getInstance();
    private Map conOpen = null;

    public StonesoftUnifier() {
        this.addStoneSoftPriority();
        this.conOpen = Collections.synchronizedMap(new FixedHashMap(10000));
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        String resource = (String)data.get("FW");
        data.put("RESOURCE", resource);
        data.put("FW_TYPE", "STONESOFT");
        data.put("LOG_FORMAT", "CEF");
        String type = (String)data.get("TYPE");
        this.checkProtocolSyntax(data);
        this.handleTime(data);
        String priority = this.handlePriority(data);
        data.put("PRIORITY", priority);
        if ("IPS".equals(type)) {
            data.put("RECORD_TYPE", "ATTACK");
            String attack = (String)data.get("SITUATION");
            if ("Connection_Allowed".equals(attack) || "Connection_Closed".equals(attack)) {
                return null;
            }
            this.handleAttack(data);
        } else if ("Firewall".equals(type)) {
            data.put("RECORD_TYPE", "traffic");
            boolean dropLog = this.handleTraffic(data);
            if (dropLog) {
                return null;
            }
            this.checkSrcDstInterfaces(data, "FW");
        } else {
            data.clear();
            return null;
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "BYTES", "DURATION", "SENT_PKT", "RECEIVED_PKT", "STATUS_CODE"};
        this.strToLong(strToLong, data);
        data.put("FW", data.get("RESOURCE"));
        return data;
    }

    private void handleAttack(Hashtable data) {
        if ("Permit".equals((String)data.get("STATUS"))) {
            data.put("STATUS", "permit");
        } else {
            data.put("STATUS", "deny");
        }
        data.put("VIRUS", (String)data.get("SITUATION"));
        data.put("li", "1");
        data.put("EVENT_TYPE", PureFirewallConstants.ATTACK_LOG);
    }

    private boolean handleTraffic(Hashtable data) {
        block16: {
            String situation = (String)data.get("SITUATION");
            HashMap temp = new HashMap();
            String srcint = (String)data.get("SRC_INTERFACE");
            String dstint = (String)data.get("DST_INTERFACE");
            srcint = srcint != null ? srcint.replace("#", "") : srcint;
            String string = dstint = dstint != null ? dstint.replace("#", "") : dstint;
            if (srcint != null) {
                data.put("SRC_INTERFACE", srcint);
            }
            if (dstint != null) {
                data.put("DST_INTERFACE", dstint);
            }
            String key = (String)data.get("FW") + (String)data.get("SRC_PORT") + (String)data.get("SRC") + (String)data.get("DEST") + (String)data.get("DST_PORT");
            try {
                if ("Connection_Allowed".equals(situation)) {
                    temp.put("TIME", (String)data.get("DATE_STRING"));
                    temp.put("STATUS", (String)data.get("STATUS"));
                    temp.put("SRC_INTERFACE", srcint);
                    temp.put("DST_INTERFACE", dstint);
                    temp.put("RULE", (String)data.get("RULE"));
                    this.conOpen.put(key, temp);
                    data.clear();
                    return true;
                }
                if ("Connection_Closed".equals(situation) || "Connection_Closed-Abnormally".equals(situation)) {
                    if (this.conOpen.containsKey(key)) {
                        String cat;
                        String url;
                        String dstInterface;
                        HashMap open = (HashMap)this.conOpen.get(key);
                        this.checkForDuration(data, open);
                        data.put("STATUS", "permit");
                        String srcInterface = (String)open.get("SRC_INTERFACE");
                        if (srcInterface != null) {
                            data.put("SRC_INTERFACE", srcInterface);
                        }
                        if ((dstInterface = (String)open.get("DST_INTERFACE")) != null) {
                            data.put("DST_INTERFACE", dstInterface);
                        }
                        if ((url = (String)open.get("URL")) != null) {
                            data.put("REQUEST", url);
                        }
                        if ((cat = (String)open.get("CAT")) != null) {
                            data.put("CATEGORY", cat);
                        }
                        data.put("RULE", (String)open.get("RULE"));
                        data.put("PRIORITY", "6");
                        this.conOpen.remove(key);
                        open.clear();
                    }
                    break block16;
                }
                if ("Connection_Discarded".equals(situation)) {
                    data.put("STATUS", "deny");
                    data.put("li", "1");
                    data.put("PRIORITY", "4");
                    data.put("DURATION", new Long(0L));
                    break block16;
                }
                if (data.get("REQUEST") != null) {
                    String action = (String)data.get("STATUS");
                    if ("Terminate".equals(action)) {
                        data.put("EVENT_TYPE", "6");
                    } else if (this.conOpen.containsKey(key)) {
                        temp = (HashMap)this.conOpen.get(key);
                        temp.put("URL", (String)data.get("REQUEST"));
                        temp.put("CAT", (String)data.get("CATEGORY"));
                        this.conOpen.put(key, temp);
                        return true;
                    }
                    break block16;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.localHandleNull(data);
            }
        }
        return false;
    }

    private String handlePriority(Hashtable data) {
        String priority = (String)data.get("PRIORITY");
        if (priority != null) {
            int pri = Integer.parseInt(priority);
            if (pri > 7 && pri < 11) {
                return "Critical";
            }
            if (pri > 4 && pri < 8) {
                return "High";
            }
            if (pri > 1 && pri < 5) {
                return "Low";
            }
        }
        return "Information";
    }

    public void checkProtocolSyntax(Hashtable data) {
        String l3Proto = (String)data.get("L3_PROTOCOL");
        if (l3Proto != null) {
            if (l3Proto.equals("47")) {
                data.put("PROTOCOL", "gre");
            } else {
                l3Proto = this.getStringL3Protocol(l3Proto);
                data.put("L3_PROTOCOL", l3Proto);
                Object destPort = data.get("DEST_PORT");
                if (destPort != null) {
                    String proto = destPort.toString() + "/" + l3Proto;
                    data.put("PROTOCOL", proto);
                }
                data.put("LEARNME", l3Proto);
                this.checkForLearnMe(data);
            }
        }
    }

    private void checkForDuration(Hashtable data, HashMap tmp) {
        String endTime = (String)data.get("DATE_STRING");
        String startTime = (String)tmp.get("TIME");
        if (startTime != null && endTime != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
                Date sDate = format.parse(startTime);
                Date eDate = format.parse(endTime);
                long sTime = sDate.getTime();
                long eTime = eDate.getTime();
                long duration = (eTime - sTime) / 1000L;
                data.put("DURATION", duration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleTime(Hashtable data) {
        String dateFormat = (String)data.get("DATE_FORMAT");
        String dateString = (String)data.get("DATE_STRING");
        try {
            if (dateString != null && dateFormat != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                long time = sdf.parse(dateString).getTime();
                Timestamp timeModified = new Timestamp(time);
                data.put("TIME", timeModified);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addStoneSoftPriority() {
        String[] pri = new String[]{"8", "9"};
        String[] PriName = new String[]{"High", "Low"};
        FixedHashMap priMap = this.fCache.prioritiesMap;
        try {
            for (int i = 0; i < 2; ++i) {
                if (priMap.containsKey((Object)PriName[i].toLowerCase())) continue;
                DataObject dao = DataAccess.constructDataObject();
                Row r = new Row("Priorities");
                r.set(2, (Object)pri[i]);
                r.set(3, (Object)PriName[i]);
                dao.addRow(r);
                DataAccess.add((DataObject)dao);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.fCache.loadPriorities();
    }

    private void localHandleNull(Hashtable data) {
        if (data.get("SENT") == null) {
            data.put("SENT", new Long(0L));
        }
        if (data.get("RECEIVED") == null) {
            data.put("RECEIVED", new Long(0L));
        }
        if (data.get("DURATION") == null) {
            data.put("DURATION", new Long(0L));
        }
    }
}

