/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreeComUnifier
extends AbstractLogUnifier {
    private static final Integer TYPE = new Integer(1);
    private static final Logger LOGGER = Logger.getLogger(ThreeComUnifier.class.getName());
    private Hashtable hTable = new Hashtable();
    private Hashtable resName = new Hashtable();
    private Map fwToVpnMap = new HashMap();
    private Pattern vpnLogPattern = Pattern.compile("(\\w+)\\s+Tunnel\\s+\\w+\\s*:\\s*(\\S+)/([^\\,]*),?\\s*client_addr\\s*=\\s*(\\S+)\\s*(.*Bytes:(\\d*).*Bytes:(\\d*))?");
    private Pattern protocolPattern = Pattern.compile("([^\\(]*).*");
    private Pattern auditField = Pattern.compile("\\w+=\\[?([^\\]]*)\\]?");
    private Pattern auditLog = Pattern.compile("\\w+=\\[(\\S*)\\]\\s*\\w+=(\\S*)\\s*\\w+=(\\S*)\\s*\\w+=(\\S*)\\s*(.*)");
    private Pattern fwsMsgPattern = Pattern.compile("[^\\:]*:(.*)\\s*profile:[^\\,]*,((.*)(denies|match))");
    private Pattern sentRcvdPattern = Pattern.compile("Sent Bytes:(\\d*)\\s+Recv Bytes:(\\d*)\\s+Sent Packets:(\\d*)\\s+Recv Packets:(\\d*)\\s*(User:([^:]*))?");
    private Pattern dateWithYr = Pattern.compile("\\w+\\s+\\d{1,2}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}\\s+\\d{4}");

    public ThreeComUnifier() {
        this.mailProtocols.add("ftp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        block57: {
            Matcher m;
            String deviceName;
            String protocolStr;
            String msg;
            String logType;
            String fwName;
            block59: {
                String priString;
                this.splitFields(data);
                fwName = (String)this.resName.get(host);
                if (fwName == null && !"".equals(fwName = (String)data.get("FW")) && fwName != null) {
                    this.resName.put(host, fwName);
                }
                if ((priString = (String)data.get("PRIORITY")) != null) {
                    try {
                        int pri = Integer.parseInt((String)data.get("PRIORITY"));
                        data.put("PRIORITY", "" + pri % 8);
                    }
                    catch (Exception ee) {
                        LOGGER.log(Level.INFO, ee.toString() + " Priority ::" + priString);
                    }
                }
                logType = (String)data.get("3C_KEY");
                msg = (String)data.get("MSG");
                this.handleDest(data);
                protocolStr = (String)data.get("PROTOCOL");
                if (!"fws".equals(logType)) break block59;
                if (msg == null) {
                    return null;
                }
                String srcandport = (String)data.get("SRC") + data.get("SRC_PORT");
                if (msg.indexOf("Session ended") > -1) {
                    try {
                        FixedHashMap fixedMap = (FixedHashMap)this.hTable.get(host);
                        Properties prop = null;
                        if (fixedMap != null) {
                            prop = (Properties)fixedMap.remove((Object)srcandport);
                        }
                        this.assignProtocol(data, protocolStr);
                        this.handleSentRcvd(data, prop);
                        if (prop != null) {
                            data.putAll(prop);
                        }
                        break block57;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block57;
                } else {
                    if (msg.indexOf("Web Filter") > -1) {
                        FixedHashMap fixedMap = (FixedHashMap)this.hTable.get(host);
                        if (fixedMap == null) {
                            fixedMap = new FixedHashMap(15000);
                            this.hTable.put(host, fixedMap);
                        }
                        Properties prop = new Properties();
                        prop.setProperty("REQUEST", (String)data.get("REQUEST"));
                        prop.setProperty("CATEGORY", (String)data.get("CATEGORY"));
                        prop.setProperty("MSG", msg);
                        Matcher m2 = this.fwsMsgPattern.matcher(msg);
                        if (m2.matches()) {
                            String uname = m2.group(1);
                            uname = uname.trim();
                            prop.setProperty("USERNAME", uname);
                            String str = m2.group(2);
                            if (str.endsWith("denies")) {
                                String rule = m2.group(3);
                                rule = rule.trim();
                                prop.put("RULE", rule);
                                prop.put("STATUS", "deny");
                                prop.put("li", "1");
                            } else {
                                prop.put("STATUS", "permit");
                            }
                        }
                        fixedMap.put((Object)srcandport, (Object)prop);
                        return null;
                    }
                    if (msg.indexOf("Secondary Session Start") <= -1) {
                        return null;
                    }
                    FixedHashMap fixedMap = (FixedHashMap)this.hTable.get(host);
                    if (fixedMap == null) {
                        fixedMap = new FixedHashMap(15000);
                        this.hTable.put(host, fixedMap);
                    }
                    Properties prop = new Properties();
                    prop.setProperty("PROTOCOL", "ftp");
                    fixedMap.put((Object)srcandport, (Object)prop);
                    return null;
                }
            }
            if ("BLK".equals(logType)) {
                block58: {
                    this.appendYrInfo(data);
                    deviceName = (String)data.get("HOSTNAME");
                    if ("".equals(deviceName) || deviceName == null) {
                        if (fwName != null) {
                            data.put("FW", fwName);
                        }
                    } else {
                        int i = deviceName.indexOf(47);
                        if (i > -1) {
                            deviceName = deviceName.substring(0, i);
                        }
                        deviceName = super.getQuotesTrimmed(deviceName);
                        data.put("FW", deviceName.trim());
                    }
                    String filterPro = (String)data.get("FILTERPROTOCOL");
                    try {
                        String tempStr = (String)data.get("SIGNNAME");
                        if (!filterPro.equalsIgnoreCase("firewall")) {
                            protocolStr = filterPro;
                            String[] rule = tempStr.split("\\:");
                            data.put("RULE", rule[0]);
                            break block58;
                        }
                        if (tempStr.startsWith("7402")) {
                            tempStr = (String)data.get("MESSAGEPARAMS");
                            String[] param = tempStr.split("\\|");
                            data.put("CATEGORY", param[1]);
                            data.put("MSG", param[2].trim());
                            data.put("REQUEST", param[3].trim());
                            data.put("RECORD_TYPE", "webfilter");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                String status = (String)data.get("STATUS");
                if (status.equalsIgnoreCase("block")) {
                    data.put("STATUS", "deny");
                    data.put("li", "1");
                }
                this.assignProtocol(data, protocolStr);
            } else if ("ALT".equals(logType)) {
                this.appendYrInfo(data);
                deviceName = (String)data.get("HOSTNAME");
                if ("".equals(deviceName) || deviceName == null) {
                    if (fwName != null) {
                        data.put("FW", fwName);
                    }
                } else {
                    int i = deviceName.indexOf(47);
                    if (i > -1) {
                        deviceName = deviceName.substring(0, i);
                    }
                    deviceName = super.getQuotesTrimmed(deviceName);
                    data.put("FW", deviceName.trim());
                }
                data.put("RECORD_TYPE", "attack");
                data.put("li", "1");
                try {
                    String params = (String)data.get("SIGNNAME");
                    String[] temp = params.split("\\:");
                    String virus = temp[1] + temp[2];
                    data.put("VIRUS", virus.trim());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                data.remove("RULE");
                protocolStr = (String)data.get("FILTERPROTOCOL");
                this.assignProtocol(data, protocolStr);
            } else if ("vpn".equals(logType)) {
                if (msg == null) {
                    return null;
                }
                if (msg.indexOf("Tunnel Established") > -1) {
                    Matcher m3 = this.vpnLogPattern.matcher(msg);
                    if (m3.matches()) {
                        data.put("VPN", m3.group(1));
                        data.put("PROTOCOL", m3.group(1));
                        data.put("USERNAME", m3.group(2));
                        data.put("SRC", m3.group(3));
                        data.put("DEST", host);
                        data.put("TRAN_IP", m3.group(4));
                    }
                    data.put("li", "1");
                    this.addVPNObject(data, host);
                    return null;
                }
                if (msg.indexOf("Tunnel Terminated") <= -1) {
                    return null;
                }
                String sentRcvd = (String)data.get("SENTANDRCVD");
                if (sentRcvd != null) {
                    msg = msg + " " + sentRcvd;
                }
                if ((m = this.vpnLogPattern.matcher(msg)).matches()) {
                    data.put("VPN", m.group(1));
                    data.put("PROTOCOL", m.group(1));
                    data.put("USERNAME", m.group(2));
                    data.put("SRC", m.group(3));
                    data.put("DEST", host);
                    data.put("TRAN_IP", m.group(4));
                    sentRcvd = m.group(5);
                    if (sentRcvd != null && !"".equals(sentRcvd)) {
                        data.put("SENT", m.group(6));
                        data.put("RECEIVED", m.group(7));
                    }
                }
                data.put("li", "1");
                this.removeVPNObject(data, host);
                this.handleSpecialChars(data, new String[]{"USER"});
            } else if ("audit".equals(logType)) {
                String src;
                if (msg == null) {
                    String user = (String)data.get("USER");
                    if (user == null) {
                        return null;
                    }
                    m = this.auditLog.matcher(user);
                    if (!m.matches()) {
                        return null;
                    }
                    data.put("USERNAME", m.group(1));
                    data.put("SRC", m.group(2));
                    data.put("INTERFACE", m.group(3));
                    data.put("ACCESS", m.group(4));
                    msg = m.group(5);
                    data.put("MSG", msg);
                }
                data.put("DEST", "0.0.0.0");
                data.put("EVENT_TYPE", "1");
                data.put("li", "1");
                if (msg.indexOf("Logged into") > -1) {
                    data.put("SUBTYPE", "1");
                } else if (msg.indexOf("Logged out") > -1) {
                    data.put("SUBTYPE", "2");
                } else {
                    if (msg.indexOf("Invalid password") <= -1) {
                        return null;
                    }
                    data.put("SUBTYPE", "3");
                }
                String uname = (String)data.get("USER");
                m = this.auditField.matcher(uname);
                if (m.matches()) {
                    uname = m.group(1);
                    data.put("USERNAME", uname.trim());
                }
                if ((m = this.auditField.matcher(src = (String)data.get("SRC"))).matches()) {
                    data.put("SRC", m.group(1));
                }
            }
        }
        this.assignPreParserTime(data);
        data.put("SYSLOGIP", host);
        data.put("rtype", TYPE);
        data.put("FW_TYPE", "3COM");
        data.put("LOG_FORMAT", "3COM_NATIVE");
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT", "EVENT_TYPE"};
        this.strToInt(strToInt, data);
        String[] strToLong = new String[]{"SENT", "RECEIVED", "DURATION", "SENT_PKT", "RECEIVED_PKT", "TRAN_PORT", "STATUS_CODE", "POLICY_ID"};
        this.strToLong(strToLong, data);
        super.checkForLearnMe(data);
        return data;
    }

    private void splitFields(Hashtable data) {
        String head = (String)data.get("HEAD");
        String[] keys = head.split(",");
        String log = (String)data.get("LOG");
        String[] values = log.split("\\t");
        for (int i = 0; i < values.length; ++i) {
            String val = values[i];
            if (val == null) {
                return;
            }
            val = val.trim();
            val = super.getQuotesTrimmed(val);
            data.put(keys[i], val);
            LOGGER.log(Level.FINER, " Log attribute : " + keys[i] + " --> " + val);
        }
        String year = (String)data.get("YEAR");
        if (year != null) {
            String date_fmt = (String)data.get("DATE_FORMAT");
            data.put("DATE_FORMAT", date_fmt + " yyyy");
            data.remove("NO_YEAR");
        }
    }

    @Override
    public void flushMemory(String host) {
        LOGGER.log(Level.FINER, host + " removed from 3COM map");
        this.resName.remove(host);
    }

    private void assignProtocol(Hashtable data, String protocolStr) {
        Matcher m;
        if (protocolStr != null && (m = this.protocolPattern.matcher(protocolStr)).matches()) {
            String temp = m.group(1).trim();
            if ("tcp".equalsIgnoreCase(temp) || "udp".equalsIgnoreCase(temp)) {
                String protocolPort = (String)data.get("DEST_PORT");
                protocolStr = protocolPort + "/" + temp;
                data.put("L3_PROTOCOL", temp);
            } else {
                protocolStr = temp;
            }
            data.put("PROTOCOL", protocolStr);
        }
    }

    private void handleSentRcvd(Hashtable data, Properties memProp) {
        String sentandrcvd = (String)data.get("SENTANDRCVD");
        if (sentandrcvd != null) {
            Matcher m = this.sentRcvdPattern.matcher(sentandrcvd);
            if (m.matches()) {
                data.put("SENT", m.group(1));
                data.put("RECEIVED", m.group(2));
                data.put("SENT_PKT", m.group(3));
                data.put("RECEIVED_PKT", m.group(4));
                String uname = m.group(6);
                if (uname != null) {
                    uname = uname.trim();
                    data.put("USERNAME", uname);
                }
            }
        } else {
            String protocol = null;
            if (memProp != null) {
                protocol = memProp.getProperty("PROTOCOL");
            }
            if (protocol == null) {
                protocol = (String)data.get("PROTOCOL");
            }
            if (this.mailProtocols.contains(protocol)) {
                data.put("SENT", (String)data.get("BYTES"));
            } else {
                data.put("RECEIVED", (String)data.get("BYTES"));
            }
        }
    }

    private void addVPNObject(Hashtable data, String host) {
        try {
            String resource = this.resName.get(host).toString();
            String user = (String)data.get("USERNAME");
            data.put("TIME", this.getTimeStamp(data));
            PIXVPNObject vpnObj = new PIXVPNObject(data);
            vpnObj.setResource(resource);
            vpnObj.setUser(user);
            Map<String, PIXVPNObject> vpnObjMap = (Map<String, PIXVPNObject>)this.fwToVpnMap.get(resource);
            if (vpnObjMap == null) {
                vpnObjMap = Collections.synchronizedMap(new FixedHashMap(800));
                this.fwToVpnMap.put(resource, vpnObjMap);
            }
            vpnObjMap.put(user, vpnObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeVPNObject(Hashtable data, String host) {
        try {
            String resource = this.resName.get(host).toString();
            String user = (String)data.get("USERNAME");
            Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
            if (vpnObjMap != null) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.remove(user);
                long duration = 0L;
                if (vpnObj != null) {
                    Timestamp startTime = vpnObj.getVPNTime();
                    Timestamp endTime = this.getTimeStamp(data);
                    duration = endTime.getTime() - startTime.getTime();
                    duration /= 1000L;
                }
                data.put("DURATION", new Long(duration));
            } else {
                data.put("DURATION", new Long(0L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.fwToVpnMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private Timestamp getTimeStamp(Hashtable data) {
        SimpleDateFormat sdf = new SimpleDateFormat((String)data.get("DATE_FORMAT"));
        long time = System.currentTimeMillis();
        try {
            time = sdf.parse((String)data.get("DATE_STRING")).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Timestamp(time);
    }

    private void appendYrInfo(Hashtable data) {
        String hitTime = (String)data.get("HITTIME");
        if (hitTime != null) {
            String date_str = (String)data.get("DATE_STRING");
            String date_fmt = (String)data.get("DATE_FORMAT");
            date_str = date_str + hitTime.substring(0, 4);
            data.put("DATE_STRING", date_str);
            data.put("DATE_FORMAT", date_fmt + " yyyy");
            data.remove("NO_YEAR");
        }
    }
}

