/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnParsedFormatDataUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(UnParsedFormatDataUnifier.class.getName());
    private ArrayList resourceList = new ArrayList();
    private static Persistence persistence;

    public UnParsedFormatDataUnifier() {
        this.populateResourceList();
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        LOGGER.log(Level.FINER, "[UnParsedFormatDataUnifier.unifyData()] Called with " + data + " hashcode ::" + this.hashCode());
        if (!this.resourceList.contains(host)) {
            try {
                this.resourceList.add(host);
                Row row = new Row("UnParsedRecords");
                row.set("RESOURCE", (Object)host);
                row.set("RECORD", data.get("RECORD"));
                row.set("SYSLOG_SERVER", data.get("SYSLOG_SERVER"));
                DataObject obj = this.getPersistence().constructDataObject();
                obj.addRow(row);
                this.getPersistence().add(obj);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return null;
    }

    private void populateResourceList() {
        try {
            Table resourceTable = new Table("UnParsedRecords");
            SelectQueryImpl sqlImpl = new SelectQueryImpl(resourceTable);
            sqlImpl.addSelectColumn(new Column("UnParsedRecords", "*"));
            DataObject toReturn = this.getPersistence().get((SelectQuery)sqlImpl);
            Iterator itr = toReturn.getRows("UnParsedRecords");
            while (itr.hasNext()) {
                Row record = (Row)itr.next();
                this.resourceList.add((String)record.get("RESOURCE"));
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "[UnParsedRecords.populateResourceList()] Exception while Populated ResourceList");
            exp.printStackTrace();
        }
    }

    private Persistence getPersistence() {
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persistence;
    }

    @Override
    public void flushMemory(String resource) {
        boolean result = this.resourceList.remove(resource);
        LOGGER.log(Level.FINER, "Flushing Memory Unparsed Host List :::{0}", this.resourceList + " hashcode ::" + this.hashCode() + " result::" + result + " res ::" + resource);
    }
}

