/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.dc;

import com.adventnet.fa.server.dc.AbstractLogUnifier;
import com.adventnet.fa.server.dc.PIXVPNObject;
import com.adventnet.la.util.FixedHashMap;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VPNConcentratorUnifier
extends AbstractLogUnifier {
    private static final Logger LOGGER = Logger.getLogger(VPNConcentratorUnifier.class.getName());
    private static final Integer TYPE = new Integer(17);
    String ORG_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS";
    String IOS_DATE_FORMAT = "yyyy MMM dd HH:mm:ss.SSS";
    String ipRegEx = ".*?(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}).*";
    boolean srcValue = true;
    private FixedHashMap vpnHash = new FixedHashMap(100);
    private FixedHashMap tranIPHash = new FixedHashMap(100);
    private Map liveVPNMap = null;
    private Map userMap = Collections.synchronizedMap(new FixedHashMap(50));

    public VPNConcentratorUnifier() {
        this.liveVPNMap = Collections.synchronizedMap(new FixedHashMap(200));
    }

    @Override
    public Hashtable unifyData(String host, Hashtable data) {
        data.put("li", "1");
        if (data.get("STATUS") != null && ((String)data.get("STATUS")).toLowerCase().equals("access granted")) {
            data.put("STATUS", "permit");
        }
        if ("true".equals((String)data.get("DROP_LOG"))) {
            String logRecord = (String)data.remove("MSG");
            if (data.get("PRV_IP") != null) {
                String srcIP = (String)data.remove("CLIENT_IP");
                String tranIP = (String)data.remove("PRV_IP");
                this.tranIPHash.put((Object)srcIP, (Object)tranIP);
            } else if (data.get("FAILED_USER") != null | data.get("HTTP_USER") != null) {
                String failedUser = null;
                failedUser = data.get("FAILED_USER") == null ? (String)data.remove("HTTP_USER") : (String)data.remove("FAILED_USER");
                String srcIP = (String)data.remove("CLIENT_IP");
                Hashtable memHash = this.checkVPNHash(failedUser.trim());
                if (memHash != null) {
                    memHash.put("SRC", srcIP);
                    String completeMSG = srcIP + " " + (String)memHash.remove("MSG");
                    memHash.put("MSG", completeMSG);
                    this.vpnHash.remove((Object)failedUser.trim());
                    this.correctSRCName(memHash);
                    return memHash;
                }
            }
            return null;
        }
        if ("vpn".equals((String)data.get("RECORD_TABLE"))) {
            if (data.get("VPN_TYPE") == null) {
                return null;
            }
            this.populateCommonData(host, data);
            String src = (String)data.get("SRC");
            String user = (String)data.get("USERNAME");
            if ("connected".equalsIgnoreCase((String)data.remove("CONNECTION_STATUS"))) {
                data.put("SENT", new Long(0L));
                data.put("RECEIVED", new Long(0L));
                if (src == null) {
                    String srcName;
                    Map userSrcMap = (Map)this.userMap.get(host);
                    String string = srcName = userSrcMap == null ? null : (String)userSrcMap.get(user);
                    if (srcName != null) {
                        data.put("SRC", srcName);
                        userSrcMap.remove(user);
                    } else {
                        data.put("SRC", "Unknown");
                    }
                } else {
                    this.srcValue = false;
                    this.userMap.remove(host);
                }
                Map<String, PIXVPNObject> vpnMap = (Map<String, PIXVPNObject>)this.liveVPNMap.get(host);
                if (vpnMap == null) {
                    vpnMap = Collections.synchronizedMap(new FixedHashMap(1000));
                    this.liveVPNMap.put(host, vpnMap);
                }
                PIXVPNObject obj = new PIXVPNObject(data);
                obj.setVPNName((String)data.get("VPN_TYPE"));
                obj.setUser((String)data.get("USERNAME"));
                vpnMap.put(obj.getUser(), obj);
                return data;
            }
            if (data.get("AUTH") != null) {
                if (this.srcValue) {
                    Map<String, String> userSrcMap = (Map<String, String>)this.userMap.get(host);
                    if (userSrcMap == null) {
                        userSrcMap = Collections.synchronizedMap(new FixedHashMap(100));
                        this.userMap.put(host, userSrcMap);
                    }
                    userSrcMap.put((String)data.get("USER"), (String)data.get("SRC"));
                }
                return null;
            }
            String[] strToLong = new String[]{"SENT", "RECEIVED"};
            this.strToLong(strToLong, data);
            data.put("VPN", (String)data.remove("VPN_TYPE"));
            if (this.tranIPHash.containsKey((Object)src)) {
                data.put("TRAN_IP", this.tranIPHash.get((Object)src));
            }
            this.tranIPHash.remove((Object)src);
            Map vpnMap = (Map)this.liveVPNMap.get(host);
            if (vpnMap != null) {
                vpnMap.remove(user);
            }
        } else if ("evt".equals((String)data.get("RECORD_TABLE"))) {
            String user = (String)data.get("USERNAME");
            this.populateCommonData(host, data);
            data.put("SENT", new Long(0L));
            data.put("RECEIVED", new Long(0L));
            data.put("USERNAME", user.trim());
            String[] strToInt = new String[]{"EVENT_TYPE"};
            this.strToInt(strToInt, data);
        } else if ("mgmt".equals((String)data.get("RECORD_TABLE"))) {
            String user = (String)data.get("USERNAME");
            this.populateCommonData(host, data);
            data.put("SENT", new Long(0L));
            data.put("RECEIVED", new Long(0L));
            data.put("SUBTYPE", "1");
            data.put("USERNAME", user.trim());
            String[] strToInt = new String[]{"EVENT_TYPE"};
            this.strToInt(strToInt, data);
            if ("REFUSED".equalsIgnoreCase((String)data.get("STATUS"))) {
                String protocol = (String)data.get("PROTOCOL");
                data.put("SUBTYPE", "3");
                data.put("STATUS", "deny");
                if ("HTTP".equalsIgnoreCase(protocol.trim())) {
                    this.vpnHash.put((Object)"HTTP", (Object)data);
                } else {
                    this.vpnHash.put((Object)user.trim(), (Object)data);
                }
                return null;
            }
            if ("disconnected".equalsIgnoreCase((String)data.get("STATUS"))) {
                data.put("SUBTYPE", "2");
            }
        }
        return data;
    }

    @Override
    public Map getLiveData(String resource) {
        TreeMap<Timestamp, PIXVPNObject> liveVPNUserMap = new TreeMap<Timestamp, PIXVPNObject>();
        Map vpnObjMap = (Map)this.liveVPNMap.get(resource);
        if (vpnObjMap != null) {
            for (String key : vpnObjMap.keySet()) {
                PIXVPNObject vpnObj = (PIXVPNObject)vpnObjMap.get(key);
                Timestamp time = vpnObj.getVPNTime();
                liveVPNUserMap.put(time, vpnObj);
            }
        }
        return liveVPNUserMap;
    }

    private void populateCommonData(String host, Hashtable data) {
        data.put("FW", host);
        data.put("rtype", TYPE);
        data.put("SYSLOGIP", host);
        data.put("DEST", host);
        data.put("FW_TYPE", "CiscoVPN");
        data.put("LOG_FORMAT", "CiscoVPN");
        if (data.get("PROTOCOL") != null) {
            String protocol = (String)data.remove("PROTOCOL");
            data.put("PROTOCOL", protocol.trim());
        }
        if (data.get("SRC") == null) {
            data.put("SRC", "0.0.0.0");
        }
        String[] strToInt = new String[]{"SRC_PORT", "DEST_PORT"};
        this.strToInt(strToInt, data);
        this.checkForLearnMe(data);
        this.checkPriority(data);
        this.handleTime(data);
        this.assignDuration(data);
        this.correctSRCName(data);
    }

    private void correctSRCName(Hashtable data) {
        String srcName;
        if (data.get("SRC") != null && (srcName = ((String)data.get("SRC")).trim()).indexOf(":") > 0) {
            int srcLength = srcName.length();
            srcName = srcName.substring(0, srcLength - 1);
            data.put("SRC", srcName);
        }
    }

    private void handleTime(Hashtable data) {
        String priority;
        String DATE_FORMAT = this.IOS_DATE_FORMAT;
        if (data.get("ORG_PRIORITY") != null) {
            DATE_FORMAT = this.ORG_DATE_FORMAT;
            priority = (String)data.remove("ORG_PRIORITY");
            data.put("PRIORITY", priority);
        } else if (data.get("IOS_PRIORITY") != null) {
            priority = (String)data.remove("IOS_PRIORITY");
            data.put("PRIORITY", priority);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (data.get("TIME") != null) {
            String time = (String)data.remove("TIME");
            try {
                data.put("TIME", new Timestamp(dateFormat.parse(time).getTime()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        } else {
            data.put("TIME", new Timestamp(System.currentTimeMillis()));
        }
    }

    private void assignDuration(Hashtable data) {
        String dhour = (String)data.get("DURATION_HOUR");
        if (dhour == null) {
            data.put("DURATION", new Long(0L));
            return;
        }
        String dmin = (String)data.get("DURATION_MIN");
        String dsec = (String)data.get("DURATION_SEC");
        try {
            long duration = Integer.parseInt(dhour) * 3600 + Integer.parseInt(dmin) * 60 + Integer.parseInt(dsec);
            if (duration == 0L) {
                duration = 1L;
            }
            data.put("DURATION", new Long(duration));
            return;
        }
        catch (Exception ee) {
            LOGGER.log(Level.FINER, " EXCEPTION WHILE PARSING DURATION TIME dhour =={0} dmin {1} dsec {2}", new Object[]{dhour, dmin, dsec});
            ee.printStackTrace();
            data.put("DURATION", new Long(0L));
            return;
        }
    }

    private Hashtable checkVPNHash(String address) {
        if (this.vpnHash == null || this.vpnHash.size() == 0) {
            return null;
        }
        if (this.vpnHash.containsKey((Object)address)) {
            return (Hashtable)this.vpnHash.get((Object)address);
        }
        return null;
    }
}

