/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.imp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPMessageCollector;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FTPUtil {
    private static final Logger LOGGER = Logger.getLogger(FTPUtil.class.getName());
    private static Logger log = Logger.getLogger(FTPUtil.class.getName());

    public static FTPClient getFTPClient(String hostName, String userName, String password, boolean binaryFile, int ftpPort) throws Exception {
        log.info("Connecting");
        try {
            FTPClient ftp = new FTPClient(hostName, ftpPort);
            LOGGER.log(Level.INFO, " FTP client {0}", ftp);
            FTPMessageCollector listener = new FTPMessageCollector();
            ftp.setMessageListener((FTPMessageListener)listener);
            FTPUtil.loginFTPClient(userName, password, ftp);
            if (binaryFile) {
                log.info("Setting up passive, Binary transfers");
                ftp.setConnectMode(FTPConnectMode.PASV);
                ftp.setType(FTPTransferType.BINARY);
            } else {
                log.info("Setting up passive, ASCII transfers");
                ftp.setConnectMode(FTPConnectMode.PASV);
                ftp.setType(FTPTransferType.ASCII);
            }
            return ftp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FTPClient getFTPClient(String hostName, String userName, String password) throws Exception {
        log.info("Connecting");
        try {
            FTPClient ftp = new FTPClient();
            ftp.setControlEncoding("UTF-8");
            ftp.setRemoteHost(hostName);
            ftp.connect();
            LOGGER.log(Level.FINER, " FTP client {0}", ftp);
            FTPMessageCollector listener = new FTPMessageCollector();
            ftp.setMessageListener((FTPMessageListener)listener);
            FTPUtil.loginFTPClient(userName, password, ftp);
            log.info("Setting up passive, ASCII transfers");
            ftp.setConnectMode(FTPConnectMode.PASV);
            ftp.setType(FTPTransferType.ASCII);
            return ftp;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static FTPClient getFTPClient(String hostName, String userName, String password, boolean binaryFile) throws Exception {
        log.info("Connecting");
        try {
            FTPClient ftp = new FTPClient();
            ftp.setControlEncoding("UTF-8");
            ftp.setRemoteHost(hostName);
            ftp.connect();
            LOGGER.log(Level.FINER, " FTP client {0}", ftp);
            FTPMessageCollector listener = new FTPMessageCollector();
            ftp.setMessageListener((FTPMessageListener)listener);
            FTPUtil.loginFTPClient(userName, password, ftp);
            log.info("Setting up passive, Binary transfers");
            ftp.setConnectMode(FTPConnectMode.PASV);
            ftp.setType(FTPTransferType.BINARY);
            return ftp;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void loginFTPClient(String user, String password, FTPClient ftp) throws Exception {
        log.info("Logging in");
        ftp.login(user, password);
    }

    public static String doFTP(FTPClient ftp, String baseDirectory, String remoteDir, String fileName) throws Exception {
        try {
            String remoteFile;
            log.info("Change the dir");
            if (remoteDir != null) {
                ftp.chdir(remoteDir);
            }
            log.info("Getting file");
            StringBuffer tmpBuf = new StringBuffer();
            if (baseDirectory == null) {
                tmpBuf.append(System.getProperty("server.dir"));
                tmpBuf.append(File.separator);
                tmpBuf.append("server");
                tmpBuf.append(File.separator);
                tmpBuf.append("imported_files");
                tmpBuf.append(File.separator);
            } else {
                tmpBuf.append(baseDirectory);
            }
            tmpBuf.append(fileName);
            tmpBuf.append(File.separator);
            LOGGER.log(Level.FINER, "creating directory<->{0}", tmpBuf);
            File wd = new File(tmpBuf.toString());
            if (!wd.exists()) {
                wd.mkdirs();
            }
            tmpBuf.append(File.separator);
            tmpBuf.append(fileName);
            String string = remoteFile = remoteDir != null ? remoteDir : fileName;
            if (remoteDir != null && !remoteDir.endsWith(fileName)) {
                if (remoteDir.indexOf("/") >= 0) {
                    remoteFile = remoteFile + "/";
                } else if (remoteDir.indexOf("\\") >= 0) {
                    remoteFile = remoteFile + "\\";
                }
                remoteFile = remoteFile + fileName;
                LOGGER.log(Level.FINER, "remoteFile <->{0}", remoteFile);
            }
            try {
                ftp.get(tmpBuf.toString(), remoteFile);
                return tmpBuf.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static FTPFile[] getList(String dir, FTPClient ftp) throws Exception {
        LOGGER.log(Level.FINER, " Getting list for  {0}", ftp);
        if (dir != null) {
            ftp.chdir(dir);
        }
        String currentDir = ftp.pwd();
        FTPFile[] list = ftp.dirDetails(null);
        return list;
    }

    public static void logOut(FTPClient ftp) throws Exception {
        if (ftp == null) {
            return;
        }
        log.info("Quitting client");
        ftp.quit();
    }

    public static String getSeparator(FTPClient ftp) throws Exception {
        String OS = ftp.system();
        if (OS.indexOf("UNIX") > -1) {
            return "/";
        }
        return "\\";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParentDir(String origDir, FTPClient ftp) throws Exception {
        String parentDir = null;
        try {
            ftp.chdir("..");
            parentDir = ftp.pwd();
        }
        catch (Exception e) {
            try {
                parentDir = ftp.pwd();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        finally {
            try {
                ftp.chdir(origDir);
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        }
        return parentDir;
    }

    public static ArrayList findFolders(String home, String serverOS) {
        if (home == null) {
            home = serverOS.equals("Linux") ? "/" : "c:\\";
        }
        File f = new File(home);
        String[] allFolderList = f.list();
        ArrayList<String> dirList = new ArrayList<String>();
        ArrayList fileList = new ArrayList();
        if (allFolderList != null) {
            for (String folder : allFolderList) {
                if (!new File(home + folder).isDirectory() || folder.startsWith(".")) continue;
                dirList.add(folder);
            }
            return dirList;
        }
        return null;
    }

    public static ArrayList findFiles(String home, String serverOS) {
        if (home == null) {
            home = serverOS.equals("Linux") ? "/" : "c:\\";
        }
        File f = new File(home);
        String[] allFilesList = f.list();
        ArrayList<String> fileList = new ArrayList<String>();
        if (allFilesList != null) {
            for (String file : allFilesList) {
                if (new File(home + file).isDirectory() || file.startsWith(".")) continue;
                fileList.add(file);
            }
            return fileList;
        }
        return null;
    }

    public static String getFilePath(String hostName, String userName, String fullFilePath, int i) {
        String tempPath = "ftp://" + userName + "@" + hostName;
        fullFilePath = fullFilePath.replaceFirst(tempPath, "");
        int index = fullFilePath.lastIndexOf("/");
        String path = fullFilePath.substring(0, index + 1);
        String file = fullFilePath.substring(index + 1, fullFilePath.length());
        if (i == 0) {
            return path;
        }
        if (i == 1) {
            return file;
        }
        return null;
    }
}

