/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.lc.IPFIXTemplate;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.V9Flow;
import com.adventnet.la.util.FixedHashMap;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPFIXFlow
extends V9Flow {
    private static final Logger LOGGER = Logger.getLogger(IPFIXFlow.class.getName());
    private static IPFIXTemplate.IPFIX_IDS ipfix_ids;
    private static Map urlMap;
    private static FACacheManager facache;
    int delta_sent;
    int delta_rcvd;
    int appl;
    int ips;
    int gav;
    int aspy;
    int internal_flag = 0;
    private String sent;
    private String rcvd;
    private String url;
    long flow_start_time;
    long flow_end_time;
    boolean isDeltaPkt = true;

    IPFIXFlow(String[] data, String hostIP, int entId) {
        this.hostIP = hostIP;
        this.fw_type = "SonicWall";
        this.event_occur_time = new Long(data[IPFIXTemplate.IPFIX_IDS.FLOW_END_TIME.ordinal()]);
        this.conn_id = data[IPFIXTemplate.IPFIX_IDS.FLOW_ID.ordinal()];
        String temp = data[IPFIXTemplate.IPFIX_IDS.SRC_ADDR.ordinal()];
        this.src = PacketUtil.str_addr(new Long(temp));
        temp = data[IPFIXTemplate.IPFIX_IDS.DST_ADDR.ordinal()];
        this.dst = PacketUtil.str_addr(new Long(temp));
        this.src_if = data[IPFIXTemplate.IPFIX_IDS.SRC_INTF.ordinal()];
        this.dst_if = data[IPFIXTemplate.IPFIX_IDS.DST_INTF.ordinal()];
        this.srcPort = data[IPFIXTemplate.IPFIX_IDS.SRC_PORT.ordinal()];
        this.dstPort = data[IPFIXTemplate.IPFIX_IDS.DST_PORT.ordinal()];
        this.sent = data[IPFIXTemplate.IPFIX_IDS.BYTES_SENT.ordinal()];
        this.rcvd = data[IPFIXTemplate.IPFIX_IDS.BYTES_RCVD.ordinal()];
        this.delta_sent = new Integer(data[IPFIXTemplate.IPFIX_IDS.DELTA_BYTES_SENT.ordinal()]);
        this.delta_rcvd = new Integer(data[IPFIXTemplate.IPFIX_IDS.DELTA_BYTES_RCVD.ordinal()]);
        this.flow_start_time = new Long(data[IPFIXTemplate.IPFIX_IDS.FLOW_START_TIME.ordinal()]);
        this.flow_end_time = new Long(data[IPFIXTemplate.IPFIX_IDS.FLOW_END_TIME.ordinal()]);
        this.duration = this.flow_end_time - this.flow_start_time;
        this.proto = data[IPFIXTemplate.IPFIX_IDS.PROTOCOL.ordinal()];
        this.event_code = new Integer(data[IPFIXTemplate.IPFIX_IDS.FLOW_BLOCK_REASON.ordinal()]);
        this.appl = new Integer(data[IPFIXTemplate.IPFIX_IDS.FLOW_TO_APP_SIG_ID.ordinal()]);
        this.ips = new Integer(data[IPFIXTemplate.IPFIX_IDS.FLOW_TO_IPS_ID.ordinal()]);
        this.gav = new Integer(data[IPFIXTemplate.IPFIX_IDS.FLOW_TO_GAV_ID.ordinal()]);
        this.aspy = new Integer(data[IPFIXTemplate.IPFIX_IDS.FLOW_TO_ASPY_ID.ordinal()]);
        this.internal_flag = new Integer(data[IPFIXTemplate.IPFIX_IDS.INTERNAL_FLAG.ordinal()]);
        boolean bl = this.isDeltaPkt = (this.internal_flag & 2) == 0;
        if (!this.isDeltaPkt) {
            this.url = (String)urlMap.remove(hostIP + "_" + this.flow_start_time + "_" + this.conn_id);
        }
    }

    public boolean isDeltaPktFlow() {
        return this.isDeltaPkt;
    }

    @Override
    public String getSentBytes() {
        return this.sent;
    }

    @Override
    public String getRcvdBytes() {
        return this.rcvd;
    }

    public int getDeltaSent() {
        return this.delta_sent;
    }

    public int getDeltaRcvd() {
        return this.delta_rcvd;
    }

    public int getApplID() {
        return this.appl;
    }

    public int getAttackID() {
        return this.ips;
    }

    public int getVirusID() {
        return this.gav;
    }

    public int getAspyID() {
        return this.aspy;
    }

    @Override
    public String getTime() {
        Date time = new Date(new Long(this.event_occur_time) * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(time);
    }

    public String getUrl() {
        return this.url;
    }

    public static void handleURL(String[] data, String hostIP) {
        long timestamp = new Long(data[IPFIXTemplate.IPFIX_IDS.TIME_STAMP.ordinal()]);
        String flow_id = data[IPFIXTemplate.IPFIX_IDS.FLOW_ID.ordinal()];
        String url = data[IPFIXTemplate.IPFIX_IDS.REQUEST.ordinal()];
        urlMap.put(hostIP + "_" + timestamp + "_" + flow_id, url);
        LOGGER.log(Level.FINER, " conn_id {0} url {1} and Map size {2} ", new Object[]{flow_id, url, urlMap.size()});
    }

    public static void handleInterface(String[] data, String hostIP) {
        try {
            String rid;
            String key = hostIP + "_" + data[IPFIXTemplate.IPFIX_IDS.IF_NAME.ordinal()];
            if (!facache.checkDeviceInterfaceIndexMap(key) && (rid = facache.getDeviceId(hostIP)) != null) {
                Long if_index = (long)new Long(data[IPFIXTemplate.IPFIX_IDS.IF_INDEX.ordinal()]);
                String if_name = data[IPFIXTemplate.IPFIX_IDS.IF_NAME.ordinal()];
                String if_ip = PacketUtil.str_addr(new Long(data[IPFIXTemplate.IPFIX_IDS.IF_IPADDR.ordinal()]));
                String if_speed = data[IPFIXTemplate.IPFIX_IDS.IF_SPEED.ordinal()];
                String if_mask = "";
                facache.addNewInterface(Long.parseLong(rid), if_name, if_ip, if_speed, if_mask, if_index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        urlMap = Collections.synchronizedMap(new FixedHashMap(1000));
        facache = FACacheManager.getInstance();
    }
}

