/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.lc.PacketUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPFIXTemplate {
    private static IPFIXTemplate tempinst = null;
    private static final Logger LOGGER = Logger.getLogger(IPFIXTemplate.class.getName());
    private Hashtable templateMap = new Hashtable();
    private static HashMap entIDMap = new HashMap();
    private static HashMap ruleHashVsName = new HashMap();
    private int ent_id = 8741;

    private IPFIXTemplate() {
    }

    public IPFIX_IDS getField(int ordinal) {
        IPFIX_IDS[] aa;
        for (IPFIX_IDS bb : aa = IPFIX_IDS.values()) {
            if (bb.ordinal() != ordinal) continue;
            return bb;
        }
        return null;
    }

    public void printTemplate() {
        for (String key : this.templateMap.keySet()) {
            Integer[][] arr = (Integer[][])this.templateMap.get(key);
            for (int i = 0; i < arr.length; ++i) {
                int ordinal = arr[i][0];
                IPFIX_IDS o = this.getField(ordinal);
                LOGGER.log(Level.INFO, "Field " + i + " : " + (Object)((Object)o));
            }
        }
    }

    public static synchronized IPFIXTemplate getInstance() {
        if (tempinst == null) {
            tempinst = new IPFIXTemplate();
        }
        return tempinst;
    }

    public Integer[][] getTemplate(String tempID) {
        if (this.templateMap.containsKey(tempID)) {
            return (Integer[][])this.templateMap.get(tempID);
        }
        return null;
    }

    public Hashtable getTemplates() {
        return this.templateMap;
    }

    public int getEntId(long sourceId) {
        int id = 0;
        if (entIDMap.get(sourceId) != null) {
            id = (Integer)entIDMap.get(sourceId);
        }
        return id;
    }

    public int addTemplate(String firewallIP, long sourceID, byte[] buf, int marker, int templates_tot_len, int pduCount, int processedPDU) {
        int templates_count = 0;
        int j = 4;
        while (processedPDU + templates_count < pduCount && j < templates_tot_len) {
            boolean isValid;
            LOGGER.log(Level.FINEST, "Marker location = {0}", marker);
            int computationStart = marker;
            long actualTempID = PacketUtil.to_number(buf, marker, 2);
            int fieldCount = (int)PacketUtil.to_number(buf, marker + 2, 2);
            String tempid = firewallIP + "_" + sourceID + "_" + actualTempID;
            LOGGER.log(Level.FINER, "ADDING TEMPLATE FLOW :::: template ID is = {0} fieldCount = {1}", new Object[]{tempid, fieldCount});
            Integer[][] arr = new Integer[fieldCount][2];
            if (actualTempID > 255L && (isValid = this.processTemplate(arr, marker += 4, fieldCount, buf))) {
                this.templateMap.put(tempid, arr);
                entIDMap.put(sourceID, this.ent_id);
            }
            int computedTempLength = (marker += fieldCount * 8) - computationStart;
            j += computedTempLength;
            ++templates_count;
        }
        return templates_count;
    }

    private boolean processTemplate(Integer[][] arr, int marker, int fieldCount, byte[] buf) {
        boolean isValid = true;
        this.ent_id = (int)PacketUtil.to_number(buf, marker + 4, 4);
        for (int i = 0; i < fieldCount; ++i) {
            int fieldno = (int)PacketUtil.to_number(buf, marker + 1, 1);
            Integer fieldlen = new Integer((int)PacketUtil.to_number(buf, marker + 2, 2));
            LOGGER.log(Level.FINER, "fieldno= {0} fieldlen= {1} marker= {2}", new Object[]{fieldno, fieldlen, marker});
            switch (fieldno) {
                case 1: 
                case 124: {
                    arr[i][0] = new Integer(IPFIX_IDS.TIME_STAMP.ordinal());
                    break;
                }
                case 2: 
                case 123: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_ID.ordinal());
                    break;
                }
                case 5: {
                    arr[i][0] = new Integer(IPFIX_IDS.SRC_ADDR.ordinal());
                    break;
                }
                case 6: {
                    arr[i][0] = new Integer(IPFIX_IDS.DST_ADDR.ordinal());
                    break;
                }
                case 9: {
                    arr[i][0] = new Integer(IPFIX_IDS.SRC_INTF.ordinal());
                    break;
                }
                case 10: {
                    arr[i][0] = new Integer(IPFIX_IDS.DST_INTF.ordinal());
                    break;
                }
                case 11: {
                    arr[i][0] = new Integer(IPFIX_IDS.SRC_PORT.ordinal());
                    break;
                }
                case 12: {
                    arr[i][0] = new Integer(IPFIX_IDS.DST_PORT.ordinal());
                    break;
                }
                case 14: {
                    arr[i][0] = new Integer(IPFIX_IDS.BYTES_SENT.ordinal());
                    break;
                }
                case 16: {
                    arr[i][0] = new Integer(IPFIX_IDS.BYTES_RCVD.ordinal());
                    break;
                }
                case 17: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_START_TIME.ordinal());
                    break;
                }
                case 18: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_END_TIME.ordinal());
                    break;
                }
                case 19: {
                    arr[i][0] = new Integer(IPFIX_IDS.INTERNAL_FLAG.ordinal());
                    break;
                }
                case 20: {
                    arr[i][0] = new Integer(IPFIX_IDS.PROTOCOL.ordinal());
                    break;
                }
                case 173: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_BLOCK_REASON.ordinal());
                    break;
                }
                case 22: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_TO_APP_SIG_ID.ordinal());
                    break;
                }
                case 23: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_TO_USER_ID.ordinal());
                    break;
                }
                case 25: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_TO_IPS_ID.ordinal());
                    break;
                }
                case 26: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_TO_GAV_ID.ordinal());
                    break;
                }
                case 27: {
                    arr[i][0] = new Integer(IPFIX_IDS.FLOW_TO_ASPY_ID.ordinal());
                    break;
                }
                case 59: {
                    arr[i][0] = new Integer(IPFIX_IDS.REQUEST.ordinal());
                    break;
                }
                case 41: {
                    arr[i][0] = new Integer(IPFIX_IDS.APP_NAME.ordinal());
                    break;
                }
                case 43: {
                    arr[i][0] = new Integer(IPFIX_IDS.APP_CAT.ordinal());
                    break;
                }
                case 44: {
                    arr[i][0] = new Integer(IPFIX_IDS.APP_SIG_ID.ordinal());
                    break;
                }
                case 49: {
                    arr[i][0] = new Integer(IPFIX_IDS.IPS_NAME.ordinal());
                    break;
                }
                case 52: {
                    arr[i][0] = new Integer(IPFIX_IDS.IPS_SIG_ID.ordinal());
                    break;
                }
                case 46: {
                    arr[i][0] = new Integer(IPFIX_IDS.VIRUS_NAME.ordinal());
                    break;
                }
                case 47: {
                    arr[i][0] = new Integer(IPFIX_IDS.GAV_SIG_ID.ordinal());
                    break;
                }
                case 56: {
                    arr[i][0] = new Integer(IPFIX_IDS.ASPY_NAME.ordinal());
                    break;
                }
                case 57: {
                    arr[i][0] = new Integer(IPFIX_IDS.ASPY_SIG_ID.ordinal());
                    break;
                }
                case 101: {
                    arr[i][0] = new Integer(IPFIX_IDS.IF_INDEX.ordinal());
                    break;
                }
                case 119: {
                    arr[i][0] = new Integer(IPFIX_IDS.IF_SPEED.ordinal());
                    break;
                }
                case 117: {
                    arr[i][0] = new Integer(IPFIX_IDS.IF_NAME.ordinal());
                    break;
                }
                case 170: {
                    arr[i][0] = new Integer(IPFIX_IDS.DELTA_BYTES_SENT.ordinal());
                    break;
                }
                case 172: {
                    arr[i][0] = new Integer(IPFIX_IDS.DELTA_BYTES_RCVD.ordinal());
                    break;
                }
                case 175: {
                    arr[i][0] = new Integer(IPFIX_IDS.IF_IPADDR.ordinal());
                    break;
                }
                case 177: {
                    arr[i][0] = new Integer(IPFIX_IDS.IF_ZONE.ordinal());
                    break;
                }
                default: {
                    arr[i][0] = new Integer(-1);
                }
            }
            arr[i][1] = fieldlen;
            marker += 8;
        }
        return isValid;
    }

    static enum IPFIX_IDS {
        TIME_STAMP(1, 4),
        FLOW_ID(2, 4),
        SRC_ADDR(5, 4),
        DST_ADDR(6, 4),
        SRC_INTF(9, 4),
        DST_INTF(10, 4),
        SRC_PORT(11, 2),
        DST_PORT(12, 2),
        BYTES_SENT(14, 4),
        BYTES_RCVD(16, 4),
        DELTA_BYTES_SENT(170, 4),
        DELTA_BYTES_RCVD(172, 4),
        FLOW_START_TIME(17, 4),
        FLOW_END_TIME(18, 4),
        INTERNAL_FLAG(19, 2),
        PROTOCOL(20, 1),
        FLOW_BLOCK_REASON(173, 1),
        FLOW_TO_APP_SIG_ID(22, 4),
        FLOW_TO_USER_ID(23, 8),
        FLOW_TO_IPS_ID(25, 4),
        FLOW_TO_GAV_ID(26, 4),
        FLOW_TO_ASPY_ID(27, 4),
        REQUEST(59, 128),
        APP_NAME(41, 96),
        APP_CAT(43, 96),
        APP_SIG_ID(44, 4),
        IPS_NAME(49, 96),
        IPS_SIG_ID(52, 4),
        VIRUS_NAME(46, 96),
        GAV_SIG_ID(47, 4),
        ASPY_NAME(56, 96),
        ASPY_SIG_ID(57, 4),
        IF_INDEX(101, 4),
        IF_SPEED(119, 4),
        IF_NAME(117, 32),
        IF_IPADDR(175, 4),
        IF_ZONE(177, 32);

        private int type;
        private int len;

        private IPFIX_IDS(int type, int len) {
            this.type = type;
            this.len = len;
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.len;
        }
    }
}

