/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.lea.LeaManager;
import com.adventnet.fa.server.lc.LCConfigHandler;
import com.adventnet.fa.server.lc.LogCollector;
import com.adventnet.fa.server.lc.SyslogServer;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LCManager {
    private static final Logger LOGGER = Logger.getLogger(LCManager.class.getName());
    LogCollector logCollector = null;
    private static LCManager manager = null;

    public static LCManager getInstance() {
        if (manager == null) {
            manager = new LCManager();
        }
        return manager;
    }

    public void setLogCollector(LogCollector lc) {
        this.logCollector = lc;
    }

    public void loadLogFetchersFromDB() {
        LCConfigHandler.getInstance().loadConfiguration();
        LCConfigHandler.getInstance().populateConfiguration();
    }

    public void addSyslogCollector(Long sysId, int port) {
        SyslogServer ss = new SyslogServer(sysId.toString(), port);
        LOGGER.log(Level.FINER, " adding syslog server :: {0}  :: {1}", new Object[]{sysId, new Integer(port)});
        this.logCollector.addLogFetcher(sysId.toString(), ss);
    }

    public void removeSyslogCollector(String key) {
        this.logCollector.removeLogFetcher(key);
    }

    public void addLeaLogCollector(String fwName, String fwIpAddress, int port, String recIp, int recPort, boolean auth) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("--online");
        if (System.getProperty("DISABLE_LEA_NG") == null) {
            list.add("--ifleafw");
        }
        LOGGER.log(Level.INFO, " adding lea server :: {0}  :: {1}  :: {2}  :: {3} {4} {5}", new Object[]{fwName, fwIpAddress, new Integer(port), recIp, new Integer(recPort), new Boolean(auth)});
        if (auth) {
            String conf = System.getProperty("server.home") + File.separator + "server" + File.separator + "leaconf" + File.separator + fwName + ".conf";
            File file = new File(conf);
            if (!file.exists()) {
                conf = System.getProperty("server.home") + File.separator + "server" + File.separator + "leaconf" + File.separator + "leaclient.conf";
                file = new File(conf);
            }
            list.add("--auth");
            list.add("--config");
            list.add(file.getAbsolutePath());
        }
        String[] opts = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            opts[i] = (String)list.get(i);
        }
        this.addLeaLogCollector(fwIpAddress, port, recIp, recPort, opts);
    }

    public void addLeaLogCollector(String fwIpAddress, int port, String recIp, int recPort, String[] opts) {
        LeaManager.getInstance().startRecordCollection(fwIpAddress, String.valueOf(port), recIp, String.valueOf(recPort), opts);
    }

    public void removeLealogCollector(String key) {
        LeaManager.getInstance().stopRecordCollection(key);
    }

    public void stopLogFetcher(String key) {
        this.logCollector.stopLogFetcher(key);
    }

    public void startLogFetcher(String key) {
        this.logCollector.startLogFetcher(key);
    }

    public void startLogFetchers() {
        this.logCollector.startLogFetchers();
    }

    public void stopLogFetchers() {
        this.logCollector.stopLogFetchers();
    }

    public boolean enableLogFetcher(String key) {
        LOGGER.log(Level.FINE, "LCManager.enableLogFetcher() called for ::::: {0} ", key);
        return this.logCollector.enableLogFetcher(key);
    }

    public boolean disableLogFetcher(String key) {
        LOGGER.log(Level.FINE, "LCManager.disableLogFetcher() called for :::::: {0} ", key);
        return this.logCollector.disableLogFetcher(key);
    }
}

