/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.lc.IPFIXFlow;
import com.adventnet.fa.server.lc.IPFIXStaticFlowHandler;
import com.adventnet.fa.server.lc.IPFIXTemplate;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.RecordStore;
import com.adventnet.fa.server.lc.V9Flow;
import com.adventnet.fa.server.lc.V9Template;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetflowToSyslogConvertor {
    private String syslogServerName;
    private V9Template v9temp;
    private IPFIXTemplate ipfixTemp;
    private IPFIXStaticFlowHandler ipfixHandler;
    private static final Logger LOGGER = Logger.getLogger(NetflowToSyslogConvertor.class.getName());
    private static int header_size;
    private int entId;

    public NetflowToSyslogConvertor(String name) {
        this.syslogServerName = name;
        this.v9temp = V9Template.getInstance();
        this.ipfixTemp = IPFIXTemplate.getInstance();
        this.ipfixHandler = IPFIXStaticFlowHandler.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flowToSyslog(String hostIP, byte[] packet, int len, RecordStore store) {
        short ver = (short)PacketUtil.to_number(packet, 0, 2);
        header_size = ver == 9 ? 20 : 16;
        LOGGER.log(Level.FINER, "Netflow Version is {0} and HEADER size is {1}", new Object[]{ver, header_size});
        int pduCount = (int)PacketUtil.to_number(packet, 2, 2);
        int processedPDU = 0;
        LOGGER.log(Level.FINER, "Total no of PDUs (Template and Data) exported in this flow is {0} ", pduCount);
        long time = System.currentTimeMillis();
        long sourceID = PacketUtil.to_number(packet, header_size - 4, 4);
        int marker = header_size;
        while (marker < len && processedPDU < pduCount) {
            long startTime = System.currentTimeMillis();
            int flowSetId = (int)PacketUtil.to_number(packet, marker, 2);
            int length = (int)PacketUtil.to_number(packet, marker + 2, 2);
            LOGGER.log(Level.FINER, "FlowSetId = {0} ", flowSetId);
            LOGGER.log(Level.FINER, "Length = {0} ", length);
            if (length == 0) break;
            try {
                if (flowSetId > 255) {
                    processedPDU += this.parseDataSets(ver, hostIP, sourceID, flowSetId, length, packet, marker + 4, time, store, pduCount, processedPDU);
                    continue;
                }
                if (flowSetId == 0) {
                    LOGGER.log(Level.SEVERE, "This is v9 Template Flow");
                    processedPDU += this.v9temp.addTemplate(hostIP, sourceID, packet, marker + 4, length, pduCount, processedPDU);
                    continue;
                }
                if (flowSetId != 2) continue;
                processedPDU += this.ipfixTemp.addTemplate(hostIP, sourceID, packet, marker + 4, length, pduCount, processedPDU);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception while parsing V9 data/template flow - {0}", e.getMessage());
                e.printStackTrace();
            }
            finally {
                marker += length;
            }
        }
        return processedPDU;
    }

    private int parseDataSets(short ver, String hostIP, long sourceID, int flowSetId, int length, byte[] packet, int marker, long time, RecordStore store, int pduCount, int processedPDU) throws Exception {
        String resName = hostIP;
        String templateID = hostIP + "_" + sourceID + "_" + flowSetId;
        int datasets = 0;
        V9Flow flow_obj = null;
        Integer[][] template = this.v9temp.getTemplate(templateID);
        if (ver == 10) {
            template = this.ipfixTemp.getTemplate(templateID);
            this.entId = this.ipfixTemp.getEntId(sourceID);
        }
        if (template != null) {
            LOGGER.log(Level.FINER, "Template is found for id {0}", templateID);
            int j = 4;
            block9: while (j < length && processedPDU + datasets < pduCount && length - j >= 40) {
                String[] data = new String[60];
                for (int i = 0; i < template.length; ++i) {
                    int field_ordinal = template[i][0];
                    int field_len = template[i][1];
                    if (field_ordinal < 0) {
                        marker += field_len;
                        j += field_len;
                        continue;
                    }
                    data[field_ordinal] = PacketUtil.to_string(packet, marker, field_len, field_ordinal);
                    marker += field_len;
                    j += field_len;
                }
                ++datasets;
                if (ver == 9) {
                    flow_obj = new V9Flow(data, hostIP);
                    int event_code = flow_obj.getEventCode();
                    if (event_code < 2 || event_code > 3) {
                        continue;
                    }
                } else {
                    resName = FAServerUtil.getIpfixDevices(hostIP);
                    switch (flowSetId) {
                        case 257: {
                            flow_obj = new IPFIXFlow(data, resName, this.entId);
                            break;
                        }
                        case 262: {
                            IPFIXFlow.handleURL(data, resName);
                            continue block9;
                        }
                        case 261: {
                            this.ipfixHandler.handleAppFlow(data, flowSetId, this.entId);
                            continue block9;
                        }
                        case 264: {
                            this.ipfixHandler.handleAttackFlow(data, flowSetId, this.entId);
                            continue block9;
                        }
                        case 265: {
                            this.ipfixHandler.handleVirusFlow(data, flowSetId, this.entId);
                            continue block9;
                        }
                        case 266: {
                            this.ipfixHandler.handleSpywareFlow(data, flowSetId, this.entId);
                            continue block9;
                        }
                        case 270: {
                            IPFIXFlow.handleInterface(data, resName);
                            continue block9;
                        }
                        default: {
                            continue block9;
                        }
                    }
                }
                String syslog = this.convertToSyslog(flow_obj);
                Object[] syslogArr = new Object[]{hostIP, this.syslogServerName, syslog};
                store.saveRecord(syslogArr);
            }
        }
        return datasets;
    }

    private String convertToSyslog(V9Flow v9_data) throws Exception {
        StringBuffer sb = new StringBuffer();
        String fw_type = v9_data.getFwType();
        sb.append("id=firewall");
        sb.append(" time=\"" + v9_data.getTime() + "\"");
        sb.append(" fw=" + v9_data.getHostIP());
        sb.append(" type=traffic");
        sb.append(" fw_type=\"" + fw_type + "\"");
        int event_code = v9_data.getEventCode();
        if (event_code == 3 || event_code == 1) {
            sb.append(" pri=4");
            sb.append(" status=deny");
            sb.append(" action=block");
        } else {
            sb.append(" pri=5");
            sb.append(" status=allow");
        }
        String temp = v9_data.getConnId();
        if (temp != null) {
            sb.append(" conn_id=" + temp);
        }
        sb.append(" duration=" + v9_data.getDuration());
        sb.append(" proto=" + v9_data.getProtocol());
        sb.append(" src=\"" + v9_data.getSrc() + "\"");
        sb.append(" dst=\"" + v9_data.getDst() + "\"");
        if ("Cisco".equals(fw_type)) {
            sb.append(" rule=" + v9_data.getRule());
            temp = v9_data.getXlateSrc();
            if (temp != null) {
                sb.append(" tran_ip=\"" + temp + "\"");
                sb.append(" xlate_src=\"" + temp + "\"");
            }
            if ((temp = v9_data.getXlateSrcPort()) != null) {
                sb.append(" tran_port=" + temp);
                sb.append(" xlate_srcPort=" + temp);
            }
            if ((temp = v9_data.getXlateDst()) != null) {
                sb.append(" xlate_dst=\"" + temp + "\"");
            }
            if ((temp = v9_data.getXlateDstPort()) != null) {
                sb.append(" xlate_dstPort=" + temp);
            }
            if (event_code != 3) {
                sb.append(" bytes=" + v9_data.getBytes());
            }
            sb.append(" event_code=" + event_code);
            sb.append(" ext_event_code=" + v9_data.getExtEventCode());
        } else {
            String virus;
            IPFIXFlow ipfix_data = (IPFIXFlow)v9_data;
            if (ipfix_data.isDeltaPkt) {
                sb.append(" delta_out=" + ipfix_data.getDeltaSent());
                sb.append(" delta_in=" + ipfix_data.getDeltaRcvd());
                sb.append(" agg_out=" + ipfix_data.getSentBytes());
                sb.append(" agg_in=" + ipfix_data.getRcvdBytes());
                sb.append(" sent=0 rcvd=0");
            } else {
                sb.append(" sent=" + ipfix_data.getSentBytes());
                sb.append(" rcvd=" + ipfix_data.getRcvdBytes());
            }
            if (ipfix_data.getUrl() != null) {
                sb.append(" url=" + ipfix_data.getUrl());
            }
            if (ipfix_data.getApplID() != 0) {
                String app = this.ipfixHandler.getApplName(ipfix_data.getApplID(), this.entId);
                if (app != null) {
                    String[] str = app.split(",");
                    sb.append(" app=\"" + str[0] + "\"");
                    sb.append(" app_cat=\"" + str[1] + "\"");
                }
                sb.append(" app_sig_id=" + ipfix_data.getApplID());
            }
            if (ipfix_data.getAttackID() != 0) {
                String attack = this.ipfixHandler.getAttackName(ipfix_data.getAttackID(), this.entId);
                if (attack != null) {
                    sb.append(" attack_id=\"" + attack + "\"");
                }
                sb.append(" attack_sig_id=" + ipfix_data.getAttackID());
            }
            if (ipfix_data.getVirusID() != 0) {
                virus = this.ipfixHandler.getVirusName(ipfix_data.getVirusID(), this.entId);
                if (virus != null) {
                    sb.append(" virus=\"" + virus + "\"");
                }
                sb.append(" virus_sig_id=" + ipfix_data.getVirusID());
            }
            if (ipfix_data.getAspyID() != 0) {
                virus = this.ipfixHandler.getSpywareName(ipfix_data.getAspyID(), this.entId);
                if (virus != null) {
                    sb.append(" virus=\"" + virus + "\"");
                }
                sb.append(" aspy_sig_id=" + ipfix_data.getAspyID());
            }
            sb.append(" log_format=IPFIX ");
        }
        sb.append(" src_int=\"" + v9_data.getSrcInt() + "\"");
        sb.append(" dst_int=\"" + v9_data.getDstInt() + "\"");
        sb.append(" src_port=" + v9_data.getSrcPort());
        sb.append(" dst_port=" + v9_data.getDstPort());
        temp = v9_data.getUser();
        if (temp != null) {
            sb.append(" user=\"" + v9_data.getUser() + "\"");
        }
        LOGGER.log(Level.FINE, "Syslog that i framed is :::::::::::: {0} ", sb);
        return sb.toString();
    }

    private void printBits(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (byte val : b) {
            for (int t = 128; t > 0; t /= 2) {
                if ((val & t) != 0) {
                    buf.append("1");
                }
                if ((val & t) != 0) continue;
                buf.append("0");
            }
            buf.append("  ");
        }
        LOGGER.log(Level.FINER, "{0}", buf);
    }
}

