/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.Device;
import com.adventnet.fa.server.FACacheManager;
import com.adventnet.fa.server.FAServerUtil;
import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.ad.UserMACHandler;
import com.adventnet.fa.server.lc.TriggerTasks;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.dm.DataManagement;
import com.adventnet.la.util.dm.LimitFinder;
import com.adventnet.mfw.service.Service;
import com.adventnet.mfw.service.ServiceUtil;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacketUtil {
    private static final Logger LOGGER = Logger.getLogger(PacketUtil.class.getName());
    private static final int BATCH_SIZE = 5000;
    private static long packetCount = 0L;
    private static long lastProcessedPkt = -4990L;
    private static boolean deleted = false;
    private static TriggerTasks taskHandle = null;
    private static FirewallLicenseManager fwaLic = FirewallLicenseManager.getInstance();
    private static boolean newResourceAdded = false;
    private static long lastTriggeredTime = 0L;
    private static boolean isHighFlowCondition = "true".equals(System.getProperty("highFlow", "false"));
    private static long highFlowSplittingPoint = Integer.valueOf(System.getProperty("highFlowSplitPoint", "1000000")).intValue();
    private static long highFlowCount = 0L;
    private static TriggerTasks highFlowRateTaskHandler = null;
    private static String[] highFlowRateTasks = new String[]{"HighFlowCruncher"};
    static ThreadLocal<ReentrantLock> baseTableLock = new ThreadLocal<ReentrantLock>(){

        @Override
        public ReentrantLock initialValue() {
            return new ReentrantLock();
        }
    };
    static boolean includeDailyToYearlyTasks = false;
    private static TriggerTasks task4FirstResource = null;
    private static List<String> highFlowRawSplitterTaskList;

    public static boolean incrementCount(String resource, String ip, Hashtable unifiedOutput, Boolean fromImport, Boolean considerAsVdom, String physicalDevName) {
        if (resource == null) {
            return false;
        }
        ++highFlowCount;
        Device currentDevice = fwaLic.getDeviceObject(resource);
        if (currentDevice == null) {
            FACacheManager.getInstance().addResource(resource, ip, unifiedOutput, fromImport, considerAsVdom, physicalDevName);
            LaCacheManager.getInstance().updateIpToResource(ip, resource);
            int size = fwaLic.getDeviceHashSize();
            LimitFinder.resetTableLimits((int)fwaLic.getDeviceHashSize());
            if (size == 0 && !isHighFlowCondition) {
                PacketUtil.generateAllReports();
            } else if (size > 0 || deleted) {
                PacketUtil.createNewResource(resource);
                newResourceAdded = true;
            }
            fwaLic.addNewDevice(resource);
            ++packetCount;
            return true;
        }
        int status = currentDevice.getLicenseStatus();
        if (status == 0) {
            return false;
        }
        currentDevice.increaseCounter();
        currentDevice.setLatestUpdateTime();
        ++packetCount;
        if (!isHighFlowCondition && task4FirstResource != null && PacketUtil.getPacketCount() > 200L && PacketUtil.getStatus() == 7) {
            task4FirstResource.awaken();
        }
        if (isHighFlowCondition) {
            if (highFlowCount % highFlowSplittingPoint == 0L) {
                highFlowCount = 0L;
                LOGGER.log(Level.FINER, "PacketUtil.incrementCount() inside highFlow handling block ...");
                baseTableLock.get().lock();
                LOGGER.log(Level.INFO, "PacketUtil.incrementCount() about to start raw table splitter task.");
                PacketUtil.executeHighFlowRawSplitter();
                LOGGER.log(Level.INFO, "PacketUtil.incrementCount() after finishing the splitter task.");
                baseTableLock.get().unlock();
                LOGGER.log(Level.FINER, "PacketUtil.incrementCount() about to start the high flow cruncher task");
                highFlowRateTaskHandler.awaken();
                LOGGER.log(Level.FINER, "PacketUtil.incrementCount() after finishing the HighFlowCruncher task");
            }
            return true;
        }
        if (packetCount - lastProcessedPkt > 5000L && System.currentTimeMillis() - lastTriggeredTime > 120000L) {
            lastProcessedPkt = packetCount;
            String[] tasks = new String[]{"ConfigurationTablePopulator-1", "ConfigurationTablePopulator-2", "ConfigurationTablePopulator-3", "ConfigurationTablePopulator-4"};
            if (taskHandle == null) {
                taskHandle = new TriggerTasks("Raw-To-Hourly-Table-Task", 421000, tasks, false);
                taskHandle.start();
            } else {
                taskHandle.awaken();
            }
            lastTriggeredTime = System.currentTimeMillis();
        }
        return true;
    }

    public static boolean hasNewResourceAdded() {
        if (!newResourceAdded) {
            return false;
        }
        newResourceAdded = false;
        return true;
    }

    public static Map getLastUpdateMap() {
        return fwaLic.getUpdateTimeMap();
    }

    public static long getPacketCount() {
        return packetCount;
    }

    public static void setPacketCount(long temp) {
        packetCount = temp;
    }

    public static void removeResource(String resource) {
        if (resource == null) {
            return;
        }
        fwaLic.resetDeviceLicense();
        UserMACHandler handler = FirewallConstants.getUserMACHandlerInstance();
        if (handler != null) {
            handler.deleteResourceDetails(resource);
        }
        FAServerUtil.handleDHCPServerDelete(resource);
        deleted = true;
        task4FirstResource = null;
        LOGGER.log(Level.INFO, " Resource ::::{0} Deleted Successfully ::", resource);
    }

    public static long getCount(String host) {
        return fwaLic.getDevicePacketCount(host);
    }

    private static synchronized void createNewResource(String host) {
        LOGGER.log(Level.INFO, " ALERT ::: New Resource ::::{0} Added ==========", host);
        if (isHighFlowCondition) {
            return;
        }
        String[] array = new String[]{"ConfigurationTablePopulator-1", "ConfigurationTablePopulator-2", "ConfigurationTablePopulator-3", "ConfigurationTablePopulator-4"};
        TriggerTasks tasks = new TriggerTasks(host, 20000, null, true);
        tasks.start();
    }

    public static synchronized void generateAllReports() {
        task4FirstResource = new TriggerTasks("ReportGenerationThread For FirstResource", 20000, null, true);
        task4FirstResource.start();
    }

    public static synchronized void executeTrendTasks() {
        String[] array = new String[]{"Hourly_Trend_Table_Populator", "Daily_Trend_Table_Populator", "DOW_Trend_Table_Populator"};
        LOGGER.log(Level.INFO, " Executing Trend Task Groups ");
        PacketUtil.executeTaskGroups(array);
    }

    private static void executeHighFlowRawSplitter() {
        try {
            Service service = ServiceUtil.lookup((String)"DataManagement");
            DataManagement dmService = (DataManagement)service;
            dmService.executeTaskGroups(highFlowRawSplitterTaskList);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static synchronized void executeTaskGroups(String[] array) {
        if (array == null) {
            return;
        }
        try {
            List<String> taskGroups = Arrays.asList(array);
            Service service = ServiceUtil.lookup((String)"DataManagement");
            DataManagement dmService = (DataManagement)service;
            dmService.executeTaskGroups(taskGroups);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static void executeFreeFlowTaskGroups(String[] array) {
        if (array == null) {
            return;
        }
        try {
            List<String> taskGroups = Arrays.asList(array);
            Service service = ServiceUtil.lookup((String)"DataManagement");
            DataManagement dmService = (DataManagement)service;
            dmService.executeTaskGroups(taskGroups);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static int getStatus() {
        return task4FirstResource == null ? -1 : task4FirstResource.getStatus();
    }

    public static long to_number(byte[] p, int off, int len) {
        long ret = 0L;
        int done = off + len;
        if (len != 1) {
            for (int i = off; i < done; ++i) {
                ret = (ret << 8 & 0xFFFFFFFFFFFFFFFFL) + (long)(p[i] & 0xFF);
            }
        } else {
            byte b = p[off];
            ret = b & 0xFF;
        }
        return ret;
    }

    public static String to_string(byte[] p, int off, int len, int ordinal) {
        String result = "";
        if (len <= 8) {
            result = result + PacketUtil.to_number(p, off, len);
        } else if ((ordinal == 23 || ordinal == 24) && len == 12) {
            result = result + PacketUtil.to_number(p, off, 4);
        } else {
            if (len == 0) {
                return "Unknown";
            }
            byte[] user = new byte[len];
            int i = off;
            int j = 0;
            while (i < off + len) {
                user[j] = p[i];
                ++i;
                ++j;
            }
            result = new String(user);
            result = result.trim();
        }
        return result;
    }

    public static final String str_addr(long addr) {
        return new String((addr >> 24 & 0xFFL) + "." + (addr >> 16 & 0xFFL) + "." + (addr >> 8 & 0xFFL) + "." + (addr & 0xFFL));
    }

    public static final void initHFTask() {
        if (highFlowRateTaskHandler != null) {
            includeDailyToYearlyTasks = true;
            highFlowRateTaskHandler.awaken();
        }
    }

    static {
        highFlowRateTaskHandler = isHighFlowCondition ? new TriggerTasks("HighFlowRate - Raw To Hourly", 60000, highFlowRateTasks, false) : null;
        highFlowRawSplitterTaskList = Arrays.asList("RawTableSplitter-1");
    }
}

