/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.FirewallConstants;
import com.adventnet.fa.server.FirewallLicenseManager;
import com.adventnet.fa.server.FirewallSequenceGenerator;
import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.dc.ConsolidatorTask;
import com.adventnet.fa.server.lc.LuceneDataImpl;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.RecordReader;
import com.adventnet.fa.server.lc.RecordWriter;
import com.adventnet.fa.server.lc.SyslogServer;
import com.adventnet.fa.server.lc.WriterRepository;
import com.adventnet.la.LaCacheManager;
import com.adventnet.la.util.DNSResolverThread;
import com.adventnet.la.util.nf.NotificationEngine;
import com.adventnet.la.util.pe.DataArchiverInterface;
import com.adventnet.la.util.pe.FormatIdentifier;
import com.adventnet.la.util.pe.ParserEngineContext;
import com.adventnet.la.util.pe.ParserEngineHandler;
import com.adventnet.la.util.pe.ParserNotifier;
import com.adventnet.la.util.pe.Record;
import com.adventnet.la.util.pe.RecordParser;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.logsearch.index.api.LuceneData;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordHandler
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RecordHandler.class.getName());
    private Record record;
    private DataArchiverInterface archiver;
    private static ConsolidatorTask cTask = new ConsolidatorTask();
    private static FirewallLicenseManager fwaLic = FirewallLicenseManager.getInstance();
    private static HashMap<String, FirewallSequenceGenerator> generatorMap = new HashMap(7);
    private FwParserEngine fwEngine;
    private ParserNotifier parserNotifier;
    private ParserEngineContext context;
    private RecordParser recordParser;
    private FormatIdentifier formatIdentifier;
    private DataObject dobj;
    private boolean ignoreUnParsedRecord = false;
    private Boolean considerAsVdom = Boolean.FALSE;
    private Boolean fromImport = Boolean.FALSE;
    private String vdomIpAddress = null;
    private String physicalDevName = null;
    private int previousFormatIndex;
    private int previousPreLogFormatIndex;
    private static long luceneBatchCount = 0L;
    private static long unassignedBatchCount = 0L;
    private static long proxyBatchCount = 0L;
    private static long liveTrafficCount = 0L;
    private Hashtable unifiedOutput = null;
    private String formatName = null;
    byte[] ipv6Arr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    byte[] ipv4Arr = new byte[]{127, 0, 0, 1};
    private LogIndexingAPI indexingAPI = LogIndexingAPI.getInstance();
    private DNSResolverThread dnsThread = DNSResolverThread.getInstance();
    private static boolean indexall = true;
    private static long timeSum = 0L;
    private static long logCount = 1L;
    private static String ipv6Address = null;
    private static String ipv4Address = null;
    private static ThreadLocal<Hashtable> storage = new ThreadLocal(){

        protected synchronized Hashtable initialValue() {
            return new Hashtable();
        }
    };
    private boolean prepareCalled = false;
    private Hashtable wrapper = null;

    public RecordHandler() {
        this.prepare();
        this.archiver = this.fwEngine.getDataArchiver();
        this.prepareCalled = true;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public RecordHandler(Record record, DataArchiverInterface arc, boolean ignoreUnParsedRecord) {
        this(record, arc);
        this.ignoreUnParsedRecord = ignoreUnParsedRecord;
    }

    public static void setIndexall(boolean val) {
        indexall = val;
    }

    public RecordHandler(Record record, DataArchiverInterface arc, Boolean ignoreUnParsedRecord, Boolean fromImport, Boolean considerAsVdom, String vdomIpAddress) {
        this(record, arc);
        this.ignoreUnParsedRecord = ignoreUnParsedRecord;
        this.considerAsVdom = considerAsVdom;
        this.vdomIpAddress = vdomIpAddress;
        this.fromImport = fromImport;
    }

    public RecordHandler(Record record, DataArchiverInterface arc) {
        this.record = record;
        this.archiver = arc;
    }

    public void setWrapper(Hashtable wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void run() {
        try {
            if (!this.prepareCalled) {
                this.prepare();
                this.unifiedOutput = new Hashtable();
            } else {
                this.unifiedOutput = storage.get();
                this.unifiedOutput.clear();
            }
            String host = this.vdomIpAddress != null ? this.vdomIpAddress : this.record.getHost();
            String localIP = ipv6Address;
            if (localIP.equals(host)) {
                host = ipv4Address;
            }
            this.record.setHost(host);
            this.unifiedOutput = this.updateHashtable(this.record);
            boolean isFromImport = this.fromImport;
            boolean isConsiderAsVdom = this.considerAsVdom;
            if (this.archiver != null) {
                if (this.record.getResource() == null) {
                    this.setResourceFromMemory(this.record);
                }
                this.archiver.archiveRecord(this.record);
            }
            if (this.unifiedOutput == null || this.unifiedOutput.size() == 1) {
                return;
            }
            String tableName = (String)this.unifiedOutput.get("tableName");
            String recordResource = (String)this.unifiedOutput.get("FW");
            recordResource = recordResource == null ? this.record.getResource() : recordResource;
            this.unifiedOutput.put((String)this.unifiedOutput.get("PK"), generatorMap.get((String)this.unifiedOutput.get("PK")).getNext());
            LOGGER.log(Level.FINER, "RecordHandler abt to check if resource is ManagedDevice or not. Resource=" + recordResource);
            boolean isManagedDevice = fwaLic.isManagedDevice(recordResource);
            if (isManagedDevice) {
                this.publishForNotification(this.unifiedOutput, tableName);
                long before = System.nanoTime();
                LuceneDataImpl impl = RecordReader.luceneDataStore.get();
                impl.setData(this.unifiedOutput, tableName);
                String pathid = "-1";
                if (FirewallConstants.needToArchive()) {
                    pathid = this.record.getArchivedFile();
                    this.record.setRawLogPointer(pathid + "_" + this.record.getIndex());
                }
                this.record.setRelationalData((LuceneData)impl);
                if (indexall) {
                    this.indexingAPI.indexRecord((Object)this.record);
                } else if (this.record.getLogFormat().size() != 1 || !this.record.getLogFormat().contains("lt")) {
                    this.indexingAPI.indexRecord((Object)this.record);
                }
                long timediff = System.nanoTime() - before;
                timeSum += timediff;
                if (++logCount % 100000L == 0L) {
                    LOGGER.log(Level.INFO, "Time taken for indexing one lakh record is--->" + timeSum + " in NanoSecond");
                    timeSum = 0L;
                    logCount = 1L;
                }
            } else {
                LOGGER.log(Level.INFO, "inside FirewallLicenseManager.isManagedDevice() Else Loop");
            }
            this.dumpToFile(this.unifiedOutput, tableName, this.record.getHost());
            if (!this.prepareCalled) {
                this.cleanUp();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void setDO(DataObject dobj) {
        this.dobj = dobj;
    }

    private void dumpToFile(Hashtable unifiedOutput, String tableName, String ip) {
        unifiedOutput.remove("MSG");
        RecordWriter recWriter = WriterRepository.getInstance().getWriter(tableName);
        recWriter.save(unifiedOutput, ip, this.fromImport, this.considerAsVdom, this.physicalDevName);
    }

    private void publishForNotification(Hashtable unifiedOutput, String tableName) {
        try {
            String lic_resourceName = FirewallLicenseManager.getInstance().getResourceNameFromDevice(this.record.getResource());
            if (lic_resourceName != null) {
                unifiedOutput.put("RESOURCE", lic_resourceName);
            }
            if (this.fromImport.booleanValue() && this.wrapper != null) {
                this.wrapper.clear();
                this.wrapper.putAll(unifiedOutput);
                NotificationEngine.getInstance().sPublish((Map)this.wrapper, 1);
            } else {
                NotificationEngine.getInstance().sPublish((Map)unifiedOutput, 1);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static String getIndexString() {
        try {
            return luceneBatchCount + " logs are indexed out of " + PacketUtil.getPacketCount() + " [ " + luceneBatchCount * 100L / PacketUtil.getPacketCount() + "% ]";
        }
        catch (Exception ee) {
            if (PacketUtil.getPacketCount() == 0L) {
                return "No Logs are Indexed";
            }
            return ee.toString();
        }
    }

    private Hashtable parseRecord(Record record) {
        String data = record.getData();
        String host = record.getHost();
        if (data == null || "".equals(data)) {
            return null;
        }
        int formatIndex = this.formatIdentifier.getFormatIndex(data, host);
        if (formatIndex == -2) {
            LOGGER.log(Level.INFO, " UNABLE TO IDENTIFY THE LOG FORMAT FOR : {0}", host);
        } else {
            boolean success;
            int formatID;
            if (this.ignoreUnParsedRecord && (formatID = this.formatIdentifier.getFormatID(formatIndex)) == -1) {
                this.formatIdentifier.removeLearnings(host);
                if (PacketUtil.getCount(host) <= 0L) {
                    return null;
                }
            }
            if (!(success = this.recordParser.parseRecord(data, formatIndex, this.unifiedOutput, host))) {
                this.previousFormatIndex = formatIndex;
                this.previousPreLogFormatIndex = this.formatIdentifier.getPreLogFormatForHost(host);
                LOGGER.log(Level.FINER, " POSSIBLE CHANGE IN THE LOG FORMAT. RELEARNING THE NEW FORMAT FOR Log :{0} received from Host : {1}", new Object[]{data, host});
                formatIndex = this.formatIdentifier.relearnLogFormat(data, host);
                LOGGER.log(Level.FINER, "After Relearning the format obtained is {0} ", new Object[]{new Integer(formatIndex)});
                int formatID2 = this.formatIdentifier.getFormatID(formatIndex);
                if (formatID2 == -1) {
                    this.formatIdentifier.removeLearnings(host);
                    this.formatIdentifier.updateLearnings(host, this.previousFormatIndex, this.previousPreLogFormatIndex);
                    return null;
                }
                if (formatIndex == -2) {
                    LOGGER.log(Level.INFO, " UNABLE TO RELEARN THE LOG FORMAT FOR : {0}", host);
                } else {
                    success = this.recordParser.parseRecord(data, formatIndex, this.unifiedOutput, host);
                    if (!success) {
                        LOGGER.log(Level.FINE, " UNABLE TO PARSE THE LOGS EVEN AFTER LEARNING AGAIN FOR : {0} data :: {1}", new Object[]{host, data});
                    } else {
                        String syslogServer = record.getSyslogServer();
                        if (syslogServer != null) {
                            this.unifiedOutput.put("SYSLOG_SERVER", syslogServer);
                        }
                        this.unifiedOutput.put("FORMAT_ID", new Integer(formatIndex));
                    }
                }
            } else {
                String syslogServer = record.getSyslogServer();
                if (syslogServer != null) {
                    this.unifiedOutput.put("SYSLOG_SERVER", syslogServer);
                }
                this.unifiedOutput.put("FORMAT_ID", new Integer(formatIndex));
            }
        }
        return this.unifiedOutput.size() > 0 ? this.unifiedOutput : null;
    }

    private Row getRow(Record record) {
        String resNameFromParsing;
        Integer formatId;
        Object rid;
        this.unifiedOutput = this.parseRecord(record);
        if (this.unifiedOutput == null) {
            this.setResourceFromMemory(record);
            return null;
        }
        String fgtDevName = (String)this.unifiedOutput.get("FW_NAME");
        if (fgtDevName != null && (rid = LaCacheManager.getInstance().getFirewallId(fgtDevName)) != null) {
            this.unifiedOutput.put("FW", fgtDevName);
        }
        if ((formatId = (Integer)this.unifiedOutput.get("FORMAT_ID")) == null) {
            return null;
        }
        String host = record.getHost();
        Vector handlers = this.parserNotifier.getHandlersForFormat(formatId.intValue());
        String resName = (String)this.unifiedOutput.get("RESOURCE");
        String string = resNameFromParsing = resName != null ? resName : (String)this.unifiedOutput.get("FW");
        if (this.fromImport.booleanValue()) {
            this.unifiedOutput.put("considerAsVdom", this.considerAsVdom.toString());
        }
        for (int i = 0; i < handlers.size(); ++i) {
            ParserEngineHandler handler = (ParserEngineHandler)handlers.elementAt(i);
            this.unifiedOutput = handler.recordParsed(this.context, host, this.unifiedOutput);
        }
        if (this.unifiedOutput == null) {
            if (resNameFromParsing != null) {
                record.setResource(resNameFromParsing);
            }
            return null;
        }
        if (this.unifiedOutput.size() == 1) {
            this.setResource(record, this.unifiedOutput);
            return null;
        }
        this.setResource(record, this.unifiedOutput);
        this.physicalDevName = (String)this.unifiedOutput.remove("physicalDeviceName");
        if (record.getResource() == null) {
            this.setResourceAsHost(record, this.unifiedOutput);
        }
        if ("true".equals(this.unifiedOutput.get("Proxy"))) {
            if (FirewallConstants.isProxyIndexingEnabled()) {
                record.setToBeIndexed(true);
                record.setLogFormat("proxy");
            }
        } else {
            boolean security = false;
            record.setToBeIndexed(true);
            if ("1".equals(this.unifiedOutput.get("uli"))) {
                record.setLogFormat("u");
            }
            if ("1".equals(this.unifiedOutput.get("li"))) {
                security = true;
                record.setLogFormat("s");
            }
            if (!security) {
                record.setLogFormat("lt");
            }
        }
        record.addtoNonDb("PORT_INFO", this.portinfo());
        return cTask.getRowForResourceType(this.unifiedOutput);
    }

    private void setResource(Record record, Hashtable unifiedOutput) {
        String resource = (String)unifiedOutput.get("RESOURCE");
        if (resource == null) {
            resource = (String)unifiedOutput.get("FW");
            if (resource != null && !"".equals(resource)) {
                record.setResource(resource);
            }
        } else {
            record.setResource(resource);
        }
    }

    private void setResourceFromMemory(Record record) {
        record.setResource(LaCacheManager.getInstance().getResourceName(record.getHost()));
    }

    private void setResourceAsHost(Record record, Hashtable unifiedOutput) {
        String resource = (String)unifiedOutput.get("RESOURCE");
        if (resource != null) {
            record.setResource(resource);
        } else {
            resource = (String)unifiedOutput.get("FW");
            if (resource != null) {
                record.setResource(resource);
            } else {
                record.setResource(record.getHost());
            }
        }
    }

    public String getTime() {
        String reqTime = null;
        if (this.unifiedOutput == null) {
            return reqTime;
        }
        Object temp = null;
        Object v = this.unifiedOutput.get("TIME");
        temp = v;
        if (v != null) {
            try {
                String timeString = temp.toString();
                SimpleDateFormat formatString = new SimpleDateFormat("yyyy-MM-dd");
                Date date = formatString.parse(timeString);
                reqTime = formatString.format(date);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return reqTime;
    }

    private String portinfo() {
        if (this.unifiedOutput.get("PORT_INFO") != null) {
            return (String)this.unifiedOutput.get("PORT_INFO");
        }
        return "-";
    }

    private void prepare() {
        this.fwEngine = FwParserEngine.getInstance();
        this.formatIdentifier = this.fwEngine.formatIdentifier;
        this.recordParser = this.fwEngine.recordParser;
        this.parserNotifier = this.fwEngine.notifier;
        this.context = this.fwEngine.context;
    }

    private void cleanUp() {
        long startDebug = System.currentTimeMillis();
        if (SyslogServer.freeQueue.isEmpty()) {
            SyslogServer.freeQueue.add(this.record);
        }
        this.record = null;
        this.archiver = null;
        this.fwEngine = null;
        this.parserNotifier = null;
        this.context = null;
        this.recordParser = null;
        this.formatIdentifier = null;
        this.dobj = null;
    }

    private Hashtable updateHashtable(Record record) {
        String resNameFromParsing;
        Integer formatId;
        Object rid;
        this.unifiedOutput = this.parseRecord(record);
        if (this.unifiedOutput == null) {
            this.setResourceFromMemory(record);
            return null;
        }
        String fgtDevName = (String)this.unifiedOutput.get("FW_NAME");
        if (fgtDevName != null && (rid = LaCacheManager.getInstance().getFirewallId(fgtDevName)) != null) {
            this.unifiedOutput.put("FW", fgtDevName);
        }
        if ((formatId = (Integer)this.unifiedOutput.get("FORMAT_ID")) == null) {
            return null;
        }
        String host = record.getHost();
        Vector handlers = this.parserNotifier.getHandlersForFormat(formatId.intValue());
        String resName = (String)this.unifiedOutput.get("RESOURCE");
        String string = resNameFromParsing = resName != null ? resName : (String)this.unifiedOutput.get("FW");
        if (this.fromImport.booleanValue()) {
            this.unifiedOutput.put("considerAsVdom", this.considerAsVdom.toString());
        }
        for (int i = 0; i < handlers.size(); ++i) {
            ParserEngineHandler handler = (ParserEngineHandler)handlers.elementAt(i);
            this.unifiedOutput = handler.recordParsed(this.context, host, this.unifiedOutput);
        }
        if (this.unifiedOutput == null) {
            if (resNameFromParsing != null) {
                record.setResource(resNameFromParsing);
            }
            return null;
        }
        if (this.unifiedOutput.size() == 1) {
            this.setResource(record, this.unifiedOutput);
            return null;
        }
        this.setResource(record, this.unifiedOutput);
        this.physicalDevName = (String)this.unifiedOutput.remove("physicalDeviceName");
        if (record.getResource() == null) {
            this.setResourceAsHost(record, this.unifiedOutput);
        }
        if ("true".equals(this.unifiedOutput.get("Proxy"))) {
            if (FirewallConstants.isProxyIndexingEnabled()) {
                record.setToBeIndexed(true);
                record.setLogFormat("proxy");
            }
        } else {
            boolean security = false;
            record.setToBeIndexed(true);
            if ("1".equals(this.unifiedOutput.get("uli"))) {
                record.setLogFormat("u");
            }
            if ("1".equals(this.unifiedOutput.get("li"))) {
                security = true;
                record.setLogFormat("s");
            }
            if (!security) {
                record.setLogFormat("lt");
            }
        }
        record.addtoNonDb("PORT_INFO", this.portinfo());
        this.unifiedOutput.put("tableName", this.unifiedOutput.get("tableName") != null ? (String)this.unifiedOutput.get("tableName") : "FirewallRecords");
        return cTask.gethashtableForResourceType(this.unifiedOutput);
    }

    static {
        generatorMap.put("LRID", new FirewallSequenceGenerator("FirewallRecords", "LRID"));
        generatorMap.put("SQID", new FirewallSequenceGenerator("SquidRecords", "SQID"));
        try {
            ipv4Address = InetAddress.getByAddress(new byte[]{127, 0, 0, 1}).getHostAddress();
            ipv6Address = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}).getHostAddress();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            ipv6Address = "";
        }
    }
}

