/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.FwParserEngine;
import com.adventnet.fa.server.lc.LuceneDataImpl;
import com.adventnet.fa.server.lc.RecordHandler;
import com.adventnet.fa.server.lc.RecordStore;
import com.adventnet.fa.server.lc.StoreRepository;
import com.adventnet.la.util.pe.Record;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordReader
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(RecordReader.class.getName());
    private RecordStore store = null;
    boolean shutdown = false;
    Object obj = new Object();
    private long port;
    private FwParserEngine fwEngine;
    private DataObject dobj;
    static ThreadLocal<LuceneDataImpl> luceneDataStore = new ThreadLocal(){

        protected synchronized LuceneDataImpl initialValue() {
            return new LuceneDataImpl();
        }
    };
    static ThreadLocal<RecordHandler> recordHandlerStore = new ThreadLocal(){

        protected synchronized RecordHandler initialValue() {
            return new RecordHandler();
        }
    };
    static ThreadLocal<Record> recordObjStore = new ThreadLocal(){

        protected synchronized Record initialValue() {
            return new Record("", "", "");
        }
    };

    public RecordReader(long port) {
        super("RecordReader Thread for " + port);
        LOGGER.log(Level.FINER, "[RecordReader] RecordReader's Constructor Called *************");
        this.port = port;
        this.store = StoreRepository.getInstance().getRecordStore(port);
        this.init();
        this.start();
    }

    private void init() {
        LOGGER.log(Level.FINER, "[RecordReader] RecordReader's init() called *****************");
        this.fwEngine = FwParserEngine.getInstance();
        LOGGER.log(Level.FINER, "[RecordReader] ParserEngine instance is *********** {0}", this.fwEngine);
        try {
            this.dobj = DataAccess.constructDataObject();
        }
        catch (DataAccessException dExp) {
            dExp.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.log(Level.FINER, "[RecordReader] Inside Run()");
        while (!this.shutdown) {
            try {
                List records = this.store.getRecordsToProcess();
                if (records == null) {
                    Object object = this.obj;
                    synchronized (object) {
                        this.obj.wait(1L);
                        continue;
                    }
                }
                int size = records.size();
                for (int i = 0; i < size; ++i) {
                    Object[] recordArr = (Object[])records.get(i);
                    RecordHandler rHandler = recordHandlerStore.get();
                    Record recordObj = recordObjStore.get();
                    recordObj.resetAll((String)recordArr[0], (String)recordArr[1], (String)recordArr[2]);
                    rHandler.setRecord(recordObj);
                    rHandler.setDO(this.dobj);
                    rHandler.run();
                    rHandler = null;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

