/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.fa.server.lc.WriterRepository;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TriggerTasks
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(TriggerTasks.class.getName());
    int wait_time = 20000;
    String threadName = "TriggerTasks";
    String[] array = new String[]{"ConfigurationTablePopulator-1", "ConfigurationTablePopulator-2", "ConfigurationTablePopulator-3", "ConfigurationTablePopulator-4", "ConfigurationTablePopulator-5", "ConfigurationTablePopulator-6", "ConfigurationTablePopulator-7"};
    Object obj = new Integer(0);
    boolean runOnce = false;
    private int status = 7;
    private long populatedHrTablePreviouslyAt = -1L;
    private long breakingPoint = 420000L;
    private int size;
    private long splitPoint = 5400000L;
    private long highFlowRateSplitPoint = 420000L;
    private long previouslySplittedAt = -1L;
    private static boolean isHighFlowCondition = "true".equals(System.getProperty("highFlow", "false"));

    public TriggerTasks(String threadName, int waitfor, String[] tasks, boolean runOnce) {
        LOGGER.log(Level.INFO, "Creating new instance for {0}", threadName);
        this.threadName = threadName;
        this.wait_time = waitfor;
        if (tasks != null) {
            this.array = tasks;
        }
        this.runOnce = runOnce;
        this.size = this.array.length;
        this.previouslySplittedAt = System.currentTimeMillis();
        this.splitPoint = "true".equals(System.getProperty("highFlow", "false")) ? this.highFlowRateSplitPoint : this.splitPoint;
        if (isHighFlowCondition) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaken() {
        Object object = this.obj;
        synchronized (object) {
            this.obj.notify();
        }
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            Thread.currentThread().setName(this.threadName);
            try {
                boolean wait = true;
                LOGGER.log(Level.INFO, "TriggerTask ... status of runOnce is -->" + this.runOnce);
                if (this.runOnce) {
                    while (wait) {
                        LOGGER.log(Level.INFO, " Wait Count for Host ::{0} ::  Temp Thread :{1} :: Thanks for waiting {2} seconds", new Object[]{this.threadName, Thread.currentThread().getName(), new Integer(this.wait_time)});
                        Object object = this.obj;
                        synchronized (object) {
                            this.obj.wait(this.wait_time);
                        }
                        this.status = 8;
                        LOGGER.log(Level.INFO, " Hei !!! Good Starting Generating Reports ============>>>>{0} for :::{1}", new Object[]{Thread.currentThread().getName(), this.threadName});
                        WriterRepository.getInstance().flushWriters();
                        PacketUtil.executeTaskGroups(this.array);
                        Thread.currentThread().setName(this.threadName);
                        wait = false;
                    }
                    break block28;
                }
                LOGGER.log(Level.INFO, "TriggerTask.run() inside scheduled Task block !!");
                if (isHighFlowCondition) {
                    LOGGER.log(Level.INFO, "inside highFlowRateCondition !!");
                    String[] onlyHFlowTask = new String[]{"HighFlowCruncher"};
                    String[] allTasks = new String[]{"HighFlowCruncher", "ConfigurationTablePopulator-5", "ConfigurationTablePopulator-6", "ConfigurationTablePopulator-7"};
                    while (wait) {
                        LOGGER.log(Level.INFO, " Hei !!! Good Starting Generating Reports using high flow rate tasks Start");
                        if (PacketUtil.includeDailyToYearlyTasks) {
                            PacketUtil.executeTaskGroups(allTasks);
                            PacketUtil.includeDailyToYearlyTasks = false;
                        } else {
                            PacketUtil.executeTaskGroups(onlyHFlowTask);
                        }
                        Object object = this.obj;
                        synchronized (object) {
                            if (this.isInterrupted()) {
                                LOGGER.log(Level.INFO, " Clear Interruption in TriggerTask has to be called before wait() call ......");
                                this.clearInterruption();
                            }
                            this.obj.wait(this.wait_time);
                        }
                    }
                } else {
                    while (wait) {
                        String[] newTaskGroups;
                        boolean includeSplitTask;
                        LOGGER.log(Level.INFO, " Hei !!! Good Starting Generating Reports ============>>>>{0} for :::{1}", new Object[]{Thread.currentThread().getName(), this.threadName});
                        this.populatedHrTablePreviouslyAt = this.populatedHrTablePreviouslyAt == -1L && this.size == 4 ? System.currentTimeMillis() : this.populatedHrTablePreviouslyAt;
                        boolean bl = includeSplitTask = System.currentTimeMillis() - this.previouslySplittedAt >= this.splitPoint;
                        if (this.size == 4 && System.currentTimeMillis() - this.populatedHrTablePreviouslyAt < this.breakingPoint) {
                            LOGGER.log(Level.INFO, "TriggerTasks inside < 7 min check execute only 3 tasks");
                            newTaskGroups = includeSplitTask ? this.copyContents(this.array, new String[this.size + 1], true) : this.copyContents(this.array, new String[this.size - 1], false);
                            PacketUtil.executeTaskGroups(newTaskGroups);
                        } else {
                            LOGGER.log(Level.INFO, "TriggerTasks Inside > 7 min check abt to execute all tasks");
                            if (this.size == 4) {
                                this.populatedHrTablePreviouslyAt = System.currentTimeMillis();
                            }
                            newTaskGroups = includeSplitTask ? this.copyContents(this.array, new String[this.size + 2], true) : this.array;
                            PacketUtil.executeTaskGroups(newTaskGroups);
                        }
                        if (includeSplitTask) {
                            this.previouslySplittedAt = System.currentTimeMillis();
                        }
                        Thread.currentThread().setName(this.threadName);
                        LOGGER.log(Level.INFO, " Wait Count for Host ::{0} ::  Temp Thread :{1} :: Thanks for waiting {2} seconds", new Object[]{this.threadName, Thread.currentThread().getName(), new Integer(this.wait_time)});
                        Object object = this.obj;
                        synchronized (object) {
                            if (this.isInterrupted()) {
                                LOGGER.log(Level.INFO, " Clear Interruption in TriggerTask has to be called before wait() call ......");
                                this.clearInterruption();
                            }
                            this.obj.wait(this.wait_time);
                        }
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                LOGGER.log(Level.INFO, " Clear Interruption has to be called from TriggerTask catch block......");
                this.clearInterruption();
            }
            finally {
                LOGGER.log(Level.INFO, " It's finally block of TriggerTask......");
            }
        }
        LOGGER.log(Level.INFO, " Exiting thread for{0}:: {1} :: Thanks for waiting {2} seconds", new Object[]{this.threadName, Thread.currentThread().getName(), new Integer(this.wait_time)});
        this.status = 9;
    }

    private String[] copyContents(String[] source, String[] destination, boolean includeRawTableSplitter) {
        if (includeRawTableSplitter) {
            System.arraycopy(source, 0, destination, 0, this.size);
            int dstLength = destination.length;
            int indexOfRawTableSplitter = dstLength == 5 ? 3 : 4;
            destination[indexOfRawTableSplitter] = "RawTableSplitter";
            destination[++indexOfRawTableSplitter] = "HourlyTableSplitter";
        } else {
            System.arraycopy(source, 0, destination, 0, this.size - 1);
        }
        return destination;
    }

    private void clearInterruption() {
        if (this != null && this.isInterrupted()) {
            LOGGER.log(Level.WARNING, "Thread was interrupted while running TriggerTask");
            this.interrupted();
            LOGGER.log(Level.WARNING, "Interruption cleared on TriggerTask");
        } else {
            LOGGER.log(Level.WARNING, "In TriggerTask clearInterruption, this.isInterrupted() -> false");
        }
    }
}

