/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.fa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.fa.server.lc.PacketUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V9Template {
    private static V9Template tempinst = null;
    private static final Logger LOGGER = Logger.getLogger(V9Template.class.getName());
    private Hashtable templateMap = new Hashtable();
    private static HashMap ruleHashVsName = new HashMap();

    private V9Template() {
        V9Template.populateRuleHashFromDB(null);
    }

    public static void populateRuleHashFromDB(String resIP) {
        SelectQueryImpl sel = new SelectQueryImpl(new Table("DeviceRules"));
        sel.addSelectColumn(new Column("DeviceRules", "*"));
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("RESOURCEID");
        cols.add("IPADDRESS");
        sel.addSelectColumn(new Column("Resources", "*"));
        Join join = new Join("DeviceRules", "Resources", new String[]{"RID"}, new String[]{"RESOURCEID"}, 2);
        sel.addJoin(join);
        Criteria crit1 = new Criteria(new Column("DeviceRules", "RULEHASH"), (Object)"NULL", 1);
        if (resIP == null) {
            sel.setCriteria(crit1);
        } else {
            Criteria crit2 = new Criteria(new Column("Resources", "IPADDRESS"), (Object)resIP, 0);
            sel.setCriteria(crit1.and(crit2));
        }
        try {
            DataObject doo = DataAccess.get((SelectQuery)sel);
            Iterator itr = doo.getRows("DeviceRules");
            while (itr.hasNext()) {
                Row r1 = (Row)itr.next();
                String ruleName = (String)r1.get("RULE");
                String ruleHash = (String)r1.get("RULEHASH");
                Row r2 = doo.getRow("Resources", r1);
                resIP = (String)r2.get("IPADDRESS");
                LOGGER.log(Level.FINER, "V9Template.java -> Constructor() : ruleHashVsName is populated key: {0} and value: {1}", new Object[]{resIP + "_" + ruleHash, ruleName});
                ruleHashVsName.put(resIP + "_" + ruleHash, ruleName);
            }
        }
        catch (Exception exp) {
            System.out.println("V9Template.java: Exception while adding RULE HASH");
            exp.printStackTrace();
        }
    }

    public static String getRuleName(String key) {
        return (String)ruleHashVsName.get(key);
    }

    public V9_IDS getField(int ordinal) {
        V9_IDS[] aa;
        for (V9_IDS bb : aa = V9_IDS.values()) {
            if (bb.ordinal() != ordinal) continue;
            return bb;
        }
        return null;
    }

    public void printTemplate() {
        for (String key : this.templateMap.keySet()) {
            Integer[][] arr = (Integer[][])this.templateMap.get(key);
            System.out.println("**********************************");
            for (int i = 0; i < arr.length; ++i) {
                int ordinal = arr[i][0];
                V9_IDS o = this.getField(ordinal);
                System.out.println("Field " + i + " : " + (Object)((Object)o));
            }
            System.out.println("**********************************");
        }
    }

    public static synchronized V9Template getInstance() {
        if (tempinst == null) {
            tempinst = new V9Template();
        }
        return tempinst;
    }

    public Integer[][] getTemplate(String tempID) {
        if (this.templateMap.containsKey(tempID)) {
            return (Integer[][])this.templateMap.get(tempID);
        }
        return null;
    }

    public Hashtable getTemplates() {
        return this.templateMap;
    }

    public int addTemplate(String firewallIP, long sourceID, byte[] buf, int marker, int templates_tot_len, int pduCount, int processedPDU) {
        int templates_count = 0;
        int j = 4;
        while (processedPDU + templates_count < pduCount && j < templates_tot_len) {
            boolean isValid;
            LOGGER.log(Level.FINEST, "Marker location = {0}", marker);
            int computationStart = marker;
            long actualTempID = PacketUtil.to_number(buf, marker, 2);
            int fieldCount = (int)PacketUtil.to_number(buf, marker + 2, 2);
            String tempid = firewallIP + "_" + sourceID + "_" + actualTempID;
            LOGGER.log(Level.FINER, "ADDING TEMPLATE FLOW :::: template ID is = {0} fieldCount = {1}", new Object[]{tempid, fieldCount});
            Integer[][] arr = new Integer[fieldCount][2];
            if (actualTempID > 255L && (isValid = this.processTemplate(arr, marker += 4, fieldCount, buf))) {
                this.templateMap.put(tempid, arr);
            }
            int computedTempLength = (marker += fieldCount * 4) - computationStart;
            j += computedTempLength;
            ++templates_count;
        }
        return templates_count;
    }

    private boolean processTemplate(Integer[][] arr, int marker, int fieldCount, byte[] buf) {
        boolean isValid = false;
        for (int i = 0; i < fieldCount; ++i) {
            int fieldno = (int)PacketUtil.to_number(buf, marker, 2);
            Integer fieldlen = new Integer((int)PacketUtil.to_number(buf, marker + 2, 2));
            LOGGER.log(Level.FINER, "fieldno= {0} fieldlen= {1} marker= {2}", new Object[]{fieldno, fieldlen, marker});
            switch (fieldno) {
                case 323: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_EVENT_TIME_MSEC.ordinal());
                    break;
                }
                case 152: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_FLOW_CREATE_TIME_MSEC.ordinal());
                    break;
                }
                case 148: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_CONN_ID.ordinal());
                    break;
                }
                case 8: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_SRC_ADDR_IPV4.ordinal());
                    break;
                }
                case 27: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_SRC_ADDR_IPV6.ordinal());
                    break;
                }
                case 12: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_DST_ADDR_IPV4.ordinal());
                    break;
                }
                case 28: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_DST_ADDR_IPV6.ordinal());
                    break;
                }
                case 10: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_SRC_INTF_ID.ordinal());
                    break;
                }
                case 14: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_DST_INTF_ID.ordinal());
                    break;
                }
                case 4: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_PROTOCOL.ordinal());
                    break;
                }
                case 7: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_SRC_PORT.ordinal());
                    break;
                }
                case 11: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_DST_PORT.ordinal());
                    break;
                }
                case 85: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_FLOW_BYTES.ordinal());
                    break;
                }
                case 33000: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_INGRESS_ACL_ID.ordinal());
                    break;
                }
                case 33001: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_EGRESS_ACL_ID.ordinal());
                    break;
                }
                case 40000: {
                    arr[i][0] = fieldlen == 20 ? new Integer(V9_IDS.NF_F_USERNAME.ordinal()) : new Integer(V9_IDS.NF_F_USERNAME_MAX.ordinal());
                    break;
                }
                case 40001: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_XLATE_SRC_ADDR_IPV4.ordinal());
                    break;
                }
                case 40002: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_XLATE_DST_ADDR_IPV4.ordinal());
                    break;
                }
                case 40003: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_XLATE_SRC_PORT.ordinal());
                    break;
                }
                case 40004: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_XLATE_DST_PORT.ordinal());
                    break;
                }
                case 40005: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_FW_EVENT.ordinal());
                    isValid = true;
                    break;
                }
                case 33002: {
                    arr[i][0] = new Integer(V9_IDS.NF_F_FW_EXT_EVENT.ordinal());
                    break;
                }
                default: {
                    arr[i][0] = new Integer(-1);
                }
            }
            arr[i][1] = fieldlen;
            marker += 4;
        }
        return isValid;
    }

    static enum V9_IDS {
        NF_F_CONN_ID(148, 4),
        NF_F_SRC_ADDR_IPV4(8, 4),
        NF_F_DST_ADDR_IPV4(12, 4),
        NF_F_PROTOCOL(4, 1),
        NF_F_SRC_ADDR_IPV6(27, 16),
        NF_F_DST_ADDR_IPV6(28, 16),
        NF_F_SRC_PORT(7, 2),
        NF_F_DST_PORT(11, 2),
        NF_F_ICMP_TYPE(176, 1),
        NF_F_ICMP_CODE(177, 1),
        NF_F_ICMP_TYPE_IPV6(178, 1),
        NF_F_ICMP_CODE_IPV6(179, 1),
        NF_F_SRC_INTF_ID(10, 2),
        NF_F_DST_INTF_ID(14, 2),
        NF_F_XLATE_SRC_ADDR_IPV4(40001, 4),
        NF_F_XLATE_DST_ADDR_IPV4(40002, 4),
        NF_F_XLATE_SRC_PORT(40003, 2),
        NF_F_XLATE_DST_PORT(40004, 2),
        NF_F_FW_EVENT(40005, 1),
        NF_F_FW_EXT_EVENT(33002, 2),
        NF_F_EVENT_TIME_MSEC(323, 8),
        NF_F_FLOW_BYTES(85, 4),
        NF_F_FLOW_CREATE_TIME_MSEC(152, 8),
        NF_F_INGRESS_ACL_ID(33000, 12),
        NF_F_EGRESS_ACL_ID(33001, 12),
        NF_F_USERNAME(40000, 20),
        NF_F_USERNAME_MAX(40000, 65);

        private int type;
        private int len;

        private V9_IDS(int type, int len) {
            this.type = type;
            this.len = len;
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.len;
        }
    }
}

